clear all
clc
close all

load('SHARE_RECS')
coh_m2=load('coh_m2.out');
coh_m3=load('coh_m3.out');
coh_m4=load('coh_m4.out');
%%We exclude the last cohort estimates from this exercise because their shares are in fact an outlier (100% share).
figure(1)
        subplot(2,3,1)
        hold on
        plot(coh_m2(1:end-1,2),coh_m2(1:end-1,3),'LineWidth',1.5,'Color',[0 0 1])
        ylabel('$\it{2^{nd}}$ central mom.','FontSize',12,'FontName','Helvetica','FontAngle','italic','Interpreter','latex')
        axis tight; box on
                
        subplot(2,3,2)
        plot(coh_m2(1:end-1,2),coh_m3(1:end-1,3),'LineWidth',1.5,'Color',[0 0 1])
        ylabel('$\it{3^{rd}}$ central mom.','FontSize',12,'FontName','Helvetica','FontAngle','italic','Interpreter','latex')
        axis tight; box on 
        box on
        title('by year of birth','FontSize',12,'FontName','Helvetica','Interpreter','latex')
        
         subplot(2,3,3)
        plot(coh_m2(1:end-1,2),coh_m4(1:end-1,3),'LineWidth',1.5,'Color',[0 0 1])
        ylabel('$\it{4^{th}}$ central mom.','FontSize',12,'FontName','Helvetica','FontAngle','italic','Interpreter','latex')
        axis tight; box on 
        box on

        
         subplot(2,3,4)
        Fit = polyfit(Share_of_recessions,coh_m2(1:end-1,3),1); % x = x data, y = y data, 1 = order of the polynomial i.e a straight line 
        xfit=linspace(min(Share_of_recessions), max(Share_of_recessions), length(Share_of_recessions));
        hold on
        scatter(Share_of_recessions,coh_m2(1:end-1,3),'MarkerEdgeColor',[0 0 0],'MarkerFaceColor',[0 0 1])
         hold on
        plot(xfit,polyval(Fit,xfit),'r.-')
        hold off
        ylabel('$\it{2^{nd}}$ central mom.','FontSize',12,'FontName','Helvetica','FontAngle','italic','Interpreter','latex')
        axis tight; box on 
        
        subplot(2,3,5)
        Fit = polyfit(Share_of_recessions,coh_m3(1:end-1,3),1); % x = x data, y = y data, 1 = order of the polynomial i.e a straight line 
        xfit=linspace(min(Share_of_recessions), max(Share_of_recessions), length(Share_of_recessions));
        hold on
        scatter(Share_of_recessions,coh_m3(1:end-1,3),'MarkerEdgeColor',[0 0 0],'MarkerFaceColor',[0 0 1])
         hold on
        plot(xfit,polyval(Fit,xfit),'r.-')
        hold off
        ylabel('$\it{3^{rd}}$ central mom.','FontSize',12,'FontName','Helvetica','FontAngle','italic','Interpreter','latex')
        axis tight; box on 
        title('by share of recessions','FontSize',12,'FontName','Helvetica','Interpreter','latex')
        
         subplot(2,3,6)
        Fit = polyfit(Share_of_recessions,coh_m4(1:end-1,3),1); % x = x data, y = y data, 1 = order of the polynomial i.e a straight line 
        xfit=linspace(min(Share_of_recessions), max(Share_of_recessions), length(Share_of_recessions));
        hold on
        scatter(Share_of_recessions,coh_m4(1:end-1,3),'MarkerEdgeColor',[0 0 0],'MarkerFaceColor',[0 0 1])
         hold on
        plot(xfit,polyval(Fit,xfit),'r.-')
        hold off
        ylabel('$\it{4^{th}}$ central mom.','FontSize',12,'FontName','Helvetica','FontAngle','italic','Interpreter','latex')
        axis tight; box on 
        

        
   
%sup = suptitle('Figure 1: Cohort effects on the distribution of residual household labour income');
%set(sup,'FontSize',18,'FontWeight','normal')
        
set (figure(1), 'Units', 'normalized', 'Position', [0.16,0,0.8,0.8]);
%set (figure(1), 'Units', 'normalized', 'Position', [0.25,0,0.50,1]);
h = figure(1);
set(h,'Units','Inches');
pos = get(h,'Position');
set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
print(h,'Fig_1','-dpdf','-r600')
print(h,'Fig_1','-depsc2','-r600')    
        