clear;
m = 1000;%smoothing parameter

%set the grids
ficogrid = 480: 20: 840;I=length(ficogrid);
downpgrid=[0 :10:5*60];J=length(downpgrid);
incgrid=[40 50 60 70 80 90 100 110 120 130 140 150 160 170 180 200 250 1000];K=length(incgrid);

% number of years and cities
NY=14;NC=100;

load frontierdata.txt; data=frontierdata;
output=zeros(length(ficogrid)*length(downpgrid)*length(incgrid)*NY*NC,6);
l=1;

for c=1:NC
temp=data(data(:,1)>=480&data(:,1)<=850&data(:,8)==c,:);
nobs=min(5,floor(length(temp)*0.0001)); % number of observations to exclude from bin before computing frontier

data_fico = temp(:,1);
data_loan = temp(:,2);
data_downp = temp(:,3);
data_inc = temp(:,4);
data_year = temp(:,5);
cbsa=temp(1,6);
clear temp 

    for year = 2001:2014
        myids = find( data_year==year);
        fico = data_fico(myids);
        loan = data_loan(myids);
        downp = data_downp(myids);	
        inc = data_inc(myids);	
        for i=1:I
            for j=1:J         
                for k=1:K            
                output(l,1)=ficogrid(i);output(l,2)=downpgrid(j);output(l,3)=incgrid(k);output(l,4)=year;
                output(l,5)=frontier_website(m, ficogrid(i), fico,downpgrid(j),downp,incgrid(k),inc,loan,nobs);output(l,6)=cbsa;
                l=l+1;
                end
            end    
        end
    end
end

save frontieroutput.txt output -ascii -double -tabs
