#include <oxstd.h>
#import  <msvar130>

main()
{
	decl time=timer();
	decl msvar = new MSVAR();
	decl PrSt, PrS, Sigma;

	msvar->IsOxPack(FALSE);			    // mandatory command
	msvar->SetOptions(TRUE,TRUE,TRUE);  // MSVAR settings (TRUE: automatic StdErrors, TRUE: automatic DrawResults, TRUE: save gwg files)
	
	// Load data and select variables
	
	msvar->Load("c:/farshid/data/uknew/uknew.xls");
	msvar->Select(Y_VAR, { "growth", 0, 2, "spread", 0, 2});	//	endogenous
	
	msvar->SetSample(1961,2,1999,4);
	
		// Specify the MS-VAR
	
	decl fModel = MSIAH;					// model type: MSI,MSIH,MSM,MSMH,MSIA,MSIAH,MSIA,MSIAH,MSH,SR,SETAR
										// allowing for shifts in the 	(I)ntercept / (M)ean,
										//								(A)utoregressive parameters
										//								(H)eteroskedasticity										
	decl M = 2; 						// number of regimes
	msvar->SetModel(fModel, M);			// model specification

	// ESTIMATE

	msvar->Estimate();					// estimates
	msvar->IsConverged();

	//  Get Smoothed Prob. and Sigmas

	PrSt = msvar->GetProbSt();					// Get M*T matrix of smoothed regime probabilities
		print("PrSt");
		print(PrSt');
	PrS  = msvar->GetProbS();
		print("PrS");
		print(PrS');
	Sigma = msvar->GetSigma();
		print("Sigma");
		print(Sigma);
		
	//	Graphics
	
	msvar->DrawResults();				// shows graphics
		SaveDrawWindow("c:/farshid/data/UKnew/Graphics/MSIAH2VAR2/UKresult.ps");
	msvar->DrawErrors(TRUE);			// shows graphics
		SaveDrawWindow("c:/farshid/data/UKnew/Graphics/MSIAH2VAR2/UKerrors.ps");
	msvar->DrawFit();					// shows graphics
		SaveDrawWindow("c:/farshid/data/UKnew/Graphics/MSIAH2VAR2/UKfit.ps");
	msvar->DrawModelAnalysis();			// shows graphics
		SaveDrawWindow("c:/farshid/data/UKnew/Graphics/MSIAH2VAR2/UKmodana.ps");
	msvar->CycleDating();				// prints regime classification
	msvar->TestAsy();					// asymmetry tests
	delete msvar;
}