function [yb,yt] = mk_yt(ym)
% PURPOSE: generates yb, (nn x 1) mean vector and yt, (nt*nn x 1) demeaned
% vector
% -----------------------------------------------------
% USAGE: [yb,yt] = mk_yt(ym)
% where: 
% ym = (nt x nn) matrix
% NOTE: no dimension checks imposed , 17/04/04
% -----------------------------------------------------
% RETURNS: 
% yb = (nn x 1) mean value vector (on rows different units)
% yt = (nt*nn x 1) vector with stacked demeaned variable 
% -----------------------------------------------------
% written by:
% Gianni Amisano, Dept of Economics
% University of Brescia
% amisano@eco.unibs.it
nt=size(ym,1);
nn=size(ym,2);
yb=mean(ym);
yt=ym-ones(nt,1)*yb;
yb=yb';
yt=reshape(yt,nt*nn,1);