function [xb,xt] = mk_xt(xa)
% PURPOSE: generates xb, (nn x nk) mean matrix and xt, (nt*nn x nk) demeaned matrix
% -----------------------------------------------------
% USAGE: [xb,xt] = mk_xt(xa)
% where: 
% xa = (nt x nn x nk) array
% NOTE: no dimension checks imposed , 17/04/04
% -----------------------------------------------------
% RETURNS: 
% xb = (nn x nk) mean value matrix (on rows different units, on columns different variables)
% xt = (nt*nn x nk) matrix with stacked demeaned varibles 
% -----------------------------------------------------
% written by:
% Gianni Amisano, Dept of Economics
% University of Brescia
% amisano@eco.unibs.it
nt=size(xa,1);
nn=size(xa,2);
nk=size(xa,3);
xb=squeeze(mean(xa));
xbb=permute(repmat(xb,[1 1 nt]),[3 1 2]);
xt=xa-xbb;
xt=reshape(xt,nt*nn,nk);