function [xa,nks] = mk_xa_re2(za,trv)
% PURPOSE: generates xa, (nt x nn x nks) covariates array
% with extra covariates to account for initial distribution of
% random effects
% -----------------------------------------------------
% USAGE: [xa,nks] = mk_xa_re(za,ind_re,nk1)
% where: 
% za     = (nt x nn x nk) input covariates array
% trv    = (nk x 1) in which each element signals treatment of 
%           corresponding covariate (=1 insert mean, = 2 insert initial
%           value, = 3 (or other) skip)
% NOTES: no dimension checks imposed , 18/04/04
%        program assumes that the ordering of variables in za is :
% -----------------------------------------------------
% RETURNS: 
% xa = (nt x nn x nks) resulting array with covariates
% nks = number of resulting covariates 
% -----------------------------------------------------
% written by:
% Gianni Amisano, Dept of Economics
% University of Brescia
% amisano@eco.unibs.it
nt=size(za,1);
nn=size(za,2);
nk=size(za,3);
nk1=size(trv(trv==1),1);
nk2=size(trv(trv==2),1);
nk3=nk-nk1-nk2;
nks=nk+nk1+nk2;
xa=zeros(nt,nn,nks);
xa(:,:,1:nk)=za;
icum=0;
for ik1=1:nk
    if trv(ik1)==1;
        icum=icum+1;
        xa(:,:,nk+icum)=ones(nt,1)*mean(za(:,:,ik1));
    elseif trv(ik1)==2;
        icum=icum+1;
        xa(:,:,nk+icum)=ones(nt,1)*za(1,:,ik1);
    end
end
