function [xa,nks] = mk_xa_re1(za,ind_re,nk1)
% PURPOSE: generates xa, (nt x nn x nks) covariates array
% with extra covariates to account for initial distribution of
% random effects
% -----------------------------------------------------
% USAGE: [xa,nks] = mk_xa_re(za,ind_re,nk1)
% where: 
% za     = (nt x nn x nk) input covariates array
% ind_re = integer = 0 no dependence on regressors and initial conditions 
%                  = 1 heckman(1981)  correction (means of covariates)
%                  = 2 (or any other value)= wooldridge (2003) approach: all values of covariates 
% nk1    = number of covariates to be included into RE specification
% NOTES: no dimension checks imposed , 18/04/04
%        program assumes that the ordering of variables in za is :
% (1) covariates to be included into RE specification (Z1)
% (2) lagged end variable (Z2)
% (3) variables not to be inserted into RE specification (intercept, time
% dummies, or any other time constant covariate).
% -----------------------------------------------------
% RETURNS: 
% xa = (nt x nn x nks) resulting array with covariates
% nks = number of resulting covariates 
% -----------------------------------------------------
% written by:
% Gianni Amisano, Dept of Economics
% University of Brescia
% amisano@eco.unibs.it
nt=size(za,1);
nn=size(za,2);
nk=size(za,3);
nk2=1;
nk3=nk-nk1-nk2;
if ind_re==0
    nks=nk;
    xa=za;
elseif ind_re==1
    nks=nk1+nk2+nk3+nk1+1;
    xa=zeros(nt,nn,nks);
    xa(:,:,1:nk)=za;
    z1a=permute(za(:,:,1:nk1),[1 3 2]);
    for ik1=1:nk1
        xa(:,:,nk+ik1)=ones(nt,1)*za(1,:,ik1);
    end
    xa(:,:,nks)=ones(nt,1)*za(1,:,nk1+1);
else
    nks=nk1+nk2+nk3+nk1*nt+1;
    xa=zeros(nt,nn,nks);
    xa(:,:,1:nk)=za;
    z1a=permute(za(:,:,1:nk1),[1 3 2]);
    z1a=reshape(z1a,1,nt*nk1,nn);
    z1a=repmat(z1a,[nt 1 1]);
    z1a=permute(z1a,[1 3 2]);
    xa(:,:,nk+1:nks-1)=z1a;
    xa(:,:,nks)=ones(nt,1)*za(1,:,nk1+1);
end