function [ym,alpha] = mk_pdata1(xa,a0,ha,beta,modtype)
% PURPOSE: generates panel data with randomly drawn intercepts 
% -----------------------------------------------------
% USAGE: [ym,alpha] = mk_pdata1(xa,a0,ha,beta)
% where: 
% xa = (nt x nn x nk) regressors array
% a0 = mean of intercepts
% ha = precision of intercepts
% beta= (nk x 1) vector of slope parameters
% modtype = 0 normal errors
%         =~0 logistic errors
% NOTE: no dimension checks imposed , 10/03/04
% -----------------------------------------------------
% RETURNS: 
% xtt = ((nt+1) x nn x nk) array with modified x's to marginalise
%        alphas out
% -----------------------------------------------------
% written by:
% Gianni Amisano, Dept of Economics
% University of Brescia
% amisano@eco.unibs.it
nt=size(xa,1);
nn=size(xa,2);
nk=size(xa,3);
alpha=a0+randn(nn,1)/sqrt(ha);
if modtype==0
    epsilon=randn(nt*nn,1);
else
    epsilon=rand(nt*nn,1);
    epsilon=log(epsilon./(1-epsilon));
end
ym=reshape(reshape(xa,nt*nn,nk)*beta+epsilon,nt,nn)+ones(nt,1)*alpha';

