function ape = mk_ape(betam,alpham,ztilde)
% PURPOSE: generates ape, (nk x 1) vector with APEs
% see Wooldridge (2002)
% -----------------------------------------------------
% USAGE: ape = mk_ape(betam,alpham,ztilde)
% where: 
% betam     = (mk x nk) matrix with mk draws on nk slope coeffs
% alpham    = (mk x nn) matrix with mk draws on nn REs
% ztilde    = (nk x 1) vector with reference point for calculation
% NOTE: no dimension checks imposed , 19/04/04
% -----------------------------------------------------
% RETURNS: 
% ape = (nk x 1) APE's
% -----------------------------------------------------
% written by:
% Gianni Amisano, Dept of Economics
% University of Brescia
% amisano@eco.unibs.it
nm=size(betam,1);
nk=size(betam,2);
nn=size(alpham,2);
ape=normpdf(betam*ztilde*ones(1,nn)+alpham);
ape=mean((mean(ape')'*ones(1,nk)).*betam)';
