function lv = draw_probitlv(dv,zv)
% PURPOSE: generates draw from latent variables in probit model
% -----------------------------------------------------
% USAGE: lv = draw_probitlv(dv,zv)
% where: 
% dv = vector with dependent variable values 
% zv = vector with systematic part of lv
% NOTE: no dimension checks imposed , 13/03/04
% -----------------------------------------------------
% RETURNS: 
% lv = (mm x 1) draw on lv 
% -----------------------------------------------------
% written by:
% Gianni Amisano, Dept of Economics
% University of Brescia
% amisano@eco.unibs.it
mm=size(dv,1);
cv=normcdf(-zv);
uv=rand(mm,1);
lv=dv.*((1-cv).*uv+cv)+(1-dv).*cv.*uv;
lv=norminv(lv)+zv;