function ha = draw_ha(nup,sp,alpha,a0)
% PURPOSE: generates draw from conditional distribution of ha
% -----------------------------------------------------
% USAGE: ha = draw_ha(nup,sp,alpha,a0)
% where: 
% nup= a priori df parameter
% sp= a priori scale parameter
% alpha = (nn x 1) vector of intercepts 
% a0=prior mean of alpha
% NOTE: no dimension checks imposed , 12/03/04
% -----------------------------------------------------
% RETURNS: 
% alpha = (nn x 1) draw on beta 
% -----------------------------------------------------
% written by:
% Gianni Amisano, Dept of Economics
% University of Brescia
% amisano@eco.unibs.it
nn=size(alpha,1);
nu=nup+nn;
s=(alpha-a0);
s=s'*s+sp;
ha=randn(nu,1);
ha=ha'*ha/s;