function beta = draw_beta_slope(nt,nk,psi,xxwu,xxbu,Hp_beta,Hmup_beta,xb,xt,yb,yt)
% PURPOSE: generates draw from conditional distribution of beta,
% common slope parameters
% -----------------------------------------------------
% USAGE: beta = draw_beta(nt,nk,psi,xxwu,xxbu,Hp_beta,Hmup_beta,xb,xt,yb,yt)
% where: 
% nt         = number of time periods
% nk         = number of covariates
% psi        = scalar factor to be applied to BU part of cross product moment of x's
% xxwu       = (nk x nk) matrix with WU part of cross product moment of x's
% xxwu       = (nk x nk) matrix with BU part of cross product moment of x's
% Hp_beta    = (nk x nk) prior precision of beta
% Hmup_beta  = (nk x 1) vector = Hp_beta*mup_beta;
% xb         = (nn x nk) unit mean matrix for x
% xt         = (nn*nt x nk) demeaned regressors
% yb         = (nn x 1) unit means vector for y
% yt         = (nn*nt x nk) demeaned y
% NOTE: no dimension checks imposed , 12/03/04
% -----------------------------------------------------
% RETURNS: 
% beta = (nk x 1) draw on beta 
% -----------------------------------------------------
% written by:
% Gianni Amisano, Dept of Economics
% University of Brescia
% amisano@eco.unibs.it
H_beta=inv(Hp_beta+xxwu+psi*xxbu);
mu_beta=H_beta*(Hmup_beta+xt'*yt+psi*nt*xb'*yb);
beta=(chol(H_beta)')*randn(nk,1)+mu_beta;