function alpha = draw_alpha(ym,xa,beta,ha,a0)
% PURPOSE: generates draw from conditional distribution of beta,
% intercept parameters
% -----------------------------------------------------
% USAGE: alpha = draw_alpha(ym,xa,ha,a0)
% where: 
% ym= (nt x nn) matrix of depvars
% xa= (nt)*nn x nk matrix with regressors
% beta = (nk x 1) 
% ha= prior precision of alpha
% a0=prior mean of alpha
% NOTE: no dimension checks imposed , 12/03/04
% -----------------------------------------------------
% RETURNS: 
% alpha = (nn x 1) draw on beta 
% -----------------------------------------------------
% written by:
% Gianni Amisano, Dept of Economics
% University of Brescia
% amisano@eco.unibs.it
nt=size(xa,1);
nn=size(xa,2);
nk=size(xa,3);
yss=reshape(ym,nt*nn,1)-reshape(xa,nt*nn,nk)*beta;
yss=mean(reshape(yss,nt,nn))';
w=nt/(nt+ha);
yss=w*yss+(1-w)*a0;
alpha=yss+(randn(nn,1)/sqrt(nt+ha));