function [dummyoutput] = Bayesian_Panel_Probit_MCMC(ind_descriptive,infiledata,index_range0,index_range,output_version,cl,indyd,a0,ha,nup,sp,scalar_H_beta,scalar_mu_beta,M,nskip,burninprop)
% performs MCMC for Bayesian Panel Probit model
%inputs
%ind_descriptive=1; % if not equal to zero, then descriptive stats are computed
%infiledata='a_all_entries_unrestricted_1';
%index_range0='e1:ar3'; % to read the specifics for estimation
%index_range='a4:ar1644'; % to read data set
%output_version='1'; % this is useful to change output name
%cl=.95;
%indyd=0; %indicator for inserting year dummies
%a0=0.00;
%ha=0.5;
%nup=1;
%sp=2.0;
%scalar_H_beta=1;
%scalar_mu_beta=0;
%simulation settings
%M=1e+3;
%nskip=0;
%burninprop=.3;

%%
dummyoutput=0;
nskip1=nskip+1;
M1=M*(1+burninprop);
M2=M1*nskip1;
[alldata,all_str]=xlsread(infiledata,index_range);
indexm=xlsread(infiledata,index_range0)';
str_regr=[];
str_data=[];
for ik=5:size(all_str,2)
    str_regr{ik-4,1}=all_str{1,ik};
end
str_data{1,1}=all_str{1,1};
str_data{2,1}=all_str{1,3};
str_data{3,1}=all_str{1,4};
all_str1=all_str(1,:)';
all_str=[];
all_str{1,1}='year';
all_str{2,1}='unit';
all_str{3,1}='depvar';
for ik=5:length(all_str1)
    all_str{ik-1,1}=all_str1{ik,1};

end
alldata=alldata(:,[1 3:end]);
alldata=sortrows(alldata,[2 1]);
nn=length(find(alldata(:,1)==alldata(1,1)));
nt=length(find(alldata(:,2)==alldata(1,2)));
index_include=find(indexm(:,2)==1);
str_regressors=str_regr(index_include);
trv=[indexm(index_include,3);3];
nk=length(trv); % true covariates
str_regressors{nk,1}='intercept';
xalla=[alldata(:,[3;3+index_include]) ones(nt*nn,1)];
if indyd~=0
    yeardummies=repmat(eye(nt),nn,1);
    yeardummies=yeardummies(:,2:end);
    xalla=[xalla yeardummies];
    trv= [trv; ones(nt-1,1)];
    nk=length(trv);
end
xalla=reshape(xalla,nt*nn,1,nk+1);
xalla=reshape(xalla,nt,nn,nk+1);
dm=squeeze(xalla(:,:,1));
xa=xalla(:,:,2:end);
[za,nks] = mk_xa_re2(xa,trv);
xa=za;
nk=nks;
%beta=0.0001*(1:nk)';
%alpha=zeros(nn,1);
%modtype=0;
%xa=randn(nt,nn,nk);
%[ym,alphatrue]=mk_pdata1(xa,a0,ha,beta,modtype);
%dm=ym>0;
Hp_beta=scalar_H_beta*eye(nk);
mup_beta=scalar_mu_beta*ones(nk,1);
Hmup_beta=Hp_beta*mup_beta;
dv=reshape(dm,nt*nn,1);
betam=zeros(M1,nk);
alpham=zeros(M1,nn);
%
%
ml_infom=zeros(M1,2+nk+1); % this contains info for ML evaluation , lnl, lnprior and transformed values for the parameters
hav=zeros(M1,1);
fitted_probv=zeros(M1,2);
[xb,xt] = mk_xt(xa);
xxwu=xt'*xt; % wu bit of cross moment matrix of x's
xxbu=nt*xb'*xb; % % bu bit of cross moment matrix of x's
tic;
pv=zeros(nn*nt,1);
elasticitiesv=zeros(nk,2);
iskip=1;
% draw from prior
Cp_beta=chol(inv(Hp_beta))';
priorm=(repmat(mup_beta,1,M)+Cp_beta*randn(size(betam,2),M))';
priorm=[priorm chi2rnd(nup*ones(M,1))/sp];
beta=0*priorm(1,1:nk)';
ha=priorm(1,nk+1);
alpha=0*randn(nn,1)/sqrt(ha);
mean_regressors=mean(squeeze(mean(xa,1)))';
mean_depvar=mean(dv);
h_bar = waitbar(0,'MCMC computations');



Rm=[mup_beta 1./sqrt(diag(Hp_beta)); sp nup];
prior_type_ndxv=[4*ones(nk,1);2];
lnprior_const=DSGE_prior_lnconst1(Rm,prior_type_ndxv);
varm=zeros(M1,4);
for im=1:M2
     psi=1/(1+nt/ha);
     zv1=reshape(xa,nt*nn,nk)*beta; % this is stored to facilitate computation of likelihood
     zv=zv1+reshape(ones(nt,1)*alpha',nt*nn,1);
     lv = draw_probitlv(dv,zv);
     varv=[var(normcdf(zv1));var(normcdf(zv)); var(reshape(ones(nt,1)*alpha',nt*nn,1))/var(lv); var(alpha)];
     ym=reshape(lv,nt,nn);
     [yb,yt]=mk_yt(ym);
     beta = draw_beta(nt,nk,psi,xxwu,xxbu,Hp_beta,Hmup_beta,xb,xt,yb,yt);
     alpha = draw_alpha(ym,xa,beta,ha,a0);
     ha=draw_ha(nup,sp,alpha,a0);
     Phi_mean=mean(normcdf(mean_regressors'*beta+alpha));
     phi_mean=mean(normpdf(mean_regressors'*beta+alpha));
     %new
     if im > nskip1*burninprop
         pv=pv+(normcdf(zv)/(M*nskip1));
         elasticitiesv(:,1)=elasticitiesv(:,1)+beta*phi_mean/(Phi_mean*(M*nskip1));
         elasticitiesv(:,2)=elasticitiesv(:,2)+mean_regressors.*beta*phi_mean/(Phi_mean*(M*nskip1));
     end
     
     
     
     
     
     waitbar(im/M2);
    if iskip==nskip1
        clc;
        iskip=1;
        % compute prior and likelihood
        % likelihood
        lnl=normcdf(zv1/sqrt(1+(1/ha)));
        lnl0=sum(dv.*log(lnl)+(1-dv).*log(1-lnl));
        
        
        [omega,lnjac,lnprior]=DSGE_repar1([beta;ha],Rm,0,prior_type_ndxv);
        lnprior=lnprior+lnjac+lnprior_const;
        lnprior=sum(lnprior);
            
        %record
        ml_infom(im/nskip1,:)=[lnprior lnl0 omega'];   
        betam(im/nskip1,:) = beta';
        alpham(im/nskip1,:)=alpha';
        fitted_probv(im/nskip1,1)=Phi_mean;
        fitted_probv(im/nskip1,2)=phi_mean;
        varm(im/nskip1,:)=varv';
        hav(im/nskip1)=ha;        
    else
        iskip=iskip+1;
    end
end
close(h_bar)
toc;
M_ini=ceil(burninprop*M)+1;
betam=betam(M_ini:end,:);
alpham=alpham(M_ini:end,:);
hav=hav(M_ini:end,:);
fitted_probv=fitted_probv(M_ini:end,:);
ml_infom=ml_infom(M_ini:end,:);
varm=varm(M_ini:end,:);
ztilde=mean(reshape(xa,nt*nn,nk))';
%%
synthesis= [mean(betam)' std(betam)']; 
 
ape=mk_ape(betam,alpham,ztilde);
 
%% 
%new
%pv=pv/size(betam,1);
corrm=corrcoef([pv dv]);
goodness_fit=zeros(2,1);
goodness_fit(1)=corrm(1,2);
goodness_fit(2)=mean((pv>mean(dv))==dv);
simm=[betam hav];
nktot=size(simm,2);
ndx_quant=round(0.5*M)*ones(3,1);
ndx_quant(1)=round(M*(1-cl)/2);
ndx_quant(3)=round(M*(1+cl)/2);
synthesis1=[synthesis;[mean(hav) std(hav)]];
synthesis1=[synthesis1 zeros(size(synthesis1,1),3)];

for ik=1:nktot
    simv=sort(simm(:,ik));
    synthesis1(ik,3:5)=simv(ndx_quant)';
end
resultsfilename=[infiledata '_results' '_' output_version ];
aux_str=cellstr(strvcat('coeff.','regressor','prior mean','prior std','post mean','post std','lower','median','upper','significant?','APE','unit effect ?','time effect ?','mean_regressor','elasticity1','elasticity2'));
str_coeffs=[];
for ik=1:nks
    str_coeffs{ik,1}=['\beta_' int2str(ik)];
end
str_coeffs{nks+1,1}='h_\alpha';
trm_not3=[trv (1:length(trv))'];
trm_not3=trm_not3(trm_not3(:,1)<3,:);
str_regressors1=str_regressors;
nk_fixed_effects=nk-length(trv);
for ik=1:nk_fixed_effects
    if trm_not3(ik,1)==1
        str_regressors1{length(trv)+ik,1}=strcat('mean_', cell2mat(str_regressors(trm_not3(ik,2))));
    else
        str_regressors1{length(trv)+ik,1}=strcat('initial_',cell2mat(str_regressors(trm_not3(ik,2))));
    end
        
end
str_regressors1{nks+1,1}='precision \alpha';
synthesis1=[synthesis1 (synthesis1(:,3).*synthesis1(:,5))>0];

str_aux1=[];
str_aux1{1,1}='confidence level';
str_aux1{2,1}='correlation btw p^ and y';
str_aux1{3,1}='proportion correct forecasts';
str_aux1{4,1}='mean depvar';
str_aux1{5,1}='mean fitted depvar';


system(['del ' resultsfilename '.xls']);
xlswrite(resultsfilename,str_coeffs,1,'a2');
xlswrite(resultsfilename,str_regressors1,1,'b2');
xlswrite(resultsfilename,aux_str',1,'a1');
xlswrite(resultsfilename,[mean(priorm)' std(priorm)' synthesis1 [ape;0]],1,'c2');

xlswrite(resultsfilename,str_aux1,1,['a' int2str(nk+3)]);
xlswrite(resultsfilename,[cl; goodness_fit; mean_depvar; mean(pv)],1,['b' int2str(nk+3)]);

[nt,nn,nk1]=size(xalla);
index_ue=zeros(nk1,nn);
index_te=zeros(nk1,nt);
for it=1:nt
    xalla1=squeeze(xalla(it,:,:));
    index_te(:,it)=(var(xalla1)>0)';
end
index_te=sum(index_te,2)==0;
for in=1:nn
        xalla1=squeeze(xalla(:,in,:));
        index_ue(:,in)=(var(xalla1)>0)';
end
index_ue=sum(index_ue,2)==0;
index_uete=real([index_ue(2:end) index_te(2:end)]);
xlswrite(resultsfilename,index_uete,1,'l2');
xlswrite(resultsfilename,[mean_regressors elasticitiesv],1,'n2');
if nktot>24
    cols_graph=6;
else
    cols_graph=4;
end
rows_graph=ceil(nktot/cols_graph);
nclasses=40;
figure(1);
for ik=1:nktot
    if ik<nktot
        str_title=['\beta_{' int2str(ik) '}'];
    else
        str_title='h_\alpha';
    end
    subplot(rows_graph,cols_graph,ik);
    hist([simm(:,ik) priorm(:,ik)],nclasses);    
    title(str_title);
end
h=legend('post.','prior',2);
figure(2);
for ik=1:nktot
    if ik<nktot
        str_title=['\beta_{' int2str(ik) '}'];
    else
        str_title='h_\alpha';
    end
    subplot(rows_graph,cols_graph,ik);
    hist(simm(:,ik),nclasses);    
    title(str_title);
end
legend('posterior',1);

saveas(1,['fig1_' infiledata],'fig');
saveas(1,['fig1_' infiledata],'eps');
saveas(2,['fig2_' infiledata],'fig');
saveas(2,['fig2_' infiledata],'eps');

%% descriptive statistics
if ind_descriptive
    alldata_=sort(alldata(:,3:end));
    alldata0=sort(alldata_(alldata_(:,1)==0,:));
    alldata1=sort(alldata_(alldata_(:,1)==1,:));
    N=size(alldata,1);
    N0=size(alldata0,1);
    N1=size(alldata1,1);
    qv=[.25 .5 .75]';
    nall=size(alldata,2)-2; % all the variables
    nstat=8;
    output_descriptive=zeros(nall,nstat,3);
    mean_=mean(alldata_)';
    mean0=mean(alldata0)';
    mean1=mean(alldata1)';
    sd_=std(alldata_)';
    sd0=std(alldata0)';
    sd1=std(alldata1)';
    dfv=((sd1.^2)/N1+(sd0.^2)/N0)./((((sd1.^2)/N1).^2)/(N1-1)+(((sd0.^2)/N0).^2)/(N0-1));
    output_descriptive(:,1,1)=mean_;
    output_descriptive(:,1,2)=mean0;
    output_descriptive(:,1,3)=mean1;
    output_descriptive(:,2,1)=sd_;
    output_descriptive(:,2,2)=sd0;
    output_descriptive(:,2,3)=sd1;
    ztest=(mean0-mean1)./sqrt(((sd0.^2)/N0)+(sd1.^2)/N1);
    output_descriptive(:,3,:)=repmat(ztest,[1 1 3]);
    output_descriptive(:,4,1)=alldata_(1,:)';
    output_descriptive(:,4,2)=alldata0(1,:)';
    output_descriptive(:,4,3)=alldata1(1,:)';
    output_descriptive(:,5,1)=alldata_(end,:)';
    output_descriptive(:,5,2)=alldata0(end,:)';
    output_descriptive(:,5,3)=alldata1(end,:)';
    output_descriptive(:,6:8,1)=alldata_(ceil(N*qv),:)';
    output_descriptive(:,6:8,2)=alldata0(ceil(N0*qv),:)';
    output_descriptive(:,6:8,3)=alldata1(ceil(N1*qv),:)';
    str_output1=[];
    for is=1:nstat
        str_output1{is,1}='all';
        str_output1{is+nstat,1}='depvar = 0';
        str_output1{is+nstat*2,1}='depvar = 1';
    end
    str_output2=[];
    str_output2{1,1}='mean';
    str_output2{2,1}='sd';
    str_output2{3,1}='ztest';
    str_output2{4,1}='min';
    str_output2{5,1}='max';
    str_output2{6,1}='.25 q';
    str_output2{7,1}='median';
    str_output2{8,1}='.75 q';
    str_output2=repmat(str_output2,3,1);
    str_N=[];
    str_N{1,1}='N';
    str_N{2,1}='N0';
    str_N{3,1}='N1';
    xlswrite(resultsfilename,str_output1',2,'b1');
    xlswrite(resultsfilename,str_output2',2,'b2');
    xlswrite(resultsfilename,all_str(3:end),2,'a3');
    output_descriptive_m=[squeeze(output_descriptive(:,:,1)) squeeze(output_descriptive(:,:,2)) squeeze(output_descriptive(:,:,3))];
    xlswrite(resultsfilename,output_descriptive_m,2,'b3');
    xlswrite(resultsfilename,str_N,2,['a' int2str(nall+3)]);
    xlswrite(resultsfilename,[N;N0;N1],2,['b' int2str(nall+3)]);
    nstat1=3;
    str_output1=[];
    for is=1:nstat1
        str_output1{is,1}='all';
        str_output1{is+nstat1,1}='depvar = 0';
        str_output1{is+nstat1*2,1}='depvar = 1';
    end
    str_output2=[];
    str_output2{1,1}='mean';
    str_output2{2,1}='sd';
    str_output2{3,1}='ztest';
    str_output2=repmat(str_output2,3,1);
    xlswrite(resultsfilename,str_output1',3,'b1');
    xlswrite(resultsfilename,str_output2',3,'b2');
    xlswrite(resultsfilename,all_str(3:end),3,'a3');
    output_descriptive_m=[squeeze(output_descriptive(:,1:nstat1,1)) squeeze(output_descriptive(:,1:nstat1,2)) squeeze(output_descriptive(:,1:nstat1,3))];
    xlswrite(resultsfilename,output_descriptive_m,3,'b3');
    xlswrite(resultsfilename,str_N,3,['a' int2str(nall+3)]);
    xlswrite(resultsfilename,[N;N0;N1],3,['b' int2str(nall+3)]);
end
    
%% %descriptive statistics across the years
T=size(za,1);
K=size(alldata,2)-2;
year_stats=zeros(T,K+4,7);
all_str_ys=['year';str_N;all_str(3:end,1)];
str_output1_ys=str_output1([1 2 4 5 7 8],1);
str_output2_ys=str_output2([1 2 4 5 7 8],1);
for it=alldata(1,1):alldata(end,1)
    it1=it-alldata(1,1)+1;
    alldata_=alldata(alldata(:,1)==it,:);
    alldata_=alldata_(:,3:end);
    alldata1=alldata_(alldata_(:,1)==1,:);
    alldata0=alldata_(alldata_(:,1)==0,:);
    mean_=mean(alldata_)';
    std_=std(alldata_)';
    N=size(alldata_,1);
    N0=size(alldata0,1);
    N1=size(alldata1,1);
    if N1==0
        mean_1=zeros(K,1);
        std_1=zeros(K,1);
    elseif N1>1
            mean_1=mean(alldata1)';
            std_1=std(alldata1)' ;
    else
            mean_1=alldata1';
            std_1=0*mean_1;
    end
    if N0==0
        mean_0=zeros(K,1);
        std_0=zeros(K,1);
    elseif N0>1
        mean_0=mean(alldata0)';
        std_0=std(alldata0)';
    else
        mean_0=alldata0';
        std_0=0*mean_0;
    end
    year_stats(it1,1,1)=it;
    year_stats(it1,2:4,1)=[N N0 N1]';
    year_stats(it1,5:end,:)=[mean_ std_ mean_0 std_0 mean_1 std_1 mean_0< mean_1 ];
    i1=(it1-1)*(K+6)+1;
    xlswrite(resultsfilename,str_output1_ys',4,['b' int2str(i1)]);
    xlswrite(resultsfilename,str_output2_ys',4,['b' int2str(i1+1)]);
    xlswrite(resultsfilename,all_str_ys,4,['a' int2str(i1+2)]);
    xlswrite(resultsfilename,squeeze(year_stats(it1,:,:)),4,['b' int2str(i1+2)]);
end    
%% compute ML
%lnPL=sum(param(:,npar+2:npar+3),2);
for ik=1:(nk+3)
    ml_infom(isnan(ml_infom(:,ik)),:)=[];
end
[MLvec,MLcoverage]=MLMGD(ml_infom(:,3:end),sum(ml_infom(:,1:2),2));
xlswrite(resultsfilename,[MLvec MLcoverage],5);
%% write decomposition
xlswrite(resultsfilename,mean(varm),6);
