function LLH = concentrated_llhSN(Y,mu,eta)
%calculate the concentrated log likelihood of skew Normal
%   f_SN = 2 normpdf(Y,mu,Sigma)*normcdf(eta*(Y-mu),0,1)
%    where Sigma = (Y-mu)'(Y-mu)/N
Sigma = (Y-mu)'*(Y-mu)/size(Y,1);
f_SN = 2*mvnpdf(Y,mu,Sigma).*normcdf((Y-mu)*eta',0,1);
LLH = sum(log(f_SN));
end

