clc
clear

% calculate Test Statist
load('data10_00.mat')
N = size(data10_00,1);
data10_00(data10_00(:,1)==0,:)=[];
data10_00(data10_00(:,2)==0,:)=[];
ldata=log(data10_00);
n=size(ldata,1);

s=skewness(ldata); s(3)=skewness(ldata(:,1)-ldata(:,2));
s_stat = n/6*s.^2;
s_p = 1-chi2cdf(s_stat,1);

k=kurtosis(ldata); k(3)=kurtosis(ldata(:,1)-ldata(:,2));
k_stat = n/6*(k-3).^2/4;
k_p = 1-chi2cdf(k_stat,1);

n=size(ldata,1);
jb = n/6*(s.^2+(k-3).^2/4);
jb_p = 1-chi2cdf(jb,2);

% GET
gs = GlobalSearch('Display','off','NumTrialPoints',1000);
problem = createOptimProblem('fmincon','x0',0,'objective',@(a) -suptest(ldata,1,a));
[lambda,GET] = run(gs,problem);
GET = - GET;

% Margins
margin = Marginstat(ldata);

% AA
lm_AA = LMAAstat(ldata);

% GMM
GMM = GMMstat(ldata);
        
Stat = [GET lm_AA GMM margin];
save('all_Stat')

