---
title: "Replication file for: Anchoring the yield curve: term structure forecasting using survey data"
subtitle: "DNS model in state space form"
date: \today
author:
- Carlo Altavilla^[European Central Bank]
- Raffaella Giacomini^[University College London]
- Giuseppe Ragusa^[Luiss University]
output:
  pdf_document:
    keep_tex: true
    includes:
      in_header: header.tex
    toc: false
fontsize: 12pt
geometry: margin=1in
---

\listoffigures
\listoftables
\clearpage


```r
if (!require("pacman")) {
  install.packages("pacman", repos = "https://cran.rstudio.com")
  require(pacman)
  }
```

```
## Loading required package: pacman
```

```r
pkg_from_cran = c(
  "tikzDevice",
  "Hmisc",
  "RColorBrewer",
  "RcppRoll",
  "dplyr",
  "forecast",
  "ggplot2",
  "ggthemes",
  "lubridate",
  "purrr",
  "reshape2",
  "sandwich",
  "xts"
  )

p_load(char = pkg_from_cran)

## Patch latex form Hmisc to work with markdown
if (!is.na(match("latex.R", list.files("."))))
  source("latex.R")
```













\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
\begin{center}
\begin{tabular}{lllll}
\hline\hline
\multicolumn{1}{l}{Maturity}&\multicolumn{1}{c}{$h = 3$}&\multicolumn{1}{c}{$h = 6$}&\multicolumn{1}{c}{$h = 9$}&\multicolumn{1}{c}{$h = 12$}\tabularnewline
\hline
$\tau = 3$&0.79&0.83&0.89&0.98\tabularnewline
$\tau = 6$&0.79&0.86&0.93&1.00\tabularnewline
$\tau = 12$&1.01&1.03&1.09&1.14\tabularnewline
$\tau = 25$&1.23&1.23&1.33&1.38\tabularnewline
$\tau = 60$&1.33&1.35&1.59&1.72\tabularnewline
$\tau = 120$&1.31&1.16&1.32&1.50\tabularnewline
\hline
\end{tabular}
\caption{MSFE of Blue Chip survey forecasts (relative to the Random Walk forecast)\label{}}\end{center}
\end{table}




\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
\begin{center}
\begin{tabular}{lllll}
\hline\hline
\multicolumn{1}{l}{Maturity}&\multicolumn{1}{c}{$h = 3$}&\multicolumn{1}{c}{$h = 6$}&\multicolumn{1}{c}{$h = 9$}&\multicolumn{1}{c}{$h = 12$}\tabularnewline
\hline
$\tau = 3$&0.42&0.58&0.69&0.81\tabularnewline
$\tau = 6$&0.64&0.74&0.83&0.93\tabularnewline
$\tau = 12$&0.87&0.90&0.97&1.06\tabularnewline
$\tau = 24$&1.07&1.06&1.13&1.21\tabularnewline
$\tau = 60$&1.10&1.12&1.23&1.32\tabularnewline
$\tau = 120$&1.25&1.26&1.53&1.71\tabularnewline
\hline
\end{tabular}
\caption{MSFE of Blue Chip survey forecasts (relative to the Yields-only DNS  forecasts)\label{}}\end{center}
\end{table}







<img src="figures/factors-1.pdf" title="DNS factors and empirical counterparts.The first factor $\beta_{1t}$ controls the yield curve level, as it can be verified that $\lim_{\tau\to\infty}y_{t}(\tau)=\beta_{1t}$. The second factor $\beta_{2t}$ is related to the yield curve slope, defined as the difference between the 10-year and three-month yields. The third factor $\beta_{3t}$ governs the curvature of the yield curve, defined as twice the two-year yield minus the sum of the 10-year and three-month yields." alt="DNS factors and empirical counterparts.The first factor $\beta_{1t}$ controls the yield curve level, as it can be verified that $\lim_{\tau\to\infty}y_{t}(\tau)=\beta_{1t}$. The second factor $\beta_{2t}$ is related to the yield curve slope, defined as the difference between the 10-year and three-month yields. The third factor $\beta_{3t}$ governs the curvature of the yield curve, defined as twice the two-year yield minus the sum of the 10-year and three-month yields." style="display: block; margin: auto;" />



\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
{\footnotesize
\begin{center}
\begin{tabular}{llllllllll}
\hline\hline
\multicolumn{1}{c}{Maturity (months)}&\multicolumn{1}{c}{Mean}&\multicolumn{1}{c}{SD}&\multicolumn{1}{c}{Min}&\multicolumn{1}{c}{Max}&\multicolumn{1}{c}{MAE}&\multicolumn{1}{c}{RMSE}&\multicolumn{1}{c}{$\hat{\rho}(1)$}&\multicolumn{1}{c}{$\hat{\rho}(12)$}&\multicolumn{1}{c}{$\hat{\rho}(30)$}\tabularnewline
\hline
  3&-2.1e-01&2.4e-01&-1.6e+00&4.7e-01&1.0e-01&3.2e-01&0.86&0.29&-0.0385\tabularnewline
  6&-4.9e-02&6.3e-02&-2.7e-01&2.2e-01&6.4e-03&8.0e-02&0.86&0.29&-0.0448\tabularnewline
  9&-1.7e-02&1.9e-02&-7.7e-02&5.7e-02&6.8e-04&2.6e-02&0.87&0.33&-0.0377\tabularnewline
 12&-4.3e-08&4.8e-08&-2.2e-07&1.3e-07&4.1e-15&6.4e-08&0.44&0.25& 0.1146\tabularnewline
 15& 6.7e-03&6.2e-03&-1.2e-02&2.9e-02&8.4e-05&9.2e-03&0.89&0.39&-0.0064\tabularnewline
 18& 5.9e-03&5.2e-03&-7.7e-03&2.5e-02&6.1e-05&7.8e-03&0.90&0.41& 0.0126\tabularnewline
 21& 1.8e-09&6.0e-08&-2.8e-07&2.8e-07&3.6e-15&6.0e-08&0.41&0.11& 0.0080\tabularnewline
 24&-8.9e-03&7.3e-03&-3.6e-02&5.8e-03&1.3e-04&1.2e-02&0.91&0.45& 0.0493\tabularnewline
 30&-3.0e-02&2.4e-02&-1.2e-01&2.0e-02&1.5e-03&3.8e-02&0.91&0.47& 0.0803\tabularnewline
 36&-5.0e-02&3.8e-02&-1.9e-01&3.5e-02&3.9e-03&6.3e-02&0.92&0.48& 0.1054\tabularnewline
 48&-7.1e-02&5.3e-02&-2.6e-01&5.4e-02&7.9e-03&8.9e-02&0.92&0.49& 0.1425\tabularnewline
 60&-6.6e-02&4.8e-02&-2.3e-01&5.3e-02&6.7e-03&8.2e-02&0.92&0.49& 0.1689\tabularnewline
 72&-3.9e-02&2.8e-02&-1.3e-01&3.3e-02&2.4e-03&4.9e-02&0.92&0.48& 0.1891\tabularnewline
 84& 1.0e-08&2.0e-08&-3.2e-08&1.6e-07&5.1e-16&2.2e-08&0.32&0.19&-0.0160\tabularnewline
 96& 4.6e-02&3.2e-02&-4.0e-02&1.4e-01&3.1e-03&5.6e-02&0.92&0.46& 0.2182\tabularnewline
108& 9.3e-02&6.4e-02&-8.1e-02&3.0e-01&1.3e-02&1.1e-01&0.91&0.45& 0.2282\tabularnewline
120& 1.4e-01&9.4e-02&-1.2e-01&4.4e-01&2.8e-02&1.7e-01&0.91&0.44& 0.2351\tabularnewline
\hline
\end{tabular}
\caption{In-sample fit statistic of the DNS model in state-space form. The descriptive statistics refer to the residuals of the equation for yields at the corresponding maturities. The last three columns present residual sample autocorrelations at lag 1, 12, and 30, respectively.\label{}}\end{center}}
\end{table}





The curvature factor closely matches the dynamics of its empirical counterpart: the difference between the two series has a mean of -12.4153349 basis points and a standard deviation of 19.1797888 basis points. Also, the slope factor matches very closely the empirical proxy for the slope with a correlation of 0.9799311. The level factor shows instead a marked departure from the empirical counterpart. Importantly, this departure is most noticeable in the period 2000-2011. In particular, from January 1985 to December 2001, the correlation between $\\hat{\beta}_{1,t}$ and $(y_{t}(3)+y_{t}(24)+y_{t}(120))/3$ is 0.8077292, from January 2002 to December 2011 the correlation drops to 0.2920553. The mean and standard deviations of the difference increase from 119.3886625 basis points to 196.316468 basis points and from 93.8050413 basis points to 124.6348969 basis points, respectively.









<img src="figures/relative_mse_dns-1.pdf" title="Relative MSFE of the forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts" alt="Relative MSFE of the forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts" style="display: block; margin: auto;" />

<img src="figures/relative_msfe_dns_tilted-1.pdf" title="Relative MSFE of the tilted forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts" alt="Relative MSFE of the tilted forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts" style="display: block; margin: auto;" />


<img src="figures/rolling_base-1.pdf" title="Rolling relative MSFE of the forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts" alt="Rolling relative MSFE of the forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts" style="display: block; margin: auto;" />

<img src="figures/rolling_macro-1.pdf" title="Rolling relative MSFE of the tilted forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts" alt="Rolling relative MSFE of the tilted forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts" style="display: block; margin: auto;" />


<img src="figures/rolling_macro_2-1.pdf" title="Rolling relative MSFE of the tilted forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts. Both the 3-month and the 6-month BC forecasts." alt="Rolling relative MSFE of the tilted forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts. Both the 3-month and the 6-month BC forecasts." style="display: block; margin: auto;" />


<img src="figures/rolling_macro_mae-1.pdf" title="Rolling relative MAFE of the tilted forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts" alt="Rolling relative MAFE of the tilted forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts" style="display: block; margin: auto;" />


<img src="figures/rolling_macro_mae_2-1.pdf" title="Rolling relative MAFE of the tilted forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts. Both the 3-month and the 6-month BC forecasts." alt="Rolling relative MAFE of the tilted forecasts based on the  yields only and macro augmented DNS models against the random walk forecasts. Both the 3-month and the 6-month BC forecasts." style="display: block; margin: auto;" />



<img src="figures/encompassing-1.pdf" title="Notes: The figure reports the sequence of test statistics for the time-varying encompassing test described in Section 3.2, testing the null hypothesis that the BC forecast encompasses the DNS forecast, against the alternative hypothesis that it does not. The null hypothesis is rejected when the sequence of test statistics crosses the horizontal solid line, which represents the critical value (which equals 2.62 for test statistics computed over an estimation window that uses $40\%$ of the out-of-sample observations and for a $5\%$ significance level)." alt="Notes: The figure reports the sequence of test statistics for the time-varying encompassing test described in Section 3.2, testing the null hypothesis that the BC forecast encompasses the DNS forecast, against the alternative hypothesis that it does not. The null hypothesis is rejected when the sequence of test statistics crosses the horizontal solid line, which represents the critical value (which equals 2.62 for test statistics computed over an estimation window that uses $40\%$ of the out-of-sample observations and for a $5\%$ significance level)." style="display: block; margin: auto;" />
\clearpage


<img src="figures/encompassing_36-1.pdf" title="Notes: The figure reports the sequence of test statistics for the time-varying encompassing test described in Section 3.2, testing the null hypothesis that the BC forecast encompasses the DNS forecast, against the alternative hypothesis that it does not. The null hypothesis is rejected when the sequence of test statistics crosses the horizontal solid line, which represents the critical value (which equals 2.62 for test statistics computed over an estimation window that uses $40\%$ of the out-of-sample observations and for a $5\%$ significance level)." alt="Notes: The figure reports the sequence of test statistics for the time-varying encompassing test described in Section 3.2, testing the null hypothesis that the BC forecast encompasses the DNS forecast, against the alternative hypothesis that it does not. The null hypothesis is rejected when the sequence of test statistics crosses the horizontal solid line, which represents the critical value (which equals 2.62 for test statistics computed over an estimation window that uses $40\%$ of the out-of-sample observations and for a $5\%$ significance level)." style="display: block; margin: auto;" />
\clearpage




\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
{\footnotesize
\begin{center}
\begin{tabular}{lllllcllll}
\hline\hline
\multicolumn{1}{l}{\bfseries Maturity}&\multicolumn{4}{c}{\bfseries Anchored vs DNS}&\multicolumn{1}{c}{\bfseries }&\multicolumn{4}{c}{\bfseries Anchored vs RW}\tabularnewline
\cline{2-5} \cline{7-10}
\multicolumn{1}{l}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}&\multicolumn{1}{c}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}\tabularnewline
\hline
3&$0.42^{***}$&$0.58^{*}$&$0.70^{}$&$0.83^{}$&&$0.79^{***}$&$0.84^{*}$&$0.90^{}$&$1.00^{}$\tabularnewline
6&$0.58^{***}$&$0.66^{***}$&$0.74^{*}$&$0.84^{}$&&$0.71^{***}$&$0.77^{***}$&$0.83^{*}$&$0.91^{}$\tabularnewline
9&$0.66^{**}$&$0.70^{**}$&$0.77^{}$&$0.87^{}$&&$0.78^{**}$&$0.81^{**}$&$0.86^{}$&$0.93^{}$\tabularnewline
12&$0.72^{*}$&$0.74^{*}$&$0.79^{}$&$0.89^{}$&&$0.84^{*}$&$0.85^{*}$&$0.89^{}$&$0.96^{}$\tabularnewline
15&$0.77^{}$&$0.77^{}$&$0.81^{}$&$0.91^{}$&&$0.88^{}$&$0.88^{}$&$0.92^{}$&$0.99^{}$\tabularnewline
18&$0.80^{}$&$0.80^{}$&$0.83^{}$&$0.93^{}$&&$0.90^{}$&$0.91^{}$&$0.95^{}$&$1.02^{}$\tabularnewline
21&$0.81^{}$&$0.82^{}$&$0.85^{}$&$0.94^{}$&&$0.93^{}$&$0.94^{}$&$0.99^{}$&$1.06^{}$\tabularnewline
24&$0.82^{}$&$0.84^{}$&$0.87^{}$&$0.96^{}$&&$0.95^{}$&$0.97^{}$&$1.02^{}$&$1.09^{}$\tabularnewline
30&$0.84^{}$&$0.86^{}$&$0.90^{}$&$0.98^{}$&&$0.98^{}$&$1.02^{}$&$1.09^{}$&$1.17^{}$\tabularnewline
36&$0.84^{}$&$0.89^{}$&$0.92^{}$&$1.01^{}$&&$1.02^{}$&$1.07^{}$&$1.16^{}$&$1.24^{}$\tabularnewline
48&$0.86^{}$&$0.92^{}$&$0.96^{}$&$1.04^{}$&&$1.07^{}$&$1.13^{}$&$1.26^{}$&$1.35^{}$\tabularnewline
60&$0.88^{}$&$0.95^{}$&$0.99^{}$&$1.07^{}$&&$1.07^{}$&$1.14^{}$&$1.28^{}$&$1.40^{}$\tabularnewline
72&$0.92^{}$&$0.98^{}$&$1.02^{}$&$1.10^{}$&&$1.03^{}$&$1.11^{}$&$1.25^{}$&$1.37^{}$\tabularnewline
84&$0.97^{}$&$1.02^{}$&$1.06^{}$&$1.12^{}$&&$1.00^{}$&$1.07^{}$&$1.18^{}$&$1.30^{}$\tabularnewline
96&$1.04^{}$&$1.06^{}$&$1.10^{}$&$1.15^{}$&&$1.01^{}$&$1.04^{}$&$1.11^{}$&$1.21^{}$\tabularnewline
108&$1.10^{}$&$1.11^{}$&$1.14^{}$&$1.17^{}$&&$1.08^{}$&$1.03^{}$&$1.05^{}$&$1.12^{}$\tabularnewline
120&$1.15^{}$&$1.15^{}$&$1.17^{}$&$1.19^{}$&&$1.20^{}$&$1.06^{}$&$1.02^{}$&$1.05^{}$\tabularnewline
\hline
\end{tabular}
\caption{\textbf{Relative MSFEs of anchored forecasts. Baseline model:Yields only Sample: 2000:01 - 2011:12.} The table reports the ratios of MSFE for the models considered. The asterisk indicates significance  according to the Diebold and Mariano (1995) test of equal accuracy against the alternative that the anchored forecast is more accurate ('***' at the 1\%, '**' at the 5\%, and '*' at the 1\%). The Diebold and Mariano test was implemented using an HAC estimator with $h-1$ truncation parameter.\label{}}\end{center}}
\end{table}
\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
{\footnotesize
\begin{center}
\begin{tabular}{lllllcllll}
\hline\hline
\multicolumn{1}{l}{\bfseries Maturity}&\multicolumn{4}{c}{\bfseries Anchored vs DNS}&\multicolumn{1}{c}{\bfseries }&\multicolumn{4}{c}{\bfseries Anchored vs RW}\tabularnewline
\cline{2-5} \cline{7-10}
\multicolumn{1}{l}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}&\multicolumn{1}{c}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}\tabularnewline
\hline
3&$0.32^{***}$&$0.49^{*}$&$0.63^{}$&$0.78^{}$&&$0.79^{***}$&$0.84^{*}$&$0.90^{}$&$1.00^{}$\tabularnewline
6&$0.51^{***}$&$0.63^{***}$&$0.72^{*}$&$0.84^{}$&&$0.73^{***}$&$0.77^{***}$&$0.83^{*}$&$0.91^{}$\tabularnewline
9&$0.63^{**}$&$0.71^{*}$&$0.77^{}$&$0.88^{}$&&$0.79^{**}$&$0.83^{*}$&$0.87^{}$&$0.93^{}$\tabularnewline
12&$0.72^{*}$&$0.77^{}$&$0.82^{}$&$0.90^{}$&&$0.87^{*}$&$0.88^{}$&$0.91^{}$&$0.96^{}$\tabularnewline
15&$0.79^{}$&$0.82^{}$&$0.85^{}$&$0.92^{}$&&$0.92^{}$&$0.93^{}$&$0.94^{}$&$0.98^{}$\tabularnewline
18&$0.84^{}$&$0.85^{}$&$0.87^{}$&$0.94^{}$&&$0.96^{}$&$0.96^{}$&$0.98^{}$&$1.01^{}$\tabularnewline
21&$0.86^{}$&$0.87^{}$&$0.89^{}$&$0.94^{}$&&$0.99^{}$&$0.99^{}$&$1.01^{}$&$1.04^{}$\tabularnewline
24&$0.87^{}$&$0.88^{}$&$0.90^{}$&$0.95^{}$&&$1.01^{}$&$1.02^{}$&$1.04^{}$&$1.07^{}$\tabularnewline
30&$0.88^{}$&$0.90^{}$&$0.91^{}$&$0.96^{}$&&$1.03^{}$&$1.06^{}$&$1.09^{}$&$1.11^{}$\tabularnewline
36&$0.87^{}$&$0.90^{}$&$0.91^{}$&$0.96^{}$&&$1.04^{}$&$1.08^{}$&$1.12^{}$&$1.15^{}$\tabularnewline
48&$0.87^{}$&$0.91^{}$&$0.92^{}$&$0.95^{}$&&$1.05^{}$&$1.10^{}$&$1.16^{}$&$1.19^{}$\tabularnewline
60&$0.89^{}$&$0.93^{}$&$0.93^{}$&$0.95^{}$&&$1.04^{}$&$1.09^{}$&$1.14^{}$&$1.17^{}$\tabularnewline
72&$0.94^{}$&$0.97^{}$&$0.95^{}$&$0.95^{}$&&$1.02^{}$&$1.05^{}$&$1.09^{}$&$1.10^{}$\tabularnewline
84&$1.02^{}$&$1.02^{}$&$0.99^{}$&$0.96^{}$&&$1.03^{}$&$1.03^{}$&$1.03^{}$&$1.01^{}$\tabularnewline
96&$1.10^{}$&$1.08^{}$&$1.03^{}$&$0.97^{}$&&$1.09^{}$&$1.04^{}$&$0.98^{}$&$0.92^{}$\tabularnewline
108&$1.19^{}$&$1.15^{}$&$1.09^{}$&$0.99^{}$&&$1.21^{}$&$1.08^{}$&$0.96^{}$&$0.85^{}$\tabularnewline
120&$1.24^{}$&$1.21^{}$&$1.15^{}$&$1.02^{}$&&$1.39^{}$&$1.16^{}$&$0.98^{}$&$0.81^{}$\tabularnewline
\hline
\end{tabular}
\caption{\textbf{Relative MSFEs of anchored forecasts. Baseline model:macro augmented Sample: 2000:01 - 2011:12.} The table reports the ratios of MSFE for the models considered. The asterisk indicates significance  according to the Diebold and Mariano (1995) test of equal accuracy against the alternative that the anchored forecast is more accurate ('***' at the 1\%, '**' at the 5\%, and '*' at the 1\%). The Diebold and Mariano test was implemented using an HAC estimator with $h-1$ truncation parameter.\label{}}\end{center}}
\end{table}


\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
{\footnotesize
\begin{center}
\begin{tabular}{lllllcllll}
\hline\hline
\multicolumn{1}{l}{\bfseries Maturity}&\multicolumn{4}{c}{\bfseries Anchored vs DNS}&\multicolumn{1}{c}{\bfseries }&\multicolumn{4}{c}{\bfseries Anchored vs RW}\tabularnewline
\cline{2-5} \cline{7-10}
\multicolumn{1}{l}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}&\multicolumn{1}{c}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}\tabularnewline
\hline
3&$0.42^{***}$&$0.58^{*}$&$0.70^{}$&$0.83^{}$&&$0.79^{***}$&$0.84^{*}$&$0.90^{}$&$1.00^{}$\tabularnewline
6&$0.64^{***}$&$0.73^{*}$&$0.83^{}$&$0.94^{}$&&$0.78^{***}$&$0.85^{*}$&$0.94^{}$&$1.02^{}$\tabularnewline
9&$0.70^{***}$&$0.78^{}$&$0.87^{}$&$0.98^{}$&&$0.83^{***}$&$0.89^{}$&$0.98^{}$&$1.06^{}$\tabularnewline
12&$0.76^{*}$&$0.82^{}$&$0.92^{}$&$1.03^{}$&&$0.88^{*}$&$0.94^{}$&$1.03^{}$&$1.11^{}$\tabularnewline
15&$0.81^{}$&$0.86^{}$&$0.96^{}$&$1.07^{}$&&$0.93^{}$&$0.98^{}$&$1.08^{}$&$1.16^{}$\tabularnewline
18&$0.85^{}$&$0.90^{}$&$0.99^{}$&$1.10^{}$&&$0.96^{}$&$1.03^{}$&$1.14^{}$&$1.22^{}$\tabularnewline
21&$0.88^{}$&$0.93^{}$&$1.03^{}$&$1.14^{}$&&$1.00^{}$&$1.07^{}$&$1.19^{}$&$1.28^{}$\tabularnewline
24&$0.90^{}$&$0.96^{}$&$1.06^{}$&$1.18^{}$&&$1.03^{}$&$1.12^{}$&$1.25^{}$&$1.34^{}$\tabularnewline
30&$0.93^{}$&$1.01^{}$&$1.12^{}$&$1.24^{}$&&$1.09^{}$&$1.20^{}$&$1.37^{}$&$1.47^{}$\tabularnewline
36&$0.95^{}$&$1.05^{}$&$1.17^{}$&$1.29^{}$&&$1.15^{}$&$1.27^{}$&$1.47^{}$&$1.59^{}$\tabularnewline
48&$0.98^{}$&$1.10^{}$&$1.24^{}$&$1.36^{}$&&$1.22^{}$&$1.36^{}$&$1.62^{}$&$1.77^{}$\tabularnewline
60&$1.01^{}$&$1.14^{}$&$1.29^{}$&$1.42^{}$&&$1.22^{}$&$1.37^{}$&$1.67^{}$&$1.85^{}$\tabularnewline
72&$1.03^{}$&$1.17^{}$&$1.33^{}$&$1.46^{}$&&$1.16^{}$&$1.32^{}$&$1.62^{}$&$1.84^{}$\tabularnewline
84&$1.06^{}$&$1.19^{}$&$1.36^{}$&$1.50^{}$&&$1.10^{}$&$1.25^{}$&$1.52^{}$&$1.74^{}$\tabularnewline
96&$1.09^{}$&$1.21^{}$&$1.38^{}$&$1.53^{}$&&$1.06^{}$&$1.18^{}$&$1.40^{}$&$1.62^{}$\tabularnewline
108&$1.11^{}$&$1.22^{}$&$1.39^{}$&$1.55^{}$&&$1.08^{}$&$1.14^{}$&$1.29^{}$&$1.48^{}$\tabularnewline
120&$1.12^{}$&$1.22^{}$&$1.38^{}$&$1.54^{}$&&$1.16^{}$&$1.12^{}$&$1.20^{}$&$1.36^{}$\tabularnewline
\hline
\end{tabular}
\caption{\textbf{Relative MSFEs of anchored forecasts using both 3m and 6m BC forecasts. Baseline model:Yields only Sample: 2000:01 - 2011:12.} The table reports the ratios of MSFE for the models considered. The asterisk indicates significance  according to the Diebold and Mariano (1995) test of equal accuracy against the alternative that the anchored forecast is more accurate ('***' at the 1\%, '**' at the 5\%, and '*' at the 1\%). The Diebold and Mariano test was implemented using an HAC estimator with $h-1$ truncation parameter.\label{}}\end{center}}
\end{table}
\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
{\footnotesize
\begin{center}
\begin{tabular}{lllllcllll}
\hline\hline
\multicolumn{1}{l}{\bfseries Maturity}&\multicolumn{4}{c}{\bfseries Anchored vs DNS}&\multicolumn{1}{c}{\bfseries }&\multicolumn{4}{c}{\bfseries Anchored vs RW}\tabularnewline
\cline{2-5} \cline{7-10}
\multicolumn{1}{l}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}&\multicolumn{1}{c}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}\tabularnewline
\hline
3&$0.32^{***}$&$0.49^{*}$&$0.63^{}$&$0.78^{}$&&$0.79^{***}$&$0.84^{*}$&$0.90^{}$&$1.00^{}$\tabularnewline
6&$0.55^{***}$&$0.69^{*}$&$0.81^{}$&$0.94^{}$&&$0.78^{***}$&$0.85^{*}$&$0.94^{}$&$1.02^{}$\tabularnewline
9&$0.66^{**}$&$0.76^{}$&$0.86^{}$&$0.98^{}$&&$0.83^{**}$&$0.89^{}$&$0.97^{}$&$1.04^{}$\tabularnewline
12&$0.76^{}$&$0.82^{}$&$0.91^{}$&$1.02^{}$&&$0.91^{}$&$0.94^{}$&$1.01^{}$&$1.08^{}$\tabularnewline
15&$0.83^{}$&$0.87^{}$&$0.95^{}$&$1.05^{}$&&$0.96^{}$&$0.99^{}$&$1.06^{}$&$1.12^{}$\tabularnewline
18&$0.87^{}$&$0.91^{}$&$0.98^{}$&$1.07^{}$&&$1.01^{}$&$1.03^{}$&$1.10^{}$&$1.16^{}$\tabularnewline
21&$0.90^{}$&$0.93^{}$&$1.00^{}$&$1.09^{}$&&$1.03^{}$&$1.06^{}$&$1.14^{}$&$1.20^{}$\tabularnewline
24&$0.92^{}$&$0.95^{}$&$1.02^{}$&$1.10^{}$&&$1.06^{}$&$1.09^{}$&$1.18^{}$&$1.23^{}$\tabularnewline
30&$0.93^{}$&$0.97^{}$&$1.05^{}$&$1.12^{}$&&$1.08^{}$&$1.14^{}$&$1.25^{}$&$1.31^{}$\tabularnewline
36&$0.92^{}$&$0.99^{}$&$1.06^{}$&$1.14^{}$&&$1.10^{}$&$1.18^{}$&$1.31^{}$&$1.37^{}$\tabularnewline
48&$0.93^{}$&$1.00^{}$&$1.08^{}$&$1.16^{}$&&$1.12^{}$&$1.21^{}$&$1.37^{}$&$1.45^{}$\tabularnewline
60&$0.95^{}$&$1.02^{}$&$1.10^{}$&$1.17^{}$&&$1.11^{}$&$1.19^{}$&$1.35^{}$&$1.44^{}$\tabularnewline
72&$0.99^{}$&$1.04^{}$&$1.11^{}$&$1.17^{}$&&$1.08^{}$&$1.14^{}$&$1.27^{}$&$1.36^{}$\tabularnewline
84&$1.05^{}$&$1.07^{}$&$1.12^{}$&$1.17^{}$&&$1.06^{}$&$1.09^{}$&$1.17^{}$&$1.23^{}$\tabularnewline
96&$1.12^{}$&$1.11^{}$&$1.13^{}$&$1.15^{}$&&$1.10^{}$&$1.06^{}$&$1.07^{}$&$1.10^{}$\tabularnewline
108&$1.18^{}$&$1.14^{}$&$1.13^{}$&$1.13^{}$&&$1.20^{}$&$1.07^{}$&$1.00^{}$&$0.97^{}$\tabularnewline
120&$1.22^{}$&$1.17^{}$&$1.12^{}$&$1.09^{}$&&$1.36^{}$&$1.11^{}$&$0.95^{}$&$0.87^{}$\tabularnewline
\hline
\end{tabular}
\caption{\textbf{Relative MSFEs of anchored forecasts using both 3m and 6m BC forecasts. Baseline model:macro augmented Sample: 2000:01 - 2011:12.} The table reports the ratios of MSFE for the models considered. The asterisk indicates significance  according to the Diebold and Mariano (1995) test of equal accuracy against the alternative that the anchored forecast is more accurate ('***' at the 1\%, '**' at the 5\%, and '*' at the 1\%). The Diebold and Mariano test was implemented using an HAC estimator with $h-1$ truncation parameter.\label{}}\end{center}}
\end{table}

\clearpage
\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
{\footnotesize
\begin{center}
\begin{tabular}{lllllcllll}
\hline\hline
\multicolumn{1}{l}{\bfseries Maturity}&\multicolumn{4}{c}{\bfseries Anchored vs DNS}&\multicolumn{1}{c}{\bfseries }&\multicolumn{4}{c}{\bfseries Anchored vs RW}\tabularnewline
\cline{2-5} \cline{7-10}
\multicolumn{1}{l}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}&\multicolumn{1}{c}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}\tabularnewline
\hline
3&$0.47^{***}$&$0.62^{**}$&$0.72^{}$&$0.83^{}$&&$0.77^{***}$&$0.82^{**}$&$0.88^{}$&$0.96^{}$\tabularnewline
6&$0.61^{***}$&$0.68^{***}$&$0.75^{*}$&$0.84^{}$&&$0.70^{***}$&$0.76^{***}$&$0.81^{*}$&$0.88^{}$\tabularnewline
9&$0.67^{***}$&$0.72^{**}$&$0.78^{}$&$0.86^{}$&&$0.76^{***}$&$0.80^{**}$&$0.84^{}$&$0.90^{}$\tabularnewline
12&$0.71^{**}$&$0.75^{*}$&$0.80^{}$&$0.88^{}$&&$0.81^{**}$&$0.83^{*}$&$0.87^{}$&$0.92^{}$\tabularnewline
15&$0.75^{*}$&$0.78^{}$&$0.82^{}$&$0.90^{}$&&$0.84^{*}$&$0.86^{}$&$0.89^{}$&$0.94^{}$\tabularnewline
18&$0.78^{}$&$0.80^{}$&$0.84^{}$&$0.92^{}$&&$0.87^{}$&$0.89^{}$&$0.92^{}$&$0.96^{}$\tabularnewline
21&$0.80^{}$&$0.82^{}$&$0.86^{}$&$0.93^{}$&&$0.89^{}$&$0.91^{}$&$0.94^{}$&$0.99^{}$\tabularnewline
24&$0.82^{}$&$0.84^{}$&$0.88^{}$&$0.95^{}$&&$0.91^{}$&$0.93^{}$&$0.97^{}$&$1.01^{}$\tabularnewline
30&$0.84^{}$&$0.87^{}$&$0.91^{}$&$0.98^{}$&&$0.95^{}$&$0.98^{}$&$1.03^{}$&$1.06^{}$\tabularnewline
36&$0.85^{}$&$0.90^{}$&$0.94^{}$&$1.01^{}$&&$0.99^{}$&$1.02^{}$&$1.08^{}$&$1.11^{}$\tabularnewline
48&$0.87^{}$&$0.93^{}$&$0.99^{}$&$1.05^{}$&&$1.04^{}$&$1.08^{}$&$1.16^{}$&$1.20^{}$\tabularnewline
60&$0.89^{}$&$0.96^{}$&$1.03^{}$&$1.09^{}$&&$1.04^{}$&$1.10^{}$&$1.20^{}$&$1.25^{}$\tabularnewline
72&$0.92^{}$&$0.99^{}$&$1.08^{}$&$1.13^{}$&&$1.01^{}$&$1.09^{}$&$1.20^{}$&$1.26^{}$\tabularnewline
84&$0.95^{}$&$1.02^{}$&$1.12^{}$&$1.17^{}$&&$0.98^{}$&$1.05^{}$&$1.18^{}$&$1.24^{}$\tabularnewline
96&$1.00^{}$&$1.06^{}$&$1.17^{}$&$1.21^{}$&&$0.96^{}$&$1.02^{}$&$1.14^{}$&$1.20^{}$\tabularnewline
108&$1.05^{}$&$1.10^{}$&$1.21^{}$&$1.24^{}$&&$1.00^{}$&$1.01^{}$&$1.11^{}$&$1.16^{}$\tabularnewline
120&$1.09^{}$&$1.13^{}$&$1.25^{}$&$1.26^{}$&&$1.09^{}$&$1.03^{}$&$1.10^{}$&$1.13^{}$\tabularnewline
\hline
\end{tabular}
\caption{\textbf{Relative MSFEs of anchored forecasts. DNS model:Yields only Sample: 2000:01 - 2008:12.} The table reports the ratios of MSFE for the models considered. The asterisk indicates significance  according to the Diebold and Mariano (1995) test of equal accuracy against the alternative that the anchored forecast is more accurate ('***' at the 1\%, '**' at the 5\%, and '*' at the 1\%). The Diebold and Mariano test was implemented using an HAC estimator with $h-1$ truncation parameter.\label{}}\end{center}}
\end{table}
\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
{\footnotesize
\begin{center}
\begin{tabular}{lllllcllll}
\hline\hline
\multicolumn{1}{l}{\bfseries Maturity}&\multicolumn{4}{c}{\bfseries Anchored vs DNS}&\multicolumn{1}{c}{\bfseries }&\multicolumn{4}{c}{\bfseries Anchored vs RW}\tabularnewline
\cline{2-5} \cline{7-10}
\multicolumn{1}{l}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}&\multicolumn{1}{c}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}\tabularnewline
\hline
3&$0.41^{***}$&$0.60^{**}$&$0.73^{}$&$0.87^{}$&&$0.77^{***}$&$0.82^{**}$&$0.88^{}$&$0.96^{}$\tabularnewline
6&$0.58^{***}$&$0.71^{***}$&$0.80^{*}$&$0.91^{}$&&$0.71^{***}$&$0.76^{***}$&$0.81^{*}$&$0.88^{}$\tabularnewline
9&$0.67^{***}$&$0.77^{**}$&$0.84^{}$&$0.93^{}$&&$0.77^{***}$&$0.82^{**}$&$0.85^{}$&$0.90^{}$\tabularnewline
12&$0.74^{*}$&$0.81^{}$&$0.87^{}$&$0.95^{}$&&$0.83^{*}$&$0.86^{}$&$0.89^{}$&$0.93^{}$\tabularnewline
15&$0.79^{}$&$0.85^{}$&$0.90^{}$&$0.97^{}$&&$0.88^{}$&$0.90^{}$&$0.92^{}$&$0.95^{}$\tabularnewline
18&$0.83^{}$&$0.88^{}$&$0.92^{}$&$0.98^{}$&&$0.92^{}$&$0.93^{}$&$0.95^{}$&$0.98^{}$\tabularnewline
21&$0.85^{}$&$0.90^{}$&$0.93^{}$&$0.99^{}$&&$0.95^{}$&$0.96^{}$&$0.98^{}$&$1.01^{}$\tabularnewline
24&$0.87^{}$&$0.91^{}$&$0.94^{}$&$1.00^{}$&&$0.97^{}$&$0.99^{}$&$1.01^{}$&$1.03^{}$\tabularnewline
30&$0.88^{}$&$0.93^{}$&$0.96^{}$&$1.01^{}$&&$1.01^{}$&$1.04^{}$&$1.07^{}$&$1.08^{}$\tabularnewline
36&$0.89^{}$&$0.94^{}$&$0.97^{}$&$1.01^{}$&&$1.04^{}$&$1.07^{}$&$1.11^{}$&$1.12^{}$\tabularnewline
48&$0.90^{}$&$0.96^{}$&$1.00^{}$&$1.02^{}$&&$1.07^{}$&$1.12^{}$&$1.18^{}$&$1.19^{}$\tabularnewline
60&$0.92^{}$&$0.97^{}$&$1.02^{}$&$1.04^{}$&&$1.08^{}$&$1.14^{}$&$1.22^{}$&$1.22^{}$\tabularnewline
72&$0.95^{}$&$1.00^{}$&$1.04^{}$&$1.05^{}$&&$1.06^{}$&$1.13^{}$&$1.22^{}$&$1.22^{}$\tabularnewline
84&$1.00^{}$&$1.03^{}$&$1.07^{}$&$1.06^{}$&&$1.05^{}$&$1.11^{}$&$1.20^{}$&$1.20^{}$\tabularnewline
96&$1.07^{}$&$1.08^{}$&$1.11^{}$&$1.07^{}$&&$1.07^{}$&$1.10^{}$&$1.19^{}$&$1.16^{}$\tabularnewline
108&$1.14^{}$&$1.13^{}$&$1.16^{}$&$1.09^{}$&&$1.15^{}$&$1.13^{}$&$1.19^{}$&$1.13^{}$\tabularnewline
120&$1.19^{}$&$1.18^{}$&$1.20^{}$&$1.10^{}$&&$1.29^{}$&$1.19^{}$&$1.22^{}$&$1.12^{}$\tabularnewline
\hline
\end{tabular}
\caption{\textbf{Relative MSFEs of anchored forecasts. DNS model:macro augmented Sample: 2000:01 - 2008:12.} The table reports the ratios of MSFE for the models considered. The asterisk indicates significance  according to the Diebold and Mariano (1995) test of equal accuracy against the alternative that the anchored forecast is more accurate ('***' at the 1\%, '**' at the 5\%, and '*' at the 1\%). The Diebold and Mariano test was implemented using an HAC estimator with $h-1$ truncation parameter.\label{}}\end{center}}
\end{table}

\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
{\footnotesize
\begin{center}
\begin{tabular}{lllllcllll}
\hline\hline
\multicolumn{1}{l}{\bfseries Maturity}&\multicolumn{4}{c}{\bfseries Anchored vs DNS}&\multicolumn{1}{c}{\bfseries }&\multicolumn{4}{c}{\bfseries Anchored vs RW}\tabularnewline
\cline{2-5} \cline{7-10}
\multicolumn{1}{l}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}&\multicolumn{1}{c}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}\tabularnewline
\hline
3&$0.47^{***}$&$0.62^{**}$&$0.72^{}$&$0.83^{}$&&$0.77^{***}$&$0.82^{**}$&$0.88^{}$&$0.96^{}$\tabularnewline
6&$0.67^{***}$&$0.75^{**}$&$0.84^{}$&$0.92^{}$&&$0.77^{***}$&$0.83^{**}$&$0.90^{}$&$0.96^{}$\tabularnewline
9&$0.71^{***}$&$0.79^{}$&$0.87^{}$&$0.96^{}$&&$0.81^{***}$&$0.87^{}$&$0.94^{}$&$1.00^{}$\tabularnewline
12&$0.76^{**}$&$0.83^{}$&$0.91^{}$&$0.99^{}$&&$0.86^{**}$&$0.92^{}$&$0.98^{}$&$1.03^{}$\tabularnewline
15&$0.80^{}$&$0.86^{}$&$0.95^{}$&$1.03^{}$&&$0.90^{}$&$0.96^{}$&$1.03^{}$&$1.07^{}$\tabularnewline
18&$0.83^{}$&$0.90^{}$&$0.98^{}$&$1.06^{}$&&$0.93^{}$&$0.99^{}$&$1.07^{}$&$1.12^{}$\tabularnewline
21&$0.87^{}$&$0.93^{}$&$1.02^{}$&$1.09^{}$&&$0.96^{}$&$1.03^{}$&$1.11^{}$&$1.16^{}$\tabularnewline
24&$0.89^{}$&$0.96^{}$&$1.05^{}$&$1.12^{}$&&$1.00^{}$&$1.07^{}$&$1.16^{}$&$1.20^{}$\tabularnewline
30&$0.93^{}$&$1.01^{}$&$1.11^{}$&$1.18^{}$&&$1.06^{}$&$1.14^{}$&$1.24^{}$&$1.29^{}$\tabularnewline
36&$0.97^{}$&$1.06^{}$&$1.16^{}$&$1.24^{}$&&$1.12^{}$&$1.20^{}$&$1.32^{}$&$1.37^{}$\tabularnewline
48&$1.01^{}$&$1.12^{}$&$1.25^{}$&$1.33^{}$&&$1.19^{}$&$1.30^{}$&$1.46^{}$&$1.51^{}$\tabularnewline
60&$1.03^{}$&$1.17^{}$&$1.32^{}$&$1.41^{}$&&$1.21^{}$&$1.34^{}$&$1.53^{}$&$1.61^{}$\tabularnewline
72&$1.05^{}$&$1.21^{}$&$1.38^{}$&$1.48^{}$&&$1.16^{}$&$1.33^{}$&$1.55^{}$&$1.65^{}$\tabularnewline
84&$1.06^{}$&$1.24^{}$&$1.44^{}$&$1.55^{}$&&$1.09^{}$&$1.27^{}$&$1.52^{}$&$1.64^{}$\tabularnewline
96&$1.06^{}$&$1.26^{}$&$1.49^{}$&$1.60^{}$&&$1.03^{}$&$1.21^{}$&$1.45^{}$&$1.60^{}$\tabularnewline
108&$1.06^{}$&$1.27^{}$&$1.51^{}$&$1.63^{}$&&$1.01^{}$&$1.16^{}$&$1.38^{}$&$1.53^{}$\tabularnewline
120&$1.04^{}$&$1.25^{}$&$1.49^{}$&$1.62^{}$&&$1.04^{}$&$1.13^{}$&$1.31^{}$&$1.46^{}$\tabularnewline
\hline
\end{tabular}
\caption{\textbf{Relative MSFEs of anchored forecasts using 3m and 6m BC survey forecasts. DNS model:Yields only Sample: 2000:01 - 2008:12.} The table reports the ratios of MSFE for the models considered. The asterisk indicates significance  according to the Diebold and Mariano (1995) test of equal accuracy against the alternative that the anchored forecast is more accurate ('***' at the 1\%, '**' at the 5\%, and '*' at the 1\%). The Diebold and Mariano test was implemented using an HAC estimator with $h-1$ truncation parameter.\label{}}\end{center}}
\end{table}
\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
{\footnotesize
\begin{center}
\begin{tabular}{lllllcllll}
\hline\hline
\multicolumn{1}{l}{\bfseries Maturity}&\multicolumn{4}{c}{\bfseries Anchored vs DNS}&\multicolumn{1}{c}{\bfseries }&\multicolumn{4}{c}{\bfseries Anchored vs RW}\tabularnewline
\cline{2-5} \cline{7-10}
\multicolumn{1}{l}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}&\multicolumn{1}{c}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}\tabularnewline
\hline
3&$0.41^{***}$&$0.60^{**}$&$0.73^{}$&$0.87^{}$&&$0.77^{***}$&$0.82^{**}$&$0.88^{}$&$0.96^{}$\tabularnewline
6&$0.63^{***}$&$0.78^{**}$&$0.89^{}$&$1.00^{}$&&$0.77^{***}$&$0.83^{**}$&$0.90^{}$&$0.96^{}$\tabularnewline
9&$0.70^{***}$&$0.83^{}$&$0.93^{}$&$1.03^{}$&&$0.81^{***}$&$0.88^{}$&$0.94^{}$&$0.99^{}$\tabularnewline
12&$0.77^{*}$&$0.87^{}$&$0.97^{}$&$1.05^{}$&&$0.86^{*}$&$0.92^{}$&$0.98^{}$&$1.03^{}$\tabularnewline
15&$0.82^{}$&$0.91^{}$&$1.00^{}$&$1.08^{}$&&$0.91^{}$&$0.97^{}$&$1.02^{}$&$1.06^{}$\tabularnewline
18&$0.86^{}$&$0.94^{}$&$1.02^{}$&$1.10^{}$&&$0.95^{}$&$1.00^{}$&$1.06^{}$&$1.10^{}$\tabularnewline
21&$0.88^{}$&$0.96^{}$&$1.04^{}$&$1.11^{}$&&$0.98^{}$&$1.04^{}$&$1.10^{}$&$1.13^{}$\tabularnewline
24&$0.90^{}$&$0.98^{}$&$1.06^{}$&$1.13^{}$&&$1.01^{}$&$1.07^{}$&$1.14^{}$&$1.17^{}$\tabularnewline
30&$0.93^{}$&$1.01^{}$&$1.09^{}$&$1.15^{}$&&$1.05^{}$&$1.13^{}$&$1.21^{}$&$1.24^{}$\tabularnewline
36&$0.94^{}$&$1.03^{}$&$1.12^{}$&$1.17^{}$&&$1.09^{}$&$1.18^{}$&$1.28^{}$&$1.30^{}$\tabularnewline
48&$0.96^{}$&$1.06^{}$&$1.15^{}$&$1.20^{}$&&$1.14^{}$&$1.24^{}$&$1.37^{}$&$1.40^{}$\tabularnewline
60&$0.98^{}$&$1.08^{}$&$1.18^{}$&$1.23^{}$&&$1.15^{}$&$1.26^{}$&$1.42^{}$&$1.45^{}$\tabularnewline
72&$1.00^{}$&$1.10^{}$&$1.20^{}$&$1.24^{}$&&$1.12^{}$&$1.25^{}$&$1.41^{}$&$1.45^{}$\tabularnewline
84&$1.03^{}$&$1.12^{}$&$1.22^{}$&$1.24^{}$&&$1.08^{}$&$1.20^{}$&$1.37^{}$&$1.40^{}$\tabularnewline
96&$1.06^{}$&$1.14^{}$&$1.23^{}$&$1.23^{}$&&$1.07^{}$&$1.16^{}$&$1.31^{}$&$1.33^{}$\tabularnewline
108&$1.09^{}$&$1.15^{}$&$1.21^{}$&$1.20^{}$&&$1.11^{}$&$1.14^{}$&$1.25^{}$&$1.25^{}$\tabularnewline
120&$1.11^{}$&$1.15^{}$&$1.18^{}$&$1.15^{}$&&$1.20^{}$&$1.16^{}$&$1.21^{}$&$1.18^{}$\tabularnewline
\hline
\end{tabular}
\caption{\textbf{Relative MSFEs of anchored forecasts using 3m and 6m BC survey forecasts. DNS model:macro augmented Sample: 2000:01 - 2008:12.} The table reports the ratios of MSFE for the models considered. The asterisk indicates significance  according to the Diebold and Mariano (1995) test of equal accuracy against the alternative that the anchored forecast is more accurate ('***' at the 1\%, '**' at the 5\%, and '*' at the 1\%). The Diebold and Mariano test was implemented using an HAC estimator with $h-1$ truncation parameter.\label{}}\end{center}}
\end{table}

\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
{\footnotesize
\begin{center}
\begin{tabular}{lllllcllll}
\hline\hline
\multicolumn{1}{l}{\bfseries Maturity}&\multicolumn{4}{c}{\bfseries Conditional forecast vs DNS}&\multicolumn{1}{c}{\bfseries }&\multicolumn{4}{c}{\bfseries Conditional vs RW}\tabularnewline
\cline{2-5} \cline{7-10}
\multicolumn{1}{l}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}&\multicolumn{1}{c}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}\tabularnewline
\hline
3&$0.42^{***}$&$0.58^{*}$&$0.70^{}$&$0.83^{}$&&$0.79^{***}$&$0.84^{*}$&$0.90^{}$&$1.00^{}$\tabularnewline
6&$0.56^{***}$&$0.65^{**}$&$0.73^{*}$&$0.82^{}$&&$0.68^{***}$&$0.75^{**}$&$0.82^{*}$&$0.89^{}$\tabularnewline
9&$0.65^{**}$&$0.70^{*}$&$0.76^{}$&$0.85^{}$&&$0.77^{**}$&$0.81^{*}$&$0.85^{}$&$0.91^{}$\tabularnewline
12&$0.72^{*}$&$0.75^{}$&$0.79^{}$&$0.87^{}$&&$0.83^{*}$&$0.85^{}$&$0.89^{}$&$0.94^{}$\tabularnewline
15&$0.77^{}$&$0.78^{}$&$0.82^{}$&$0.89^{}$&&$0.88^{}$&$0.89^{}$&$0.92^{}$&$0.97^{}$\tabularnewline
18&$0.80^{}$&$0.81^{}$&$0.84^{}$&$0.91^{}$&&$0.91^{}$&$0.93^{}$&$0.96^{}$&$1.01^{}$\tabularnewline
21&$0.83^{}$&$0.84^{}$&$0.86^{}$&$0.93^{}$&&$0.94^{}$&$0.96^{}$&$1.00^{}$&$1.04^{}$\tabularnewline
24&$0.84^{}$&$0.86^{}$&$0.88^{}$&$0.94^{}$&&$0.96^{}$&$0.99^{}$&$1.03^{}$&$1.08^{}$\tabularnewline
30&$0.85^{}$&$0.89^{}$&$0.91^{}$&$0.97^{}$&&$1.00^{}$&$1.05^{}$&$1.11^{}$&$1.15^{}$\tabularnewline
36&$0.86^{}$&$0.91^{}$&$0.94^{}$&$0.99^{}$&&$1.04^{}$&$1.10^{}$&$1.18^{}$&$1.22^{}$\tabularnewline
48&$0.87^{}$&$0.95^{}$&$0.98^{}$&$1.03^{}$&&$1.09^{}$&$1.17^{}$&$1.28^{}$&$1.33^{}$\tabularnewline
60&$0.91^{}$&$0.98^{}$&$1.01^{}$&$1.05^{}$&&$1.10^{}$&$1.18^{}$&$1.31^{}$&$1.38^{}$\tabularnewline
72&$0.95^{}$&$1.01^{}$&$1.05^{}$&$1.08^{}$&&$1.07^{}$&$1.15^{}$&$1.28^{}$&$1.35^{}$\tabularnewline
84&$1.01^{}$&$1.05^{}$&$1.09^{}$&$1.10^{}$&&$1.04^{}$&$1.11^{}$&$1.22^{}$&$1.28^{}$\tabularnewline
96&$1.07^{}$&$1.10^{}$&$1.13^{}$&$1.13^{}$&&$1.04^{}$&$1.08^{}$&$1.14^{}$&$1.19^{}$\tabularnewline
108&$1.14^{}$&$1.15^{}$&$1.17^{}$&$1.15^{}$&&$1.12^{}$&$1.07^{}$&$1.08^{}$&$1.10^{}$\tabularnewline
120&$1.19^{}$&$1.19^{}$&$1.22^{}$&$1.18^{}$&&$1.24^{}$&$1.10^{}$&$1.06^{}$&$1.04^{}$\tabularnewline
\hline
\end{tabular}
\caption{\textbf{Relative MSFEs of conditional forecasts. Baseline model:Yields only Sample: 2000:01 - 2011:12.} The table reports the ratios of MSFE for the models considered. The asterisk indicates significance  according to the Diebold and Mariano (1995) test of equal accuracy against the alternative that the anchored forecast is more accurate ('***' at the 1\%, '**' at the 5\%, and '*' at the 1\%). The Diebold and Mariano test was implemented using an HAC estimator with $h-1$ truncation parameter.\label{}}\end{center}}
\end{table}
\newcolumntype{.}{D{.}{.}{-1}}
\begin{table}[!tbp]
{\footnotesize
\begin{center}
\begin{tabular}{lllllcllll}
\hline\hline
\multicolumn{1}{l}{\bfseries Maturity}&\multicolumn{4}{c}{\bfseries Conditional forecast vs DNS}&\multicolumn{1}{c}{\bfseries }&\multicolumn{4}{c}{\bfseries Conditional vs RW}\tabularnewline
\cline{2-5} \cline{7-10}
\multicolumn{1}{l}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}&\multicolumn{1}{c}{}&\multicolumn{1}{c}{h=3}&\multicolumn{1}{c}{h=6}&\multicolumn{1}{c}{h=9}&\multicolumn{1}{c}{h=12}\tabularnewline
\hline
3&$0.32^{***}$&$0.49^{*}$&$0.63^{}$&$0.78^{}$&&$0.79^{***}$&$0.84^{*}$&$0.90^{}$&$1.00^{}$\tabularnewline
6&$0.50^{***}$&$0.61^{**}$&$0.71^{*}$&$0.81^{}$&&$0.70^{***}$&$0.76^{**}$&$0.82^{*}$&$0.88^{}$\tabularnewline
9&$0.64^{**}$&$0.71^{*}$&$0.77^{}$&$0.85^{}$&&$0.81^{**}$&$0.83^{*}$&$0.86^{}$&$0.90^{}$\tabularnewline
12&$0.75^{}$&$0.78^{}$&$0.82^{}$&$0.88^{}$&&$0.90^{}$&$0.89^{}$&$0.91^{}$&$0.93^{}$\tabularnewline
15&$0.83^{}$&$0.83^{}$&$0.85^{}$&$0.90^{}$&&$0.97^{}$&$0.95^{}$&$0.95^{}$&$0.96^{}$\tabularnewline
18&$0.88^{}$&$0.87^{}$&$0.88^{}$&$0.91^{}$&&$1.01^{}$&$0.99^{}$&$0.99^{}$&$0.99^{}$\tabularnewline
21&$0.91^{}$&$0.89^{}$&$0.90^{}$&$0.92^{}$&&$1.04^{}$&$1.02^{}$&$1.02^{}$&$1.01^{}$\tabularnewline
24&$0.92^{}$&$0.91^{}$&$0.91^{}$&$0.93^{}$&&$1.06^{}$&$1.05^{}$&$1.05^{}$&$1.04^{}$\tabularnewline
30&$0.92^{}$&$0.92^{}$&$0.92^{}$&$0.93^{}$&&$1.07^{}$&$1.08^{}$&$1.10^{}$&$1.08^{}$\tabularnewline
36&$0.90^{}$&$0.92^{}$&$0.93^{}$&$0.93^{}$&&$1.08^{}$&$1.10^{}$&$1.14^{}$&$1.12^{}$\tabularnewline
48&$0.90^{}$&$0.93^{}$&$0.93^{}$&$0.93^{}$&&$1.09^{}$&$1.12^{}$&$1.17^{}$&$1.16^{}$\tabularnewline
60&$0.92^{}$&$0.95^{}$&$0.94^{}$&$0.92^{}$&&$1.08^{}$&$1.10^{}$&$1.16^{}$&$1.14^{}$\tabularnewline
72&$0.98^{}$&$0.99^{}$&$0.97^{}$&$0.93^{}$&&$1.07^{}$&$1.08^{}$&$1.11^{}$&$1.07^{}$\tabularnewline
84&$1.06^{}$&$1.05^{}$&$1.01^{}$&$0.94^{}$&&$1.08^{}$&$1.06^{}$&$1.06^{}$&$0.99^{}$\tabularnewline
96&$1.17^{}$&$1.12^{}$&$1.07^{}$&$0.96^{}$&&$1.15^{}$&$1.08^{}$&$1.02^{}$&$0.91^{}$\tabularnewline
108&$1.26^{}$&$1.20^{}$&$1.14^{}$&$0.99^{}$&&$1.28^{}$&$1.13^{}$&$1.01^{}$&$0.85^{}$\tabularnewline
120&$1.34^{}$&$1.28^{}$&$1.20^{}$&$1.03^{}$&&$1.49^{}$&$1.22^{}$&$1.02^{}$&$0.82^{}$\tabularnewline
\hline
\end{tabular}
\caption{\textbf{Relative MSFEs of conditional forecasts. Baseline model:macro augmented Sample: 2000:01 - 2011:12.} The table reports the ratios of MSFE for the models considered. The asterisk indicates significance  according to the Diebold and Mariano (1995) test of equal accuracy against the alternative that the anchored forecast is more accurate ('***' at the 1\%, '**' at the 5\%, and '*' at the 1\%). The Diebold and Mariano test was implemented using an HAC estimator with $h-1$ truncation parameter.\label{}}\end{center}}
\end{table}



<img src="figures/fomc-1.pdf" title="The figure reports the 1- to 4-quarter-ahead forecasts of the 3-month yield given by the DNS model and the BC survey before and after the FOMC Statement of August 9, 2011." alt="The figure reports the 1- to 4-quarter-ahead forecasts of the 3-month yield given by the DNS model and the BC survey before and after the FOMC Statement of August 9, 2011." style="display: block; margin: auto;" />



<img src="figures/fomc_tilted-1.pdf" title="The figure shows the 12-month-ahead yield curve forecast implied by the DNS model and the corresponding anchored forecast made before and after the FOMC State- ment of August 9, 2011, together with the actual yield curve realization." alt="The figure shows the 12-month-ahead yield curve forecast implied by the DNS model and the corresponding anchored forecast made before and after the FOMC State- ment of August 9, 2011, together with the actual yield curve realization." style="display: block; margin: auto;" />


<img src="figures/3dyield-1.pdf" title="plot of chunk 3dyield" alt="plot of chunk 3dyield" style="display: block; margin: auto;" />


\clearpage

## Replication information

This file is produced from the `R` markdown document `kalman.Rmd`.

This pdf was produced on

```
## ##------ Thu Mar 23 01:03:30 2017 ------##
```

The specs for the platform and the `R` installation were:


```r
R.version
```

```
##                _                           
## platform       x86_64-apple-darwin13.4.0   
## arch           x86_64                      
## os             darwin13.4.0                
## system         x86_64, darwin13.4.0        
## status                                     
## major          3                           
## minor          3.2                         
## year           2016                        
## month          10                          
## day            31                          
## svn rev        71607                       
## language       R                           
## version.string R version 3.3.2 (2016-10-31)
## nickname       Sincere Pumpkin Patch
```

The following packages were used:


```
## tikzDevice[1] '0.10.1'
## Hmisc[1] '4.0.2'
## RColorBrewer[1] '1.1.2'
## RcppRoll[1] '0.2.2'
## dplyr[1] '0.5.0'
## forecast[1] '8.0'
## ggplot2[1] '2.2.1'
## ggthemes[1] '3.4.0'
## lubridate[1] '1.6.0'
## purrr[1] '0.2.2'
## reshape2[1] '1.4.2'
## sandwich[1] '2.3.4'
## xts[1] '0.9.7'
```
