SigmaInv <- function(Sigma, idx, m) {
  s <- dim(Sigma)
  i <- array(0, s[1])
  for (j in 1:s[1]) {
   i[j] <- solve(Sigma[j,idx,,])[m,m] 
  }
  i
}

SigmaInv2 <- function(Sigma) {
  s <- dim(Sigma)
  i <- array(0, dim(Sigma))
  for (j in 1:dim(Sigma)[1]) {
    i[j,,,] <- solve(Sigma[j,,,])
  }
  i
}

encomp_rolling <- function(BC, MODEL, Sigma, mu, lag = 0) {
  T_1  <- length(BC)
  T_2  <- length(MODEL)
  if (T_1 != T_2)
    stop("wrong dimension")
  T = T_1
  m  <- round(mu*T)
  idx <- seq(1, T - m + 1)
  crit  <- c(3.176, 2.938, 2.770, 2.624, 2.475, 2.352, 2.248, 2.080, 1.975)
  k <- crit[round(mu*10)]
  enc_rol <- array(0, T - m)
  jj <- 1
  for (ii in m:T) {
    lambda  <- Sigma[(ii-m + 1):ii]*((BC[(ii - m + 1):ii] - MODEL[(ii - m + 1):ii]) * BC[(ii - m + 1):ii])
    eta <- 0.5*Sigma[(ii-m + 1):ii]*(MODEL[(ii - m + 1):ii] - BC[(ii - m + 1):ii])^2
    V <- lrvar(eta + lambda, type = "Newey-West")
    enc_rol[jj] <- mean(eta+lambda)/sqrt(V)
    jj <- jj + 1
  }
  list(enc_rol = enc_rol, k = k, idx = idx)
}

encomp_rolling_2 <- function(BC, MODEL, Sigma, mu, lag = 0) {
  ## BC is T x k
  ## Model T x k
  ## Sigma is T x k x k  
  T_1  <- nrow(BC)
  T_2  <- nrow(MODEL)
  if (T_1 != T_2)
    stop("wrong dimension")
  T = T_1
  m  <- round(mu*T)
  idx <- seq(1, T - m + 1)
  crit  <- c(3.176, 2.938, 2.770, 2.624, 2.475, 2.352, 2.248, 2.080, 1.975)
  k <- crit[round(mu*10)]
  enc_rol <- array(0, T - m)
  rr <- 1
  S <- SigmaInv2(Sigma)
  lambda <- array(0, m)
  eta <- array(0, m)
  
  lambda_ <- array(0, T_1)
  eta_ <- array(0, T_1)
  for (ii in m:T) {
    etilde <-  BC[(ii - m + 1):ii, , drop = FALSE]
    ehat <- MODEL[(ii - m + 1):ii, , drop = FALSE]
    SS <- S[(ii - m + 1):ii, 1, , ,drop=F]
    for (jj in 1:m) {
      lambda[jj] <- -t(etilde[jj, ] - ehat[jj, ]) %*% SS[jj, , , ] %*% etilde[jj, ]
      eta[jj]    <- 0.5*t(etilde[jj,]-ehat[jj,])%*%SS[jj,,,]%*%(etilde[jj,]-ehat[jj,])
    }
  
    V <- lrvar((eta+lambda), type = "Newey-West")
    enc_rol[rr] <- mean(eta+lambda)/sqrt(V)
    rr <- rr + 1
  }
  
  for (ii in 1:T) {
    etilde <-  BC[ii, , drop = TRUE]
    ehat <- MODEL[ii, , drop = TRUE]
    SS <- S[ii, 1, , ,drop=T]
  
  lambda_[ii] <- -(etilde-ehat)%*%SS%*%etilde
  eta_[ii]    <- 0.5*t(etilde-ehat)%*%SS%*%(etilde-ehat)
  }
  
  list(enc_rol = enc_rol, k = k, idx = idx, eta = eta_, lambda = lambda_)
}


MAE_ <- function(u, na.rm)
  mean(abs(u), na.rm = na.rm)

MAE <- function(u, na.rm = TRUE) {
## Calculate Median Absolute Error
  ## u is the forecast error
  if (NCOL(u) > 1)
    apply(u, 2, MAE_, na.rm = na.rm)
  else
    MAE_(u, na.rm = na.rm)
}

RMSE <- function(u) {
  sqrt(mean(abs(u - mean(u, na.rm = TRUE)) ^ 2))
}


MSFE_ <- function(u, na.rm)
  mean(u ^ 2, na.rm = na.rm)

RollMSFE_ <- function(u, n, na.rm) {
  roll_mean(u ^ 2,
            n,
            partial = FALSE,
            align = "right",
            na.rm = na.rm)
}

RollMAE_ <- function(u, n, na.rm) {
  roll_mean(abs(u),
            n,
            partial = FALSE,
            align = "right",
            na.rm = na.rm)
}


MAE <- function(u, colnames = NA, rownames = NA, na.rm = TRUE) {
  ## Calculate  Mean Square Error
  ## u is the forecast error
  ## if colnames and rownames are returned and of the right length
  ## are attached to the final matrix
  du <- dim(u)
  if (length(du) > 3)
    stop("too many dimensions")
  
  if (length(du) > 2)
    mae <- apply(u, 2:3, MAE_, na.rm = na.rm)
  else if (length(du) == 2)
    mae <- apply(u, 2, MAE_, na.rm = na.rm)
  else
    mae <- MSFE_(u, na.rm = na.rm)
  
  if (!is.na(colnames) && length(du) == 3 && length(colnames) == du[3])
    colnames(mae) <- colnames
  if (!is.na(rownames) && length(du) == 3 && length(rownames) == du[2])
    rownames(mae) <- rownames
  
  return(mae)
  
}

MSFE <- function(u, colnames = NA, rownames = NA, na.rm = TRUE) {
  ## Calculate  Mean Square Error
  ## u is the forecast error
  ## if colnames and rownames are returned and of the right length
  ## are attached to the final matrix
  du <- dim(u)
  if (length(du) > 3)
    stop("too many dimensions")

  if (length(du) > 2)
    mfe <- apply(u, 2:3, MSFE_, na.rm = na.rm)
  else if (length(du) == 2)
    mfe <- apply(u, 2, MSFE_, na.rm = na.rm)
  else
    mfe <- MSFE_(u, na.rm = na.rm)

  if (!is.na(colnames) && length(du) == 3 && length(colnames) == du[3])
    colnames(mfe) <- colnames
  if (!is.na(rownames) && length(du) == 3 && length(rownames) == du[2])
    rownames(mfe) <- rownames

  return(mfe)

}

RollMSFE <- function(u, n, colnames = NA, rownames = NA, na.rm = TRUE) {
  ## Calculate Root Mean Square Error
  ## u is the forecast error
  ## if colnames and rownames are returned and of the right length
  ## are attached to the final matrix
  du <- dim(u)
  if (length(du) > 3)
    stop("too many dimensions")

  if (length(du) > 1)
    mfe <- apply(u, 2:3, RollMSFE_, n = n, na.rm = na.rm)
  else
    mfe <- RollMSFE_(u, n, na.rm = na.rm)

  if (!is.na(colnames) && length(du) == 3 && length(colnames) == du[3])
    dimnames(mfe)[[3]] <- colnames
  if (!is.na(rownames) && length(du) == 3 && length(rownames) == du[2])
    dimnames(mfe)[[2]] <- rownames

  return(mfe)

}


RollMAE <- function(u, n, colnames = NA, rownames = NA, na.rm = TRUE) {
  ## Calculate Root Mean Square Error
  ## u is the forecast error
  ## if colnames and rownames are returned and of the right length
  ## are attached to the final matrix
  du <- dim(u)
  if (length(du) > 3)
    stop("too many dimensions")
  
  if (length(du) > 1)
    mae <- apply(u, 2:3, RollMAE_, n = n, na.rm = na.rm)
  else
    mae <- RollMAE_(u, n, na.rm = na.rm)
  
  if (!is.na(colnames) && length(du) == 3 && length(colnames) == du[3])
    dimnames(mae)[[3]] <- colnames
  if (!is.na(rownames) && length(du) == 3 && length(rownames) == du[2])
    dimnames(mae)[[2]] <- rownames
  
  return(mae)
  
}




RMSFE <- function(u, na.rm = TRUE)
  sqrt(MSFE(u, na.rm = na.rm))




plot_encompassing_2 <- function() {
  colored <- TRUE
  
  if (colored) {
    cols <- RColorBrewer::brewer.pal(8, name = "Dark2")[8:3]
    cols <- c("#000000", cols)
    cols[6] <- cols[7]
  } else {
    cols <- rep("black", 6)
  }
  
  ## Put the sizth month yellow
  tmp <- cols[2] 
  cols[2] <- cols[4]
  cols[4] <- tmp
  
  
  par(
    mfrow = c(2, 2),
    mar = c(3, 3, 2, 1),
    mgp = c(2, .7, 0),
    tck = -.01,
    cex.lab = 0.75,
    cex.axis = 0.75
  )
  m <- matrix(c(1,2,3,4,5,5), nrow = 3,ncol = 2,byrow = TRUE)
  layout(mat = m,heights = c(0.4,0.4,0.2))
  
  lty0 <- c(1, c(2, 3, 4, 5, 6))
  pch0 = c(0, 1, 2, 3, 4, 5, 6)
  
  for (h in c(3, 6, 9, 12)) {
    j <- 1
    for (err in c(3,6,12,24,60, 120)) {
      mat <- match(err, maturities)
      MODEL <- as.matrix(dns_model[[1]]$error[, h, mat])
      MODEL <- ts(MODEL, start = c(2000,h), frequency = 12)
      ad <- yield_data[(180 + h):(180 + h + 143), mat]
      bc <- ad-bc_set[[paste0("m", err)]][[2]][[h / 3]][-c(1:(180 + h - 1)), ]
      
      bc <- ts(bc, start = c(2000, h), frequency = 12)
      
      BC <- as.matrix(bc[1:(144)])
      MODEL <- as.matrix(MODEL[1:144])
      Sigma <- dns_model[[1]]$Sigma[1:(144), h, mat, mat, drop = FALSE]
    
      out <- encomp_rolling_2(BC, MODEL, Sigma, 0.4)
      out$enc_rol <- ts(out$enc_rol,
                        start = c(2004, 10),
                        frequency = 12)
      
      if (err == 3) {
        plot(
          out$enc_rol,
          ylim = c(-4, 4.5),
          type = 'l',
          lwd = 2,
          col = cols[1],
          ylab = '',
          xlab = "",
          xlim = c(2004, 2013),
          axes = T,
          main = paste0("h = ", h),
          cex.main = 0.85
        )
        abline(h = -out$k, lwd = 1.5, col = ifelse(colored, "darkred", "black"), lty = 1)
        abline(h = 0, lwd = 2, col = "lightgrey", lty = 2)
        grid(lwd=1.2)
      } else {
        lines(out$enc_rol, lty = lty0[j], lwd = 2, col = cols[j])
      }
      j <- j + 1
    }
  }
  
  mtext("Value of encmpassing statistics", 
        side = 2, padj = 2, outer = TRUE, adj = .67, cex = 0.75)
  par(mar = c(0, 0, 0, 0))
  plot(
    1,
    type = "n",
    axes = FALSE,
    xlab = "",
    ylab = "",
    frame.plot = FALSE
  )
  plot_colors <- cols[1:6]
  bcmat <- c(3, 6, 12, 24, 60, 120)
  legend(x = "top", inset = 0,
         legend = paste0("y(", bcmat, ")"), 
         col = plot_colors, lty = lty0, bty = 'n', lwd = 3, cex = 1.3, horiz = TRUE)
}



plot_encompassing_3 <- function() {
  colored <- TRUE
  
  if (colored) {
    cols <- RColorBrewer::brewer.pal(8, name = "Dark2")[8:3]
    cols <- c("#000000", cols)
    cols[6] <- cols[7]
  } else {
    cols <- rep("black", 6)
  }
  
  ## Put the sizth month yellow
  tmp <- cols[2] 
  cols[2] <- cols[4]
  cols[4] <- tmp
  
  par(
    mfrow = c(2, 2),
    mar = c(3, 3, 2, 1),
    mgp = c(2, .7, 0),
    tck = -.01,
    cex.lab = 0.75,
    cex.axis = 0.75
  )
  m <- matrix(c(1,2,3,4,5,5), nrow = 3,ncol = 2,byrow = TRUE)
  layout(mat = m,heights = c(0.4,0.4,0.2))
  
  lty0 <- c(1, c(2, 3, 4, 5, 6))
  pch0 <- c(0, 1, 2, 3, 4, 5, 6)
  
  for (h in c(3, 6, 9, 12)) {
    #bc <- as.numeric(bc_error[[paste0("m", 3)]][[h/3]][1:145])

    MODEL <- as.matrix(dns_model[[1]]$error[, h, 1])
    MODEL <- ts(MODEL, start = c(2000,h), frequency = 12)
    ad <- yield_data[(180 + h):(180 + h + 143), 1]
    bc <- ad-bc_set[[paste0("m", 3)]][[2]][[h / 3]][-c(1:(180 + h - 1)), ]
    
    bc <- ts(bc, start = c(2000, h), frequency = 12)
    
    BC <- as.matrix(bc[1:(144)])
    MODEL <- as.matrix(MODEL[1:144])
    Sigma <- dns_model[[1]]$Sigma[1:(144), h, 1, 1, drop = FALSE]
    
    out <- encomp_rolling_2(BC, MODEL, Sigma, 0.4)
    out$enc_rol <- ts(out$enc_rol,
                      start = c(2004, 10),
                      frequency = 12)

      plot(
          out$enc_rol,
          ylim = c(-3, 5),
          type = 'l',
          lwd = 2,
          col = cols[1],
          ylab = '',
          xlab = "",
          xlim = c(2004, 2013),
          axes = T,
          main = paste0("h = ", h),
          cex.main = 0.85
        )
        abline(h = -out$k, lwd = 3, col = ifelse(colored, "darkred", "black"), lty = 1)
        abline(h = 0, lwd = 2, col = "lightgrey", lty = 2)
        grid(lwd=1.2)


        
        MODEL <- as.matrix(dns_model[[1]]$error[, h, 1])
        MODEL <- ts(MODEL, start = c(2000,h), frequency = 12)
        ad <- yield_data[(180 + h):(180 + h + 143), 1]
        bc_1 <- ad-bc_set[[paste0("m", 3)]][[2]][[h / 3]][-c(1:(180 + h - 1)), ]
        ad <- yield_data[(180 + h):(180 + h + 143), 2]
        bc_2 <- ad-bc_set[[paste0("m", 6)]][[2]][[h / 3]][-c(1:(180 + h - 1)), ]
        
        
        BC <- as.matrix(cbind(bc_1, bc_2)[1:(144)])
        MODEL <- as.matrix(MODEL[1:144])
        Sigma <- dns_model[[1]]$Sigma[1:(144), h, c(1,2), c(1,2), drop = FALSE]
        
        out <- encomp_rolling_2(BC, MODEL, Sigma, 0.4)
        out$enc_rol <- ts(out$enc_rol,
                          start = c(2004, 10),
                          frequency = 12)

        lines(out$enc_rol, lty = 2, col = cols[2], lwd =2)      
    
  }
  
  mtext("Value of encmpassing statistics", 
        side = 2, padj = 2, outer = TRUE, adj = .67, cex = 0.75)
  par(mar = c(0, 0, 0, 0))
  plot(
    1,
    type = "n",
    axes = FALSE,
    xlab = "",
    ylab = "",
    frame.plot = FALSE
  )
  plot_colors <- cols[1:6]
  bcmat <- c(3, 6, 12, 24, 60, 120)
  legend(x = "top", inset = 0,
         legend = c("y(3)", "y(3) + y(6)"), col = cols[1:2],
         lty = c(1,3), bty = 'n', lwd = 3, cex = 1.5, horiz = TRUE)
}


plot_msfe <- function(x, title, color = FALSE) {
  if (color)
    col0 <- brewer.pal(4, "BrBG")
  else
    col0 <- rep("black", 4)
  
  nc <- ncol(x)
  at.axis <- c(seq(3, 24, 3), 30, seq(36, 120, 12)) 
  lty0 <- c(2, 3, 4, 5)
  pch0 <- c(0, 1, 2, 4)
  plot(y = x[3,], x = 1:nc, col = col0[1],
       type = 'l', lwd = 2, ylim = c(0.2, 3), lty = lty0[1], 
       ylab = 'Relative MSFE', xlab = 'Maturity (Months)', 
       axes = FALSE, cex.lab = 1, cex.main = 1, main = title)
  points(x[3,], pch = pch0[1], col = col0[1])
  axis(1, seq(1, nc), label = at.axis, cex.axis = .6, lwd = 1.5)
  axis(2, cex.axis = .8, lwd = 1.5)
  abline(h = 1, lty = 9, lwd = 2, col = 'darkgray')
  box(lwd = 1.5)
  grid(lwd = 1.2)
  for (j in c(6,9,12)) {
    lines(x[j,], lwd = 2, lty = lty0[j/3], col = col0[j/3])
    points(x[j,], pch = pch0[j/3], col = col0[j/3])
  }
  legend(
    'topright',
    legend = c('h = 3', 'h = 6', 'h = 9', 'h = 12'),
    lty = 1:4,
    lwd = 2,
    bty = 'n',
    cex = 1,
    pch = pch0,
    y.intersp = 0.85,
    col = col0
  )
}


dm_test <- function(e1, e2, alternative = c("two.sided", "less", "greater"), h = 1, power = 2) 
{
  alternative <- match.arg(alternative)
  d <- c(abs(e1)) ^ power - c(abs(e2)) ^ power
  d.var <- lrvar(d, "NeweyWest", prewhite = FALSE, adjust = FALSE, lag = h - 1)
  dv <- d.var
  if (dv > 0) 
    STATISTIC <- mean(d, na.rm = TRUE)/sqrt(dv)
  else stop("Variance of DM statistic is zero")
  n <- length(d)
  names(STATISTIC) <- "DM"
  if (alternative == "two.sided") 
    PVAL <- 2 * pnorm(-abs(STATISTIC))
  else if (alternative == "less") 
    PVAL <- pnorm(STATISTIC)
  else if (alternative == "greater") 
    PVAL <- pnorm(STATISTIC, lower.tail = FALSE)
  PARAMETER <- c(h, power)
  names(PARAMETER) <- c("Forecast horizon", "Loss function power")
  structure(list(statistic = STATISTIC, parameter = PARAMETER, 
                 alternative = alternative, p.value = PVAL, method = "Diebold-Mariano Test", 
                 data.name = c(deparse(substitute(e1)), deparse(substitute(e2)))), 
            class = "htest")
}