## -----------------------------------------------------------------------------
## Set loadings 
## -----------------------------------------------------------------------------
Lambda <- NSextract(maturities, lambda, 1:m)$load
## Utility function 
beta_est <- t(apply(yield_data, 1, 
                    function(u)
                      NSextract(maturities, lambda, u)$betas))

idx <- index(yield_data)[endpoints(yield_data, 'months')]

## index of initial out-of-sample (oos) window
oos_start <- which(month(idx) ==  1 & year(idx) == 1985)
oos_end   <- which(month(idx) == 12 & year(idx) == 1999)
oos_stop <- which(month(idx) == forecast_end_month & 
                    year(idx) == forecast_end_year)
## Number of oos observation
oos_T <- length(idx[(oos_end):oos_stop])
mask <- array(NA, c(oos_T, h_max, m))
Sigma <- array(0, c(oos_T, h_max, m, m))
## Effective oos yield
actual_yield <- array(NA, c(oos_T, h_max, m))

## The containers have the following structure
##
## [model_name]
## description
## model_par
## fcast
## error
## Sigma
## fcast_tilt
## error_tilt
## fcast_cond
## error_cond
## actual_yield
## oos_dates

des <- array("", 2)
## State equation
U <- "unequal"
B <- "diagonal and unequal"
Q <- "unconstrained"
## Measurament equation
A <- zeros(m, 1)
Z <- Lambda 
R <- "diagonal and unequal"
## Initial value
## x_{0} ~ N(x0, V0)
x0 <- zeros(f, 1)
V0 <- diag(1, f)
mod_base = list(
  U = U,
  B = B,
  Q = Q,
  A = A,
  Z = Z,
  R = R,
  x0 = x0,
  V0 = V0,
  tinitx = 0
)

model_par <- list()
################################################################################
## Yields only
################################################################################
des[1] <- "Yields only"
## State equation
U <- "unequal"
B <- "diagonal and unequal"
Q <- "unconstrained"
## Measurament equation
A <- zeros(m, 1)
Z <- Lambda
R <- "diagonal and unequal"
## Initial value
## x_{0} ~ N(x0, V0)
x0 <- zeros(f, 1)
#V0 <- diag(1, f)
V0 <- diag(0, f)
mod = list(
  U = U,
  B = B,
  Q = Q,
  A = A,
  Z = Z,
  R = R,
  V0 = V0,
  tinitx = 0
)
model_par[[1]] <- mod

################################################################################
## Macro augmented
################################################################################
des[2] <- "macro augmented"
Xmf <- rbind(array(NA, ncol(macro)), as.matrix(macro[-1, ]))
nc <- ncol(Xmf)

U <- "unequal"

B11 <- as.list(zeros(f, f))
B11[[1]] <- "b1"
B11[[5]] <- "b2"
B11[[9]] <- "b3"
B11

B22 <- as.list(zeros(r, r))
B22[[1]] <- "g1"
B22[[4]] <- "g2"


B12 <- as.list(paste0("b12_", 1:(r * f)))
B21 <- as.list(paste0("b21_", 1:(r * f)))

B <- rbind(cbind(matrix(B11, f, f), matrix(B12, f, r)),
           cbind(matrix(B21, r, f), matrix(B22, r, r)))

Q <- "unconstrained"

## Measurament equation
A <- matrix(c(as.list(zeros(m, 1)), 
              as.list(paste0("a", 1:nc))), m + nc, 1)
Z1 <- rbind(cbind(Lambda, zeros(m, r)))
Z2 <- cbind(matrix(as.list(paste0("z", 1:(nc * f))), nc, f), 
            matrix(as.list(paste0("d", 1:(nc * r))), nc, r))
Z <- rbind(Z1, Z2)

R <- "diagonal and unequal"
## Initial value
## x_{0} ~ N(x0, V0)
x0 <- zeros(f + r, 1)
V0 <- diag(0, f + r)

mod = list(
  U = U,
  B = B,
  Q = Q,
  A = A,
  Z = Z,
  R = R,
  V0 = V0,
  tinitx = 0
)

model_par[[2]] <- mod

#====================>  Assign models to struct  <===================#
dns_model <- list()
for (j in 1:length(model_par)) {
  dns_model[[j]] <-  list(description = des[j],
                          model_par = model_par[[j]],
                          est_model = list(),
                          fcast = mask,
                          error = mask,
                          fcast_rw = mask,
                          error_rw = mask,
                          Sigma = Sigma, 
                          fcast_tilt = mask,
                          error_tilt = mask,
                          fcast_cond = mask,
                          error_cond = mask,
                          actual_yield = actual_yield,
                          oos_dates = matrix(NA, oos_T, h_max),
                          loglik = matrix(NA, oos_T, 1), 
                          AIC = matrix(NA, oos_T, 1))
}


## -----------------------------------------------------------------------------
## Fix macro variables
## -----------------------------------------------------------------------------
colnames(Xmf) <- paste0("mv", 1:ncol(Xmf))

## -----------------------------------------------------------------------------
## Initial values
## -----------------------------------------------------------------------------
initvalues <- function(idx, typemodel = c("yields only", "macro augmented"), ...) {
  tm <- match.arg(typemodel)
  ## idx is and index, e.g. 1:80, that indexes the window used in the estimation  
  b <- beta_est[idx,]
  Y <- yield_data[idx,]
  ## Estimate a VAR
  v  <- VAR(b)
  A <- sapply(coef(v), function(u) u[,1])
  ## State equation
  u0 <- A[4, , drop = FALSE]
  B0 <- A[-4,]
  Q0 <- summary(v)[["covres"]]
  ## Measurament equation
  R0 <- var(Y - b %*% t(Lambda))
  Q0 <- matrix(Q0[!upper.tri(Q0)])
  if (tm == "yields only") {
    return(list(U = matrix(u0),
                B = diag(matrix(c(B0))),
                Q = Q0,
                R = matrix(diag(R0), 17),
                x0 = matrix(colMeans(b))))
  }

  if (tm == "macro augmented") {
    ## Model with factors
    larg <- list(...)
    X    <- larg$X[idx,]
    XX   <- na.omit(X)
    indx <- attr(XX, "na.action")
    if (length(indx > 0))
      bb <- b[-indx, ]
    else
      bb <- b
    ## Estimate X ~ mu + b
    OLS <- lm(XX ~ 1 + bb)
    ee <- resid(OLS)
    pc <- princomp(ee)
    FF <- pc$scores[, 1:r]
    bbFF <- cbind(bb, FF)
    colnames(bbFF) <- c(paste0("B", 1:3), paste0("F", 1:r))
    vbbff <- VAR(bbFF)
    AA <- sapply(coef(vbbff), function(u)
      u[, 1])
    ZZ <- coef(OLS2 <- lm(XX ~ 1 + bb + FF))
    R <- diag(var(resid(OLS2)))
    rr <- resid(vbbff)
    Q0 <- var(rr)
    B0 <- AA[-(f + r + 1), ]
    B0[(f + 1):(f + r), (f + 1):(f + r)] <-
      diag(diag(B0[(f + 1):(f + r), (f + 1):(f + r)]))
    B0[1:f, 1:f] <- diag(diag(B0[1:f, 1:f]))
    B0 <- B0[!B0 == 0]
    
    return(list(U = matrix(AA[f + r,]), 
                B = matrix(c(B0)),
                A = matrix(c(coef(OLS)[1,])),
                Q = matrix(Q0[!upper.tri(Q0)]),
                Z = matrix(c(t(ZZ[-1,]))),
                R = matrix(c(diag(R0), R)),
                x0 = matrix(colMeans(bbFF))))
  }
}

MARSSpar2init <- function(listobj) {
  ## Given a list ofMARSSmle objects, extract the
  ## parameters.
  ## Used to pass initial value to a new MARSS call  
  init <- lapply(listobj, FUN = function(u) u$par)
  for (ll in 1:length(listobj)) {
    init[[ll]]$R[init[[ll]]$R == 0] <- 1e-09
  }
  init
}