###########################################################################
##  @knitr data
###########################################################################

## ---> Forecast period
forecast_start_year  <- 2000; forecast_end_year  <- 2011
forecast_start_month <- 1;    forecast_end_month <- 12

## ---> Vector of maturities
maturities <- mat.idx <- c(seq(3,24,3), 30, seq(36, 120, 12))

## ---> Numebr of Macro factors
n_mfactors <- 2

## ---> max step ahed
h_max <- 12

use_fred <- TRUE
type_yield <- "monthly-average"

matlab2POS = function(x,tz = "UTC") {
  days = x - 719529 + 693960 #719529 = days from 1-1-0000 to 1-1-1970
  secs = days * 86400 #86400 seconds in a day
  return(as.POSIXct(secs,origin = "1970-1-1",tz = tz))#returns POSIXct object
}

bc_align <- function(x, start_year_target, start_month_target, end_year_target, end_month_target) {
  months <- x$Month
  bc    <- matrix(0, length(months), 4)
  colnames(bc) <- c('h=3', 'h=6', 'h=9', 'h=12')
  for (i in 1:length(months)) {
    if (months[i] %in% c(1, 4, 7, 10)) {
      bc[i,1] <- x[i,5]
      bc[i,2] <- x[i,6]
      bc[i,3] <- x[i,7]
      bc[i,4] <- x[i,8]
    }
    else {
      bc[i,1] <- x[i,6]
      bc[i,2] <- x[i,7]
      bc[i,3] <- x[i,8]
      bc[i,4] <- x[i,9]
    }
  }

  ## The alignment is now done.
  ## For consistency we store the BC forecast as follows

  #  Release Date     | h = 3    | h = 6    | h = 9   | h = 12   |
  #  -------------------------------------------------------------
  #  Nov-1985        | (Jan86)   | (Apr86) | (Jul86) | (Oct86)   |
  #  Dec-1985        | (Jan86)   | (Apr86) | (Jul86) | (Oct86)   |
  #  Jan-1986        | (Jan86)   | (Apr86) | (Jul86) | (Oct86)   |



  # In parenthesis the target date of the forecast

  bc_release <- as.xts(ts(bc, start = c(x[1, 1], x[1, 2]), frequency = 12))

  tmp  <- bc_release[,1]
  index(tmp) <- index(tmp) + 2/12
  bc_target_h1 <- tmp

  tmp  <- bc_release[,2]
  index(tmp) <- index(tmp) + 5/12
  bc_target_h2 <- tmp

  tmp  <- bc_release[,3]
  index(tmp) <- index(tmp) + 8/12
  bc_target_h3 <- tmp

  tmp  <- bc_release[,4]
  index(tmp) <- index(tmp) + 11/12
  bc_target_h4 <- tmp

  bc_release <- bc_release["1985-1/2011-12"]
  bc_target_h1 <- bc_target_h1["1985-1/2012-03"]
  bc_target_h2 <- bc_target_h2["1985-1/2012-06"]
  bc_target_h3 <- bc_target_h3["1985-1/2012-09"]
  bc_target_h4 <- bc_target_h4["1985-1/2012-12"]

  list(release = bc_release, h1 = bc_target_h1,
       h2 = bc_target_h2, h3 = bc_target_h3, h4 = bc_target_h4)
}


################################################################################
##  data
##
## Gürkaynak, Refet S., Brian Sack, and Jonathan H. Wright. "The US Treasury
## yield curve: 1961 to the present." Journal of Monetary Economics 54.8 (2007):
## 2291-2304
##
################################################################################
## These are the raw yield from GSW
gsw_data <- read.csv('../data/feds200628.csv', sep = ";")
gsw_data <- gsw_data[,c(1:21, 95:100)]
yield_raw <- gsw_data[,2:21]
yield_date  <- as.Date(gsw_data[,1])

## Get the beta's and taus
parms <- gsw_data[,-c(1:21)]
beta <- parms[,c(1:4)]
tau  <- parms[,c(5:6)]

## Fit the yields using daily beta's and tau's
maturities_f <- seq(1/12, 20, by = 1/12)

f1 <- function(u) (1 - exp(-(u / tau[, 1])))/(u/tau[,1])
f2 <- function(u) (1 - exp(-(u / tau[, 1])))/(u/tau[,1]) - exp(-u/tau[,1])
f3 <- function(u) (1 - exp(-(u / tau[, 2])))/(u/tau[,2]) - exp(-u/tau[,2])

load_lev   <- matrix(1, nrow(yield_raw), length(maturities_f))
load_slope <- sapply(maturities_f, f1)
load_curv1 <- sapply(maturities_f, f2)
load_curv2 <- sapply(maturities_f, f3)

yield_fit <- load_lev*beta[,1] + load_slope*beta[,2] +
  load_curv1*beta[,3] + load_curv2*beta[,4]

yield_fit <- xts(yield_fit, yield_date)


## Construct and-of-month dataset
yield_last <- apply.monthly(yield_fit, tail, 1)

## Construct average month dataset
yield_mean <- apply.monthly(yield_fit, mean, na.rm = TRUE)

## Keep only relevant maturities
yield_last <- yield_last[,mat.idx]
yield_mean <- yield_mean[,mat.idx]

## Keep relevant data
yield_last <- yield_last['1985-01-01/2012-12-31']
yield_mean <- yield_mean['1985-01-01/2012-12-31']

yield_mean <- zoo(yield_mean, order.by = as.yearmon(index(yield_mean)))
yield_last <- zoo(yield_last, order.by = as.yearmon(index(yield_mean)))

if (use_fred) {
  load("../data/DGS3MO.RData")
  DGS3MO <- as.xts(DGS3MO)
  DGS3MO_last <- apply.monthly(DGS3MO, tail, 1)
  DGS3MO_mean <- apply.monthly(DGS3MO, mean, na.rm = TRUE)

  DGS3MO_mean <- DGS3MO_mean['1985-01-01/2012-12-31']
  DGS3MO_last <- DGS3MO_last['1985-01-01/2012-12-31']

  DGS3MO_mean <- zoo(DGS3MO_mean, order.by = as.yearmon(index(yield_mean)))
  DGS3MO_last <- zoo(DGS3MO_last, order.by = as.yearmon(index(yield_mean)))

  yield_last[,1] <- as.numeric(DGS3MO_last)
  yield_mean[,1] <- as.numeric(DGS3MO_mean)

  colnames(yield_last) <- paste("tau =", maturities)
  colnames(yield_mean) <- paste("tau =", maturities)

}


colnames(yield_last) <- colnames(yield_mean) <- paste0(mat.idx)

## Select yield data
if (type_yield == 'monthly-average') {
  yield_data <- yield_mean
}

if (type_yield == 'end-of-month') {
  yield_data <- yield_last
}

rm(parms, gsw_data, yield_fit, yield_date, yield_raw)

################################################################################
##
##  bluechip
##
################################################################################
bc_3m <- read.csv('../data/bc_data_3m.csv')
## 1985 - 11 -> Fixed
bc_3m[37,9] <- 7.8

tmp <- bc_align(bc_3m, forecast_start_year, forecast_start_month,
                    forecast_end_year, forecast_end_month)

bc_3m_release    <- tmp$release

bc_3m_target  <- list()
for (j in 1:4)
  bc_3m_target[[paste0("h=", j)]] <- tmp[[j + 1]]

bc_set <- list()
bc_set[['m3']] <- list(bc_3m_release, bc_3m_target)
for (hh in c(6, 12, 24, 60, 120)) {
  bc <- read.csv(paste('../../data/bc_data_',hh,'m.csv', sep = ""))
  tmp <- bc_align(bc, forecast_start_year, forecast_start_month,
                  forecast_end_year, forecast_end_month)
  ltmp  <- list()
  for (j in seq(3, 12, 3))
    ltmp[[paste0("h=", j)]] <- tmp[[(j / 3 + 1)]]
    bc_set[[paste0("m", hh)]] <- list(release = tmp$release, target = ltmp)
}


bc_cpi <- read.csv('../data/bc_data_cpi.csv')
tmp <- bc_align(bc_cpi, forecast_start_year, forecast_start_month,
                        forecast_end_year, forecast_end_month)
bc_cpi_release <- tmp$release
bc_cpi_target  <- list()
for (j in 1:4)
  bc_cpi_target[[paste0("h=", j)]] <- tmp[[j+1]]

################################################################################
##
##  macrodata
##
################################################################################
macro <- read.csv('../data/dataset_factors_data.csv')
macro_date <- as.Date(matlab2POS(macro[,1], tz = "UTC"))
macro <- macro[,-1]
macro <- as.xts(macro, macro_date)
macro <- lag.xts(macro)
## Subsetting
macro <- macro["1985-01-01/2011-12-30"]
yield_data <- xts(yield_data, as.yearmon(index(yield_data)))
macro <- xts(macro, as.yearmon(index(macro)))
