% recursivefcastb1.m

% Ron Alquist

% University of Michigan

% March 2007



% This program computes recursive forecasts for the case where alpha is estimated and beta = 1.


% It computes the following forecast evaluation statistics: MSPE, its value relative to that of the RW forecast,

% the DM test statistic, the bias of the forecast, the MAPE, its value relative to that of the RW forecast, the DM test statistic

% of equal predictive accuracy, the bias of the forecast, the success ratio, and the asymptotic p-value of

% the directional accuracy statistic.



function [mspe,msperat,dmmspe,bias,mape,maperat,dmmape,sr,srpval]=recursivefcastb1(y,sprd,X,R,h,date,spot)
         


% Inputs

% y = dependent variable (Nx1)

% sprd = futures-spot spread (Nx1)

% X = regressor matrix (Nxk)

% R = length of initial estimate period

% h = forecast horizon (months)

% date = Year (column 1) and month (column 2)

% spot = spot prices (Nx1)




N = rows(X);

P = rows(X) - R;

for i = R-h+1:P+R-h
    
    sample = 1:i;
    
    Xsmpl = X(sample,:);
    
    ysmpl = y(sample);
    
    sprdsmpl = sprd(sample,1);
    
    datesmpl = date(sample,:);
    
    [bhat,bhatstd,tbhat,yhat,ehat] = ols(ysmpl,Xsmpl);
         
        dyf(i-R+h,:) = X(i+h,:)*bhat + sprd(i+h,1);
        
      % Xmat(i-R+h,:)=[X(i+h,:) sprd(i+h,1)];
        
        yfmat(i-R+h,:) = [date(h+i,1:2) (1 + dyf(i-R+h,1))*spot(i,1) spot(h+i,1) spot(i,1)];
    
end;

regfe = yfmat(:,4) - yfmat(:,3);

rwfe = yfmat(:,4) - yfmat(:,5);

% MSPE
        
mspe = mean(regfe.^2);

bias = mean(regfe);

variance = mspe - bias^2;

dmspe = rwfe.^2 - regfe.^2;

msperat = mean(regfe.^2)/mean(rwfe.^2);

nlagmspe = round(4*((rows(dmspe)/100)^(2/9)));

f0hatmspe = nwesterr(dmspe,ones(rows(dmspe),1),nlagmspe);

dbarmspe = mean(dmspe);

dmmspe = dbarmspe/f0hatmspe;
        
% MAPE 

mape = mean(abs(regfe));

dmape = abs(rwfe) - abs(regfe);

maperat = mean(abs(regfe))/mean(abs(rwfe));

nlagmape = round(4*((rows(dmape)/100)^(2/9)));

f0hatmape = nwesterr(dmape,ones(rows(dmape),1),nlagmape);

dbarmape = mean(dmape);

dmmape = dbarmape/f0hatmape; 

% Directional accuracy

ds = yfmat(:,4) - yfmat(:,5);

dsf = yfmat(:,3) - yfmat(:,5);

n = rows(yfmat);

pxhat = mean(sign(dsf)>0);

pyhat = mean(sign(ds)>0);

phat = mean(sign(ds)==sign(dsf));

phatstar = pxhat*pyhat + (1-pxhat)*(1-pyhat);

vphat = phatstar*(1-phatstar)/n;

vphatstar = (pxhat*(1-pxhat)*(2*pyhat-1)^2)/n+(pyhat*(1-pyhat)*(2*pxhat-1)^2)/n+4*pyhat*pxhat*(1-pyhat)*(1-pxhat)/n^2;

sr = phat;

if ((vphat - vphatstar) ~= 0)
    
    da = (phat-phatstar)/sqrt(vphat-vphatstar);

    srpval = 1 - normcdf(da,0,1);
    
else
    
    srpval = 'NA. This model generates forecasts in one direction only.';
    
end;