% PFIND.M
% Lutz Kilian
% University of Michigan
% April 1997
%
% Code written for p=1,...,pmax. Must be adapted slightly if we allow for p=0.

function [porder]=pfind(y,pmax);

crit=zeros(1,pmax);
[t,q]=size(y);

XMAX=ones(1,t-pmax);
for i=1:pmax
	XMAX=[XMAX; y(pmax+1-i:t-i,:)'];
end;

for jj=1:pmax

	X=XMAX(1:jj*q+1,:);
   Y=y(pmax+1:t,:)';   

	B=Y*X'*inv(X*X');        
   SIGMA=(Y-B*X)*(Y-B*X)'/(t-pmax);
	np=length(vec(B));

   % Calculating value of aic(jj)
   crit(jj)=log(det(SIGMA))+np*2/(t-pmax);    		  % aic value
%  crit(jj)=log(det(SIGMA))+np*log(t-pmax)/(t-pmax);  % sic value
	
end;

[pmin,porder]=min(crit);
       
