% nwvcmat.m

% Ron Alquist

% University of Michigan

% March 2007


% This code is based on that provided by James LeSage for computing Newey-West

% standard errors.



% This program returns the Newey-West variance-covariance matrix.




function [V] = nwvcmat(y,x,nlag)

[nobs nvar] = size(x);

xpxi = inv(x'*x);

beta = xpxi*(x'*y);

yhat = x*beta;

resid = y - yhat;

sigu = resid'*resid;

sige = sigu/(nobs-nvar);

% perform Newey-West correction

emat = [];

for i=1:nvar;

emat = [emat

        resid'];

end;

       

    hhat = emat.*x';

    G=zeros(nvar,nvar); w=zeros(2*nlag+1,1);

    a=0;



    while a~=nlag+1;

        ga=zeros(nvar,nvar);

        w(nlag+1+a,1)=(nlag+1-a)/(nlag+1);

        za=hhat(:,(a+1):nobs)*hhat(:,1:nobs-a)';

          if a==0;

           ga=ga+za;

          else

           ga=ga+za+za';

          end;

        G=G+w(nlag+1+a,1)*ga;

        a=a+1;

    end; 

    

        V=xpxi*G*xpxi;

        nwerr= sqrt(diag(V));
        
        tstat=beta./nwerr;