% nrbpt.m

% Ron Alquist

% University of Michigan

% March 2007



% This program computes the forecast accuracy statistics based on Pesaran and Timmerman's (1992)

% directional accuracy test statistic for forecasts that do not rely on regression methods. It returns the

% success ratio and the asymptotic p-value of the test statistic.





function [sr,srpval]=nrbpt(s,sf,h,year,date)

% Inputs

% s = Nx1 vector of spot prices.

% sf = Nx1 vector of predictor variable.

% year = Cut-off year to begin forecasting. Set to 1990, so that forecasts begin in 1991.1.

% h = Forecast horizon in months.

% date = Date vector with year (column 1) and month (column 2).



fehat = [date(h+1:rows(date),1:2) s(h+1:rows(s),1) sf(1:rows(sf)-h,1) s(1:rows(s)-h,1) (s(h+1:rows(s),1)-sf(1:rows(sf)-h,1))];

fehat = [fehat(h+1:rows(fehat),1:6) fehat(h+1:rows(fehat),3)-fehat(1:rows(fehat)-h,3) fehat(h+1:rows(fehat),4)-fehat(1:rows(fehat)-h,3)];

R = (fehat(:,1) > year);

fehat = fehat(R,:);

% Remove NaNs

ndum = (isnan(fehat(:,3)) | isnan(fehat(:,4)));

% fehat = delif(fehat,ndum);

fehat = fehat(~ndum,:);

bdate = fehat(1,1:2);

edate = fehat(rows(fehat),1:2);

% Directional accuracy statistic

ds = fehat(:,7);
   
dsf = fehat(:,8);
    
n = rows(ds);
    
pxhat = mean(sign(dsf)>0);
    
pyhat = mean(sign(ds)>0);
    
phat = mean(sign(ds)==sign(dsf));
    
phatstar = pxhat*pyhat + (1-pxhat)*(1-pyhat);
    
vphat = phatstar*(1-phatstar)/n;
    
vphatstar = (pxhat*(1-pxhat)*(2*pyhat-1)^2)/n+(pyhat*(1-pyhat)*(2*pxhat-1)^2)/n+4*pyhat*pxhat*(1-pyhat)*(1-pxhat)/n^2;
    
sr = phat;
    
if ((vphat - vphatstar) ~= 0)
    
    da = (phat-phatstar)/sqrt(vphat-vphatstar);

    srpval = 1 - normcdf(da,0,1);
    
else
    
    srpval = 'NA. This model generates forecasts in one direction only.';
    
end;