% mspedm.m

% Ron Alquist

% University of Michigan

% March 2007



% This program returns the MSPE of the forecast, its value relative to that of the RW forecast, the

% asymptotic p-value of test statistic of equal predictive accuracy, and the bias of the forecast.



function [mspe,msperat,pval,bias] = mspedm(s,sf,h,yr,date)

% Inputs

% s = spot prices (Nx1)

% sf = predictor variable (Nx1)

% yr = year to begin forecasting

% h = forecast horizon (months)

% date = Year (column 1) and month (column 2)


fehat = [date(h+1:end,1:2) s(h+1:end,1)-s(1:end-h,1) s(h+1:end,1)-sf(1:end-h,1)];

R=(fehat(:,1)>yr);

fehat=fehat(R,:);

% Remove missing data

ndum=(isnan(fehat(:,3)) | isnan(fehat(:,4)));

% fehat=delif(fehat,ndum);

fehat = fehat(~ndum,:);

bdate=fehat(1,1:2);

edate=fehat(end,1:2);

% MSPE

mspe=mean(fehat(:,4).^2);

bias=mean(fehat(:,4));

variance=mspe-bias^2;

% Forecasting ability against RW

rwehat = fehat(:,3);

regehat = fehat(:,4);

dmspe = rwehat.^2-regehat.^2;

nlagmspe = round(4*((rows(dmspe)/100)^(2/9)));

f0hatmspe = nwesterr(dmspe,ones(rows(dmspe),1),nlagmspe);

dbarmspe = mean(dmspe);

dmmspe = dbarmspe/f0hatmspe;

msperat = mean(regehat.^2)/mean(rwehat.^2);

pval = 1 - normcdf(dmmspe,0,1);