% mspecw.m

% Ron Alquist

% University of Michigan

% March 2007



% This program returns the MSPE of the forecast, its value relative to that of the RW forecast, the

% Clark-West adjusted p-value of test statistic of equal predictive accuracy, and the bias of the forecast.



function [mspe,msperat,pvaladj,bias] = mspecw(s,sf,h,yr,date)

% Inputs

% s = spot prices (Nx1)

% sf = predictor variable (Nx1)

% h = forecast horizon (months)

% yr = cut-off year to begin forecasting.

% date = year (column 1) and month (column 2).


fehat = [date(h+1:end,1:2) s(h+1:end,1)-s(1:end-h,1) s(h+1:end,1)-sf(1:end-h,1)];

R = (fehat(:,1)>yr);

fehat = fehat(R,:);

% Remove missing data

ndum = (isnan(fehat(:,3)) | isnan(fehat(:,4)));

% fehat=delif(fehat,ndum);

fehat = fehat(~ndum,:);

bdate = fehat(1,1:2);

edate = fehat(end,1:2);

% MSPE

mspe = mean(fehat(:,4).^2);

bias = mean(fehat(:,4));

variance = mspe-bias^2;

% Forecasting ability against RW

rwehat = fehat(:,3);

regehat = fehat(:,4);

msperat = mean(regehat.^2)/mean(rwehat.^2);

mspeadj = fehat(:,4).^2-(fehat(:,4)-fehat(:,3)).^2;

dmspeadj = rwehat.^2-mspeadj;

nlagmspeadj = round(4*((rows(dmspeadj)/100)^(2/9)));

f0hatmspeadj = nwesterr(dmspeadj,ones(rows(dmspeadj),1),nlagmspeadj);

dbarmspeadj = mean(dmspeadj);

dmmspeadj = dbarmspeadj/f0hatmspeadj;

pvaladj = 1 - normcdf(dmmspeadj,0,1);