% mapedm.m

% Ron Alquist

% University of Michigan

% March 2007



% This program returns the MAPE of the forecast, its value relative to that of the RW forecast, and the

% asymptotic p-value of test statistic of equal predictive accuracy.



function [mape,maperat,pval] = mapedm(s,sf,h,yr,date)

% Inputs

% s = spot prices (Nx1)

% sf = predictor variable (Nx1)

% yr = year to begin forecasting

% h = forecast horizon (months)

% date = Year (column 1) and month (column 2)



fehat = [date(h+1:end,1:2) s(h+1:end,1)-s(1:end-h,1) s(h+1:end,1)-sf(1:end-h,1)];

R=(fehat(:,1)>yr);

fehat=fehat(R,:);

% Remove missing data

ndum=(isnan(fehat(:,3)) | isnan(fehat(:,4)));

% fehat=delif(fehat,ndum);

fehat = fehat(~ndum,:);

bdate=fehat(1,1:2);

edate=fehat(end,1:2);

% MAPE

mape=mean(abs(fehat(:,4)));

% Forecasting ability against RW

rwehat = fehat(:,3);

regehat = fehat(:,4);

dmape = abs(rwehat)-abs(regehat);

nlagmape = round(4*((rows(dmape)/100)^(2/9)));

f0hatmape = nwesterr(dmape,ones(rows(dmape),1),nlagmape);

dbarmape = mean(dmape);

dmmapein = dbarmape/f0hatmape;

maperat = mean(abs(regehat))/mean(abs(rwehat));

pval = 1 - normcdf(dmmapein,0,1);