% dslag.m

% Ron Alquist
% Bank of Canada
% August 2010

% This program computes the local drift over the past l months. The local
% drift is expressed as the l-month percent change. 

function [dsl] = dslag(s,l)
 
% Inputs

% s = spot price (Tx1)
% l = local drift lag length

T = rows(s);

ds = [0; (s(2:end,1) -s(1:end-1,1))./s(1:end-1,1)];

dsl = NaN.*zeros(T,1);

for i = 1 : T-l
    
    ld = cumprod(1+ds(i+1:i+l,1));
    
    dsl(i+l,1) = ld(end,1);

end;    