% bstrap.m

% Ron Alquist

% University of Michigan / Bank of Canada

% March 2007. Revised April 2013.

% This program computes the bootstrapped p-values for the test statistic of equal predictive accuracy under

% quadratic and absolute loss for the spread regressions.



function [mspepval, mapepval] = bstrap(d,s,f,dmmspedata,dmmapedata,h,R,model,B)




% Inputs

% d = date vector (Tx2)

% s = spot price (Tx1)

% f = futures price (Tx1)

% dmmspedata = DM test statistic from original data under quadratic loss

% dmmapedata = DM test statistic from data under absolute loss

% h = forecast horizon

% R = length of initial estimation sample

% model = 1 if alpha and beta are estimated; 2 if only beta is estimated; 3 if only alpha is estimated; 4 if alpha estimated and beta = 1 is imposed.

% B = Number of bootstrap replications




if (model == 1) || (model==2) || (model == 3) || (model ==4)
                                                                 
    T = rows(s);
    
    P = T -R;

    ds = log(s(2:end,:)) - log(s(1:end-1,:));
    
    sprd = log(f(1:end,:)) - log(s(1:end,:));
    
    [bhat,bhatstd,tbhat,yhat,uhat] = ols(sprd,ones(rows(sprd),1));
    
    p = 1;
    
    % [p] = pfind(uhat,pmax); 
    
    [rhohat,bhatstd,tbhat,yhat,ehat] = ar(uhat,p); 
    
    rhat = rhohat(2:end,:)';
    
    uhatrep = repmat(uhat,1,p);
    
    X = [];
    
    for k = 1 : p 
        
        X(:,k) = [NaN*ones(k,1); uhatrep(1:end-k,k)]; 
        
    end;
    
    X = [ones(T-p,1), X(p+1:end,:)]; 
   
    ht = diag(X*((X'*X)\X'));
    
    ehatdd = ehat./sqrt(1 - ht);
        
    dmmspevec = zeros(B,1);
    
    dmmapevec = zeros(B,1);

   rds = rows(ds);
  
    for b = 1 : B
        
        eta = randn(rds,1);  
        
        dsstar = eta.*ds;      
       
        ls0 = log(s(fix(rand(1,1).*T) + 1)); 
        
        lsstar = cumsum([ls0; dsstar(fix(rand(500+T-1,1).*rds) + 1)]);
        
        ystar = lsstar(501+h:end,1) - lsstar(501:end-h,1);      
        
        if (model == 1) || (model == 2) || (model == 4)            
           
            uhatstar = [uhat(fix(rand(p,1).*rows(uhat)) + 1,1); zeros(500+T-p,1)];            
           
            ehatstar = [eta(fix(rand(500+1,1).*rows(eta)) + 1,1); eta].* [ehatdd(fix(rand(500+p,1).*rows(ehatdd)) + 1,1); ehatdd];            
            
            for k = p + 1 : T + 500  
                
                uhatstar(k,1) = rhat*uhatstar(k-1: -1 : k-p) + ehatstar(fix(rand(1,1).*rows(ehatstar)) + 1,1);                
            
            end;            
            
            sprdstar = uhatstar(501:end,1);            
        
        end;
                    
    if (model == 1)
        
         Xstar = [ones(T,1), sprdstar(1:T,1)];  
         
    elseif (model == 2)   
        
        Xstar = sprdstar(1:T,1);
        
    elseif (model == 3)||(model == 4)  
        
         Xstar = [ones(T,1)];  
         
    end;
    
    dyf = zeros(P,1);
    yfmat = zeros(P,5);
    
    for i = R-h+1:P+R-h   
        
        if (model == 1) || (model == 2) || (model == 3) 
            
            ysmpl = ystar(1:i-h,1);
            
            Xsmpl = Xstar(1:i-h,:); 
            
            bhat = (Xsmpl'*Xsmpl)\Xsmpl'*ysmpl;   
            
            % bhatmat(i-R+h,:) = bhat';             
        
            dyf(i-R+h,:) = Xstar(i+h,:)*bhat;
            
            yfmat(i-R+h,:) = [d(h+i,1:2) (1 + dyf(i-R+h,1))*exp(lsstar(500+i,1)) exp(lsstar(500+i,1)) exp(lsstar(500+h+i,1))]; 
            
        elseif (model == 4)  
            
            sprdsmpl = sprdstar(1:i-h,1);
            
            ysmpl = ystar(1:i-h,1) - sprdsmpl;
            
            Xsmpl = Xstar(1:i-h,:);
            
            bhat = (Xsmpl'*Xsmpl)\Xsmpl'*ysmpl; 
            
            % bhatmat(i-R+h,:) = bhat';              
            
            dyf(i-R+h,:) = Xstar(i+h,:)*bhat + sprdstar(i+h,1);
            
            yfmat(i-R+h,:) = [d(h+i,1:2) (1 + dyf(i-R+h,1))*exp(lsstar(500+i,1)) exp(lsstar(500+i,1)) exp(lsstar(500+h+i,1))];   
            
        end; 
        
    end;
                    
        regfe = yfmat(:,5) - yfmat(:,3);
        
        rwfe = yfmat(:,5) - yfmat(:,4);
        
        % MSPE  
        
        dmspe = rwfe.^2 - regfe.^2; 
        
        nlagmspe = round(4*((rows(dmspe)/100)^(2/9))); 
        
        f0hatmspe = nwesterr(dmspe,ones(rows(dmspe),1),nlagmspe);
        
        dbarmspe = mean(dmspe);  
        
        dmmspe = dbarmspe/f0hatmspe;  
        
        dmmspevec(b,:) = dmmspe;
        
        clear dmspe nlagmspe f0hatmspe dbarmspe;
        
        % MAPE 
        
        dmape = abs(rwfe) - abs(regfe); 
        
        nlagmape = round(4*((rows(dmape)/100)^(2/9)));  
        
        f0hatmape = nwesterr(dmape,ones(rows(dmape),1),nlagmape);  
        
        dbarmape = mean(dmape);
        
        dmmape = dbarmape/f0hatmape;  
        
        dmmapevec(b,:) = dmmape;
        
        clear dmape nlagmape f0hatmape dbarmape;            
    end;

% Empirical distribution of DM test statistics.

mspepval=sum(dmmspevec>dmmspedata)/rows(dmmspevec);

mapepval=sum(dmmapevec>dmmapedata)/rows(dmmapevec);

else 
    
    disp('Error. model = 1, 2, 3, or 4.');
    
    mspepval = 'NA';    
    
    mapepval = 'NA';   
    
end;
    