% bsmapeld.m

% Ron Alquist

% University of Michigan / Bank of Canada

% March 2007. Corrected October 2011.



% This program returns the MAPE, the ratio of the MAPE relative to that of the RW forecast, and the bootstrapped p-value

% for the test statistic of equal predictive accuracy under absolute loss for forecasts based on a random walk with local

% drift.


function [mapeout,maperat,mapepval] = bsmapeld(s,sf,l,h,yr,date,B)


% Inputs

% s = spot price (Nx1)

% sf = forecast (Nx1)

% l = lag for local drift

% h = forecast horizon (months)

% yr = year to begin forecasting

% date = year (column 1) and month (column 2)

% B = Number of bootstrap replications



fehat = [date(h+1:end,1:2) s(h+1:end,1)-s(1:end-h,1) s(h+1:end,1)-sf(1:end-h,1)];

spot = s(~isnan(s(:,1)),1);

ndum = (isnan(fehat(:,3)) | isnan(fehat(:,4)));

fehat = fehat(~ndum,:);

R = (fehat(:,1)>yr);

fehat = fehat(R,:);

% MAPE

mapeout = mean(abs(fehat(:,4)));

regehat = fehat(:,4);

rwehat = fehat(:,3);

dmape = abs(rwehat)-abs(regehat);

maperat = mean(abs(regehat))/mean(abs(rwehat));

nlagmape = round(4*((rows(dmape)/100)^(2/9)));

f0hatmape = nwesterr(dmape,ones(rows(dmape),1),nlagmape);

dbarmapein = mean(dmape);

dmmapein = mean(dmape)/f0hatmape;

ds = log(spot(2:end,1)) - log(spot(1:end-1,1));

pad = fix(rand(13,1)*rows(ds))+1;

ds1 = [ds(pad,1); ds];

X = ones(rows(ds1),1);

[bhat,bhatstd,tbhat,yhat,ehat] = ols(ds1,X);

randn('state',100*sum(clock));

etamat = random('norm',0,1,rows(date),B);

% Bootstrap

for j = 1 : B
    
    spos = fix(rand(1,1)*rows(spot)) + 1;
    
    posdum = fix(rand(rows(ds1),1)*rows(ds1)) + 1;
    
    ls(:,j) = cumsum([log(spot(spos,1)); ehat(posdum).*etamat(2:end,j)]);
    
    dsstar = [0; ls(2:end,j)-ls(1:end-1,j)];
    
    T = rows(dsstar);
    
    for t = 1 : T-l
        
        ldstar=(cumprod(1+dsstar(t+1:t+l,1))).^(1/l);
        
        dslagstar(t+l,1) = ldstar(end,1);
    
    end;
      
    fehat1 = [date(h+1:end,1:2) exp(ls(h+1:end,j)) - exp(ls(1:end-h,j)) exp(ls(h+1:end,j)) - exp(ls(1:end-h,j)).*dslagstar(1:end-h,1)];
    
    b = find(fehat1(:,1) == 1991 & fehat1(:,2) == 1);
    
    e = find(fehat1(:,1) == 2007 & fehat1(:,2) == 2);

    fehat2 = fehat1(b:e,:);
            
    rwfe = fehat2(:,3);
     
    regfe = fehat2(:,4);
         
    % MAPE
        
    % mape = mean(abs(regfe));
        
    dmape = abs(rwfe) - abs(regfe);
        
    nlagmape = round(4*((rows(dmape)/100)^(2/9)));
        
    f0hatmape = nwesterr(dmape,ones(rows(dmape),1),nlagmape);
        
    dbarmape = mean(dmape);
        
    dmmape = dbarmape/f0hatmape;
        
    % dmmapemat(j,:) = dmmape;
        
    dbarmapemat(j,:) = dbarmape;
    
   clear dmape nlagmape f0hatmape dbarmape; 
            
end;

% min(dbarmapemat)

% max(dbarmapemat)

% median(dbarmapemat)

% mapepval=sum(dmmapemat>dmmapein)/rows(dmmapemat);

mapepval = sum(dbarmapemat>dbarmapein)/rows(dbarmapemat);
