function [bhat,bhatstd,tbhat,yhat,ehat] = ar(y,p)

% Inputs
% y = T x 1 vector on which to run autoregression.
% p = Lag length.

% Outputs
% bhat = Estimated autoregressive coefficients.
% bhatstd = Standard errors of the estimated coefficients.
% tbhat = t-statistics associated with estimated coefficients.
% yhat = Predicted y's.
% ehat = (T-p) x 1 vector of estimated residuals from autoregression.

T = rows(y);

yrep = repmat(y,1,p);

for i = 1 : p   
    X(:,i) = [NaN*ones(i,1); yrep(1:end-i,i)];      
end;

X = [ones(T-p,1), X(p+1:end,:)];
v = cols(X);
y = y(p+1:end,:);

bhat=(X'*X)\(X'*y);
yhat=X*bhat;
ehat=y-yhat; 

sigma=ehat'*ehat/(T-v);
bhatcov=sigma*inv(X'*X);
bhatstd=sqrt(diag(bhatcov));
tbhat=bhat./bhatstd;

