// copyright: Doornik, Laurent, S., Peters, J.-L. & Lazar, E.

/*--------------------------  NEW COMMENTS : ------------------------*/ 
/*
1) Il y avait un prbl quand SetStartValue("m_clevel",0);
J'ai chang toute la prc Getpara. C'est plus simple mnt et ca ne plante plus.
2) PrintStartValues(0) --> does nothing.
3) Init_Globals new proc (--> tutorial)
*/

/*--------------------------  Garch v.3.15 : ------------------------*/ 
/* Date of the version : September 13th, 2002. 
   Improvements : 
   v.1.00 : Creation of the Garch Class.					  
   v.1.10 : Includes faster GARCH, FIGARCH BBM, FIGARCH CHUNG, GJR and APARCH procedures. Modified IGARCH procedure. 
   v.1.11 : Includes the Nyblom Test of Stability. 
   v.1.12 : Includes the Skewed Student distribution and the Adjusted Pearson G-of-F Test. Some bugs corrected.  
   v.1.99 : Includes forecasts for AR(FI)MA-GARCH specification. 
   v.2.00 : Includes forecasts for the mean and the variance (GARCH, FIGARCH BBM, FIGARCH Chung, GJR only).  
   v.2.01 : Minor bug corrected 
   v.2.02 : Includes Forecasts Errors Measures, improved forecasts graphics. 
   v.2.03 : Forecasts storing available, includes density forecasts, plots autocorrelogram graphs. 
   v.2.04 : CDF and Inverse CDF of the GED, rearrangement of the graphs, store forecasts in the Light Version, minor bugs. 
   v.2.05 : Forecasts APARCH. 
   v.2.06 :	Allows observed variance. 
   v.2.07 : Modified FEM + Forecasts EGARCH + Improved Forecasts Graphs. 
   v.2.08 : Linear and Exclusive Restrictions 
   v.2.09 : Improved 1 step forecasting 
   v.2.10-2.12 : Various slight modifications 
   v.2.13 : Modified INVCDFTA, GetZB. Includes Trend in OxPack. Print Forecasts GOF in the Light Version.   
   v.2.14 : Include Std Dev. in FEM, small bugs corrected. 
   v.2.15 : Editable default values + Positivity constraints + minor Bugs corrected 
   v.2.16 : Constrained parameters estimation allowed. 
   v.2.17 : Mincer-Zarnowitz Regression on the forecasted volatility w/ Heteroscedastic S.E. (White) + Minor Bugs 
   v.2.18 : Correction of Minor Bugs 
   v.2.20 : MZ s.e. corrected + Store XLS files + "cleaning". 
   v.2.21 : Storing Estimated Parameters 
   v.2.22 : Compatible with Ox Pro 3.00 (DrawDensity ...) 
   v.3.00 : Hygarch included + Save Graphics + Modified OP_SETTINGS + Allows to launch filters independently.
   v.3.01 : New Forecasts + New For.Graphics Options + MZ & FEM independant + Stationarity conditions
   v.3.02 : Several rows --> sizer + Modif of cd(), Forecast()
   v.3.03 : Stationarity of GJR	+ Corrected forecasts graphics
   v.3.04 : Fixed parameters available + Split Stationarity/Positivity
   v.3.05 : Various changes
   v.3.06 : Corrected forecasts graphs + Hygarch launch (oxpack) + Corrected FIAPARCH
   v.3.07 : G@RCH 2.20 beta version !!!
   v.3.10 : Ox 3.10 compatible, minor bugs : G@RCH 2.3
   v.3.11 : - delete Filter()
   			- add garch-in-mean
			- MZ changed : the second argument is the vector of cond.var. and not a matrix
			- uses getcwd() to locate startingvalues.txt
   v.3.12 : - Corrected startingvalues.txt location
   			- Initialize binary variables in the constructor
			- Replace ScoreContributions by NumJacobianEx
			- covar(...) modified --> 3 methods	 --> modifier le tutorial
			- m_mCovarNR supprim, GetCovar() modifi
			- requires Ox 3.2
	v.3.13 :- BoxPQ rewritten
			- Small modifs
	v.3.14 :- Modifs de Sebastien
			- Correction CheckValue
	v.3.15 :- Creation de MBase2
			- Maximisation contrainte
*/
/*--------------------------  END Garch v.3.15 : ------------------------*/

//+ NM2 and NM3 density	+ Asymmetry!!!
 
#include <oxstd.h>  
#include <oxfloat.h> 
#include <oxdraw.h> 
#include <oxprob.h> 
#include <arma.h> 
#import <maximize> 
#import <modelbase> 
#import <maxsqp>
#import <packages/Garch30/MBase2>
#include <garch_enyem3.h>
#include "lib/testres.ox"

const decl HIGH_VALUE = 1e10;
const decl ERROR = .NaN;
const decl MAX_IT=1500;

Garch::option_price_call_black_scholes( decl S, // spot price
					decl X, // Strike (exercise) price,
					decl r,  // interest rate
					decl sigma,
					decl time) 
{  
	decl time_sqrt = sqrt(time);
    decl d1 = (log(S/X)+r*time)/(sigma*time_sqrt) + 0.5*sigma*time_sqrt; 
    decl d2 = d1-(sigma*time_sqrt);
    decl my_c = S * probn(d1) - X * exp(-r*time) * probn(d2);
	//println("parameter sigma ",sigma," call ",my_c," ",d1," ",probn(d1)," ",probn(d2));
    return my_c;	
}

Garch::option_price_implied_volatility_call_black_scholes_newton(decl S, decl X, decl r, decl time, decl option_price)
{
	// check for arbitrage violations:
	// if price at almost zero volatility greater than price, return 0
	decl sigma_low = 1e-5;
	decl price = option_price_call_black_scholes(S,X,r,sigma_low,time);
	if (price >= option_price) return ERROR;
	decl t_sqrt = sqrt(time);
	
	decl my_sigma = (option_price/S)/(0.398*t_sqrt);    // find initial value
	for (decl i=0;i<MAX_IT;i++)
	{
		price = option_price_call_black_scholes(S,X,r,my_sigma,time);
		decl diff = option_price -price;
		//println(option_price," ",price);
		if (fabs(diff)<FNR_ACCURACY) return my_sigma;
		decl d1 = (log(S/X)+r*time)/(my_sigma*t_sqrt) + 0.5*my_sigma*t_sqrt; 
		decl vega = S * t_sqrt * densn(d1);
		if (vega<1e-10) vega=1e-10;
		my_sigma = my_sigma + diff/vega;
		if (my_sigma<0)
		{
			//println("Sigma became negative. I changed it back.");
			my_sigma= (option_price/S)/(0.398*t_sqrt)+i/5000;
		}
		
		if (isdotinf(my_sigma))
		{
			println("Sorry. Sigma is infinity, check the problem.");
			exit(1);
	
		}
	}
	 println(S," ",X," ",time," ",my_sigma," ",price, " ", option_price);
	 println("Computing implied volatility lead to error. Increase max iterations or change program.");
	 //exit(1);
	 return ERROR;  // something screwy happened, should throw exception
}

Garch::option_price_implied_volatility_call_black_scholes_bisections(
   decl S, decl X, decl r, decl time, decl option_price) 
{ // check for arbitrage violations: 
    // if price at almost zero volatility greater than price, return 0

    decl sigma_low=0.0001;
    decl price = option_price_call_black_scholes(S,X,r,sigma_low,time);
    if (price>option_price) return 0.0;
  
    // simple binomial search for the implied volatility.
    // relies on the value of the option increasing in volatility
  
    // want to bracket sigma. first find a maximum sigma by finding a sigma
    // with a estimated price higher than the actual price.
    decl sigma_high=0.4;
    price = option_price_call_black_scholes(S,X,r,sigma_high,time);
    while (price < option_price)
	{  
		sigma_high = 2.0 * sigma_high; // keep doubling.
		price = option_price_call_black_scholes(S,X,r,sigma_high,time);
		if (sigma_high>HIGH_VALUE) return ERROR; // panic, something wrong.
    }
    for (decl i=0;i<MAX_IT;i++)
	{
		decl sigma = (sigma_low+sigma_high)*0.5;
		price = option_price_call_black_scholes(S,X,r,sigma,time);
		decl test =  (price-option_price);
		if (fabs(test)<FNR_ACCURACY) { return sigma; }
		if (test < 0.0) { sigma_low = sigma; }
		else { sigma_high = sigma; }
    }
    return ERROR;
}

Garch::option_price_call_european_simulated(decl S, 
					     			 decl X, 
					     			 decl r,
					     			 decl sigma, 
					     			 decl time,
					     			 decl no_sims)
{
    decl R = (r - 0.5 * sqr(sigma)) * time;
    decl SD = sigma * sqrt(time);
	decl prices = S * exp(R + SD * rann(1, no_sims)) - X;
	decl sum_payoffs = double(sumr(prices .> 0 .? prices .: 0));
    return exp(-r*time) * (sum_payoffs/no_sims);
}


findsample(const mdata, const mvarsel, const mlagsel, const it1, const it2, const dmisval, const at1, const at2); 
 
const decl DB_MISVAL = -9999.99;
const decl MY_MAX = 1000000;
								 
/*----------------------------/////////////--------------------------------*/ 
/*---------------------------//  INPUT  //---------------------------------*/ 
/*--------------------------/////////////----------------------------------*/ 
 
Garch::Garch() 
{ 
   this.MBase2();
   m_iModelClass = MC_GARCH;
   Init_Globals();
} 

Garch::Init_Globals() 
{
   m_cLagPort = <>;
   m_cLagArch = <>; 
   m_cNyblom = 0;	
   m_cGOF = <>;         
   m_cFOR = 0;
   m_cTests = 0;
   m_cPrintTest = 0;
   m_cBound = 0;
   m_cPrintFor = 0;
   m_cGraphs = 0;
   m_cSGraphs = 0;
   m_cForGraphs = 0;
   m_cSForGraphs = 0;
   m_cFix = 0;
   m_cIter = 0;
   m_cYsmall = 0;
   m_cXM = 0;
   m_cXV = 0; 
   m_cOV = 0;
   m_cMean = 1; 
   m_cVar = 1; 
   m_cDist = 0;   		
   m_cSk = 0;	
   m_cKu = 0;		 
   m_cAR = 0;        
   m_cMA = 0; 		
   m_cARFI = 0;	
   m_cP = 1;
   m_cQ = 1;
   m_cD = 0; 
   m_cFIMethod = 0;
   m_claglamb = 0;
   m_cIGARCH = 0;
   m_cGJR = 0;
   m_cNMGJR = 0;
   m_cNMAGARCH = 0;
   m_cHY = 0;
   m_cEgarch = 0;
   m_cAparch = 0;
   m_cFilter = 1;
   m_c_in_mean = 0;     					
   m_cMLE = 0;					
   m_cCovar = 0;
   m_vGrad = 0;
   m_restr = 0;
   m_num1der = 0;
   m_vol = 0;
   m_vol1 = 0;
   m_vol2 = 0;
   m_vol3 = 0;
   m_sk = 0;
   m_kurt = 0;
   m_vPar_forec=zeros(1,9);
}

Garch::Csts(const cstM, const cstV) 		   
{ 
	m_cMean = cstM; m_cVar = cstV; 
} 
 
Garch::CSTS(const cstM, const cstV) 
{ 
	if ((cstM < 0) || (cstM > 1)) 
	{ 
		println("The arguments of the CSTS(cstM, cstV) function must be 0 or 1.\n", 
				"You have enter ", cstM," and ", cstV,". Please correct it."); 
		exit(0); 
	} 
 
	if ((cstV < 0) || (cstV > 1)) 
	{ 
		println("The arguments of the CSTS(cstM, cstV) function must be 0 or 1.\n", 
				"You have enter ", cstM," and ", cstV,". Please correct it."); 
		exit(0); 
	} 
 
	Csts(cstM,cstV); 
} 
 
Garch::Distri(const dist) 
{ 
	m_cDist = dist; 
	m_cKu =0; 
	m_cSk =0;
	m_cNM2=0;
	m_cNM3=0;
 
	if ((m_cDist == 1)||(m_cDist == 2)) 
		m_cKu = 1; 
	else if (m_cDist == 3) 
	{ 
		m_cKu = 1;	m_cSk = 1;	 
	}
		else if (m_cDist == 4)
		{
			m_cNM2 = 1;
		}
			else if (m_cDist == 5)
			{
				m_cNM3=1;
			}
}

 
Garch::DISTRI(const dist) 
{ 
	if ((dist < 0)||(dist > 5)) 
	{ 
		println("The argument of the DISTRI(dist) function must be 0 (Gauss), 1 (Student), 2 (GED), 3 (Skewed Student) or 4 (NM).\n", 
				"You have enter ", dist,". Please correct it."); 
		exit(0); 
	} 
	 
	Distri(dist);
} 

Garch::GetDistri() 
{ 
	return m_cDist; 
}

Garch::Armaorders(const cAR, const cMA) 
{ 
	m_cAR = cAR;  m_cMA = cMA; 
} 
 
Garch::ARMA_ORDERS(const cAR, const cMA) 
{ 
	Armaorders(cAR, cMA); 
} 
 
Garch::Arfima(const cARFI) 
{ 
    m_cARFI = cARFI; 
} 
 
Garch::ARFIMA(const cARFI) 
{ 
	if ((cARFI != 0)&&(cARFI != 1)) 
	{ 
		println("The argument of the ARFIMA(cARFI) function must be 0 or 1.\n", 
				"You have enter ", cARFI,". Please correct it."); 
		exit(0); 
	} 
	 
	Arfima(cARFI); 
}																		  
 
Garch::Garchorders(const cP, const cQ) 	    
{ 
	m_cP = cP; m_cQ = cQ;	m_cFilter = 1; 
} 
 
Garch::GARCH_ORDERS(const cP, const cQ) 	    
{ 
	Garchorders(cP,cQ); 
}

Garch::ARCH_in_mean(const type) 	    
{
	if ((type<0)||(type>2))
	{
		println("The argument of the fct in_mean_type() must be 0, 1 or 2");
		println("By default it has been set to 0 (no ARCH-in-mean)");
		m_c_in_mean=0;
	}
	else
		m_c_in_mean=type;
}
 
Garch::MODEL(const mod)							 
{ 
	if ((mod < 1)||(mod > 13)) 
	{ 
		println("The argument of the MODEL(mod) function must be between 1 and 11.\n", 
				"You have enter ", mod,". Please correct it."); 
		exit(0); 
	} 
 																			  
	if ((mod != 1)&&(mod != 2)&&(mod != 6)&&(mod != 7)&&(mod != 8)&&(m_cQ < 1)) 
	{ 
		println("With this model, the ARCH order (q) must be greater than 0.\n", 
				"It is currently equal to ", m_cQ,". Please correct it."); 
		exit(0); 
	} 
 
	if ((mod == 5)&&(m_cP < 1)) 
	{ 
		println("With the IGARCH model, the GARCH order (p) must be greater than 0.\n", 
				"It is currently equal to ", m_cQ,". Please correct it."); 
		exit(0); 
	}	 
 
    m_cEgarch = 0; m_cGJR = 0; m_cAparch = 0; m_cHY = 0; m_cD = 0;	 m_cNMGJR = 0; m_cNMAGARCH = 0;
 
	if (mod == 1) 		m_cFilter = 1; 
	else if (mod == 2) 	{ m_cFilter = 2; m_cEgarch = 1; }  
	else if (mod == 3)	{ m_cFilter = 3; m_cGJR = 1; }  
	else if (mod == 4)	{ m_cFilter = 4; m_cAparch = 1; } 
	else if (mod == 5)	{ m_cFilter = 10; }
	else if (mod == 6)	{ m_cFilter = 11; m_cD = 1; }  
	else if (mod == 7)	{ m_cFilter = 12; m_cD = 1; } 
	else if (mod == 8)	{ m_cFilter = 21; m_cEgarch = 1; m_cD = 1; } 
	else if (mod == 9)	{ m_cFilter = 41; m_cAparch = 1; m_cD = 1; } 
	else if (mod == 10)	{ m_cFilter = 42; m_cAparch = 1; m_cD = 1; } 
	else if (mod == 11)	{ m_cFilter = 51; m_cHY = 1; m_cD = 1;  }
	else if (mod == 12)	{ m_cFilter = 112; m_cNMGJR = 1; }
	else if (mod == 13)	{ m_cFilter = 113; m_cNMAGARCH = 1; }  
	return  1; 
} 
 
Garch::TRUNC(const t)			 
{ 
	if ((m_cFilter == 11)||(m_cFilter == 21)||(m_cFilter == 41)||(m_cFilter == 51))		// HY 
	{ 
		if (t < 0) 
		{ 
			println("The truncation order of the FIGARCH must be greater than 0.\n", 
					"You have enter ", trunc,". Please correct it."); 
			exit(0); 
		} 
		m_claglamb  = t; 
		if (m_claglamb > m_iT2sel) 
		{ 
			println("The truncation order must be less than the sample size.\n", 
					"You have enter a truncation order of ", m_claglamb," and there are ", m_iT2sel," observations in the selected sample."); 
			exit(0); 
		} 
	} 
	 
	return  1; 
} 
 
Garch::MLE(const method) 
{ 
	if ((method != 0)&&(method != 1)&&(method != 2)) 
	{ 
		println("The argument of the MLE(method) function must be 0, 1 or 2.\n", 
				"You have enter ", method,". Please correct it."); 
		exit(0); 
	} 
	 
	if (method == 0) 
	m_iMethod = M_HESS; 
	else if	(method == 1) 
	m_iMethod = M_CROSSPRODUCT; 
	else if  (method == 2) 
	m_iMethod = M_QMLE; 
} 
 
Garch::BOUNDS(const method)						 
{ 
	if ((method != 0)&&(method != 1)) 
	{ 
		println("The arguments of the BOUNDS(method) function must be 0 or 1.\n", 
				"You have enter ", method,"Please correct it."); 
		exit(0); 
	} 
	 
	m_cBound = method; 
} 
 
Garch::BOXPIERCE(const lags) 
{ 
	if ( any(lags .< 0)) 
	{ 
		println("The arguments of the BOXPIERCE(lags) function must be positive.\n", 
				"You have enter ", lags,"Please correct it."); 
		exit(0); 
	} 
	 
	m_cLagPort = lags; 
} 
 
Garch::ARCHLAGS(const lags) 
{ 
	if ( any(lags .< 0)) 
	{ 
		println("The arguments of the ARCHLAGS(lags) function must be positive.\n", 
				"You have enter ", lags,"Please correct it."); 
		exit(0); 
	} 
	 
 	m_cLagArch = lags; 
} 
 
Garch::NYBLOM(const i)  
{ 
	if ((i != 0)&&(i != 1)) 
	{ 
		println("The argument of the NYBLOM(i) function must be 1 or 0.\n", 
				"You have enter ", i,". Please correct it."); 
		exit(0); 
	} 
	 
	if (i==1) 
	    m_cNyblom=1; 
	else 
	    m_cNyblom=0;		 
} 
 
Garch::PEARSON(const lags) 
{ 
	if (lags==0)			  
		m_cGOF=0; 
	else 
	{ 
		m_cGOF=1;	 
		m_cCellGOF=lags; 
	} 
} 
 
Garch::FORECAST(const i, const nbforc, const iprint)  
{ 
	if (i==0)
	{
		m_cFOR=0; 
		m_cPrintFor = 0; 
	}
	else 
	{ 
		m_cFOR=1;	 
		m_cTforc=nbforc; 
		m_cPrintFor = iprint; 
	} 
} 
 
Garch::ITER(const i) 
{ 
	if (i < 0) 
	{ 
		println("The argument of the ITER(i) function must be positive or null.\n", 
				"You have enter ", i,". Please correct it."); 
		exit(0); 
	} 
	 
	if (i == 0) m_cIter = -1; 
	else m_cIter = i; 
} 
 
Garch::GRAPHS(const d, const s, const file) 
{ 
	if ((d < 0)||(d > 1)||(s < 0)||(s > 1)) 
	{ 
		println("The arguments of the GRAPHS(d,s) function must be 0 or 1.\n", 
				"You have enter ", d," and ", s,". Please correct them."); 
		exit(0); 
	} 
	 
	m_cGraphs = d;	   m_cSGraphs = s;	 m_sNameGraphs = file~".eps";    
} 
 
Garch::FOREGRAPHS(const d, const s,  const file) 
{ 
	if ((d < 0)||(d > 1)||(s < 0)||(s > 1)) 
	{ 
		println("The arguments of the FOREGRAPHS(d,s) function must be 0 or 1.\n", 
				"You have enter ", d," and ", s,". Please correct them."); 
		exit(0); 
	} 
	 
	m_cForGraphs = d;	m_cSForGraphs = s;	m_sNameForGraphs = file~".eps";   
} 
 
 
Garch::COVAR(const p)														  
{ 
	if ((p < 0)||(p > 1)) 
	{ 
		println("The argument of the COVAR(p) function must be 0 or 1.\n", 
				"You have enter ", p,". Please correct it."); 
		exit(0); 
	} 
	 
	m_cCovar = p; 
} 
 
Garch::TESTS(const p, const a) 
{ 
	m_cTests = p;

	if ((m_cTests != 0)&&(m_cTests != 1)) 
	{ 
		println("The arguments of the TESTS(p,a) function must be 0 or 1.\n", 
				"You have enter ", p,". Please correct it."); 
		exit(0); 
	} 
	 
	if (m_cTests == 1)  
	{
		InitData(); 
		println("\n  ***********"); 
		println(" ** TESTS **");	 
		println("***********");	 
		println(""); 
		Normality(m_vY); 
	    println("---------------");		 
		BoxPQ(m_vY, m_cLagPort, m_cAR+m_cMA,0);	 
		println("---------------");
		BoxPQ(m_vY.^2, m_cLagPort, m_cP+m_cQ,1);  	 
		println("---------------"); 
		ArchTest(m_vY, 1, 2,  m_cP+m_cQ, TRUE);  
		println("---------------"); 
		exit(0); 
	} 
	m_cPrintTest = a;  							 
} 
 
Garch::InitStartValues(const init_par, const init_bounds) 			  
{ 
	decl i,Z,mat;
	decl file;
	mat = loadmat(startingvalues);
	
	m_mXM = GetGroup(X_VAR); 
    m_cXM = columns(m_mXM); 
	m_mXV = GetGroup(Z_VAR);    
    m_cXV = columns(m_mXV); 
	m_vOV = GetGroup(O_VAR);    
    m_cOV = columns(m_vOV);

	
	if (init_par==1)
	{
		m_clevel = double(mat[0][0]);	 
	 	if(m_cXM != 0) m_vbetam = ones(m_cXM,1) * mat[1][0]; 
		m_dARFI = double(mat[2][0])	; 
	 	if(m_cAR != 0) m_vAR = ones(m_cAR,1) * mat[3][0]; 
		if(m_cMA != 0) m_vMA = ones(m_cMA,1) * mat[4][0]; 
	    //innen
		m_calpha0 = double(mat[5][0]); 
	 	if(m_cXV != 0) m_vpsyv = ones(m_cXV,1) * mat[6][0]; 
		m_dD = double(mat[7][0]);	 
	 	if(m_cQ != 0) m_valphav = ones(m_cQ,1) * mat[8][0]; 
		if (m_cD == 0) m_vbetav = mat[9][0]; 
			else m_vbetav = (mat[9][0]./2); 
		for (i=1; i < m_cP; ++i) m_vbetav |= 0.1; 
		m_vleverage = ones(m_cQ,1) * mat[10][0];
		m_vtheta1 = double(mat[11][0]); 
		m_vtheta2 = double(mat[12][0]); 
		m_vgamma = ones(m_cQ,1) * mat[13][0]; 
		m_ddelta = double(mat[14][0]); 
		//eddig
		m_cA = double(mat[15][0]); 
		if (m_cDist == 2)	m_cV = double(mat[17][0]);							   
		else m_cV = double(mat[16][0]); 
		m_vHY = double(mat[18][0]);	   
		m_v_in_mean = double(mat[19][0]);
		
//En irtam
		//innen	 +15
		if ( (m_cDist == 4)	 ||   (m_cDist == 5))
		{
			m_calpha0_2 = double(mat[20][0]); 
	 		if(m_cXV != 0) m_vpsyv_2 = ones(m_cXV,1) * mat[21][0]; 
			m_dD_2 = double(mat[22][0]);	 
		 	if(m_cQ != 0) m_valphav_2 = ones(m_cQ,1) * mat[23][0]; 
			if (m_cD == 0) m_vbetav_2 = mat[24][0]; 
				else m_vbetav_2 = (mat[24][0]./2); 
			for (i=1; i < m_cP; ++i) m_vbetav_2 |= 0.1; 
			m_vleverage_2 = ones(m_cQ,1) * mat[25][0]; 
			m_vtheta1_2 = double(mat[26][0]); 
			m_vtheta2_2 = double(mat[27][0]); 
			m_vgamma_2 = ones(m_cQ,1) * mat[28][0]; 
			m_ddelta_2 = double(mat[29][0]);
			m_p1=double(mat[30][0]);
			m_p2=1-m_p1;
			m_mu1=double(mat[31][0]);
			m_mu2=-m_p1*m_mu1/m_p2;
		}
		if (m_cDist == 5)
		{
			m_calpha0_3 = double(mat[32][0]); 
	 		if(m_cXV != 0) m_vpsyv_3 = ones(m_cXV,1) * mat[33][0]; 
			m_dD_3 = double(mat[34][0]);	 
		 	if(m_cQ != 0) m_valphav_3 = ones(m_cQ,1) * mat[35][0]; 
			if (m_cD == 0) m_vbetav_3 = mat[36][0]; 
				else m_vbetav_3 = (mat[36][0]./2); 
			for (i=1; i < m_cP; ++i) m_vbetav_3 |= 0.1; 
			m_vleverage_3 = ones(m_cQ,1) * mat[37][0]; 
			m_vtheta1_3 = double(mat[38][0]); 
			m_vtheta2_3 = double(mat[39][0]); 
			m_vgamma_3 = ones(m_cQ,1) * mat[40][0]; 
			m_ddelta_3 = double(mat[41][0]);
			m_p2=double(mat[42][0]);
			m_p3=1-m_p1-m_p2;
			m_mu2=double(mat[43][0]);
			m_mu3=-(m_p1*m_mu1+m_p2*m_mu2)/m_p3;
		}
		//eddig

		m_mForc = <>; 
		GetPara(); 	
	} 
	if (init_bounds == 1)					 
	{ 
		Z = sumc((mat[][0] .< mat[][1]) + (mat[][0] .> mat[][2])); 
		if (Z > 0) 
		{ 
			println("At least one constraint is violated. Please check the initial values of the parameters."); 
			exit(0); 
		} 
		FixBounds(mat[0:43][1:2]);		   
	} 
} 
 
Garch::FixBounds(const m)				 
{ 
	decl i, mBound; 
	 
	mBound = <0,0>; 
	 
	if (m_cMean != 0)	mBound |= m[0][0:1]; 
	if (m_cXM != 0)		for (i=0; i < m_cXM; ++i) mBound |= m[1][0:1];			 
	if (m_cARFI != 0)	mBound |= m[2][0:1];			  
	if (m_cAR != 0)		for (i=0; i < m_cAR; ++i) mBound |= m[3][0:1];			   
	if (m_cMA != 0)		for (i=0; i < m_cMA; ++i) mBound |= m[4][0:1];
	
	//innen
	if (m_cVar != 0)	mBound |= m[5][0:1]; 
 	if (m_cXV != 0) 	for (i=0; i < m_cXV; ++i) mBound |= m[6][0:1];		   
	if (m_cD != 0)		mBound |= m[7][0:1]; 
	if (m_cFilter != 10) 
	{ 
		if (m_cP != 0) 
		{ 
			for (i=0; i < m_cP; ++i)
			{
				if (m_cEgarch != 1)  mBound |= m[8][0:1];
				else 				 mBound |= <-100,100>; 
			}
		} 
	} 
	if (m_cQ != 0)	 
	{ 
		for (i=0; i < m_cQ; ++i)
		{
			if (m_cEgarch != 1)  mBound |= m[9][0:1];
			else 				 mBound |= <-100,100>; 
		}
	} 
	if (m_cGJR)			for (i=0; i < m_cQ; ++i) mBound |= m[10][0:1]; 
	if (m_cEgarch)		mBound |= m[11][0:1]; 
	if (m_cEgarch)		mBound |= m[12][0:1]; 
	if (m_cAparch)		for (i=0; i < m_cQ; ++i) mBound |= m[13][0:1]; 
	if (m_cAparch)		mBound |= m[14][0:1];
	//eddig

//en irtam
	//innen
	if (m_cNMGJR)			for (i=0; i < m_cQ; ++i) mBound |= m[10][0:1];
	if (m_cNMAGARCH)		for (i=0; i < m_cQ; ++i) mBound |= m[10][0:1]; 
	//eddig
	
	if (m_cSk != 0)		mBound |= m[15][0:1]; 
   	if ((m_cDist != 2)&&(m_cKu != 0))	mBound |= m[16][0:1];				  
	else if	((m_cDist == 2)&&(m_cKu != 0)) mBound |= m[17][0:1]; 
	if (m_cHY != 0)     mBound |= m[18][0:1];                         
	if (m_c_in_mean != 0) mBound |= m[19][0:1];
	

//En irtam
	//innen
	if ((m_cDist == 4)  ||   (m_cDist == 5))
	{
		if (m_cVar != 0)	mBound |= m[20][0:1]; 
 		if (m_cXV != 0) 	for (i=0; i < m_cXV; ++i) mBound |= m[21][0:1];		   
		if (m_cD != 0)		mBound |= m[22][0:1]; 
		if (m_cFilter != 10) 
		{ 
			if (m_cP != 0) 
			{ 
				for (i=0; i < m_cP; ++i)
				{
					if (m_cEgarch != 1)  mBound |= m[23][0:1];
					else 				 mBound |= <-100,100>; 
				}
			} 
		} 
		if (m_cQ != 0)	 
		{ 
			for (i=0; i < m_cQ; ++i)
			{
				if (m_cEgarch != 1)  mBound |= m[24][0:1];
				else 				 mBound |= <-100,100>; 
			}
		} 
		if (m_cGJR)			for (i=0; i < m_cQ; ++i) mBound |= m[25][0:1]; 
		if (m_cEgarch)		mBound |= m[26][0:1]; 
		if (m_cEgarch)		mBound |= m[27][0:1]; 
		if (m_cAparch)		for (i=0; i < m_cQ; ++i) mBound |= m[28][0:1]; 
		if (m_cAparch)		mBound |= m[29][0:1];
		if (m_cNMGJR)			for (i=0; i < m_cQ; ++i) mBound |= m[25][0:1];
		if (m_cNMAGARCH)		for (i=0; i < m_cQ; ++i) mBound |= m[25][0:1]; 
		mBound |= m[30][0:1];
		mBound |= m[31][0:1];
	}

	if (m_cDist == 5)
	{
		if (m_cVar != 0)	mBound |= m[32][0:1]; 
 		if (m_cXV != 0) 	for (i=0; i < m_cXV; ++i) mBound |= m[33][0:1];		   
		if (m_cD != 0)		mBound |= m[34][0:1]; 
		if (m_cFilter != 10) 
		{ 
			if (m_cP != 0) 
			{ 
				for (i=0; i < m_cP; ++i)
				{
					if (m_cEgarch != 1)  mBound |= m[35][0:1];
					else 				 mBound |= <-100,100>; 
				}
			} 
		} 
		if (m_cQ != 0)	 
		{ 
			for (i=0; i < m_cQ; ++i)
			{
				if (m_cEgarch != 1)  mBound |= m[36][0:1];
				else 				 mBound |= <-100,100>; 
			}
		} 
		if (m_cGJR)			for (i=0; i < m_cQ; ++i) mBound |= m[37][0:1]; 
		if (m_cEgarch)		mBound |= m[38][0:1]; 
		if (m_cEgarch)		mBound |= m[39][0:1]; 
		if (m_cAparch)		for (i=0; i < m_cQ; ++i) mBound |= m[40][0:1]; 
		if (m_cAparch)		mBound |= m[41][0:1];
		if (m_cNMGJR)			for (i=0; i < m_cQ; ++i) mBound |= m[37][0:1];
		if (m_cNMAGARCH)		for (i=0; i < m_cQ; ++i) mBound |= m[37][0:1]; 
		mBound |= m[42][0:1];
		mBound |= m[43][0:1];
	}
	//eddig

	m_mBound = mBound[1:][];

	if (m_cFix==1)
		m_mBound=selectifr(m_mBound,1-m_vFix);	// 304 Select the bounds of the free parameters
	 
	return 1;				 	 
} 
 
Garch::InitData() 
{ 
	m_iT1est = m_iT1sel; 
	m_iT2est = m_iT2sel; 
 
    m_vY = GetGroup(Y_VAR);
    if (m_vY == <>) 
    {   println("Please select the Y variable"); 
        return FALSE; 
    } 
	m_vY = m_vY[][0];
    m_cY = columns(m_vY); 

    if (m_cY != 1) 
    {   println("Only univariate models allowed"); 
        return FALSE; 
    } 
	
	m_mXM = GetGroup(X_VAR); 
    m_cXM = columns(m_mXM); 
 
	m_mXV = GetGroup(Z_VAR);    
    m_cXV = columns(m_mXV); 
 
	m_vOV = GetGroup(O_VAR); 
	m_cOV = columns(m_vOV); 

	if (m_cOV > 1) 
    {   println("Only one realized volatility series allowed"); 
        return FALSE; 
    }
	
	m_cT = m_iT2est - m_iT1est + 1; 

	GetNbPar();
 
	if (m_cT <= m_cPar)		    
    { 
	    println("Only ", m_cT, " observations. This is not enough."); 
        return FALSE; 
	} 


	decl prbl=(fabs(m_vY) .< 0.05);
	if ( meanc( prbl ) > 0.6)
	{
		m_cYsmall=4;			
	}
	
	return 1;			  
}

Garch::SetStartValue(const name, const stval)
/*    
**  Purpose: If the user wants to use a different starting value than the default one
**			     
**  Input  :  	name : string, name of the variable (cfr. mgarch.h)
**				stval : desired starting value (different types: cst, vector, matrix) 
**                
**  Output : 1 if 'stval' has a correct dimension.    
*/  
{
	if (CheckValue(name, stval))
	{
		if (name == "m_clevel") 		m_clevel = stval;
		else if (name == "m_cFilter") 	m_cFilter = stval;
		else if (name == "m_vbetam")  	m_vbetam = stval;
		else if (name == "m_vAR") 		m_vAR = stval;
		else if (name == "m_vMA") 	 	m_vMA = stval;
		else if (name == "m_dARFI") 	m_dARFI = stval;
		//innen
 	 	else if (name == "m_calpha0")	m_calpha0 = stval;
		else if (name == "m_vpsyv")		m_vpsyv = stval;
		else if (name == "m_dD")		m_dD = stval;
		else if (name == "m_vbetav")	m_vbetav = stval;
		else if (name == "m_valphav")	m_valphav = stval;
		else if (name == "m_vleverage")	m_vleverage = stval;
		else if (name == "m_vtheta1")	m_vtheta1 = stval;
		else if (name == "m_vtheta2")	m_vtheta2 = stval;
		else if (name == "m_vgamma")	m_vgamma = stval;
		else if (name == "m_ddelta")	m_ddelta = stval;
		//eddig		
		else if (name == "m_vHY")		m_vHY = stval;
		else if (name == "m_cA") 		m_cA = stval;
		else if (name == "m_cV") 		m_cV = stval;
		else if (name == "m_v_in_mean") m_v_in_mean = stval;

//En irtam
		//innen
 	 	else if (name == "m_calpha0_2")	m_calpha0_2 = stval;
		else if (name == "m_vpsyv_2")	m_vpsyv_2 = stval;
		else if (name == "m_dD_2")		m_dD_2 = stval;
		else if (name == "m_vbetav_2")	m_vbetav_2 = stval;
		else if (name == "m_valphav_2")	m_valphav_2 = stval;
		else if (name == "m_vleverage_2") m_vleverage_2 = stval;
		else if (name == "m_vtheta1_2")	m_vtheta1_2 = stval;
		else if (name == "m_vtheta2_2")	m_vtheta2_2 = stval;
		else if (name == "m_vgamma_2")	m_vgamma_2 = stval;
		else if (name == "m_ddelta_2")	m_ddelta_2 = stval;
		else if (name == "m_p1")		m_p1 = stval;
		else if (name == "m_mu1")		m_mu1 = stval;

		else if (name == "m_calpha0_3")	m_calpha0_3 = stval;
		else if (name == "m_vpsyv_3")	m_vpsyv_3 = stval;
		else if (name == "m_dD_3")		m_dD_3 = stval;
		else if (name == "m_vbetav_3")	m_vbetav_3 = stval;
		else if (name == "m_valphav_3")	m_valphav_3 = stval;
		else if (name == "m_vleverage_3") m_vleverage_3 = stval;
		else if (name == "m_vtheta1_3")	m_vtheta1_3 = stval;
		else if (name == "m_vtheta2_3")	m_vtheta2_3 = stval;
		else if (name == "m_vgamma_3")	m_vgamma_3 = stval;
		else if (name == "m_ddelta_3")	m_ddelta_3 = stval;
		else if (name == "m_p2")		m_p2 = stval;
		else if (name == "m_mu2")		m_mu2 = stval;
		
		//eddig	
	}
	return 1;   
}

Garch::CheckValue(const name, const value)
/*    
**  Purpose: Allows to check if "value" corresponds to the correct form of the variable "name" (size, types, ...)    
**			     
**  Input  :  	name : string, name of the variable (cfr. mgarch.h)
**				value : value to be checked (different types: cst, vector, matrix) 
**                
**  Output : 1 if 'value' has the form corresponding to the variable 'name'.    
*/  
{
	decl check = 0;	
	decl c, r, i;
	
	InitData();
	
    if (name == "m_clevel")			check = (m_cMean == 1 ? isdouble(value) == 1 ? 1 : isint(value) == 1 ? 1 : 0 : 0);
	else if (name == "m_vbetam")  	check = (m_cXM > 0 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cXM ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vAR")  		check = (m_cAR > 0 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cAR ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vMA")		check = (m_cMA > 0 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cMA ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_dARFI")		check = (m_cARFI == 1 ? isdouble(value) == 1 ? value <= 1 ? value >= 0 ? 1 : 0 : 0 : isint(value) == 1 ? value <= 1 ? value >= 0 ? 1 : 0 : 0 : 0 : 0);
	//innen
	else if (name == "m_calpha0")	check = (m_cVar == 1 ? isdouble(value) == 1 ? 1 : isint(value) == 1 ? 1 : 0 : 0);
	else if (name == "m_vpsyv")		check = (m_cXV > 0 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cXV ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_dD")		check = (m_cD == 1 ? isdouble(value) == 1 ? value <= 1 ? value >= 0 ? 1 : 0 : 0 : isint(value) == 1 ? value <= 1 ? value >= 0 ? 0 : 0 : 0 : 0 : 0);
	else if (name == "m_vbetav")	check = (m_cP > 0 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cP ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_valphav")	check = (m_cQ > 0 ? ismatrix(value) == 1 ? columns(value) == 1 ?  rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vleverage")	check = (m_cGJR + m_cNMGJR + m_cNMAGARCH == 1 ? ismatrix(value) == 1 ?  columns(value) == 1 ? rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vtheta1")	check = (m_cEgarch == 1 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vtheta2")	check = (m_cEgarch == 1 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vgamma")	check = (m_cAparch == 1 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_ddelta")	check = (m_cAparch == 1 ? isdouble(value) == 1 ? 1 : isint(value) == 1 ? 1 : 0 : 0);
	//eddig
	else if (name == "m_vHY")		check = (m_cHY == 1 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == 2 ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_cA") 		check = (m_cSk == 1 ? isdouble(value) == 1 ? 1 : isint(value) == 1 ? 1 : 0 : 0);
	else if (name == "m_cV") 		check = (m_cKu == 1 ? isdouble(value) == 1 ? 1 : isint(value) == 1 ? 1 : 0 : 0);
	else if (name == "m_v_in_mean") check = (m_c_in_mean > 0 ? isdouble(value) == 1 ? 1 : isint(value) == 1 ? 1 : 0 : 0);

//En irtam
	//innen
	else if (name == "m_calpha0_2")	check = (m_cVar == 1 ? isdouble(value) == 1 ? 1 : isint(value) == 1 ? 1 : 0 : 0);
	else if (name == "m_vpsyv_2")	check = (m_cXV > 0 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cXV ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_dD_2")		check = (m_cD == 1 ? isdouble(value) == 1 ? value <= 1 ? value >= 0 ? 1 : 0 : 0 : isint(value) == 1 ? value <= 1 ? value >= 0 ? 0 : 0 : 0 : 0 : 0);
	else if (name == "m_vbetav_2")	check = (m_cP > 0 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cP ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_valphav_2")	check = (m_cQ > 0 ? ismatrix(value) == 1 ? columns(value) == 1 ?  rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vleverage_2") check = (m_cGJR + m_cNMGJR + m_cNMAGARCH == 1 ? ismatrix(value) == 1 ?  columns(value) == 1 ? rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vtheta1_2")	check = (m_cEgarch == 1 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vtheta2_2")	check = (m_cEgarch == 1 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vgamma_2")	check = (m_cAparch == 1 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_ddelta_2")	check = (m_cAparch == 1 ? isdouble(value) == 1 ? 1 : isint(value) == 1 ? 1 : 0 : 0);

	else if (name == "m_calpha0_3")	check = (m_cVar == 1 ? isdouble(value) == 1 ? 1 : isint(value) == 1 ? 1 : 0 : 0);
	else if (name == "m_vpsyv_3")	check = (m_cXV > 0 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cXV ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_dD_3")		check = (m_cD == 1 ? isdouble(value) == 1 ? value <= 1 ? value >= 0 ? 1 : 0 : 0 : isint(value) == 1 ? value <= 1 ? value >= 0 ? 0 : 0 : 0 : 0 : 0);
	else if (name == "m_vbetav_3")	check = (m_cP > 0 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cP ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_valphav_3")	check = (m_cQ > 0 ? ismatrix(value) == 1 ? columns(value) == 1 ?  rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vleverage_3") check = (m_cGJR + m_cNMGJR + m_cNMAGARCH == 1 ? ismatrix(value) == 1 ?  columns(value) == 1 ? rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vtheta1_3")	check = (m_cEgarch == 1 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vtheta2_3")	check = (m_cEgarch == 1 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_vgamma_3")	check = (m_cAparch == 1 ? ismatrix(value) == 1 ? columns(value) == 1 ? rows(value) == m_cQ ? 1 : 0 : 0 : 0 : 0);
	else if (name == "m_ddelta_3")	check = (m_cAparch == 1 ? isdouble(value) == 1 ? 1 : isint(value) == 1 ? 1 : 0 : 0);
	//eddig

	return check;   
}														 															 

Garch::PrintStartValues(const p)
{
  decl dfunc;
  decl Pnames = GetParNames();

  FigLL(m_vPar, &dfunc, 0, TRUE)	;

  if (p!=0)
  {
	  println("-------------------------------------");
	  println("Starting Values");
	  println("===============");
  }	
  if (p == 1)
  {
	decl i;
	println("Parameter", "%18s", "Value");
	for (i = 0; i < m_cPar; ++i)	println("%-17s", Pnames[i], "%#12.6f", m_vPar[i][0]);
  }
  else if (p == 2)
  {
	if (m_cMean > 0) println("m_clevel :", m_clevel);
	if (m_cXM > 0) println("m_vbetam :", m_vbetam);
	if (m_cARFI > 0) println("m_dARFI :", m_dARFI);
	if (m_cAR > 0) println("m_vAR :", m_vAR);
	if (m_cMA > 0) println("m_vMA :", m_vMA);
	//innen
	if (m_cVar > 0) println("m_calpha0 :", m_calpha0);
	if (m_cXV > 0) println("m_vpsyv :", m_vpsyv);
	if (m_cD > 0) println("m_dD", m_dD);
	if (m_cQ > 0) println("m_valphav :", m_valphav);
	if (m_cP > 0) println("m_vbetav :", m_vbetav);
	if ((m_cFilter == 3) || (m_cFilter == 112) || (m_cFilter == 113))  println("m_vleverage :", m_vleverage[0]);
	if (m_cEgarch > 0) println("m_vtheta1 :", m_vtheta1);
	if (m_cEgarch > 0) println("m_vtheta2 :", m_vtheta2);
	if (m_cAparch > 0) println("m_vgamma :", m_vgamma);
	if (m_cAparch > 0) println("m_ddelta :", m_ddelta);
	//eddig
	if (m_cSk > 0) println("m_cA :", m_cA);
	if (m_cKu > 0)println("m_cV :", m_cV);
	if (m_cHY > 0) println("m_vHY :", m_vHY);
	if (m_c_in_mean > 0) println("m_v_in_mean :", m_v_in_mean);

//En irtam
	//innen
	if ((m_cDist == 4)	|| (m_cDist == 5))
	{
		if (m_cVar > 0) println("m_calpha0_2 :", m_calpha0_2);
		if (m_cXV > 0) println("m_vpsyv_2 :", m_vpsyv_2);
		if (m_cD > 0) println("m_dD_2", m_dD_2);
		if (m_cQ > 0) println("m_valphav_2 :", m_valphav_2);
		if (m_cP > 0) println("m_vbetav_2 :", m_vbetav_2);
		if ((m_cFilter == 3) || (m_cFilter == 112) || (m_cFilter == 113)) println("m_vleverage_2 :", m_vleverage_2[0]);
		if (m_cEgarch > 0) println("m_vtheta1_2 :", m_vtheta1_2);
		if (m_cEgarch > 0) println("m_vtheta2_2 :", m_vtheta2_2);
		if (m_cAparch > 0) println("m_vgamma_2 :", m_vgamma_2);
		if (m_cAparch > 0) println("m_ddelta_2 :", m_ddelta_2);
		println("m_p1 :", m_p1);
		println("m_mu1 :", m_mu1);
	}

	if (m_cDist == 5)
	{
		if (m_cVar > 0) println("m_calpha0_3 :", m_calpha0_3);
		if (m_cXV > 0) println("m_vpsyv_3 :", m_vpsyv_3);
		if (m_cD > 0) println("m_dD_3", m_dD_3);
		if (m_cQ > 0) println("m_valphav_3 :", m_valphav_3);
		if (m_cP > 0) println("m_vbetav_3 :", m_vbetav_3);
		if ((m_cFilter == 3) || (m_cFilter == 112) || (m_cFilter == 113)) println("m_vleverage_3 :", m_vleverage_3[0]);
		if (m_cEgarch > 0) println("m_vtheta1_3 :", m_vtheta1_3);
		if (m_cEgarch > 0) println("m_vtheta2_3 :", m_vtheta2_3);
		if (m_cAparch > 0) println("m_vgamma_3 :", m_vgamma_3);
		if (m_cAparch > 0) println("m_ddelta_3 :", m_ddelta_3);
		println("m_p2 :", m_p2);
		println("m_mu2 :", m_mu2);
	}
	//eddig
  }
  else if (p == 3)
  {
	if (m_cMean > 0) MatrixToString("m_clevel", m_clevel, 0);
	if (m_cXM > 0) MatrixToString("m_vbetam", m_vbetam, 1);
	if (m_cARFI > 0) MatrixToString("m_dARFI", m_dARFI, 0);
	if (m_cAR > 0) MatrixToString("m_vAR", m_vAR, 1);
	if (m_cMA > 0) MatrixToString("m_vMA", m_vMA, 1);
	//innen
	if (m_cVar > 0) MatrixToString("m_calpha0", m_calpha0, 0);
	if (m_cXV > 0) MatrixToString("m_vpsyv", m_vpsyv, 1);
	if (m_cD > 0) MatrixToString("m_dD", m_dD, 0);
	if (m_cQ > 0) MatrixToString("m_valphav", m_valphav, 1);
	if (m_cP > 0) MatrixToString("m_vbetav", m_vbetav, 1);
	if ((m_cFilter == 3) || (m_cFilter == 112) || (m_cFilter == 113)) MatrixToString("m_vleverage", m_vleverage, 1);
	if (m_cEgarch > 0) MatrixToString("m_vtheta1", m_vtheta1, 1);
	if (m_cEgarch > 0) MatrixToString("m_vtheta2", m_vtheta2, 1);
	if (m_cAparch > 0) MatrixToString("m_vgamma", m_vgamma, 1);
	if (m_cAparch > 0) MatrixToString("m_ddelta", m_ddelta, 0);
	//eddig
	if (m_cSk > 0) MatrixToString("m_cA", m_cA, 0);
	if (m_cKu > 0)MatrixToString("m_cV", m_cV, 0);
	if (m_cHY > 0) MatrixToString("m_vHY", m_vHY, 1);	  
	if (m_c_in_mean > 0) MatrixToString("m_v_in_mean", m_v_in_mean, 0);

//En irtam
	//innen
	if ((m_cDist == 4) || (m_cDist == 5))
	{
		if (m_cVar > 0) MatrixToString("m_calpha0_2", m_calpha0_2, 0);
		if (m_cXV > 0) MatrixToString("m_vpsyv_2", m_vpsyv_2, 1);
		if (m_cD > 0) MatrixToString("m_dD_2", m_dD_2, 0);
		if (m_cQ > 0) MatrixToString("m_valphav_2", m_valphav_2, 1);
		if (m_cP > 0) MatrixToString("m_vbetav_2", m_vbetav_2, 1);
		if ((m_cFilter == 3) || (m_cFilter == 112) || (m_cFilter == 113)) MatrixToString("m_vleverage_2", m_vleverage_2, 1);
		if (m_cEgarch > 0) MatrixToString("m_vtheta1_2", m_vtheta1_2, 1);
		if (m_cEgarch > 0) MatrixToString("m_vtheta2_2", m_vtheta2_2, 1);
		if (m_cAparch > 0) MatrixToString("m_vgamma_2", m_vgamma_2, 1);
		if (m_cAparch > 0) MatrixToString("m_ddelta_2", m_ddelta_2, 0);
		MatrixToString("m_p1", m_p1, 0);
		MatrixToString("m_mu1", m_mu1, 0);
	}

	if (m_cDist == 5)
	{
		if (m_cVar > 0) MatrixToString("m_calpha0_3", m_calpha0_3, 0);
		if (m_cXV > 0) MatrixToString("m_vpsyv_3", m_vpsyv_3, 1);
		if (m_cD > 0) MatrixToString("m_dD_3", m_dD_3, 0);
		if (m_cQ > 0) MatrixToString("m_valphav_3", m_valphav_3, 1);
		if (m_cP > 0) MatrixToString("m_vbetav_3", m_vbetav_3, 1);
		if ((m_cFilter == 3) || (m_cFilter == 112) || (m_cFilter == 113)) MatrixToString("m_vleverage_3", m_vleverage_3, 1);
		if (m_cEgarch > 0) MatrixToString("m_vtheta1_3", m_vtheta1_3, 1);
		if (m_cEgarch > 0) MatrixToString("m_vtheta2_3", m_vtheta2_3, 1);
		if (m_cAparch > 0) MatrixToString("m_vgamma_3", m_vgamma_3, 1);
		if (m_cAparch > 0) MatrixToString("m_ddelta_3", m_ddelta_3, 0);
		MatrixToString("m_p2", m_p2, 0);
		MatrixToString("m_mu2", m_mu2, 0);
	}
	//eddig
  }

  if (p!=0)
  {
	  GetPara();
	  exit(0);
  }
  return 1;
}

Garch::MatrixToString(const name_matrix, const val, const format)
{
        decl str;
        if (format==0)  // scalar				 
        {
                str=sprint(val);
        }
		else if (format==1)  // column Vector				 
        {
                str=sprint("<",val[0][0]);
                for (decl i=1; i < rows(val); ++i)      	str ~= sprint(";",val[i][0]);              
                str ~= sprint(">");
        }
        else if (format==2)  // k*k matrix				 
        {
				str=sprint("<");
				for (decl i=0; i < rows(val)-1; ++i)
				{
					str ~= sprint(val[i][0]);
					for (decl j=1; j < columns(val); ++j) 	str ~= sprint(",", val[i][j]);
					str ~= sprint(";");
				}
				str ~= sprint(val[(rows(val)-1)][0]);
				for (decl j=1; j < columns(val); ++j) 		str ~= sprint(",", val[(rows(val)-1)][j]);
				str ~= sprint(">");
        }

        print("object.SetStartValue(\"", name_matrix,"\",");
        println(str,");");
		
        return 1;
}

 
/*-------------------------///////////////////------------------------------*/ 
/*------------------------// DATA HANDLING //-------------------------------*/ 
/*-----------------------///////////////////--------------------------------*/ 

Garch::GetYNames() 
{ 
	decl asy = {}; 
	GetGroupNames(Y_VAR, &asy); 	 
	return asy; 
} 
 
Garch::GetXNames() 
{ 
	decl i, asx = {}; 
	// X variables (if any) 
	GetGroupLagNames(X_VAR, 0, 10000, &asx); 
	for (i = 0; i < sizeof(asx); ++i) 	 asx[i] ~= " (M)"; 

	return asx; 
} 
 
Garch::GetZNames() 
{ 
	decl i, asz = {}; 
	GetGroupLagNames(Z_VAR, 0, 10000, &asz); 
	for (i = 0; i < sizeof(asz); ++i) 	 asz[i] ~= " (V)"; 

	return asz; 
} 
 
Garch::GetINames() 
{ 
	decl i, asi = {}; 
	GetGroupLagNames(O_VAR, 0, 10000, &asi); 

	return asi; 
} 

Garch::GetParNames() 
{ 
	decl i, asp = {}; 
 
// Rappel : m_vPar = m_clevel | m_vbetam |  m_dARFI | m_vAR | m_vMA | m_calpha0 | m_vpsyv | m_dD |  m_vbetav | m_valphav | m_vleverage | m_vtheta1 | m_vtheta2 | m_vgamma | m_ddelta | m_cA | m_cV | m_vHY 
 
	if (m_cMean != 0)	asp |= sprint("Cst(M)"); 
	if (m_cXM != 0)		for (i=0; i < m_cXM; ++i)		asp |= sprint(GetXNames()[i]); 
	if (m_cARFI != 0) 	asp |= sprint("d-Arfima"); 
	if (m_cAR != 0)	  	for (i=0; i < m_cAR; ++i)		asp |= sprint("AR(",i+1,")"); 
	if (m_cMA != 0)	   	for (i=0; i < m_cMA; ++i)	 	asp |= sprint("MA(",i+1,")"); 
	//innen
	if (m_cVar != 0)  	asp |= sprint("Cst(V)"); 
	if (m_cXV != 0)		for (i=0; i < m_cXV; ++i)		asp |= sprint(GetZNames()[i]); 
	if (m_cD != 0)	  	asp |= sprint("d-Figarch"); 
	if (m_cQ != 0)		for (i=0; i < m_cQ; ++i)	 	 			asp |= sprint("ARCH(Alpha",i+1,")"); 	 

	if (m_cP != 0) 
	{ 
		if (m_cFilter != 10)  	for (i=0; i < m_cP; ++i)	 		asp |= sprint("GARCH(Beta",i+1,")"); 
		else					for (i=0; i < m_cP-1; ++i)   		asp |= sprint("GARCH(Beta",i+2,")"); 
	} 
 
	if (m_cGJR != 0)	for (i=0; i < sizer(m_vleverage); ++i)	  	asp |= sprint("GJR(Gamma",i+1,")"); 
 
	if (m_cEgarch != 0) 
	{ 
		asp |= sprint("EGARCH(Theta1)"); 
		asp |= sprint("EGARCH(Theta2)"); 
	} 
 
	if (m_cAparch != 0) 
	{ 
		if (m_cQ != 0) 	for (i=0; i < sizer(m_vgamma); ++i)		asp |= sprint("APARCH(Gamma",i+1,")"); 
		asp |= sprint("APARCH(Delta)"); 
	}

	if (m_cNMGJR != 0)	for (i=0; i < sizer(m_vleverage); ++i)	  	asp |= sprint("NMGJR(Gamma",i+1,")");

	if (m_cNMAGARCH != 0)	for (i=0; i < sizer(m_vleverage); ++i)	  	asp |= sprint("NMAGARCH(Gamma",i+1,")");
	//eddig
	 
	if (m_cDist == 1)	asp |= sprint("Student(DF)"); 
	if (m_cDist == 2)	asp |= sprint("G.E.D.(DF)"); 
	if (m_cDist == 3) 
	{ 
		asp |= sprint("Asymmetry");  
		asp |= sprint("Tail");  
	} 
 
	if (m_cHY == 1)    	asp |= sprint("Log Alpha (HY)");  

	if (m_c_in_mean  == 1)	asp |= sprint("ARCH-in-mean(var)");  
	if (m_c_in_mean  == 2)	asp |= sprint("ARCH-in-mean(std)");

//En irtam	
	//innen
	if ((m_cDist == 4) || (m_cDist == 5))
	{
		if (m_cVar != 0)  	asp |= sprint("Cst(V)_2"); 
		if (m_cXV != 0)		for (i=0; i < m_cXV; ++i)		asp |= sprint(GetZNames()[i]); 
		if (m_cD != 0)	  	asp |= sprint("d-Figarch_2"); 
		if (m_cQ != 0)		for (i=0; i < m_cQ; ++i)	 	 			asp |= sprint("ARCH(Alpha",i+1,")_2"); 	 

		if (m_cP != 0) 
		{ 
			if (m_cFilter != 10)  	for (i=0; i < m_cP; ++i)	 		asp |= sprint("GARCH(Beta",i+1,")_2"); 
			else					for (i=0; i < m_cP-1; ++i)   		asp |= sprint("GARCH(Beta",i+2,")_2"); 
		} 
 
		//if (m_cGJR != 0)	for (i=0; i < sizer(m_vleverage); ++i)	  	asp |= sprint("GJR(Gamma",i+1,")_2"); 
 
		if (m_cEgarch != 0) 
		{ 
			asp |= sprint("EGARCH(Theta1)_2"); 
			asp |= sprint("EGARCH(Theta2)_2"); 
		} 
 
		if (m_cAparch != 0) 
		{ 
			if (m_cQ != 0) 	for (i=0; i < sizer(m_vgamma); ++i)		asp |= sprint("APARCH(Gamma",i+1,")_2"); 
			asp |= sprint("APARCH(Delta)_2"); 
		}

		if (m_cNMGJR != 0)	for (i=0; i < sizer(m_vleverage); ++i)	  	asp |= sprint("NMGJR(Gamma",i+1,")_2");

		if (m_cNMAGARCH != 0)	for (i=0; i < sizer(m_vleverage); ++i)	  	asp |= sprint("NMAGARCH(Gamma",i+1,")_2");
		
		asp |= sprint("p1");
		asp |= sprint("mu1");
	}

	if (m_cDist == 5)
	{
		if (m_cVar != 0)  	asp |= sprint("Cst(V)_3"); 
		if (m_cXV != 0)		for (i=0; i < m_cXV; ++i)		asp |= sprint(GetZNames()[i]); 
		if (m_cD != 0)	  	asp |= sprint("d-Figarch_3"); 
		if (m_cQ != 0)		for (i=0; i < m_cQ; ++i)	 	 			asp |= sprint("ARCH(Alpha",i+1,")_3"); 	 

		if (m_cP != 0) 
		{ 
			if (m_cFilter != 10)  	for (i=0; i < m_cP; ++i)	 		asp |= sprint("GARCH(Beta",i+1,")_3"); 
			else					for (i=0; i < m_cP-1; ++i)   		asp |= sprint("GARCH(Beta",i+2,")_3"); 
		} 
 
		//if (m_cGJR != 0)	for (i=0; i < sizer(m_vleverage); ++i)	  	asp |= sprint("GJR(Gamma",i+1,")_3"); 
 
		if (m_cEgarch != 0) 
		{ 
			asp |= sprint("EGARCH(Theta1)_3"); 
			asp |= sprint("EGARCH(Theta2)_3"); 
		} 
 
		if (m_cAparch != 0) 
		{ 
			if (m_cQ != 0) 	for (i=0; i < sizer(m_vgamma); ++i)		asp |= sprint("APARCH(Gamma",i+1,")_3"); 
			asp |= sprint("APARCH(Delta)_3"); 
		}

		if (m_cNMGJR != 0)	for (i=0; i < sizer(m_vleverage); ++i)	  	asp |= sprint("NMGJR(Gamma",i+1,")_3");

		if (m_cNMAGARCH != 0)	for (i=0; i < sizer(m_vleverage); ++i)	  	asp |= sprint("NMAGARCH(Gamma",i+1,")_3");
		
		asp |= sprint("p2");
		asp |= sprint("mu2");
	}
	//eddig
	
	return asp; 
} 

Garch::PAR()								 
{ 
  decl estpar, j; 
  estpar = (m_vPar)~(m_vStdErrors)'~(m_vPar./(m_vStdErrors)'); 
  return  estpar; 
}

Garch::GetValue(const name)   
/*    
**  Purpose: Returns the value of a variable      
**			     
**  Input  : name = string, the exact name of the wanted variable
**                
**  Output : the value associated with the variable "name"   
*/ 
{   
    decl value;

	if (name == "m_dLL")  			value = m_dLL;	   	
	else if (name == "m_vE")		value = m_vE;
	else if (name == "m_vE2")  	    value = m_vE2;
	else if (name == "m_vSigma2")	value = m_vSigma2;
	else if (name == "m_vGrad")  	value = m_vGrad;
	else if (name == "m_vStdErrors")value = m_vStdErrors;
	else if (name == "m_mCovar") 	value = m_mCovar;
	else if (name == "m_cT")  		value = m_cT;
	else if (name == "m_cPar")		value = m_cPar;
	else if (name == "m_vPar")  	value = m_vPar;
	else if (name == "m_cFilter") 	value = m_cFilter;
	else if (name == "m_clevel")	value = m_clevel;
	else if (name == "m_vbetam")  	value = m_vbetam;
	else if (name == "m_vAR")		value = m_vAR;
	else if (name == "m_vMA")  		value = m_vMA;
	else if (name == "m_dARFI")		value = m_dARFI;
	//innen
	else if (name == "m_calpha0")  	value = m_calpha0;
	else if (name == "m_vpsyv")  	value = m_vpsyv;
	else if (name == "m_dD")  		value = m_dD;	
	else if (name == "m_valphav") 	value = m_valphav;
	else if (name == "m_vbetav")  	value = m_vbetav;
	else if (name == "m_vleverage") value = m_vleverage;
	else if (name == "m_vtheta1") 	value = m_vtheta1;
	else if (name == "m_vtheta2")  	value = m_vtheta2;
	else if (name == "m_vgamma")  	value = m_vgamma;
	else if (name == "m_ddelta") 	value = m_ddelta;
	//eddig
	else if (name == "m_vHY") 		value = m_vHY;
	else if (name == "m_cDist")  	value = m_cDist;
	else if (name == "m_cA") 		value = m_cA;
	else if (name == "m_cV") 		value = m_cV;
	else if (name == "m_cd") 		value = m_cd;
	//else if (name == "m_cdf")  		value = m_cdf;
	else if (name == "m_cTforc") 	value = m_cTforc;
	else if (name == "m_mForc")  	value = m_mForc;
	else if (name == "m_forYerror") value = m_forYerror;
	else if (name == "m_Yfor") 		value = m_Yfor;
	else if (name == "m_Hfor") 		value = m_Hfor;
	else if (name == "m_v_in_mean") value = m_v_in_mean;

//En irtam
	else if (name == "m_vSigma2_1")	value = m_vSigma2_1;
	else if (name == "m_vSigma2_2")	value = m_vSigma2_2;
	else if (name == "m_vSigma2_3")	value = m_vSigma2_3;
	//innen
	else if (name == "m_calpha0_2") value = m_calpha0_2;
	else if (name == "m_vpsyv_2")  	value = m_vpsyv_2;
	else if (name == "m_dD_2")  	value = m_dD_2;	
	else if (name == "m_valphav_2") value = m_valphav_2;
	else if (name == "m_vbetav_2")  value = m_vbetav_2;
	else if (name == "m_vleverage_2") value = m_vleverage_2;
	else if (name == "m_vtheta1_2") value = m_vtheta1_2;
	else if (name == "m_vtheta2_2") value = m_vtheta2_2;
	else if (name == "m_vgamma_2")  value = m_vgamma_2;
	else if (name == "m_ddelta_2") 	value = m_ddelta_2;

	else if (name == "m_calpha0_3") value = m_calpha0_3;
	else if (name == "m_vpsyv_3")  	value = m_vpsyv_3;
	else if (name == "m_dD_3")  	value = m_dD_3;	
	else if (name == "m_valphav_3") value = m_valphav_3;
	else if (name == "m_vbetav_3")  value = m_vbetav_3;
	else if (name == "m_vleverage_3") value = m_vleverage_3;
	else if (name == "m_vtheta1_3") value = m_vtheta1_3;
	else if (name == "m_vtheta2_3") value = m_vtheta2_3;
	else if (name == "m_vgamma_3")  value = m_vgamma_3;
	else if (name == "m_ddelta_3") 	value = m_ddelta_3;
	
	else if (name == "m_p1") 		value = m_p1;
	else if (name == "m_p2") 		value = m_p2;
	else if (name == "m_p3") 		value = m_p3;
	else if (name == "m_mu1") 		value = m_mu1;
	else if (name == "m_mu2") 		value = m_mu2;
	else if (name == "m_mu3") 		value = m_mu3;
	//eddig
		
	return value;   
}
		
Garch::GetXBetaForc(const cTforc) 
{ 
	decl mxf = GetForcData(X_VAR, cTforc); 
	if (sizer(mxf)) 
		return mxf;					 
	else 
		return <>; 
} 
 
Garch::GetZBetaForc(const cTforc) 
{ 
	decl mxf = GetForcData(Z_VAR, cTforc); 
	if (sizer(mxf)) 
		return mxf;					 
	else 
		return <>; 
} 
Garch::GetForcData(const iGroup, const cTforc) 
{ 
	decl mx, t1x, t1, t2, cx; 
	decl t2selsave = m_iT2sel;					   /* save selection sample */ 
	 
    m_iT2sel = rows(m_mData) - 1;		 /* full sample to get whole series */ 
	if (iGroup == Y_VAR) 
    	mx = GetGroupLag(Y_VAR, 0, 0); 
	else if (iGroup == X_VAR) 
    	mx = GetGroupLag(Y_VAR, 1, 100) ~ GetGroup(iGroup); 
	else 
    	mx = GetGroup(iGroup);		 
	m_iT2sel = t2selsave; 						  /* reset selection sample */ 
	 
	t1x = t1 = m_iT2est + 1 - m_iT1sel; 
	t2 = min(sizer(mx) + m_iT1sel - m_iT1est - 1, t1 + cTforc - 1); 
	cx = columns(mx); 
	 
	if (cx == 0 || t2 < t1)						 /* no post-estimation data */ 
		return <>; 
 
    findsample(mx, range(0, cx-1), zeros(1, cx), t1, t2, DB_MISVAL, &t1, &t2); 
	if (t1 == t1x && t2 >= t1) 
	    return mx[t1 : t2][]; 
	else 
		return <>; 
} 
 
Garch::GetcT() 
{ 
	m_cT = m_iT2est - m_iT1est + 1;
	return m_cT; 
} 

Garch::GetNbPar() 
{
   	m_cPar = m_cMean + m_cXM + m_cARFI + m_cAR + m_cMA 
 			+ m_cVar + m_cXV + m_cD + m_cP + m_cQ 
   			+ m_cGJR*m_cQ + 2*m_cEgarch + m_cNMGJR*m_cQ + m_cNMAGARCH*m_cQ 
			+ m_cSk + m_cKu + m_cHY + (m_c_in_mean .!= 0)
//En irtam
			+ (m_cVar + m_cXV + m_cD + m_cP + m_cQ 
   			+ m_cGJR*m_cQ + 2*m_cEgarch + m_cNMGJR*m_cQ + m_cNMAGARCH*m_cQ 
			//+ m_cSk + m_cKu + m_cHY + (m_c_in_mean .!= 0)
			+ 2)* m_cNM2
			
			+ (m_cVar + m_cXV + m_cD + m_cP + m_cQ 
   			+ m_cGJR*m_cQ + 2*m_cEgarch + m_cNMGJR*m_cQ + m_cNMAGARCH*m_cQ 
			//+ m_cSk + m_cKu + m_cHY + (m_c_in_mean .!= 0)
			+ 2)* m_cNM3;

	if (m_cFilter == 4) m_cPar = m_cPar + m_cAparch*(m_cQ+1)
		+ (m_cAparch*(m_cQ+1)) * m_cNM2
		+ (m_cAparch*(m_cQ+1)) * m_cNM3;			
	if ((m_cAparch == 1)&&(m_cD == 1)) m_cPar = m_cPar + 2
		+ 2 * m_cNM2
		+ 2 * m_cNM3;
	
//	if (m_cTests == 0)
//	{
//		if ((m_cFilter != 10)&&(rows(m_vPar) != m_cPar))  		
// 		{ 
//			print("Incorrect number of parameters :\n", 
//				  "You should have ",m_cPar," parameters in the vector 'vP'" 
//         	  	" but there are ",rows(m_vPar)," elements in this par-vector"); 
//   			exit(0); 
// 		};
//	
//		if ((m_cFilter == 10)&&(rows(m_vPar) != m_cPar-1)) 	     					 
// 		{ 
//			print("Incorrect number of parameters :\n", 
//				  "You should have ",m_cPar-1," parameters in the vector 'vP'" 
//         	  	" but there are ",rows(m_vPar)," elements in this par-vector"); 
//   			exit(0); 
//		};
//	}; 

	if (m_cFix==1) 					// PROB 306
		m_cPar-=sumc(m_vFix);

	return m_cPar; 
}

Garch::GetSeries()
{ 
	return m_vY ~ m_vE ~ m_vSigma2;
}

Garch::Pause(const sec) 
{ 
	decl i, time; 
	time = timer(); 
	while ((timer()-time)/100 < sec) 
	{ 
		i = 1; 
	}; 
} 
 
Garch::CheckPara()							    
{ 
	if ((m_cP<0)||(m_cQ<0)||(m_cAR<0)||(m_cMA<0)) 
	{ 
	  println("You cannot enter negative GARCH or ARMA orders.\n", 
	  "Please only enter positive values."); 
	  return FALSE; 
	};
	
//En tettem ezt kommentarba, szerintem ez most nem kell

	if ((m_cP == 1) && (m_cQ == 1) && (m_cFilter == 1))				   
	{ 
		if (m_valphav + m_vbetav >= 1) 
		{ 
		  println("The sum of the Garch parameters must be less than 1.\n", 
		          "The current value are : ", double(m_vbetav)," for beta(1) and ",double(m_valphav)," for alpha(1)."); 
		  return FALSE; 
		} 
		if ((m_valphav[0]<0)||(m_vbetav[0] < 0)) 
		{ 
		  println("The GARCH parameters must be positive.\n", 
		          "The current value are : ", double(m_vbetav)," for beta(1) and ",double(m_valphav)," for alpha(1)."); 
		  return FALSE; 
		} 
	};

 
	return 1; 
} 
 
Garch::GetPara()	    
{ 
	decl par; 
 
	par = <>; 
 
	if (m_cMean != 0)	par |= m_clevel;

	if (m_cXM != 0)  	par ~= (m_vbetam)';			 
 
	if (m_cARFI != 0)	par ~= m_dARFI;					   
 
	if (m_cAR != 0)		par ~= (m_vAR)';					    
	 
	if (m_cMA != 0)		par ~= (m_vMA)';					   
 
	//innen
	if (m_cVar != 0 ) 	par ~= m_calpha0; 
 
	if (m_cXV != 0)  	par ~= (m_vpsyv)';		 

	if (m_cD != 0) 		par ~= m_dD; 
 
	if (m_cQ != 0) 	    par ~= (m_valphav)';
	
	if (m_cP != 0)										 
	{ 
		if (m_cFilter != 10) 	   				par ~= (m_vbetav)'; 
		else if	((m_cFilter == 10)&&(m_cP>1)) 	par ~= (m_vbetav[1:])'; 
	} 
 
	if (m_cGJR)			par ~= (m_vleverage)';				  
 
	if (m_cEgarch)		par ~= (m_vtheta1 ~ m_vtheta2);				  
  		  
	if (m_cAparch) 
	{ 
		if (m_cFilter == 4) par ~= (m_vgamma)';   					
		else				par ~= m_vgamma[0]; 
		
		par ~= m_ddelta;				  
  	}

	if (m_cNMGJR)		par ~= (m_vleverage)';

	if (m_cNMAGARCH)	par ~= (m_vleverage)';
	
	//eddig
	 
	if (m_cSk != 0)			par ~= m_cA	; 
 
	if (m_cKu != 0)			par ~= m_cV; 
	 
	if ((m_cHY != 0)&&(m_cD != 0)) par ~= m_vHY; 

	if (m_c_in_mean != 0)	par ~= m_v_in_mean;

//En irtam
	//innen
	if ((m_cNM2 != 0)  || 	(m_cNM3 != 0))
	{
		if (m_cVar != 0 ) 	par ~= m_calpha0_2; 
 
		if (m_cXV != 0)  	par ~= (m_vpsyv_2)';		 

		if (m_cD != 0) 		par ~= m_dD_2; 
 
		if (m_cQ != 0) 	    par ~= (m_valphav_2)';
	
		if (m_cP != 0)										 
		{ 
			if (m_cFilter != 10) 	   				par ~= (m_vbetav_2)'; 
			else if	((m_cFilter == 10)&&(m_cP>1)) 	par ~= (m_vbetav_2[1:])'; 
		} 
 
		if (m_cGJR)			par ~= (m_vleverage_2)';				  
 
		if (m_cEgarch)		par ~= (m_vtheta1_2 ~ m_vtheta2_2);				  
  		  
		if (m_cAparch) 
		{ 
			if (m_cFilter == 4) par ~= (m_vgamma_2)';   					
			else				par ~= m_vgamma_2[0]; 
		
			par ~= m_ddelta_2;				  
  		}

		if (m_cNMGJR)		par ~= (m_vleverage_2)';

		if (m_cNMAGARCH)	par ~= (m_vleverage_2)';
	
		par ~= m_p1;
		par ~= m_mu1;
	}

	if(m_cNM3 != 0)
	{
		if (m_cVar != 0 ) 	par ~= m_calpha0_3; 
 
		if (m_cXV != 0)  	par ~= (m_vpsyv_3)';		 

		if (m_cD != 0) 		par ~= m_dD_3; 
 
		if (m_cQ != 0) 	    par ~= (m_valphav_3)';
	
		if (m_cP != 0)										 
		{ 
			if (m_cFilter != 10) 	   				par ~= (m_vbetav_3)'; 
			else if	((m_cFilter == 10)&&(m_cP>1)) 	par ~= (m_vbetav_3[1:])'; 
		} 
 
		if (m_cGJR)			par ~= (m_vleverage_3)';				  
 
		if (m_cEgarch)		par ~= (m_vtheta1_3 ~ m_vtheta2_3);				  
  		  
		if (m_cAparch) 
		{ 
			if (m_cFilter == 4) par ~= (m_vgamma_3)';   					
			else				par ~= m_vgamma_3[0]; 
		
			par ~= m_ddelta_3;				  
  		}

		if (m_cNMGJR)		par ~= (m_vleverage_3)';

		if (m_cNMAGARCH)	par ~= (m_vleverage_3)';

		par ~= m_p2;
		par ~= m_mu2;
	}
	//eddig
		
	m_vPar = (par)';

	return 1; 
} 
 
Garch::SplitPara(vP) 
{ 
	decl nxt;	 
  
	nxt = 0; 
	 
	if (m_cMean != 0) 
 	{ 
   		m_clevel = vP[nxt]; 
   		nxt=nxt+1; 
 	} 
	else 
		m_clevel=<>; 
 
	if (m_cXM != 0) 
 	{ 
   		m_vbetam = vP[nxt:nxt+m_cXM-1]; 
   		nxt = nxt + m_cXM; 
 	} 
	else 
		m_vbetam=<>; 
 
	if (m_cARFI != 0) 
 	{ 
   		m_dARFI = vP[nxt]; 
   		++nxt; 
 	} 
	else 
		m_dARFI=<>;	 
	 
	if (m_cAR != 0)			  
 	{ 
		m_vAR = vP[nxt:nxt+m_cAR-1];					  
   		nxt = nxt + m_cAR; 
 	}; 
 
	if (m_cMA != 0)			    
 	{ 
	    if (m_cMA>1) 
		{ 
		    m_vMA = vP[nxt:nxt+m_cMA-1];					 
   		    nxt = nxt + m_cMA; 
		} 
		else 
		{ 
		    m_vMA = vP[nxt:nxt+m_cMA-1]; 
   		    nxt = nxt + m_cMA; 
		} 
	};
	
 	//innen
	if (m_cVar != 0)									   
 	{
   		m_calpha0 = vP[nxt]/10^(m_cYsmall); 	   // NEW 312
		//	m_calpha0 = vP[nxt]; 
   		++nxt; 
 	}; 
 
	if (m_cXV != 0) 
 	{ 
   		m_vpsyv = vP[nxt:nxt+m_cXV-1]; 
   		nxt = nxt + m_cXV; 
 	}; 
 
	if (m_cD != 0) 
 	{ 
   		m_dD = vP[nxt]; 
   		++nxt; 
 	}; 
																 
	if (m_cQ != 0) 
 	{ 
		m_valphav = vP[nxt:nxt+m_cQ-1];					 
   		nxt = nxt + m_cQ; 
 	}
	else m_valphav = <>;
	
	if (m_cP != 0)						  		 
 	{ 
	    if (m_cFilter != 10) 
		{ 
			m_vbetav = vP[nxt:nxt+m_cP-1];					  
			nxt = nxt + m_cP; 
		} 
		else if ((m_cP>1)&&(m_cFilter == 10)) 
		{ 
			m_vbetav[0][0] = 0; 
			m_vbetav[1:][0] = vP[nxt:nxt+m_cP-2];					  
			nxt = nxt + m_cP - 1;			 
		} 
 	} 
	else m_vbetav = <>; 
 
	if (m_cGJR) 
	{ 
       m_vleverage = vP[nxt:nxt+m_cQ-1]; 
 	   nxt = nxt + m_cQ; 
	} 
	if (m_cEgarch) 
	{ 
       m_vtheta1 = vP[nxt]; 
       m_vtheta2 = vP[nxt+1];		    
 	   nxt = nxt + 2; 
	}					  
	if (m_cAparch) 
	{ 
	   if (m_cFilter == 4)
	   {
	   	m_vgamma = vP[nxt:nxt+m_cQ-1]; 				  
	   	nxt = nxt + m_cQ; 
	   }
	   else
	   {
	   	m_vgamma = vP[nxt]; 
	   	++nxt; 
	   }
	   
	   m_ddelta = vP[nxt];		      
	   ++nxt;				  
	}

	if (m_cNMGJR) 
	{ 
       m_vleverage = vP[nxt:nxt+m_cQ-1]; 
 	   nxt = nxt + m_cQ; 
	}

	if (m_cNMAGARCH) 
	{ 
       m_vleverage = vP[nxt:nxt+m_cQ-1]; 
 	   nxt = nxt + m_cQ; 
	} 
	//eddig
	 
	if (m_cSk != 0)			  
 	{ 
   		m_cA = vP[nxt]	; 
		++nxt; 
 	} 
	else 
		m_cA=<>; 
	 
	if (m_cKu != 0)			  
 	{ 
   		m_cV = vP[nxt]	; 
		++nxt; 
 	} 
	else 
		m_cV=<>; 
	 
	if (m_cHY != 0)			 							  
 	{ 
   		m_vHY = vP[nxt]; 
		++nxt; 
 	} 
	else 
		m_vHY = 0; 

	if (m_c_in_mean != 0)			 							  
 	{ 
   		m_v_in_mean = vP[nxt]; 
		++nxt; 
 	} 
	else 
		m_v_in_mean = 0; 
	//innen		
	if ((m_cP != 0)&&(m_cFilter == 10))						  	 
 	{ 
		if (m_cP==1) 
			m_vbetav =  1 - sumc(m_valphav); 
		else if (m_cP>1) 
			m_vbetav[0] =  1 - sumc(m_vbetav[1:][0]) - sumc(m_valphav); 
 	};
	//eddig

//En irtam
	//innen
	if ((m_cNM2 != 0)|| (m_cNM3 != 0))
	{
		if (m_cVar != 0)									   
 		{
   			m_calpha0_2 = vP[nxt]/10^(m_cYsmall); 	   // NEW 312
			//	m_calpha0 = vP[nxt]; 
   			++nxt; 
 		}; 
 
		if (m_cXV != 0) 
 		{ 
   			m_vpsyv_2 = vP[nxt:nxt+m_cXV-1]; 
   			nxt = nxt + m_cXV; 
 		}; 
 
		if (m_cD != 0) 
 		{ 
	   		m_dD_2 = vP[nxt]; 
	   		++nxt; 
	 	}; 
																 
		if (m_cQ != 0) 
 		{ 
			m_valphav_2 = vP[nxt:nxt+m_cQ-1];					 
   			nxt = nxt + m_cQ; 
	 	}
		else m_valphav_2 = <>;
	
		if (m_cP != 0)						  		 
 		{ 
		    if (m_cFilter != 10) 
			{ 
				m_vbetav_2 = vP[nxt:nxt+m_cP-1];					  
				nxt = nxt + m_cP; 
			} 
			else if ((m_cP>1)&&(m_cFilter == 10)) 
			{ 
				m_vbetav_2[0][0] = 0; 
				m_vbetav_2[1:][0] = vP[nxt:nxt+m_cP-2];					  
				nxt = nxt + m_cP - 1;			 
			} 
 		} 
		else m_vbetav_2 = <>; 
 
		if (m_cGJR) 
		{ 
	   	   m_vleverage_2 = vP[nxt:nxt+m_cQ-1]; 
	 	   nxt = nxt + m_cQ; 
		} 
		if (m_cEgarch) 
		{ 
		   m_vtheta1_2 = vP[nxt]; 
	   	   m_vtheta2_2 = vP[nxt+1];		    
	 	   nxt = nxt + 2; 
		}					  
		if (m_cAparch) 
		{ 
		   if (m_cFilter == 4)
		   {
		   	m_vgamma_2 = vP[nxt:nxt+m_cQ-1]; 				  
		   	nxt = nxt + m_cQ; 
		   }
		   else
		   {
		   	m_vgamma_2 = vP[nxt]; 
		   	++nxt; 
		   }
	   
		   m_ddelta_2 = vP[nxt];		      
		   ++nxt;				  
		}

		if (m_cNMGJR) 
		{ 
			m_vleverage_2 = vP[nxt:nxt+m_cQ-1]; 
 	   		nxt = nxt + m_cQ; 
		}

		if (m_cNMAGARCH) 
		{ 
	       m_vleverage_2 = vP[nxt:nxt+m_cQ-1]; 
	 	   nxt = nxt + m_cQ; 
		} 

		if ((m_cP != 0)&&(m_cFilter == 10))						  	 
 		{ 
			if (m_cP==1) 
				m_vbetav_2 =  1 - sumc(m_valphav_2); 
			else if (m_cP>1) 
				m_vbetav_2[0] =  1 - sumc(m_vbetav_2[1:][0]) - sumc(m_valphav_2); 
 		};

		m_p1 = vP[nxt];
		++nxt;

		m_mu1 = vP[nxt];
		++nxt;
	}

	if (m_cNM3 != 0)
	{
		if (m_cVar != 0)									   
 		{
   			m_calpha0_3 = vP[nxt]/10^(m_cYsmall); 	   // NEW 312
			//	m_calpha0 = vP[nxt]; 
   			++nxt; 
 		}; 
 
		if (m_cXV != 0) 
 		{ 
   			m_vpsyv_3 = vP[nxt:nxt+m_cXV-1]; 
   			nxt = nxt + m_cXV; 
 		}; 
 
		if (m_cD != 0) 
 		{ 
	   		m_dD_3 = vP[nxt]; 
	   		++nxt; 
	 	}; 
																 
		if (m_cQ != 0) 
 		{ 
			m_valphav_3 = vP[nxt:nxt+m_cQ-1];					 
   			nxt = nxt + m_cQ; 
	 	}
		else m_valphav_3 = <>;
	
		if (m_cP != 0)						  		 
 		{ 
		    if (m_cFilter != 10) 
			{ 
				m_vbetav_3 = vP[nxt:nxt+m_cP-1];					  
				nxt = nxt + m_cP; 
			} 
			else if ((m_cP>1)&&(m_cFilter == 10)) 
			{ 
				m_vbetav_3[0][0] = 0; 
				m_vbetav_3[1:][0] = vP[nxt:nxt+m_cP-2];					  
				nxt = nxt + m_cP - 1;			 
			} 
 		} 
		else m_vbetav_3 = <>; 
 
		if (m_cGJR) 
		{ 
	   	   m_vleverage_3 = vP[nxt:nxt+m_cQ-1]; 
	 	   nxt = nxt + m_cQ; 
		} 
		if (m_cEgarch) 
		{ 
		   m_vtheta1_3 = vP[nxt]; 
	   	   m_vtheta2_3 = vP[nxt+1];		    
	 	   nxt = nxt + 2; 
		}					  
		if (m_cAparch) 
		{ 
		   if (m_cFilter == 4)
		   {
		   	m_vgamma_3 = vP[nxt:nxt+m_cQ-1]; 				  
		   	nxt = nxt + m_cQ; 
		   }
		   else
		   {
		   	m_vgamma_3 = vP[nxt]; 
		   	++nxt; 
		   }
	   
		   m_ddelta_3 = vP[nxt];		      
		   ++nxt;				  
		}

		if (m_cNMGJR) 
		{ 
			m_vleverage_3 = vP[nxt:nxt+m_cQ-1]; 
 	   		nxt = nxt + m_cQ; 
		}

		if (m_cNMAGARCH) 
		{ 
	       m_vleverage_3 = vP[nxt:nxt+m_cQ-1]; 
	 	   nxt = nxt + m_cQ; 
		} 		

		if ((m_cP != 0)&&(m_cFilter == 10))						  	 
 		{ 
			if (m_cP==1) 
				m_vbetav_3 =  1 - sumc(m_valphav_3); 
			else if (m_cP>1) 
				m_vbetav_3[0] =  1 - sumc(m_vbetav_3[1:][0]) - sumc(m_valphav_3); 
 		};

		m_p2 = vP[nxt];
		++nxt;

		m_mu2 = vP[nxt];
		++nxt;
	}
	//eddig

	 
	return 1; 
} 
 
Garch::GetRes(const y, const x) 
/* 
**		From y =  + b0 * X0 + b1 * X1 + ... + bk * Xk + e. 
** 		we get e = y - ... 
*/ 
{ 
	decl e; 
 
  	if ((m_cMean == 0) && (m_cXM == 0))	 		e = y; 
  	else if ((m_cMean != 0) && (m_cXM == 0))   	e = y - m_clevel; 
  	else if ((m_cMean == 0) && (m_cXM != 0))   	e = y - sumr((m_vbetam[][0:])'.*x[][]); 
  	else if ((m_cMean != 0) && (m_cXM != 0))	e = y - m_clevel - sumr((m_vbetam[][0:])'.*x[][]); 
 
  return e; 
} 
 
Garch::GetXB(const x, const n)   
/* 
**		y = m_clevel + m_vbetam' * X 
*/ 
{ 
	decl y; 
 
  	if ((m_cMean == 0) && (m_cXM == 0))		 		y = zeros(n,1); 
  	else if ((m_cMean != 0) && (m_cXM == 0))		y = m_clevel*ones(n,1); 
  	else if ((m_cMean == 0) && (m_cXM != 0))		y = sumr((m_vbetam[][0:])'.*x[][]); 
  	else if ((m_cMean != 0) && (m_cXM != 0))		y = m_clevel + sumr((m_vbetam[][0:])'.*x[][]); 
 
  	return y; 
} 
 
Garch::GetZB1(const x, const n)   
/* 
**		h1 = m_calpha0 + m_vpsyv' * X 
*/ 
{ 
	decl h; 
 
  	if ((m_cVar == 0) && (m_cXV == 0))   		h = zeros(n,1); 
  	else if ((m_cVar != 0) && (m_cXV == 0))		h = m_calpha0*ones(n,1); 
	else if ((m_cVar == 0) && (m_cXV != 0)) 
	{ 
		if (m_cFilter == (2||21))				h = log(1.0 + sumr((m_vpsyv[][0:])' .* x[][]));
		else 									h = sumr((m_vpsyv[][0:])'.*x[][]); 
	} 
  	else if ((m_cVar != 0) && (m_cXV != 0)) 
	{ 
		if (m_cFilter == (2||21))				h = m_calpha0 + log(1.0 + sumr((m_vpsyv[][0:])' .* x[][])); 
		else 									h = m_calpha0 + sumr((m_vpsyv[][0:])'.*x[][]); 
	} 
 
  	return h; 
}

//En irtam
Garch::GetZB2(const x, const n)   
/* 
**		h2 = m_calpha0_2 + m_vpsyv_2' * X 
*/ 
{ 
	decl h; 
 
  	if ((m_cVar == 0) && (m_cXV == 0))   		h = zeros(n,1); 
  	else if ((m_cVar != 0) && (m_cXV == 0))		h = m_calpha0_2*ones(n,1); 
	else if ((m_cVar == 0) && (m_cXV != 0)) 
	{ 
		if (m_cFilter == (2||21))				h = log(1.0 + sumr((m_vpsyv_2[][0:])' .* x[][])); 
		else 									h = sumr((m_vpsyv_2[][0:])'.*x[][]); 
	} 
  	else if ((m_cVar != 0) && (m_cXV != 0)) 
	{ 
		if (m_cFilter == (2||21))				h = m_calpha0_2 + log(1.0 + sumr((m_vpsyv_2[][0:])' .* x[][])); 
		else 									h = m_calpha0_2 + sumr((m_vpsyv_2[][0:])'.*x[][]); 
	} 
 
  	return h; 
}

//En irtam
Garch::GetZB3(const x, const n)   
/* 
**		h3 = m_calpha0_3 + m_vpsyv_3' * X 
*/ 
{ 
	decl h; 
 
  	if ((m_cVar == 0) && (m_cXV == 0))   		h = zeros(n,1); 
  	else if ((m_cVar != 0) && (m_cXV == 0))		h = m_calpha0_3*ones(n,1); 
	else if ((m_cVar == 0) && (m_cXV != 0)) 
	{ 
		if (m_cFilter == (2||21))				h = log(1.0 + sumr((m_vpsyv_3[][0:])' .* x[][])); 
		else 									h = sumr((m_vpsyv_3[][0:])'.*x[][]); 
	} 
  	else if ((m_cVar != 0) && (m_cXV != 0)) 
	{ 
		if (m_cFilter == (2||21))				h = m_calpha0_3 + log(1.0 + sumr((m_vpsyv_3[][0:])' .* x[][])); 
		else 									h = m_calpha0_3 + sumr((m_vpsyv_3[][0:])'.*x[][]); 
	} 
 
  	return h; 
}

//En irtam
Garch::GetZB(const x, const n)
/*
**		h=p1.*h1+p2.*h2+p3.*h3
*/
{
	decl h;
	decl h1=GetZB1(x,n);
	
	if (m_cNM2 != 0)
	{
		decl h2=GetZB2(x,n);
		h=m_p1.*(h1+m_mu1*m_mu1) + m_p2.*(h2+m_mu2*m_mu2);

		return h;
	}

	if (m_cNM3 != 0)
	{
		decl h2=GetZB2(x,n);
		decl h3=GetZB3(x,n);
		h=m_p1.*(h1+m_mu1*m_mu1) + m_p2.*(h2+m_mu2*m_mu2) + + m_p3.*(h3+m_mu3*m_mu3);

		return h;
	}
	
	return h1;
}
 
Garch::GetForErrors(const varobs)  
{ 
  	m_Yfor = GetForcData(Y_VAR, m_cTforc)[][0]; 					
 	decl mu = meanc(m_vY[0:m_cT-1][]) * ones(rows(m_Yfor),1);   
 	if (varobs==0) m_Hfor = (m_Yfor - mu).^2; 
	else 		   m_Hfor = GetForcData(O_VAR, m_cTforc); 		
	return 0;	 
} 

Garch::FixParam(const cfix, const fix)
{ 
	m_cFix = cfix; m_vFix = fix;
}

Garch::FigLL(const vP, const adFunc, const avScore, const amHessian) 
{ 
	decl likel,vP2;
	SetFreePar(vP);		// Update the free parameters

	SplitPara(GetPar());	// Update the global variables (parameters) with the free (optimized) and Fixed Parameters    
	Res_Var();
		 
	if (m_cDist == 0)	    	likel = GaussLik(m_vE, m_vSigma2); 
	else if (m_cDist == 1)		likel = StudentLik(m_vE, m_vSigma2, m_cV);		 
	else if (m_cDist == 2)		likel = GEDLik(m_vE, m_vSigma2, m_cV); 
	else if (m_cDist == 3)		likel = SkStudentLik(m_vE, m_vSigma2, m_cA, m_cV);
	else if (m_cDist == 4)		likel = NM2Lik(m_vE, m_vSigma2_1, m_vSigma2_2, m_p1, m_mu1);
	else if (m_cDist == 5)		likel = NM3Lik(m_vE, m_vSigma2_1, m_vSigma2_2, m_vSigma2_3, m_p1, m_p2, m_mu1, m_mu2);

	if (m_cRobustLL == 0)
								adFunc[0]=sumc(likel);
	else						adFunc[0]=likel; 
 
	return 1;                           
}

//En irtam
Garch::FigLL_max(const vP, const adFunc, const avScore, const amHessian) 
{ 
	decl likel,vP2;
	SetFreePar(vP);		// Update the free parameters

	SplitPara(GetPar());	// Update the global variables (parameters) with the free (optimized) and Fixed Parameters    
	Res_Var();
		 
	if (m_cDist == 0)	    	likel = GaussLik(m_vE, m_vSigma2); 
	else if (m_cDist == 1)		likel = StudentLik(m_vE, m_vSigma2, m_cV);		 
	else if (m_cDist == 2)		likel = GEDLik(m_vE, m_vSigma2, m_cV); 
	else if (m_cDist == 3)		likel = SkStudentLik(m_vE, m_vSigma2, m_cA, m_cV);
	else if (m_cDist == 4)
	{
		likel = NM2Lik(m_vE, m_vSigma2_1, m_vSigma2_2, m_p1, m_mu1);
		if (m_restr==1) 		likel-=MY_MAX*(m_mu1*m_mu1 + (m_valphav-m_valphav_2)*(m_valphav-m_valphav_2)
												+ (m_vbetav-m_vbetav_2)*(m_vbetav-m_vbetav_2) );
		else if (m_restr==2)	likel-=MY_MAX*(m_mu1*m_mu1 + m_valphav_2*m_valphav_2 + m_vbetav_2*m_vbetav_2);
		else if (m_restr==3)	likel-=MY_MAX*(m_mu1*m_mu1);
		else if (m_restr==4) 	likel-=MY_MAX*( (m_valphav-m_valphav_2)*(m_valphav-m_valphav_2)
												+ (m_vbetav-m_vbetav_2)*(m_vbetav-m_vbetav_2)   );
		else if (m_restr==5)	likel-=MY_MAX*(m_valphav_2*m_valphav_2 + m_vbetav_2*m_vbetav_2);
		else if (m_restr==6)	likel-=MY_MAX*((m_p1-0.802)^2+(m_mu1-0.0076)^2);
	}
	else if (m_cDist == 5)
	{
		likel = NM3Lik(m_vE, m_vSigma2_1, m_vSigma2_2, m_vSigma2_3, m_p1, m_p2, m_mu1, m_mu2);
		//println(sumc(likel)[0][0]);
		if (m_p1<0) likel-=MY_MAX*(-m_p1);
		if (m_p1>1) likel-=MY_MAX*(m_p1-1);
		if (m_p2<0) likel-=MY_MAX*(-m_p2);
		if (m_p2>1) likel-=MY_MAX*(m_p2-1);
		if (m_p1+m_p2>1) likel-=MY_MAX* (m_p1+m_p2-1);
		if (m_restr==1) 		likel-=MY_MAX*(m_mu1*m_mu1 + m_mu2*m_mu2 + (m_valphav-m_valphav_2)*(m_valphav-m_valphav_2)
												+ (m_vbetav-m_vbetav_2)*(m_vbetav-m_vbetav_2)
												+ (m_valphav-m_valphav_3)*(m_valphav-m_valphav_3)
												+ (m_vbetav-m_vbetav_3)*(m_vbetav-m_vbetav_3));
		else if (m_restr==2)	likel-=MY_MAX*(m_mu1*m_mu1 + m_mu2*m_mu2 + m_valphav_3*m_valphav_3 + m_vbetav_3*m_vbetav_3);
		else if (m_restr==3)	likel-=MY_MAX*(m_mu1*m_mu1 + m_mu2*m_mu2);
		else if (m_restr==4) 	likel-=MY_MAX*( (m_valphav-m_valphav_2)*(m_valphav-m_valphav_2)
												+ (m_vbetav-m_vbetav_2)*(m_vbetav-m_vbetav_2)
												+ (m_valphav-m_valphav_3)*(m_valphav-m_valphav_3)
												+ (m_vbetav-m_vbetav_3)*(m_vbetav-m_vbetav_3));
		else if (m_restr==5)	likel-=MY_MAX*(m_valphav_3*m_valphav_3 + m_vbetav_3*m_vbetav_3);
	}

	if (m_cRobustLL == 0)
								adFunc[0]=sumc(likel);
	else						adFunc[0]=likel; 
 
	return 1;                           
}

Garch::FigLL2(const avF, const vP) 
{
        decl adFunc, avScore, amHessian;
        m_cRobustLL=1;
        if (FigLL(vP, &adFunc, &avScore, &amHessian))
        avF[0] = adFunc;
    return 1;
}

Garch::Res_Var() 
{ 
	decl  sm, zz, n, G, delta;
	decl  sm_2, zz_2, G_2, delta_2;
	decl  sm_3, zz_3, G_3, delta_3;

	if (m_cAR+m_cMA)	    
	{					    
	   if (m_cAR) 
          m_vAR_MA = m_vAR;		 
	   if (m_cMA) 
	   { 
	      if (m_cAR) 
             m_vAR_MA |= m_vMA; 
		  else 
             m_vAR_MA = m_vMA;		   
	   }     
	}
	else
		m_vAR_MA=<>;

	//innen
	if (m_cXV == 0) 
  	{ 
		if (m_cVar == 0) m_calpha0 = 0;	  
			sm = m_calpha0 * ones(rows(m_vY),1);
  	} 
  	else 
  	{ 
		if (m_cVar == 0) m_calpha0 = 0; 
 
		if ((m_cD == 1)&&(m_cEgarch == 1)) 
			sm = m_calpha0 + log(1.0 + sumr((m_vpsyv[][0:])' .* m_mXV[][])); 
		else 
			sm = m_calpha0 + sumr((m_vpsyv[][0:])' .* m_mXV[][]); 
  	}; 

	if ((m_cFilter == 2)||(m_cFilter == 21)) 
		decl Cst = E_abseps(m_cDist,m_cA|m_cV);
	//eddig

//En irtam
	//innen
	if (( m_cNM2 != 0) || (m_cNM3 != 0))
	{
		if (m_cXV == 0) 
  		{ 
			if (m_cVar == 0) m_calpha0_2 = 0;	  
				sm_2 = m_calpha0_2 * ones(rows(m_vY),1);
  		} 
	  	else 
	  	{ 
			if (m_cVar == 0) m_calpha0_2 = 0; 
 
			if ((m_cD == 1)&&(m_cEgarch == 1)) 
				sm_2 = m_calpha0_2 + log(1.0 + sumr((m_vpsyv_2[][0:])' .* m_mXV[][])); 
			else 
				sm_2 = m_calpha0_2 + sumr((m_vpsyv_2[][0:])' .* m_mXV[][]); 
	  	}; 

		if ((m_cFilter == 2)||(m_cFilter == 21)) 
			decl Cst_2 = E_abseps(m_cDist,m_cA|m_cV);
	}

	if ( m_cNM3 != 0)
	{
		if (m_cXV == 0) 
  		{ 
			if (m_cVar == 0) m_calpha0_3 = 0;	  
				sm_3 = m_calpha0_3 * ones(rows(m_vY),1);
  		} 
	  	else 
	  	{ 
			if (m_cVar == 0) m_calpha0_3 = 0; 
 
			if ((m_cD == 1)&&(m_cEgarch == 1)) 
				sm_3 = m_calpha0_3 + log(1.0 + sumr((m_vpsyv_3[][0:])' .* m_mXV[][])); 
			else 
				sm_3 = m_calpha0_3 + sumr((m_vpsyv_3[][0:])' .* m_mXV[][]); 
	  	}; 

		if ((m_cFilter == 2)||(m_cFilter == 21)) 
			decl Cst_3 = E_abseps(m_cDist,m_cA|m_cV);
	}
	//eddig
	
	if (m_c_in_mean==0)
	{
		if ( (m_cNM2 == 0)	&& (m_cNM3 == 0))
		{
			//innen
			m_vE = GetRes(m_vY,m_mXM); 
	 									 
			if (m_cAR+m_cMA) m_vE = arma0(m_vE,m_vAR_MA',m_cAR,m_cMA); 

			if (m_cARFI)    m_vE = diffpow(m_vE,m_dARFI);  // ARMA - ARFIMA Order inverted
	 
			if ((m_cAparch == 1)&&(m_cD==1))
			{ 
				delta = m_ddelta; 
				G = (fabs(m_vE[][0]) - m_vgamma * (m_vE[][0])).^delta; 		
			}; 
	 	
			if (m_cP+m_cQ+m_cD > 0) 
			{ 
				if ((m_cFilter == 1)||(m_cFilter == 10)) 		m_vSigma2 = Garch_Filter(m_vE,sm,m_cP,m_cQ, m_valphav|m_vbetav); 
				else if ((m_cFilter == 11)||(m_cFilter == 51))  m_vSigma2 = Figarch_BBM(m_vE,sm,m_cP,m_cQ,m_claglamb,m_valphav|m_vbetav|m_dD|m_vHY); 
				else if (m_cFilter == 12)  m_vSigma2 = Figarch_Chung(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_dD); 
				else if (m_cFilter == 2)   m_vSigma2 = EGarch(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_vtheta1|m_vtheta2,Cst); 
				else if (m_cFilter == 21)  m_vSigma2 = FIEGarch(m_vE,sm,m_cP,m_cQ, m_valphav|m_vbetav|m_vtheta1|m_vtheta2|m_dD,m_claglamb,Cst); 
				else if (m_cFilter == 3)   m_vSigma2 = GJR_Filter(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_vleverage); 
				else if (m_cFilter == 4)   m_vSigma2 = AParch(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_vgamma|m_ddelta); 
				else if (m_cFilter == 41)  m_vSigma2 = Figarch_BBM(sqrt(G),sm,m_cP,m_cQ,m_claglamb,m_valphav|m_vbetav|m_dD|0).^(2/delta); 
				else if (m_cFilter == 42)  m_vSigma2 = Figarch_Chung(sqrt(G),sm,m_cP,m_cQ,m_valphav|m_vbetav|m_dD).^(2/delta);
				//en irtam
				else if (m_cFilter == 112)   m_vSigma2 = GJR_Filter(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_vleverage); 
				else if (m_cFilter == 113)   m_vSigma2 = AGARCH_Filter(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_vleverage); 
			} 
			else  m_vSigma2=sm;
			//eddig
		}

//En irtam
		//innen
		else if (m_cNM2 == 1)
		{
			m_vE = GetRes(m_vY,m_mXM); 
	 									 
			if (m_cAR+m_cMA) m_vE = arma0(m_vE,m_vAR_MA',m_cAR,m_cMA); 

			if (m_cARFI)    m_vE = diffpow(m_vE,m_dARFI);  // ARMA - ARFIMA Order inverted
	 
			if ((m_cAparch == 1)&&(m_cD==1))
			//not modified yet
			{ 
				delta = m_ddelta; 
				G = (fabs(m_vE[][0]) - m_vgamma * (m_vE[][0])).^delta; 		
			}; 
	 	
			if (m_cP+m_cQ+m_cD > 0)
			//csak az egyszeru Garch van megvaltoztatva, a Figarch etc. nincsenek
			{ 
				if ((m_cFilter == 1)||(m_cFilter == 10)) 		m_vSigma2 = NM2Garch_Filter(m_vE,sm,sm_2,m_cP,m_cQ, m_valphav|m_vbetav, m_valphav_2|m_vbetav_2); 
				else if ((m_cFilter == 11)||(m_cFilter == 51))  m_vSigma2 = Figarch_BBM(m_vE,sm,m_cP,m_cQ,m_claglamb,m_valphav|m_vbetav|m_dD|m_vHY); 
				else if (m_cFilter == 12)  m_vSigma2 = Figarch_Chung(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_dD); 
				else if (m_cFilter == 2)   m_vSigma2 = EGarch(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_vtheta1|m_vtheta2,Cst); 
				else if (m_cFilter == 21)  m_vSigma2 = FIEGarch(m_vE,sm,m_cP,m_cQ, m_valphav|m_vbetav|m_vtheta1|m_vtheta2|m_dD,m_claglamb,Cst); 
				else if (m_cFilter == 3)   m_vSigma2 = GJR_Filter(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_vleverage); 
				else if (m_cFilter == 4)   m_vSigma2 = AParch(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_vgamma|m_ddelta); 
				else if (m_cFilter == 41)  m_vSigma2 = Figarch_BBM(sqrt(G),sm,m_cP,m_cQ,m_claglamb,m_valphav|m_vbetav|m_dD|0).^(2/delta); 
				else if (m_cFilter == 42)  m_vSigma2 = Figarch_Chung(sqrt(G),sm,m_cP,m_cQ,m_valphav|m_vbetav|m_dD).^(2/delta); 
				else if (m_cFilter == 112)   m_vSigma2 = NM2GJR_Filter(m_vE,sm,sm_2,m_cP,m_cQ, m_valphav|m_vbetav|m_vleverage, m_valphav_2|m_vbetav_2|m_vleverage_2); 
				else if (m_cFilter == 113)   m_vSigma2 = NM2AGARCH_Filter(m_vE,sm,sm_2,m_cP,m_cQ, m_valphav|m_vbetav|m_vleverage, m_valphav_2|m_vbetav_2|m_vleverage_2); 
			} 
			else  m_vSigma2=sm;
		}

		else if (m_cNM3 == 1)
		{
			m_vE = GetRes(m_vY,m_mXM); 
	 									 
			if (m_cAR+m_cMA) m_vE = arma0(m_vE,m_vAR_MA',m_cAR,m_cMA); 

			if (m_cARFI)    m_vE = diffpow(m_vE,m_dARFI);  // ARMA - ARFIMA Order inverted
	 
			if ((m_cAparch == 1)&&(m_cD==1))
			//not modified yet
			{ 
				delta = m_ddelta; 
				G = (fabs(m_vE[][0]) - m_vgamma * (m_vE[][0])).^delta; 		
			}; 
	 	
			if (m_cP+m_cQ+m_cD > 0)
			//csak az egyszeru Garch van megvaltoztatva, a Figarch etc. nincsenek
			{ 
				if ((m_cFilter == 1)||(m_cFilter == 10)) 		m_vSigma2 = NM3Garch_Filter(m_vE,sm,sm_2,sm_3,m_cP,m_cQ, m_valphav|m_vbetav, m_valphav_2|m_vbetav_2, m_valphav_3|m_vbetav_3); 
				else if ((m_cFilter == 11)||(m_cFilter == 51))  m_vSigma2 = Figarch_BBM(m_vE,sm,m_cP,m_cQ,m_claglamb,m_valphav|m_vbetav|m_dD|m_vHY); 
				else if (m_cFilter == 12)  m_vSigma2 = Figarch_Chung(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_dD); 
				else if (m_cFilter == 2)   m_vSigma2 = EGarch(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_vtheta1|m_vtheta2,Cst); 
				else if (m_cFilter == 21)  m_vSigma2 = FIEGarch(m_vE,sm,m_cP,m_cQ, m_valphav|m_vbetav|m_vtheta1|m_vtheta2|m_dD,m_claglamb,Cst); 
				else if (m_cFilter == 3)   m_vSigma2 = GJR_Filter(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_vleverage); 
				else if (m_cFilter == 4)   m_vSigma2 = AParch(m_vE,sm,m_cP,m_cQ,m_valphav|m_vbetav|m_vgamma|m_ddelta); 
				else if (m_cFilter == 41)  m_vSigma2 = Figarch_BBM(sqrt(G),sm,m_cP,m_cQ,m_claglamb,m_valphav|m_vbetav|m_dD|0).^(2/delta); 
				else if (m_cFilter == 42)  m_vSigma2 = Figarch_Chung(sqrt(G),sm,m_cP,m_cQ,m_valphav|m_vbetav|m_dD).^(2/delta); 
				else if (m_cFilter == 112)   m_vSigma2 = NM3GJR_Filter(m_vE,sm,sm_2,sm_3,m_cP,m_cQ, m_valphav|m_vbetav|m_vleverage, m_valphav_2|m_vbetav_2|m_vleverage_2, m_valphav_3|m_vbetav_3|m_vleverage_3); 
				else if (m_cFilter == 113)   m_vSigma2 = NM3AGARCH_Filter(m_vE,sm,sm_2,sm_3,m_cP,m_cQ, m_valphav|m_vbetav|m_vleverage, m_valphav_2|m_vbetav_2|m_vleverage_2, m_valphav_3|m_vbetav_3|m_vleverage_3); 
			} 
			else  m_vSigma2=sm;
		}

		
		
		//eddig
	}
	else
//Ez nincs megvaltoztatva meg
	{
		decl XB_mean,temp;
	  	if (m_cXM == 0) 
	  	{ 
			if (m_cMean == 0)  m_clevel = 0; 
				XB_mean = m_clevel * ones(rows(m_vY),1); 
	  	} 
	  	else 
	  	{ 
			if (m_cMean == 0) m_clevel = 0; 
	 			XB_mean = m_clevel + sumr((m_vbetam[][0:])'.*m_mXM[][]); 
	  	};

		if ((m_cFilter == 1)||(m_cFilter == 10))
			temp = Garch_in_mean(m_vY, XB_mean, m_cAR|m_cMA, m_vAR_MA, m_cARFI, m_dARFI, sm, m_cP,m_cQ, m_valphav|m_vbetav,m_c_in_mean,m_v_in_mean);	
		else if (m_cFilter==2)
			temp = EGARCH_in_mean(m_vY, XB_mean, m_cAR|m_cMA, m_vAR_MA, m_cARFI, m_dARFI, sm, m_cP,m_cQ, m_valphav|m_vbetav|m_vtheta1|m_vtheta2,Cst,m_c_in_mean,m_v_in_mean);	
		else if (m_cFilter==3)
			temp = GJR_in_mean(m_vY, XB_mean, m_cAR|m_cMA, m_vAR_MA, m_cARFI, m_dARFI, sm, m_cP,m_cQ, m_valphav|m_vbetav|m_vleverage,m_c_in_mean,m_v_in_mean);	
		else if (m_cFilter==4)
			temp = APARCH_in_mean(m_vY, XB_mean, m_cAR|m_cMA, m_vAR_MA, m_cARFI, m_dARFI, sm, m_cP,m_cQ, m_valphav|m_vbetav|m_vgamma|m_ddelta,m_c_in_mean,m_v_in_mean);			
		else if ((m_cFilter == 11)||(m_cFilter == 51))
			temp = FIGARCH_BBM_in_mean(m_vY, XB_mean, m_cAR|m_cMA, m_vAR_MA, m_cARFI, m_dARFI, sm, m_cP,m_cQ, m_valphav|m_vbetav|m_dD|m_vHY,m_claglamb,m_c_in_mean,m_v_in_mean);	
		else if (m_cFilter == 21)
			temp = FIEGARCH_in_mean(m_vY, XB_mean, m_cAR|m_cMA, m_vAR_MA, m_cARFI, m_dARFI, sm, m_cP,m_cQ, m_valphav|m_vbetav|m_vtheta1|m_vtheta2|m_dD,m_claglamb,Cst,m_c_in_mean,m_v_in_mean);	
		else if	(m_cFilter == 12)
			temp = FIGARCH_Chung_in_mean(m_vY, XB_mean, m_cAR|m_cMA, m_vAR_MA, m_cARFI, m_dARFI, sm, m_cP,m_cQ, m_valphav|m_vbetav|m_dD,m_c_in_mean,m_v_in_mean);	
		else if (m_cFilter == 41)
			temp = FIAPARCH_BBM_in_mean(m_vY, XB_mean, m_cAR|m_cMA, m_vAR_MA, m_cARFI, m_dARFI, sm, m_cP,m_cQ, m_valphav|m_vbetav|m_dD|m_vgamma|m_ddelta,m_claglamb,m_c_in_mean,m_v_in_mean);	
		else if (m_cFilter == 42)
			temp = FIAPARCH_Chung_in_mean(m_vY, XB_mean, m_cAR|m_cMA, m_vAR_MA, m_cARFI, m_dARFI, sm, m_cP,m_cQ, m_valphav|m_vbetav|m_dD|m_vgamma|m_ddelta,m_c_in_mean,m_v_in_mean);	

		m_vE = temp[][0];
		m_vSigma2 = temp[][1];						
	}
	

	n = rows(m_vSigma2); 
	zz = m_vSigma2 .> 0.00001 * ones(n,1); 
	m_vSigma2 = zz .* m_vSigma2 - (zz - 1.0) * 0.00001; 
	m_cNeg = sumc(1 - zz);

	return 1;
}


/*----------------------------/////////////--------------------------------*/ 
/*---------------------------// FILTERS //---------------------------------*/ 
/*--------------------------/////////////----------------------------------*/ 
 
Garch::shape(const z,const m,const r) 
/* y=_shape(<10;11;12;13;14;15>,2,1) 
	0.00000 0.00000  
	0.00000 0.00000  
	10.00000 11.00000  
	11.00000 12.00000  
	12.00000 13.00000 */  
{ 
   decl y,n,v,zz,cv,i; 
   n = sizer(z) - m - 1; 
   y = zeros(sizer(z),m); 
 
   if (r == 1) 
       v = range(1,m) + range(0,n)'; 
   else 
       v = range(m,1) + range(0,n)'; 
 
   y[m:sizer(z)-1][] = reshape(z[--v],n+1,m); 
   return y; 
} 

//Nincs megvaltoztatva
Garch::Garch_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_garch, const in_mean_type, const in_mean)
/*
**  Purpose: Garch-in-mean (p,q) Filter
**
**  Input  : y = Y_t(T x 1)
**           Xb_mean  = b'X in the cond. mean eq. (Tx1)
**			 ARMA_orders = AR|MA orders (2x1)
**			 ARMA_coef = AR|MA paremeters (AR+MA x 1)
**			 ARFIMA = 1 if ARFIMA, 0 otherwize
**           d_arfima = ARFIMA parameter (important if ARFIMA=1)
**           Xb_var = b'X in the cond. var. eq. (Tx1) 
**			 p = GARCH order 
**           q = ARCH order 
**			 par_garch = ARCH coefficients | GARCH coefficients	 => (p+q) x 1 vector.
**           in_mean_type = 1 to add the cond. var. in the cond. mean, 2 to add the cond. std.
**			 in_mean = ARCH-in-mean parameter (scalar)
**
**  Output : res~Sigma_sq = residuals and conditional variance (T x 2)
*/
{
	decl i,j,k,betaconst;
	decl n = rows(y);				
	decl sigma_sq = new matrix[n][1]; 
	decl res = new matrix[n][1];
	decl cond_mean = zeros(n,1);
	decl cst = new matrix[n][1];
	decl esqr = new matrix[n][1];
	decl maxpq = limits(p|q)[1];
	decl nxt=0,a,b,AR_coef,MA_coef,ck;

	// ARMA
	decl AR=ARMA_orders[0];
	decl MA=ARMA_orders[1];
	if (AR>0)	AR_coef=ARMA_coef[0:AR-1];
	if (MA>0)	MA_coef=ARMA_coef[AR:];
	
	if (q>0)
	{
		a=par_garch[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b=par_garch[nxt:nxt+p-1][0];
		nxt += p;
	}
	
	if (ARFIMA != 0)
		ck = diffpow(1 | zeros(n - 1,1),d_arfima)';
		
	// To initialize the GARCH process
	decl e = y-Xb_mean;  									 
	if (sumc(ARMA_orders) != 0) e = arma0(e,ARMA_coef',ARMA_orders[0],ARMA_orders[1]); 
	if (ARFIMA) e = diffpow(e,d_arfima); 
	esqr = e.^2;
    sigma_sq[0:maxpq-1][0] = ones(maxpq,1)*meanc(esqr);	 // h_t^2 (t=1...p) = E(eps_t^2)

	for (i=0; i< maxpq; i++)
    {
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*sigma_sq[i][0];		  // add the variance in the conditional mean
		else
			cst[i]+=in_mean*sqrt(sigma_sq[i][0]); // add the std in the conditional mean
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]=-reverser(ck[][1:i])*res[0:i-1]; 
		}
		esqr[i]=res[i].^2;	
	}

	for (i=maxpq; i< n; i++)
    {
// GARCH BEGIN			
		sigma_sq[i][0] = Xb_var[i];
       	for(j=0;j<q;j++)
			sigma_sq[i][0] += (a[j][0] * esqr[i-j-1][0]); 	  // + a(L)eps_t^2
		for(j=0; j<p;j++)
			sigma_sq[i][0] += (b[j][0] * sigma_sq[i-j-1][0]); // + b(L)h_t^2
// GARCH END		
									// Computes the conditional mean
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*sigma_sq[i][0];
		else
			cst[i]+=in_mean*sqrt(sigma_sq[i][0]);
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]+=reverser(ck[][1:i])*(y[0:i-1]-cond_mean[0:i-1]); 
		}
		esqr[i]=res[i]^2;	
	}
    return res~sigma_sq;
}

//Nincs megvaltoztatva
Garch::GJR_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_gjr, const in_mean_type, const in_mean)
/*
**  Purpose: GJR-in-mean (p,q) Filter
**
**  Input  : y = Y_t(T x 1)
**           Xb_mean  = b'X in the cond. mean eq. (Tx1)
**			 ARMA_orders = AR|MA orders (2x1)
**			 ARMA_coef = AR|MA paremeters (AR+MA x 1)
**			 ARFIMA = 1 if ARFIMA, 0 otherwize
**           d_arfima = ARFIMA parameter (important if ARFIMA=1)
**           Xb_var = b'X in the cond. var. eq. (Tx1) 
**			 p = GARCH order 
**           q = ARCH order 
**			 par_gjr = ARCH coefficients | GARCH coefficients | leverage  => (p+q+q) x 1 vector.
**           in_mean_type = 1 to add the cond. var. in the cond. mean, 2 to add the cond. std.
**			 in_mean = ARCH-in-mean parameter (scalar)
**
**  Output : res~Sigma_sq = residuals and conditional variance (T x 2)
*/
{
	decl i,j,k,betaconst;
	decl n = rows(y);				
	decl sigma_sq = new matrix[n][1]; 
	decl res = new matrix[n][1];
	decl cond_mean = zeros(n,1);
	decl cst = new matrix[n][1];
	decl esqr = new matrix[n][1];
	decl eps_neg = new matrix[n][1];
	decl maxpq = limits(p|q)[1];
	decl nxt=0,a,b,AR_coef,MA_coef,ck;

	// ARMA
	decl AR=ARMA_orders[0];
	decl MA=ARMA_orders[1];
	if (AR>0)	AR_coef=ARMA_coef[0:AR-1];
	if (MA>0)	MA_coef=ARMA_coef[AR:];
	
	a=par_gjr[nxt:nxt+q-1][0]; nxt += q;
	if (p>0)
	{
		b=par_gjr[nxt:nxt+p-1][0];
		nxt += p;
	}
	decl l = par_gjr[nxt:nxt+q-1][0]; nxt += q; 

	if (ARFIMA != 0)
		ck = diffpow(1 | zeros(n - 1,1),d_arfima)';
		
	// To initialize the GJR process
	decl e = y-Xb_mean;  									 
	if (sumc(ARMA_orders) != 0) e = arma0(e,ARMA_coef',ARMA_orders[0],ARMA_orders[1]); 
	if (ARFIMA) e = diffpow(e,d_arfima); 
	esqr = e.^2;
    sigma_sq[0:maxpq-1][0] = ones(maxpq,1)*meanc(esqr);	 // h_t^2 (t=1...p) = E(eps_t^2)

	for (i=0; i< maxpq; i++)
    {
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*sigma_sq[i][0];		  // add the variance in the conditional mean
		else
			cst[i]+=in_mean*sqrt(sigma_sq[i][0]); // add the std in the conditional mean
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]=-reverser(ck[][1:i])*res[0:i-1]; 
		}
		esqr[i]=res[i].^2;
		eps_neg[i] = res[i].<0; 

	}

	for (i=maxpq; i< n; i++)
    {
// GJR BEGIN			
	   	sigma_sq[i][0] = Xb_var[i];	   
	   	for(j=0;j<q;j++) 
			sigma_sq[i][0] += (a[j][0] * esqr[i-j-1][0] + l[j][0] * eps_neg[i-j-1][0] * esqr[i-j-1][0]); 
	    for(j=0; j<p;j++) 
			sigma_sq[i][0] += (b[j][0] * sigma_sq[i-j-1][0]); 
 // GJR END		
									// Computes the conditional mean
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*sigma_sq[i][0];
		else
			cst[i]+=in_mean*sqrt(sigma_sq[i][0]);
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]+=reverser(ck[][1:i])*(y[0:i-1]-cond_mean[0:i-1]); 
		}
		esqr[i]=res[i]^2;	
		eps_neg[i] = res[i].<0; 
	}
    return res~sigma_sq;
}

//Nincs megvaltoztatva
Garch::APARCH_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_APARCH, const in_mean_type, const in_mean)
/*
**  Purpose: APARCH-in-mean (p,q) Filter
**
**  Input  : y = Y_t(T x 1)
**           Xb_mean  = b'X in the cond. mean eq. (Tx1)
**			 ARMA_orders = AR|MA orders (2x1)
**			 ARMA_coef = AR|MA paremeters (AR+MA x 1)
**			 ARFIMA = 1 if ARFIMA, 0 otherwize
**           d_arfima = ARFIMA parameter (important if ARFIMA=1)
**           Xb_var = b'X in the cond. var. eq. (Tx1) 
**			 p = GARCH order 
**           q = ARCH order 
**			 par_APARCH = ARCH coefficients | GARCH coefficients | leverage coefficients | exponent	 => (p+q+q+1) x 1 vector. 
**           in_mean_type = 1 to add the cond. var. in the cond. mean, 2 to add the cond. std.
**			 in_mean = ARCH-in-mean parameter (scalar)
**
**  Output : res~Sigma_sq = residuals and conditional variance (T x 2)
*/
{
	decl i,j,k,betaconst;
	decl n = rows(y);				
	decl sigma_sq = new matrix[n][1]; 
	decl res = new matrix[n][1];
	decl cond_mean = zeros(n,1);
	decl cst = new matrix[n][1];
	decl esqr, maxpq = limits(p|q)[1];
	decl nxt=0,b,ck,AR_coef,MA_coef;

	// ARMA
	decl AR=ARMA_orders[0];
	decl MA=ARMA_orders[1];
	if (AR>0)	AR_coef=ARMA_coef[0:AR-1];
	if (MA>0)	MA_coef=ARMA_coef[AR:];
	
	decl a=par_APARCH[nxt:nxt+q-1][0]; nxt += q;
	if (p>0)
	{
		b=par_APARCH[nxt:nxt+p-1][0];
		nxt += p;
	}
	decl g = par_APARCH[nxt:nxt+q-1][0]; nxt += q; 
	decl d = par_APARCH[nxt][0]; 
	
	if (ARFIMA != 0)
		ck = diffpow(1 | zeros(n - 1,1),d_arfima)';
		
	// To initialize the APARCH process
	decl e = y-Xb_mean;  									 
	if (sumc(ARMA_orders) != 0) e = arma0(e,ARMA_coef',ARMA_orders[0],ARMA_orders[1]); 
	if (ARFIMA) e = diffpow(e,d_arfima); 
    esqr =(fabs(e[][0]) - g[0][0] * (e[][0])).^d; 
    sigma_sq[0:maxpq-1][0] = ones(maxpq,1)*meanc(esqr);	 // h_t^2 (t=1...p) = E(eps_t^2)

    for (i=0; i< maxpq; i++)
    {
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*(sigma_sq[i][0]^(2/d));
		else
			cst[i]+=in_mean*(sigma_sq[i][0]^(1/d));
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]=-reverser(ck[][1:i])*res[0:i-1]; 
		}
	}

	for (i=maxpq; i< n; i++)
    {
// APARCH BEGIN			
		sigma_sq[i][0] = Xb_var[i];
       	for(j=0;j<q;j++)			   
			sigma_sq[i][0] += (a[j][0] * ( fabs(res[i-j-1]) - (res[i-j-1].*g[j]) ).^ d);  // + sum_i=1^q a_i (|eps_t-i| - g_i*eps_t-i)^d
		for(j=0; j<p;j++)
			sigma_sq[i][0] += (b[j][0] * sigma_sq[i-j-1][0]); // + b(L)h_t^d
// APARCH END		
									// Computes the conditional mean
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*(sigma_sq[i][0]^(2/d));
		else
			cst[i]+=in_mean*(sigma_sq[i][0]^(1/d));
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]+=reverser(ck[][1:i])*(y[0:i-1]-cond_mean[0:i-1]); 
		}
	}
    return res~(sigma_sq.^(2/d));
}

//Nincs megvaltoztatva
Garch::EGARCH_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_EGARCH, const Cst, const in_mean_type, const in_mean)
/*
**  Purpose: EGARCH-in-mean (p,q) Filter
**
**  Input  : y = Y_t(T x 1)
**           Xb_mean  = b'X in the cond. mean eq. (Tx1)
**			 ARMA_orders = AR|MA orders (2x1)
**			 ARMA_coef = AR|MA paremeters (AR+MA x 1)
**			 ARFIMA = 1 if ARFIMA, 0 otherwize
**           d_arfima = ARFIMA parameter (important if ARFIMA=1)
**           Xb_var = b'X in the cond. var. eq. (Tx1) 
**			 p = GARCH order 
**           q = ARCH order 
**			 par_EGARCH = ARCH coefficients | GARCH coefficients | EGARCH coefficients (q*theta1, then q*theta2)  => (q+p+q+q) x 1 vector. 
** 			 Cst = E|z_t| 
**           in_mean_type = 1 to add the cond. var. in the cond. mean, 2 to add the cond. std.
**			 in_mean = ARCH-in-mean parameter (scalar)
**
**  Output : res~Sigma_sq = residuals and conditional variance (T x 2)
*/
{
	decl i,j,k,betaconst;
	decl n = rows(y);				
	decl sigma_sq = new matrix[n][1]; 
	decl res = new matrix[n][1];
	decl cond_mean = zeros(n,1);
	decl cst = new matrix[n][1];
	decl esqr, maxpq = limits(p|q)[1];
	decl nxt=0,G,Z,AR_coef,MA_coef,a,b,ck;

	// ARMA
	decl AR=ARMA_orders[0];
	decl MA=ARMA_orders[1];
	if (AR>0)	AR_coef=ARMA_coef[0:AR-1];
	if (MA>0)	MA_coef=ARMA_coef[AR:];
	
	if (q>0)
	{
		a=par_EGARCH[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b=par_EGARCH[nxt:nxt+p-1][0];
		nxt += p;
	}
	decl th1=par_EGARCH[nxt][0]; ++nxt;  
	decl th2=par_EGARCH[nxt][0]; ++nxt; 
	
	if (ARFIMA != 0)
		ck = diffpow(1 | zeros(n - 1,1),d_arfima)';
		
	if (p>0)	   sigma_sq[0:maxpq-1][0] = (Xb_var[0]*(1-sumc(b)))*ones(maxpq,1); 
	else		   sigma_sq[0:maxpq-1][0] = Xb_var[0]*ones(maxpq,1); 

    for (i=0; i< maxpq; i++)
    {
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*exp(sigma_sq[i][0]);        // add the variance in the conditional mean
		else
			cst[i]+=in_mean*sqrt(exp(sigma_sq[i][0])); // add the std in the conditional mean
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]=-reverser(ck[][1:i])*res[0:i-1]; 
		}
	}

	for (i=maxpq; i< n; i++)
    {
// EGARCH BEGIN			
   		Z = reversec( res[i-q-1:i-1] ./ sqrt(exp(sigma_sq[i-q-1:i-1])) );
		
	    sigma_sq[i][0] = Xb_var[i];	 						 
        G = reversec(th1*Z + th2*( fabs(Z) - Cst ));
	    sigma_sq[i][0] += (1 * G[0][0]); 

	    for(j=0;j<q;j++)								 
        	sigma_sq[i][0] += (a[j][0] * G[j+1][0]); 
  
 	    for(j=0; j<p;j++) 
	   		sigma_sq[i][0] += (b[j][0] * (sigma_sq[i-j-1][0] - Xb_var[i-j-1]));	 
// EGARCH END		
									// Computes the conditional mean
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*exp(sigma_sq[i][0]);
		else
			cst[i]+=in_mean*sqrt(exp(sigma_sq[i][0]));
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]+=reverser(ck[][1:i])*(y[0:i-1]-cond_mean[0:i-1]); 
		}
	}
    return res~exp(sigma_sq);
}

//Nincs megvaltoztatva
Garch::FIGARCH_BBM_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_figarch, const laglamb, const in_mean_type, const in_mean)
/*
**  Purpose: FIGARCH(BBM)-in-mean (p,d,q) Filter
**
**  Input  : y = Y_t(T x 1)
**           Xb_mean  = b'X in the cond. mean eq. (Tx1)
**			 ARMA_orders = AR|MA orders (2x1)
**			 ARMA_coef = AR|MA paremeters (AR+MA x 1)
**			 ARFIMA = 1 if ARFIMA, 0 otherwize
**           d_arfima = ARFIMA parameter (important if ARFIMA=1)
**           Xb_var = b'X in the cond. var. eq. (Tx1) 
**			 p = GARCH order 
**           q = ARCH order 
**			 par_figarch = ARCH coefficients | GARCH coefficients | d | HYGARCH par log(alpha)	=> (p+q+2) x 1 vector.
**           laglamb = number of lags (or truncation) used to calculate the binomial expension 
**			     (Taylor's theorem). Suggested value : 1000 (for large sample). 
**           in_mean_type = 1 to add the cond. var. in the cond. mean, 2 to add the cond. std.
**			 in_mean = ARCH-in-mean parameter (scalar)
**
**  Remark : FIGARCH --> HYGARCH parameter log(alpha) = 0
**  Output : res~Sigma_sq = residuals and conditional variance (T x 2)
*/
{
	decl i,j,betaconst;
	decl n = rows(y);				
	decl sigma_sq = new matrix[n][1]; 
	decl res = new matrix[n][1];
	decl cond_mean = zeros(n,1);
	decl cst = new matrix[n][1];
	decl esqr = new matrix[n][1];
	decl maxpq = limits(p|q)[1];
	decl nxt=0,a,b,AR_coef,MA_coef,ck;

	// ARMA
	decl AR=ARMA_orders[0];
	decl MA=ARMA_orders[1];
	if (AR>0)	AR_coef=ARMA_coef[0:AR-1];
	if (MA>0)	MA_coef=ARMA_coef[AR:];
	
	if (q>0)
	{
		a=par_figarch[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b=par_figarch[nxt:nxt+p-1][0];
		nxt += p;
	}
	decl d=par_figarch[nxt];++nxt;
	decl alp=exp(par_figarch[nxt][0]);++nxt;			                                 
	 	
	if (ARFIMA != 0)
		ck = diffpow(1 | zeros(n - 1,1),d_arfima)';
		
	// To initialize the GARCH process
	decl e = y-Xb_mean;  									 
	if (sumc(ARMA_orders) != 0) e = arma0(e,ARMA_coef',ARMA_orders[0],ARMA_orders[1]); 
	if (ARFIMA) e = diffpow(e,d_arfima); 

	decl e2m=e'*e/n;
    decl nlaglamb=n+laglamb; 
    decl e2=e2m*ones(nlaglamb,1); 
	esqr=e.*e; 

    decl eps=zeros(n,1); 
	decl k=range(1,laglamb)'; 
	decl del=(k-1-d)./k; 
	del=reversec(cumprod(del,1))'; 
	
	for (i=0; i< n; i++)
    {
// FIGARCH BEGIN			
        eps[i][0] = alp*(del*e2[i:i+laglamb-1][0]);
		if (i<p)
			sigma_sq[i][0] = e2m;
		else
		{
			sigma_sq[i][0] = Xb_var[i]-eps[i];
	       	for(j=0;j<q;j++)
				sigma_sq[i][0] += (a[j][0] * esqr[i-j-1][0]) + (a[j][0] * eps[i-j-1][0]); 	  
			for(j=0; j<p;j++)
				sigma_sq[i][0] += (b[j][0] * sigma_sq[i-j-1][0]) - (b[j][0] * esqr[i-j-1][0]);
		}
// FIGARCH END		
									// Computes the conditional mean
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*sigma_sq[i][0];
		else
			cst[i]+=in_mean*sqrt(sigma_sq[i][0]);
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]+=reverser(ck[][1:i])*(y[0:i-1]-cond_mean[0:i-1]); 
		}
		esqr[i]=res[i]^2;	
		e2[i+laglamb]=esqr[i];
	}
    return res~sigma_sq;
}

//Nincs megvaltoztatva
Garch::FIAPARCH_BBM_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_fiaparch, const laglamb, const in_mean_type, const in_mean)
/*
**  Purpose: FIAPARCH(BBM)-in-mean (p,d,q) Filter
**
**  Input  : y = Y_t(T x 1)
**           Xb_mean  = b'X in the cond. mean eq. (Tx1)
**			 ARMA_orders = AR|MA orders (2x1)
**			 ARMA_coef = AR|MA paremeters (AR+MA x 1)
**			 ARFIMA = 1 if ARFIMA, 0 otherwize
**           d_arfima = ARFIMA parameter (important if ARFIMA=1)
**           Xb_var = b'X in the cond. var. eq. (Tx1) 
**			 p = GARCH order 
**           q = ARCH order 
**			 par_fiaparch = ARCH coefficients | GARCH coefficients | d | APARCH asymmetry coefficients | Exponent	=> (p+q+3) x 1 vector.
**           laglamb = number of lags (or truncation) used to calculate the binomial expension 
**			     (Taylor's theorem). Suggested value : 1000 (for large sample). 
**           in_mean_type = 1 to add the cond. var. in the cond. mean, 2 to add the cond. std.
**			 in_mean = ARCH-in-mean parameter (scalar)
**
**  Output : res~Sigma_sq = residuals and conditional variance (T x 2)
*/
{
	decl i,j,betaconst;
	decl n = rows(y);				
	decl sigma_sq = new matrix[n][1]; 
	decl res = new matrix[n][1];
	decl cond_mean = zeros(n,1);
	decl cst = new matrix[n][1];
	decl esqr = new matrix[n][1];
	decl maxpq = limits(p|q)[1];
	decl nxt=0,a,b,AR_coef,MA_coef,ck;

	// ARMA
	decl AR=ARMA_orders[0];
	decl MA=ARMA_orders[1];
	if (AR>0)	AR_coef=ARMA_coef[0:AR-1];
	if (MA>0)	MA_coef=ARMA_coef[AR:];
	
	if (q>0)
	{
		a=par_fiaparch[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b=par_fiaparch[nxt:nxt+p-1][0];
		nxt += p;
	}
	decl d=par_fiaparch[nxt];++nxt;
	decl g=par_fiaparch[nxt:nxt+q-1][0]; ++nxt; 
	decl delta=par_fiaparch[nxt][0]; 
	 	
	if (ARFIMA != 0)
		ck = diffpow(1 | zeros(n - 1,1),d_arfima)';
		
	// To initialize the FIAPARCH process
	decl e = y-Xb_mean;  									 
	if (sumc(ARMA_orders) != 0) e = arma0(e,ARMA_coef',ARMA_orders[0],ARMA_orders[1]); 
	if (ARFIMA) e = diffpow(e,d_arfima); 
	
    esqr=(fabs(e) - g * (e)).^delta; 
 
	decl e2m=meanc(esqr);
    decl nlaglamb=n+laglamb; 
    decl e2=e2m*ones(nlaglamb,1); 

    decl eps=zeros(n,1); 
	decl k=range(1,laglamb)'; 
	decl del=(k-1-d)./k; 
	del=reversec(cumprod(del,1))'; 
	
	for (i=0; i< n; i++)
    {
// FIAPARCH BEGIN			
        eps[i][0] = (del*e2[i:i+laglamb-1][0]);
		if (i<p)
			sigma_sq[i][0] = e2m;
		else
		{
			sigma_sq[i][0] = Xb_var[i]-eps[i];
	       	for(j=0;j<q;j++)
				sigma_sq[i][0] += (a[j][0] * esqr[i-j-1][0]) + (a[j][0] * eps[i-j-1][0]); 	  
			for(j=0; j<p;j++)
				sigma_sq[i][0] += (b[j][0] * sigma_sq[i-j-1][0]) - (b[j][0] * esqr[i-j-1][0]);
		}
// FIAPARCH END		
									// Computes the conditional mean
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*(sigma_sq[i][0]^(2/d));
		else
			cst[i]+=in_mean*(sigma_sq[i][0]^(1/d));
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]+=reverser(ck[][1:i])*(y[0:i-1]-cond_mean[0:i-1]); 
		}
		esqr[i]=(fabs(res[i][0]) - g * (res[i][0])).^delta;	
		e2[i+laglamb]=esqr[i];
	}
    return res~(sigma_sq.^(2/delta));
}

//Nincs megvaltoztatva
Garch::FIGARCH_Chung_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_figarch, const in_mean_type, const in_mean)
/*
**  Purpose: FIGARCH(Chung)-in-mean (p,d,q) Filter
**
**  Input  : y = Y_t(T x 1)
**           Xb_mean  = b'X in the cond. mean eq. (Tx1)
**			 ARMA_orders = AR|MA orders (2x1)
**			 ARMA_coef = AR|MA paremeters (AR+MA x 1)
**			 ARFIMA = 1 if ARFIMA, 0 otherwize
**           d_arfima = ARFIMA parameter (important if ARFIMA=1)
**           Xb_var = b'X in the cond. var. eq. (Tx1) 
**			 p = GARCH order 
**           q = ARCH order 
**			 par_figarch = ARCH coefficients | GARCH coefficients | d => (p+q+1) x 1 vector.
**           in_mean_type = 1 to add the cond. var. in the cond. mean, 2 to add the cond. std.
**			 in_mean = ARCH-in-mean parameter (scalar)
**
**  Output : res~Sigma_sq = residuals and conditional variance (T x 2)
*/
{
	decl i,j,betaconst;
	decl n = rows(y);				
	decl sigma_sq = new matrix[n][1]; 
	decl res = new matrix[n][1];
	decl cond_mean = zeros(n,1);
	decl cst = new matrix[n][1];
	decl esqr = new matrix[n][1];
	decl maxpq = limits(p|q)[1];
	decl nxt=0,a,b,AR_coef,MA_coef,ck;

	// ARMA
	decl AR=ARMA_orders[0];
	decl MA=ARMA_orders[1];
	if (AR>0)	AR_coef=ARMA_coef[0:AR-1];
	if (MA>0)	MA_coef=ARMA_coef[AR:];
	
	if (q>0)
	{
		a=par_figarch[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b=par_figarch[nxt:nxt+p-1][0];
		nxt += p;
	}
	decl d=par_figarch[nxt];++nxt;
	 	
	if (ARFIMA != 0)
		ck = diffpow(1 | zeros(n - 1,1),d_arfima)';
		
	// To initialize the GARCH process
	decl e = y-Xb_mean;  									 
	if (sumc(ARMA_orders) != 0) e = arma0(e,ARMA_coef',ARMA_orders[0],ARMA_orders[1]); 
	if (ARFIMA) e = diffpow(e,d_arfima); 

	esqr=e.*e; 
	decl e2=esqr-Xb_var; 
    decl eps=zeros(n,1); 
 
	decl k=range(1,n)'; 
	decl del=(k-1-d)./k; 
	del=cumprod(del,1)'; 
	
	for (i=0; i< n; i++)
    {
// FIGARCH BEGIN			
		if (i>0)
			eps[i][0] = (reverser(del[0:i-1])*(e2[0:i-1][0])); 
		if (i<p)
			sigma_sq[i][0] = meanc(esqr);
		else
		{
			sigma_sq[i][0] = Xb_var[i]-eps[i];
	       	for(j=0;j<q;j++)
				sigma_sq[i][0] += (a[j][0] * e2[i-j-1][0]) + (a[j][0] * eps[i-j-1][0]); 	  
			for(j=0; j<p;j++)
				sigma_sq[i][0] += (b[j][0] * sigma_sq[i-j-1][0]) - (b[j][0] * esqr[i-j-1][0]); 
		}
// FIGARCH END		
									// Computes the conditional mean
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*sigma_sq[i][0];
		else
			cst[i]+=in_mean*sqrt(sigma_sq[i][0]);
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]+=reverser(ck[][1:i])*(y[0:i-1]-cond_mean[0:i-1]); 
		}
		esqr[i]=res[i]^2;	
		e2[i]=esqr[i]-Xb_var[i];
	}
    return res~sigma_sq;
}

//Nincs megvaltoztatva
Garch::FIAPARCH_Chung_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_fiaparch, const in_mean_type, const in_mean)
/*
**  Purpose: FIAPARCH(Chung)-in-mean (p,d,q) Filter
**
**  Input  : y = Y_t(T x 1)
**           Xb_mean  = b'X in the cond. mean eq. (Tx1)
**			 ARMA_orders = AR|MA orders (2x1)
**			 ARMA_coef = AR|MA paremeters (AR+MA x 1)
**			 ARFIMA = 1 if ARFIMA, 0 otherwize
**           d_arfima = ARFIMA parameter (important if ARFIMA=1)
**           Xb_var = b'X in the cond. var. eq. (Tx1) 
**			 p = GARCH order 
**           q = ARCH order 
**			 par_figarch = ARCH coefficients | GARCH coefficients | d | APARCH asymmetry coefficients | Exponent => (p+q+3) x 1 vector.
**           in_mean_type = 1 to add the cond. var. in the cond. mean, 2 to add the cond. std.
**			 in_mean = ARCH-in-mean parameter (scalar)
**
**  Output : res~Sigma_sq = residuals and conditional variance (T x 2)
*/
{
	decl i,j,betaconst;
	decl n = rows(y);				
	decl sigma_sq = new matrix[n][1]; 
	decl res = new matrix[n][1];
	decl cond_mean = zeros(n,1);
	decl cst = new matrix[n][1];
	decl esqr = new matrix[n][1];
	decl maxpq = limits(p|q)[1];
	decl nxt=0,a,b,AR_coef,MA_coef,ck;

	// ARMA
	decl AR=ARMA_orders[0];
	decl MA=ARMA_orders[1];
	if (AR>0)	AR_coef=ARMA_coef[0:AR-1];
	if (MA>0)	MA_coef=ARMA_coef[AR:];
	
	if (q>0)
	{
		a=par_fiaparch[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b=par_fiaparch[nxt:nxt+p-1][0];
		nxt += p;
	}
	decl d=par_fiaparch[nxt];++nxt;
	decl g=par_fiaparch[nxt:nxt+q-1][0]; ++nxt; 
	decl delta=par_fiaparch[nxt][0]; 
	 	
	if (ARFIMA != 0)
		ck = diffpow(1 | zeros(n - 1,1),d_arfima)';
		
	// To initialize the GARCH process
	decl e = y-Xb_mean;  									 
	if (sumc(ARMA_orders) != 0) e = arma0(e,ARMA_coef',ARMA_orders[0],ARMA_orders[1]); 
	if (ARFIMA) e = diffpow(e,d_arfima); 

    esqr=(fabs(e) - g * (e)).^delta; 
	decl e2=esqr-Xb_var; 
    decl eps=zeros(n,1); 
 
	decl k=range(1,n)'; 
	decl del=(k-1-d)./k; 
	del=cumprod(del,1)'; 
	
	for (i=0; i< n; i++)
    {
// FIGARCH BEGIN			
		if (i>0)
			eps[i][0] = (reverser(del[0:i-1])*(e2[0:i-1][0])); 
		if (i<p)
			sigma_sq[i][0] = meanc(esqr);
		else
		{
			sigma_sq[i][0] = Xb_var[i]-eps[i];
	       	for(j=0;j<q;j++)
				sigma_sq[i][0] += (a[j][0] * e2[i-j-1][0]) + (a[j][0] * eps[i-j-1][0]); 	  
			for(j=0; j<p;j++)
				sigma_sq[i][0] += (b[j][0] * sigma_sq[i-j-1][0]) - (b[j][0] * esqr[i-j-1][0]); 
		}
// FIGARCH END		
									// Computes the conditional mean
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*sigma_sq[i][0];
		else
			cst[i]+=in_mean*sqrt(sigma_sq[i][0]);
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]+=reverser(ck[][1:i])*(y[0:i-1]-cond_mean[0:i-1]); 
		}
		esqr[i]=(fabs(res[i][0]) - g * (res[i][0])).^delta;	
		e2[i]=esqr[i]-Xb_var[i];
	}
    return res~(sigma_sq.^(2/delta));
}

//Nincs megvaltoztatva
Garch::FIEGARCH_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_FIEGARCH, const laglamb, const Cst, const in_mean_type, const in_mean)
/*
**  Purpose: FIEGARCH-in-mean (p,q) Filter
**
**  Input  : y = Y_t(T x 1)
**           Xb_mean  = b'X in the cond. mean eq. (Tx1)
**			 ARMA_orders = AR|MA orders (2x1)
**			 ARMA_coef = AR|MA paremeters (AR+MA x 1)
**			 ARFIMA = 1 if ARFIMA, 0 otherwize
**           d_arfima = ARFIMA parameter (important if ARFIMA=1)
**           Xb_var = b'X in the cond. var. eq. (Tx1) 
**			 p = GARCH order 
**           q = ARCH order 
**			 par_FIEGARCH = ARCH coefficients | GARCH coefficients | EGARCH coefficients (q*theta1, then q*theta2) | Differencing Coefficient (d) => (q+p+q+q+1) x 1 vector. 
**           laglamb = number of lags (or truncation) used to calculate the binomial expension 
**			     (Taylor's theorem). Suggested value : 1000 (for large sample). 
** 			 Cst = E|z_t| 
**           in_mean_type = 1 to add the cond. var. in the cond. mean, 2 to add the cond. std.
**			 in_mean = ARCH-in-mean parameter (scalar)
**
**  Output : res~Sigma_sq = residuals and conditional variance (T x 2)
*/
{
	decl i,j,betaconst;
	decl n = rows(y);				
	decl sigma_sq = new matrix[n][1]; 
	decl res = new matrix[n][1];
	decl cond_mean = zeros(n,1);
	decl cst = new matrix[n][1];
	decl esqr, maxpq = limits(p|q)[1];
	decl nxt=0,AR_coef,MA_coef,a,b,ck;
	decl Z = new matrix[n][1]; 
	decl G = new matrix[n][1]; 
	decl Gd = new matrix[n][1]; 

	// ARMA
	decl AR=ARMA_orders[0];
	decl MA=ARMA_orders[1];
	if (AR>0)	AR_coef=ARMA_coef[0:AR-1];
	if (MA>0)	MA_coef=ARMA_coef[AR:];
	
	if (q>0)
	{
		a=par_FIEGARCH[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b=par_FIEGARCH[nxt:nxt+p-1][0];
		nxt += p;
	}
	decl th1=par_FIEGARCH[nxt][0]; ++nxt;  
	decl th2=par_FIEGARCH[nxt][0]; ++nxt; 
	decl d=par_FIEGARCH[nxt][0]; 

	decl k=range(1,laglamb-1)'; 
	decl del=(k-1+d)./k; 
	del=reversec(1|cumprod(del,1))'; 
	
	if (ARFIMA != 0)
		ck = diffpow(1 | zeros(n - 1,1),d_arfima)';
		
	if (p>0)	   sigma_sq[0:maxpq-1][0] = (Xb_var[0]*(1-sumc(b)))*ones(maxpq,1); 
	else		   sigma_sq[0:maxpq-1][0] = Xb_var[0]*ones(maxpq,1); 

    for (i=0; i< maxpq; i++)
    {
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*exp(sigma_sq[i][0]);        // add the variance in the conditional mean
		else
			cst[i]+=in_mean*sqrt(exp(sigma_sq[i][0])); // add the std in the conditional mean
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]=-reverser(ck[][1:i])*res[0:i-1]; 
		}
	}

    Z[0:maxpq-1] = res[0:maxpq-1] ./ sqrt(exp(sigma_sq[0:maxpq-1]));  	 
    G[0:maxpq-1] = th1*Z[0:maxpq-1] + th2*( fabs(Z[0:maxpq-1]) - Cst ); 
//	Gd[1:maxpq-1] = G[0:maxpq-2];	    
	Gd[0:maxpq-1] = 0;	    
	
	for (i=maxpq; i< n; i++)
    {
// FIEGARCH BEGIN			
    	if (i<laglamb) 
			Gd[i] = del[][0:i-1] * G[0:i-1][0]; 
	    else 
			Gd[i] = del[][0:laglamb-1] * G[i-laglamb:i-1][0]; 
 
	    sigma_sq[i][0] = Xb_var[i];	 					 
        sigma_sq[i][0] += Gd[i];
        for(j=0;j<q;j++)								 
        	sigma_sq[i][0] += (a[j][0] * Gd[i-j-1][0]);   
        for(j=0; j<p;j++) 
        	sigma_sq[i][0] += (b[j][0] * (sigma_sq[i-j-1][0]-Xb_var[i-j-1]));  
// FIEGARCH END		
									// Computes the conditional mean
		cst[i]=Xb_mean[i];
		if (in_mean_type==1)
			cst[i]+=in_mean*exp(sigma_sq[i][0]);
		else
			cst[i]+=in_mean*sqrt(exp(sigma_sq[i][0]));
		cond_mean[i]+=cst[i];
		if (sumc(ARMA_orders) != 0)
		{
			if (i<AR)
				cond_mean[i]=y[i];
			else
			{
				if (AR != 0)
				{
					for(j=0; j<AR;j++)				
						cond_mean[i]+=AR_coef[j]*(y[i-j-1]-cst[i-j-1]);					
				}
				if (MA != 0)
				{
					for(j=0; j<MA;j++)
					{
						if (i-j-1>=0)		
							cond_mean[i]+=MA_coef[j]*(y[i-j-1]-cond_mean[i-j-1]);					
					}
				}
			}
		}
		res[i]=y[i]-cond_mean[i];
		if (ARFIMA != 0)
		{
			if (i>0)
				res[i]+=reverser(ck[][1:i])*(y[0:i-1]-cond_mean[0:i-1]); 
		}
	    Z[i] = res[i][0] / sqrt(exp(sigma_sq[i][0])); 
 
        G[i] = th1*Z[i] + th2*( fabs(Z[i]) - Cst ); 
	}
    return res~exp(sigma_sq);
}


Garch::Garch_Filter(const e, const level, const p, const q, const par) 
/* 
**  Purpose: Garch(p,q) Filter	(Bollerslev, 1986) 
** 
**  Input  : e 		= Residuals (T x 1) 
**           level  = vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order 
**			par		= ARCH coefficients | GARCH coefficients	 => (p+q) x 1 vector. 
** 
**  Output : Sigma2 = Conditional variance (m_cT x 1) 
*/ 
{ 
	decl n = rows(e);				 
	decl sigma_sq = new matrix[n][1];  
	decl esqr, maxpq = limits(p|q)[1]; 
	decl a, b, nxt=0; 
 
	if (q>0)
	{
		a= par[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b= par[nxt:nxt+p-1][0];
		nxt += p;
	}
 
    esqr = e.*e; 
 
	if ((q == 0)&&(p == 0)) 
		sigma_sq = level; 
	else if ((q == 0)&&(p != 0)) 
	   	sigma_sq = cumsum(level, b',meanc(esqr)*ones(maxpq,1)); 
    else if	((q != 0)&&(p == 0)) 
		sigma_sq = level+shape(esqr,q,1)*(reversec(a)); 
	else 
		sigma_sq = cumsum(level+shape(esqr,q,1)*(reversec(a)),b',meanc(esqr)*ones(maxpq,1));
//En irtam fent
	return sigma_sq; 
}

//En irtam
Garch::NM2Garch_Filter(const e, const level1, const level2, const p, const q, const par1, const par2) 
/* 
**  Purpose: NM2-Garch(p,q) Filter	(Bollerslev, 1986) 
** 
**  Input  : e 		= Residuals (T x 1) 
**           leveli  = vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order 
**			pari		= ARCHi coefficients | GARCHi coefficients	 => (p+q) x 1 vector. 
** 
**  Output : Sigma2 = Conditional variance (m_cT x 1) 
*/ 
{ 
	decl n = rows(e);				 
	decl sigma_sq = new matrix[n][2];  
	decl esqr, maxpq = limits(p|q)[1]; 
	decl a1, b1, a2, b2, nxt=0;
	m_p2=1-m_p1;
	m_mu2=-m_p1*m_mu1/m_p2;

	decl level = level1 ~ level2;
 
	if (q>0)
	{
		a1= par1[nxt:nxt+q-1][0];
		a2= par2[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b1= par1[nxt:nxt+p-1][0];
		b2= par2[nxt:nxt+p-1][0];
		nxt += p;
	}
 
    esqr = e.*e; 
 
	if ((q == 0)&&(p == 0)) 
		sigma_sq = level; 
	else if ((q == 0)&&(p != 0)) 
	   	sigma_sq = cumsum(level, (b1')|(b2'), meanc(esqr)*ones(maxpq,2)); 
    else if	((q != 0)&&(p == 0)) 
		sigma_sq = level+ (shape(esqr,q,1)*(reversec(a1))) ~ (shape(esqr,q,1)*(reversec(a2))); 
	else 
		sigma_sq = cumsum(level+((shape(esqr,q,1)*(reversec(a1))) ~ (shape(esqr,q,1)*(reversec(a2))))
				,(b1')|(b2'),meanc(esqr)*ones(maxpq,2));

	m_vSigma2_1= sigma_sq [][0];
	m_vSigma2_2= sigma_sq [][1];
	m_vSigma2= 	m_p1* (m_vSigma2_1 + m_mu1*m_mu1) + (m_p2)*(m_vSigma2_2 + m_mu2*m_mu2);

	return m_vSigma2; 
}

//En irtam
Garch::NM2GJR_Filter(const e, const level1, const level2, const p, const q, const par1, const par2) 
/* 
**  Purpose: NM2GJR(p,q) Filter  (Glosten, Jagannathan and Runkle, 1993) 
** 
**  Input  : e 		= Residuals (T x 1) 
**           level  = vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order 
**			par		= ARCH coefficients | GARCH coefficients | GJR coefficients	 => (q+p+q) x 1 vector. 
** 
**  Output : Sigma2 = Conditional variance (m_cT x 1) 
*/ 
{ 
	decl n = rows(e);				 
	decl sigma_sq = new matrix[n][2];  
	decl esqr, eps_neg, maxpq = limits(p|q)[1]; 
	decl a1, b1, a2, b2, l1, l2, nxt=0;
	m_p2=1-m_p1;
	m_mu2=-m_p1*m_mu1/m_p2;

	decl level = level1 ~ level2;
 
	if (q>0)
	{
		a1= par1[nxt:nxt+q-1][0];  
		a2= par2[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b1= par1[nxt:nxt+p-1][0];
		b2= par2[nxt:nxt+p-1][0];
		nxt += p;
	}

	l1=par1[nxt:][0];
	l2=par2[nxt:][0];
    esqr = e.*e;
	eps_neg = e.<0;
 
	if ((q == 0)&&(p == 0)) 
		sigma_sq = level; 
	else if ((q == 0)&&(p != 0)) 
	   	sigma_sq = cumsum(level, (b1')|(b2'), meanc(esqr)*ones(maxpq,2)); 
    else if	((q != 0)&&(p == 0)) 
		sigma_sq = level+ (shape(esqr,q,1)*(reversec(a1))+ shape(eps_neg.*esqr,q,1)*(reversec(l1))) ~ (shape(esqr,q,1)*(reversec(a2))+ shape(eps_neg.*esqr,q,1)*(reversec(l2))); 
	else 
		sigma_sq = cumsum(level+((shape(esqr,q,1)*(reversec(a1))+ shape(eps_neg.*esqr,q,1)*(reversec(l1))) ~ (shape(esqr,q,1)*(reversec(a2))+ shape(eps_neg.*esqr,q,1)*(reversec(l2))))
				,(b1')|(b2'),meanc(esqr)*ones(maxpq,2));

	m_vSigma2_1= sigma_sq [][0];
	m_vSigma2_2= sigma_sq [][1];
	m_vSigma2= 	m_p1* (m_vSigma2_1 + m_mu1*m_mu1) + m_p2* (m_vSigma2_2 + m_mu2*m_mu2);

	return m_vSigma2; 
}

//En irtam
Garch::NM2AGARCH_Filter(const e, const level1, const level2, const p, const q, const par1, const par2) 
/* 
**  Purpose: NM2-Garch(p,q) Filter	(Bollerslev, 1986) 
** 
**  Input  : e 		= Residuals (T x 1) 
**           leveli  = vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order 
**			pari		= ARCHi coefficients | GARCHi coefficients	 => (p+q) x 1 vector. 
** 
**  Output : Sigma2 = Conditional variance (m_cT x 1) 
*/ 
{ 
	decl n = rows(e);				 
	decl sigma_sq = new matrix[n][2];  
	decl esqr, esqr1, esqr2, maxpq = limits(p|q)[1]; 
	decl a1, b1, l1, l2, a2, b2, nxt=0;
	m_p2=1-m_p1;
	m_mu2=-m_p1*m_mu1/m_p2;

	decl level = level1 ~ level2;
 
	if (q>0)
	{
		a1= par1[nxt:nxt+q-1][0];
		a2= par2[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b1= par1[nxt:nxt+p-1][0];
		b2= par2[nxt:nxt+p-1][0];
		nxt += p;
	}
 
    l1=par1[nxt:][0];
	l2=par2[nxt:][0];
	esqr = e.*e;
	esqr1 = (e-l1).*(e-l1);
	esqr2 = (e-l2).*(e-l2);
 
	if ((q == 0)&&(p == 0)) 
		sigma_sq = level; 
	else if ((q == 0)&&(p != 0)) 
	   	sigma_sq = cumsum(level, (b1')|(b2'), meanc(esqr)*ones(maxpq,2)); 
    else if	((q != 0)&&(p == 0)) 
		sigma_sq = level+ (shape(esqr1,q,1)*(reversec(a1))) ~ (shape(esqr2,q,1)*(reversec(a2))); 
	else 
		sigma_sq = cumsum(level+((shape(esqr1,q,1)*(reversec(a1))) ~ (shape(esqr2,q,1)*(reversec(a2))))
				,(b1')|(b2'),meanc(esqr)*ones(maxpq,2));

	m_vSigma2_1= sigma_sq [][0];
	m_vSigma2_2= sigma_sq [][1];
	m_vSigma2= 	m_p1* (m_vSigma2_1 + m_mu1*m_mu1) + (m_p2)*(m_vSigma2_2 + m_mu2*m_mu2);

	return m_vSigma2;
}

//En irtam
Garch::NM3Garch_Filter(const e, const level1, const level2, const level3, const p, const q, const par1, const par2, const par3) 
/* 
**  Purpose: NM3-Garch(p,q) Filter	(Bollerslev, 1986) 
** 
**  Input  : e 		= Residuals (T x 1) 
**           leveli  = vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order 
**			pari		= ARCHi coefficients | GARCHi coefficients	 => (p+q) x 1 vector. 
** 
**  Output : Sigma2 = Conditional variance (m_cT x 1) 
*/ 
{ 
	decl n = rows(e);				 
	decl sigma_sq = new matrix[n][3];  
	decl esqr, maxpq = limits(p|q)[1]; 
	decl a1, b1, a2, b2, a3, b3, nxt=0;
	m_p3=1-m_p1-m_p2;
	m_mu3=-(m_p1*m_mu1+m_p2*m_mu2)/m_p3;

	decl level = level1 ~ level2 ~ level3;
 
	if (q>0)
	{
		a1= par1[nxt:nxt+q-1][0];
		a2= par2[nxt:nxt+q-1][0];
		a3= par3[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b1= par1[nxt:nxt+p-1][0];
		b2= par2[nxt:nxt+p-1][0];
		b3= par3[nxt:nxt+p-1][0];
		nxt += p;
	}
 
    esqr = e.*e; 
 
	if ((q == 0)&&(p == 0)) 
		sigma_sq = level; 
	else if ((q == 0)&&(p != 0)) 
	   	sigma_sq = cumsum(level, (b1')|(b2')|(b3'), meanc(esqr)*ones(maxpq,3)); 
    else if	((q != 0)&&(p == 0)) 
		sigma_sq = level+ (shape(esqr,q,1)*(reversec(a1))) ~ (shape(esqr,q,1)*(reversec(a2))) ~ (shape(esqr,q,1)*(reversec(a3))); 
	else 
		sigma_sq = cumsum(level+((shape(esqr,q,1)*(reversec(a1))) ~ (shape(esqr,q,1)*(reversec(a2))) ~ (shape(esqr,q,1)*(reversec(a3))))
				,(b1')|(b2')|(b3'),meanc(esqr)*ones(maxpq,3));

	m_vSigma2_1= sigma_sq [][0];
	m_vSigma2_2= sigma_sq [][1];
	m_vSigma2_3= sigma_sq [][2];
	m_vSigma2= 	m_p1* (m_vSigma2_1 + m_mu1*m_mu1) + m_p2*(m_vSigma2_2 + m_mu2*m_mu2) + m_p3*(m_vSigma2_3 + m_mu3*m_mu3);

	return m_vSigma2; 
}

//En irtam
Garch::NM3GJR_Filter(const e, const level1, const level2, const level3, const p, const q, const par1, const par2, const par3) 
/* 
**  Purpose: NM3-Garch(p,q) Filter	(Bollerslev, 1986) 
** 
**  Input  : e 		= Residuals (T x 1) 
**           leveli  = vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order 
**			pari		= ARCHi coefficients | GARCHi coefficients	 => (p+q) x 1 vector. 
** 
**  Output : Sigma2 = Conditional variance (m_cT x 1) 
*/ 
{ 
	decl n = rows(e);				 
	decl sigma_sq = new matrix[n][3];  
	decl esqr, eps_neg, maxpq = limits(p|q)[1]; 
	decl a1, b1, a2, b2, a3, b3, l1, l2, l3, nxt=0;
	m_p3=1-m_p1-m_p2;
	m_mu3=-(m_p1*m_mu1+m_p2*m_mu2)/m_p3;

	decl level = level1 ~ level2 ~ level3;
 
	if (q>0)
	{
		a1= par1[nxt:nxt+q-1][0];
		a2= par2[nxt:nxt+q-1][0];
		a3= par3[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b1= par1[nxt:nxt+p-1][0];
		b2= par2[nxt:nxt+p-1][0];
		b3= par3[nxt:nxt+p-1][0];
		nxt += p;
	}
 
	l1=par1[nxt:][0];
	l2=par2[nxt:][0];
	l3=par3[nxt:][0];
    esqr = e.*e;
	eps_neg = e.<0;
 
	if ((q == 0)&&(p == 0)) 
		sigma_sq = level; 
	else if ((q == 0)&&(p != 0)) 
	   	sigma_sq = cumsum(level, (b1')|(b2')|(b3'), meanc(esqr)*ones(maxpq,3)); 
    else if	((q != 0)&&(p == 0)) 
		sigma_sq = level+ (shape(esqr,q,1)*(reversec(a1))+ shape(eps_neg.*esqr,q,1)*(reversec(l1))) ~ (shape(esqr,q,1)*(reversec(a2))+ shape(eps_neg.*esqr,q,1)*(reversec(l2))) ~ (shape(esqr,q,1)*(reversec(a3))+ shape(eps_neg.*esqr,q,1)*(reversec(l3))); 
	else 
		sigma_sq = cumsum(level+((shape(esqr,q,1)*(reversec(a1))+ shape(eps_neg.*esqr,q,1)*(reversec(l1))) ~ (shape(esqr,q,1)*(reversec(a2))+ shape(eps_neg.*esqr,q,1)*(reversec(l2))) ~ (shape(esqr,q,1)*(reversec(a3))+ shape(eps_neg.*esqr,q,1)*(reversec(l3))))
				,(b1')|(b2')|(b3'),meanc(esqr)*ones(maxpq,3));

	m_vSigma2_1= sigma_sq [][0];
	m_vSigma2_2= sigma_sq [][1];
	m_vSigma2_3= sigma_sq [][2];
	m_vSigma2= 	m_p1* (m_vSigma2_1 + m_mu1*m_mu1) + m_p2*(m_vSigma2_2 + m_mu2*m_mu2) + m_p3*(m_vSigma2_3 + m_mu3*m_mu3);

	return m_vSigma2; 
}

//En irtam
Garch::NM3AGARCH_Filter(const e, const level1, const level2, const level3, const p, const q, const par1, const par2, const par3) 
/* 
**  Purpose: NM3-Garch(p,q) Filter	(Bollerslev, 1986) 
** 
**  Input  : e 		= Residuals (T x 1) 
**           leveli  = vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order 
**			pari		= ARCHi coefficients | GARCHi coefficients	 => (p+q) x 1 vector. 
** 
**  Output : Sigma2 = Conditional variance (m_cT x 1) 
*/ 
{ 
	decl n = rows(e);				 
	decl sigma_sq = new matrix[n][3];  
	decl esqr, esqr1, esqr2, esqr3, maxpq = limits(p|q)[1]; 
	decl a1, b1, a2, b2, a3, b3, l1, l2, l3, nxt=0;
	m_p3=1-m_p1-m_p2;
	m_mu3=-(m_p1*m_mu1+m_p2*m_mu2)/m_p3;

	decl level = level1 ~ level2 ~ level3;
 
	if (q>0)
	{
		a1= par1[nxt:nxt+q-1][0];
		a2= par2[nxt:nxt+q-1][0];
		a3= par3[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b1= par1[nxt:nxt+p-1][0];
		b2= par2[nxt:nxt+p-1][0];
		b3= par3[nxt:nxt+p-1][0];
		nxt += p;
	}
 
    l1=par1[nxt:][0];
	l2=par2[nxt:][0];
	l3=par3[nxt:][0];
	esqr = e.*e;
	esqr1 = (e-l1).*(e-l1);
	esqr2 = (e-l2).*(e-l2);
	esqr3 = (e-l3).*(e-l3);
 
	if ((q == 0)&&(p == 0)) 
		sigma_sq = level; 
	else if ((q == 0)&&(p != 0)) 
	   	sigma_sq = cumsum(level, (b1')|(b2')|(b3'), meanc(esqr)*ones(maxpq,3)); 
    else if	((q != 0)&&(p == 0)) 
		sigma_sq = level+ (shape(esqr1,q,1)*(reversec(a1))) ~ (shape(esqr2,q,1)*(reversec(a2))) ~ (shape(esqr3,q,1)*(reversec(a3))); 
	else 
		sigma_sq = cumsum(level+((shape(esqr1,q,1)*(reversec(a1))) ~ (shape(esqr2,q,1)*(reversec(a2))) ~ (shape(esqr3,q,1)*(reversec(a3))))
				,(b1')|(b2')|(b3'),meanc(esqr)*ones(maxpq,3));

	m_vSigma2_1= sigma_sq [][0];
	m_vSigma2_2= sigma_sq [][1];
	m_vSigma2_3= sigma_sq [][2];
	m_vSigma2= 	m_p1* (m_vSigma2_1 + m_mu1*m_mu1) + m_p2*(m_vSigma2_2 + m_mu2*m_mu2) + m_p3*(m_vSigma2_3 + m_mu3*m_mu3);

	return m_vSigma2; 
}

 
Garch::Figarch_BBM(const e, const level, const p, const q, const laglamb, const par) 
/* 
**  Purpose: FIGARCH(p,d,q) Filter with the Baillie, Bollerslev & Mikkelsen (1996) method 
** 
**  Input  : e 		= residuals (m_cT x 1) 
**           level 	= vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order  
**           laglamb = number of lags (or truncation) used to calculate the binomial expension 
**			     (Taylor's theorem). Suggested value : 1000 (for large sample). 
**			 par		= ARCH coefficients | GARCH coefficients | Differencing coefficient (d)| HYGARCH log(alpha) => (p+q+2) x 1 vector. 
** 
** 
**  Remark : FIGARCH --> HYGARCH parameter log(alpha) = 0
**  Output : sigma_sq = Conditional variance (m_cT x 1) 
**           Note if alpha = 1 --> HYGARCH = FIGARCH 
*/ 
{  
    decl i, j, del, lamb,lam1,lambcor,e2m,nlaglamb,e2,eps,esqr,k; 
    decl n = rows(e);           
                      
    decl sigma_sq = new matrix[n][1]; 
    decl maxpq = limits(p|q)[1]; 
	decl a, b, d, alp; 
 
	decl nxt=0; 
	 
	if (q>0)
	{
		a=par[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b=par[nxt:nxt+p-1][0];
		nxt += p;
	}
	d=par[nxt][0];++nxt; 
	alp=exp(par[nxt][0]);++nxt;			                                 
	 
	e2m=e'*e/n; 
    nlaglamb=n+laglamb; 
    e2=e2m*ones(nlaglamb,1); 
	esqr=e.*e; 
    e2[laglamb:nlaglamb-1][0]=esqr; 
    eps=zeros(n,1); 
 
	k=range(1,laglamb)'; 
	del=(k-1-d)./k; 
	del=reversec(cumprod(del,1))'; 
 
    for (i=0; i<n; i++) 
         eps[i][0] = alp*(del*e2[i:i+laglamb-1][0]);				     
	if ((q == 0)&&(p == 0)) 
		sigma_sq = level-eps; 
	else if ((q == 0)&&(p != 0)) 
		sigma_sq = cumsum(level-eps-shape(esqr,p,1)*(reversec(b)), b',meanc(esqr)*ones(maxpq,1)); 
	else if ((q != 0)&&(p == 0)) 
		sigma_sq = level-eps+shape(eps,q,1)*(reversec(a))+shape(esqr,q,1)*(reversec(a)); 
	else 
		sigma_sq = cumsum(level-eps+shape(eps,q,1)*(reversec(a))+shape(esqr,q,1)*(reversec(a))-shape(esqr,p,1)*(reversec(b)),b',meanc(esqr)*ones(maxpq,1)); 
					    
    return sigma_sq;                  
}  
 
Garch::Figarch_Chung(const e, const level, const p, const q, const par)							 // GARCH 3.0 
/* 
**  Purpose: FIGARCH(p,d,q) Filter with the Baillie, Bollerslev & Mikkelsen (1996) method 
** 
**  Input  : e 		= residuals (m_cT x 1) 
**           level 	= vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order  
**           laglamb = number of lags (or truncation) used to calculate the binomial expension 
**			     (Taylor's theorem). Suggested value : 1000 (for large sample). 
**			 par		= ARCH coefficients | GARCH coefficients | Differencing coefficient ('d') => (p+q+1) x 1 vector. 
** 
** 
**  Output : sigma_sq = Conditional variance (m_cT x 1) 
*/ 
{  
    decl i, j, del,e2,eps,esqr,k; 
    decl n = rows(e);                    
    decl sigma_sq = new matrix[n][1]; 
    decl maxpq = limits(p|q)[1]; 
	decl a, b, d; 
	decl laglamb=rows(e); 
	decl nxt=0; 
	 
	if (q>0)
	{
		a=par[nxt:nxt+q-1][0];
		++nxt;
	}
	if (p>0)
	{
		b=par[nxt:nxt+p-1][0];
		++nxt;
	}
	d=par[q+p][0]; 
 
	esqr=e.*e; 
	e2=esqr-level; 
    eps=zeros(n,1); 
 
	k=range(1,laglamb)'; 
	del=(k-1-d)./k; 
	del=cumprod(del,1)'; 
    for (i=1; i<n; i++) 
		eps[i][0] = (reverser(del[0:i-1])*(e2[0:i-1][0])); 
	if ((q == 0)&&(p == 0)) 
		sigma_sq = level-eps; 
	else if ((q == 0)&&(p != 0)) 
		sigma_sq = cumsum(level-eps-shape(esqr,p,1)*(reversec(b)), b',meanc(esqr)*ones(maxpq,1)); 
	else if ((q != 0)&&(p == 0)) 
		sigma_sq = level-eps+shape(eps,q,1)*(reversec(a))+shape(e2,q,1)*(reversec(a)); 
	else 
		sigma_sq = cumsum(level-eps+shape(eps,q,1)*(reversec(a))+shape(e2,q,1)*(reversec(a))-shape(esqr,p,1)*(reversec(b)),b',meanc(esqr)*ones(maxpq,1)); 
    return sigma_sq;                  
} 

Garch::EGarch(const e, const level, const p, const q, const par, const Cst) 
/* 
**  Purpose: EGARCH(p,d,q) Filter (Nelson, 1991) 
** 
**  Input  : e 		= residuals (m_cT x 1) 
**           level	= vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order  
**			par		= ARCH coefficients | GARCH coefficients | EGARCH coefficient (q*theta1, then q*theta2)  => (q+p+q+q) x 1 vector. 
**			Cst     = E|z_t| 
** 
**  Output : sigma_sq = Conditional variance (m_cT x 1) 
**	Utiliser proc E_abseps												    
*/																		    
{ 
	decl i,j,k; 
	decl n = rows(e);				 
	decl sigma_sq = new matrix[n][1]; 
	decl G,Z,Lambda,t1,t2,h; 
	 
	decl esqr; 
	decl maxpq = (q+1)*((q+1)>p) + p*(p >=(q+1)); 
	decl a, b, th1, th2,nxt=0; 
 
	if (q>0)
	{
		a=par[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b=par[nxt:nxt+p-1][0];
		nxt += p;
	}
	th1=par[nxt][0]; ++nxt;  
	th2=par[nxt][0]; ++nxt; 
	 
	esqr = e.*e; 
 
	if (p>0)	   sigma_sq[0:maxpq-1][0] = (level[0]*(1-sumc(m_vbetav)))*ones(maxpq,1); 
	else		   sigma_sq[0:maxpq-1][0] = level[0]*ones(maxpq,1); 

	for (i=maxpq; i< n; i++) 
    {
   		Z = reversec( e[i-q-1:i-1] ./ sqrt(exp(sigma_sq[i-q-1:i-1])) );
		
	    sigma_sq[i][0] = level[i];	 						 
        G = reversec(th1*Z + th2*( fabs(Z) - Cst ));
	    sigma_sq[i][0] += (1 * G[0][0]); 

	    for(j=0;j<q;j++)								 
        	sigma_sq[i][0] += (a[j][0] * G[j+1][0]); 
  
 	    for(j=0; j<p;j++) 
	   		sigma_sq[i][0] += (b[j][0] * (sigma_sq[i-j-1][0] - level[i-j-1]));	 
	} 
	return exp(sigma_sq); 
} 
 
Garch::FIEGarch(const e, const level, const p, const q, const par,const laglamb, const Cst) 
/* 
**  Purpose: FIEGARCH(p,d,q) filter (Bollerslev and Mikkelsen, 1996) 
** 
**  Input  : e 		= residuals (m_cT x 1) 
**           level	= vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order  
**			par		= ARCH coefficients | GARCH coefficients | EGARCH coefficients (q*theta1, then q*theta2) | Differencing Coefficient (d) => (q+p+q+q+1) x 1 vector. 
**          laglamb = number of lags (or truncation) used to calculate the binomial expension 
**			     (Taylor's theorem). Suggested value : 1000 (for large sample). 
**			Cst     = E|z_t| 
** 
**  Output : sigma_sq = Conditional variance (m_cT x 1) 
*/ 
{ 
	decl i,j,k,t1,t2,h; 
	decl n = rows(e);				 
	decl sigma_sq = new matrix[n][1]; 
	decl Z = new matrix[n][1]; 
	decl G = new matrix[n][1]; 
	decl Gd = new matrix[n][1]; 
	decl esqr = e.*e; 
	decl maxpq = (q+1)*((q+1)>p) + p*(p >=(q+1)); 
	decl del = new matrix[laglamb][1]; 
	decl a, b, nxt=0; 
 
	if (q>0)
	{
		a=par[nxt:nxt+q-1][0];
		nxt += q;
	}
	if (p>0)
	{
		b=par[nxt:nxt+p-1][0];
		nxt += p;
	}
	decl th1=par[nxt][0]; ++nxt;  
	decl th2=par[nxt][0]; ++nxt; 
	decl d=par[nxt][0]; 
	 
	k=range(1,laglamb-1)'; 
	del=(k-1+d)./k; 
	del=reversec(1|cumprod(del,1))'; 
 
	if (p>0) 
        sigma_sq[0:maxpq-1][0] = (level[0]*(1-sumc(b)))*ones(maxpq,1); 
	else 
	{ 
	    b=0; 
		sigma_sq[0:maxpq-1][0] = level[0]*ones(maxpq,1); 
	} 
    Z[0:maxpq-1] = e[0:maxpq-1] ./ sqrt(exp(sigma_sq[0:maxpq-1])); 
 	 
    G[0:maxpq-1] = th1*Z[0:maxpq-1] + th2*( fabs(Z[0:maxpq-1]) - Cst ); 
//	Gd[1:maxpq-1] = G[0:maxpq-2];	    
	Gd[0:maxpq-1] = 0;	    
 
	for (i=maxpq; i< n; i++) 
	{ 
    	if (i<laglamb) 
			Gd[i] = del[][0:i-1] * G[0:i-1][0]; 
	    else 
			Gd[i] = del[][0:laglamb-1] * G[i-laglamb:i-1][0]; 
 
	    sigma_sq[i][0] = level[i];	 					 
        sigma_sq[i][0] += Gd[i];
        for(j=0;j<q;j++)								 
        	sigma_sq[i][0] += (a[j][0] * Gd[i-j-1][0]);   
        for(j=0; j<p;j++) 
        	sigma_sq[i][0] += (b[j][0] * (sigma_sq[i-j-1][0]-level[i-j-1])); 
 
	    Z[i] = e[i][0] / sqrt(exp(sigma_sq[i][0])); 
 
        G[i] = th1*Z[i] + th2*( fabs(Z[i]) - Cst ); 
    } 
 
	return exp(sigma_sq); 
} 
 
Garch::GJR_Filter(const e, const level, const p, const q, const par) 
/* 
**  Purpose: GJR(p,q) Filter  (Glosten, Jagannathan and Runkle, 1993) 
** 
**  Input  : e 		= Residuals (T x 1) 
**           level  = vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order 
**			par		= ARCH coefficients | GARCH coefficients | GJR coefficients	 => (q+p+q) x 1 vector. 
** 
**  Output : Sigma2 = Conditional variance (m_cT x 1) 
*/ 
{ 
	decl i,j; 
	decl n = rows(e);				 
	decl sigma_sq = new matrix[n][1];  
	decl esqr,eps_neg, maxpq = limits(p|q)[1]; 
	decl a, b , l,nxt=0; 

	a=par[nxt:nxt+q-1][0]; nxt += q;				    
	if (p>0)
	{
		b=par[nxt:nxt+p-1][0];
		nxt += p;
	}
	l=par[nxt:][0]; 
	esqr = e.*e; 
	eps_neg = e.<0; 
	 
	if	((q != 0)&&(p == 0)) 
		sigma_sq = level+shape(esqr,q,1)*(reversec(a)) + shape(eps_neg.*esqr,q,1)*(reversec(l)); 
	else 
		sigma_sq = cumsum(level+shape(esqr,q,1)*(reversec(a))+ shape(eps_neg.*esqr,q,1)*(reversec(l)),b',meanc(esqr)*ones(maxpq,1)); 
 
	return sigma_sq;	 
} 

//En irtam
Garch::AGARCH_Filter(const e, const level, const p, const q, const par) 
{ 
	decl i,j; 
	decl n = rows(e);				 
	decl sigma_sq = new matrix[n][1];
	decl esqr, esqr1, maxpq = limits(p|q)[1]; 
	decl a, b , l,nxt=0; 

	a=par[nxt:nxt+q-1][0]; nxt += q;				    
	if (p>0)
	{
		b=par[nxt:nxt+p-1][0];
		nxt += p;
	}
	l=par[nxt:][0];
	esqr = e.*e;
	esqr1 = (e-l).*(e-l); 
	 
	if	((q != 0)&&(p == 0)) 
		sigma_sq = level+shape(esqr1,q,1)*(reversec(a)); 
	else 
		sigma_sq = cumsum(level+shape(esqr1,q,1)*(reversec(a)),b',meanc(esqr)*ones(maxpq,1)); 
 
	return sigma_sq;	 
} 

Garch::AParch(const e, const level, const p, const q, const par) 
/* 
**  Purpose: APARCH(p,q) Filter  (Ding et al., 1993) 
** 
**  Input  : e 		= Residuals (T x 1) 
**           level  = vector of independent variables  
**               	--> ones(t,1) if cst  
**                   	ones(t,1) + b'X if explanatory variables in the variance eq. 
**			 p 		= GARCH order  
**           q 		= ARCH order 
**			par		= ARCH coefficients | GARCH coefficients | APARCH asymmetry coefficients | APARCH's Delta	 => (q+p+q+1) x 1 vector. 
** 
**  Output : Sigma2 = Conditional variance (m_cT x 1) 
*/ 
{  
    decl n = rows(e),j,x;           
    decl func = new matrix[n][q]; 
    decl sigma = new matrix[n][1]; 
    decl sigma_sq; 
    decl esqr, maxpq = limits(p|q)[1]; 
	decl a, b, g, d,nxt=0; 
 
	a=par[nxt:nxt+q-1][0]; nxt += q; 
	if (p>0)
	{
		b=par[nxt:nxt+p-1][0];
		nxt += p;
	}
	g=par[nxt:nxt+q-1][0]; nxt += q; 
	d=par[nxt][0]; 
	 
    esqr =(fabs(e[][0]) - g[0][0] * (e[][0])).^d; 
 
    for(j=0;j<q;j++) 
    { 
       x = shape(e,q,1)[][j]; 
       func[][j] = ( fabs(x) - (x.*g[q-1-j]) ).^ d;
    } 
    func[0:maxpq-1][]=meanc(esqr)*ones(maxpq,q); 
	 
	if (p == 0) 
       sigma = level+func*(reversec(a)); 
    else 
       sigma = cumsum(level+func*(reversec(a)),b',meanc(esqr)*ones(maxpq,1)); 
 
    return sigma.^(2/m_ddelta); 
} 
	 
/*--------------------------///////////////------------------------------*/ 
/*-------------------------// FORECASTS //-------------------------------*/ 
/*------------------------///////////////--------------------------------*/ 

//Nincsenek megvaltoztatva
Garch::FORECASTING()  
{
	Res_Var();						
	
	decl y_f = new matrix[m_cTforc][1]; 
    decl h_f = new matrix[m_cTforc][1]; 
    decl i,mx; 
    decl mxf=GetXBetaForc(m_cTforc);        	 
    decl mxf_h=GetZBetaForc(m_cTforc);  		  
    decl myact=GetForcData(Y_VAR,m_cTforc); 	 
	decl mhact=GetForcData(O_VAR,m_cTforc); 	  
	m_calpha0=m_calpha0/10^m_cYsmall;
	decl level_forc=GetXB(m_mXM|mxf,m_cT+m_cTforc);  
    decl level_forc_h=GetZB(m_mXV|mxf_h,m_cT+m_cTforc);  
	decl Cst, prob_neg, ki;   
																					   
	if (m_cDist==3)	prob_neg=1/(1+exp(m_cA)^2);								 
	else 			prob_neg=0.5;											
 
	if ((m_cFilter==2)||(m_cFilter==21)) 									
		Cst = E_abseps(m_cDist,m_cA|m_cV);  
	 
	if ((m_cFilter==4)||(m_cFilter==41)||(m_cFilter==42))				
		ki = KiAparch(m_cDist,m_cQ, m_cA|m_cV, m_ddelta, m_vgamma);  
		  
	if ((m_cFilter==1)||(m_cFilter==10))  		h_f=FOR_GARCH(m_vE.^2, m_vSigma2,m_cP,m_cQ,m_valphav,m_vbetav,level_forc_h); 
	else if ((m_cFilter==11)||(m_cFilter==51))	h_f=FOR_FIGARCH_BBM(m_vE.^2, m_vSigma2,m_cP,m_cQ, m_dD, m_valphav, m_vbetav, m_vHY, level_forc_h, m_claglamb); 
	else if (m_cFilter==12)	h_f=FOR_FIGARCH_Chung(m_vE.^2, m_vSigma2,m_cP,m_cQ,m_dD, m_valphav, m_vbetav, level_forc_h); 
	else if (m_cFilter==2)	h_f=FOR_EGARCH(m_vE, m_vSigma2,m_cP,m_cQ, m_valphav, m_vbetav, m_vtheta1, m_vtheta2, level_forc_h,Cst); 
	else if (m_cFilter==21)	h_f=FOR_FIEGARCH(m_vE, m_vSigma2, m_cP, m_cQ, m_dD, m_valphav, m_vbetav, m_vtheta1, m_vtheta2, level_forc_h,Cst,m_claglamb); 
	else if (m_cFilter==3)	h_f=FOR_GJR(m_vE, m_vSigma2,m_cP,m_cQ,m_valphav, m_vbetav, m_vleverage,level_forc_h,prob_neg); 
	else if (m_cFilter==4)	h_f=FOR_APARCH(m_vE, m_vSigma2,m_cP,m_cQ,m_valphav,m_vbetav,m_vgamma,m_ddelta,level_forc_h,ki); 
	else if (m_cFilter==41) h_f=FOR_FIAPARCH_BBM(m_vE, m_vSigma2,m_cP,m_cQ, m_dD, m_valphav, m_vbetav, m_vgamma, m_ddelta, level_forc_h, m_claglamb,ki); 
	else if (m_cFilter==42) h_f=FOR_FIAPARCH_Chung(m_vE, m_vSigma2,m_cP,m_cQ, m_dD, m_valphav, m_vbetav, m_vgamma, m_ddelta, level_forc_h,ki); 
	else 					h_f=zeros(m_cTforc,1);	   

	if (m_c_in_mean==1)
		level_forc+=m_v_in_mean*(m_vSigma2|h_f);
	if (m_c_in_mean==2)
		level_forc+=m_v_in_mean*sqrt(m_vSigma2|h_f);
										  
	if (m_cAR+m_cMA+m_cARFI==0)					y_f=level_forc[m_cT:];
	else if ((m_cAR+m_cMA>0)&&(m_cARFI==0))  	y_f=FOR_ARMA(m_vY-level_forc[:m_cT-1],m_cAR,m_cMA,m_vAR_MA',level_forc,m_vE); // Verifier 
	else										y_f=FOR_ARFIMA(m_vY-level_forc[:m_cT-1],m_cAR,m_cMA,m_dARFI,m_vAR_MA',level_forc[m_cT:],m_vE);   
	
	m_mForc = y_f ~ h_f	; 
	if (m_cPrintFor == 1) 
	{ 
		mx = (range(1,m_cTforc,1))' ~ m_mForc; 
		println("");	 
		println("\n  ***************"); 
		println(" ** FORECASTS **");	 
		println("***************"); 
		println("Number of Forecasts: ",m_cTforc);
		println("%c", {"Horizon","Mean", "Variance"},  "%cf", {"%7.0f", "%11.4g", "%11.4g"}, mx); 
		println("---------------"); 
	} 
    return (m_mForc); 
}  
 
Garch::FOR_ARMA(const y_l, const p, const q, const arma, const level_forc, const e)   
/* 
**  Purpose: forecasts from an ARMA(p,q) model as an H x 1 matrix  
** 
**  Format : yf = FOR_ARMA(const y_l, const p, const q, const ar, const ma, const level_forc, const e); 
** 
**  Input  : y_l = y - b*X (T x 1) where X is a matrix of explanatory variables and b the estimated parameter 
**           p = AR order (1 x 1) 
**           q = MA order (1 x 1) 
**           arma = AR coefficients followed by MA coefficients (1 x p+q) 
**           level_forc = b*X_i for i=1, ..., T+H (T+H x 1) 
**			 e = pre-forecast residual values (T x 1) 
** 
**  Output : yf = forecasts from an ARMA(p,q) (H x 1) 
*/ 
{ 
	decl beta_forc,beta_forc2,yf,ar; 
    if (p>0) 
	{ 
	    ar=arma[][0:p-1]'; 
     	beta_forc = level_forc-lag0(level_forc,range(1,p)')*ar;
		beta_forc2 = beta_forc[sizer(y_l):];
	} 
	else 
		beta_forc2 = level_forc[sizer(y_l):];
	
	yf = armaforc(beta_forc2,arma, p, q, y_l+level_forc[:sizer(y_l)-1], e); 
    return (yf); 
} 
 
Garch::FOR_ARFIMA(const y_l, const p, const q, const d, const arma, const level_forc, const e)  
/* 
**  Purpose: forecasts from an ARFIMA(p,d,q) model as an H x 1 matrix  
** 
**  Format : yf = FOR_ARFIMA(const y_l, const p, const q, const ar, const ma, const level_forc, const e); 
** 
**  Input  : y_l = y - b*X (T x 1) where X is a matrix of explanatory variables and b the estimated parameter 
**           p = AR order (1 x 1) 
**           q = MA order (1 x 1) 
**			 d = long memory coefficient (1 x 1) 
**           arma = AR coefficients followed by MA coefficients (1 x p+q) 
**           level_forc = b*X_i for i=1, ..., H (H x 1) 
**			 e = pre-forecast residual values (T x 1) 
** 
**  Output : yf = forecasts from an ARFIMA(p,d,q) (H x 1) 
*/ 
{ 
	decl beta_forc,yf,ar,ck,T,k,i,A,ee,Tforc,yl,yd; 
	ee=e; 
	yl=y_l; 
	T=rows(ee); 
	Tforc=sizer(level_forc); 
	yf=zeros(Tforc,1); 
	ck = diffpow(1 | zeros(T + Tforc - 1,1),d)'; 
	if (p>0) 
		decl yyd=zeros(p,1); 
	for (k = 0; k < p; ++k) 
	{ 
		yyd[k][0]=-reverser(ck[][1:T - k - 1])*yl[0:T-2-k]; 
	} 
	if (p>0) 
	{ 
		yyd[0:k-1]=reversec(yyd[0:k-1][0]); 
		A=yl-(zeros(T-p,1)|yyd); 
	} 
	else 
		A=yl;		 
	for (i = 0; i < Tforc; ++i) 
	{ 
		yd = -reverser(ck[][1:T + i])*yl; 
		yf[i] = armaforc(level_forc[i]+yd, arma, p, q, A, ee); 
		yl |= (yf[i]-level_forc[i]); 
		A|=yf[i]-level_forc[i]-yd; 
		ee|=0; 
	} 	 
    return (yf); 
} 
 
Garch::FOR_GARCH(const esqr, const hh, const p, const q, const alpha, const beta, const level_forc) 
/* 
**  Purpose: forecasts from a Garch(p,q) (H x 1) 
** 
**  Input  : esqr = pre-forecast squared residual values (T x 1) 
**           hh = pre-forecast conditional variances (T x 1) 
**			 p = GARCH order  
**           q = ARCH order 
**           para = GARCH coefficients followed by ARCH coefficients (1 x p+q) 
**           level_forc = b*X_i for i=1, ..., T+H (T+H x 1) 
** 
**  Output : Sigmaf = Forecasted Conditional variance (H x 1) 
**  OK 
*/ 
{ 
	decl k;
	decl j;
	decl T=rows(esqr); 
	decl e2=esqr; 
	decl H = sizer(level_forc)-T;
	decl sigmaf = hh|zeros(H,1); 
	decl maxpq = limits(p|q)[1]; 
	for (k = 0; k < H; ++k) 
    { 
	   	sigmaf[T+k][0] = level_forc[T+k];	 
       	for(j=0;j<q;j++)  
          	sigmaf[T+k][0] += (alpha[j][0] * e2[T+k-j-1][0]);  
 
		for(j=0; j<p;j++)  
			sigmaf[T+k][0] += (beta[j][0] * sigmaf[T+k-j-1][0]);  
 
		e2 |= sigmaf[T+k][0];
	} 
  	return sigmaf[T:T+H-1][];  
}  
  
Garch::FOR_GJR(const e, const hh, const p, const q, const alpha, const beta, const leverage, const level_forc, const prob_neg)	   
/*  
**  Purpose: forecasts from a GJR-GARCH(p,q) (H x 1)  
**  
**  Input  : e = pre-forecast residual values (T x 1)  
**           hh = pre-forecast conditional variances (T x 1)  
**			 p = GARCH order   
**           q = ARCH order  
**           para = GARCH coefficients followed by ARCH and leverage coefficients (1 x p+q*2)  
**           level_forc = b*X_i for i=1, ..., T+H (T+H x 1)  
**			 prob_neg = probability that e < 0 (1 X 1)  
**  
**  Output : Sigmaf = Forecasted Conditional variance (H x 1)  
**  OK, mais vrifier prob_neg dans la partie estimation				      
*/  
{  
	decl i,j;  
	decl T=rows(e);  
	decl e2=e.^2;  
	decl H = sizer(level_forc)-T;  
	decl sigmaf = hh|zeros(H,1);   
	decl maxpq = limits(p|q)[1];  
	decl eps_neg = e.<0;  
	for (i=0; i< H; i++)  
    {  
		sigmaf[T+i][0] = level_forc[T+i];	   
       	for(j=0;j<q;j++)  
          	sigmaf[T+i][0] += (alpha[j][0] * e2[T+i-j-1][0] + leverage[j][0] * eps_neg[T+i-j-1][0] * e2[T+i-j-1][0]);  
  
		for(j=0; j<p;j++)  
			sigmaf[T+i][0] += (beta[j][0] * sigmaf[T+i-j-1][0]);  
  
		e2 |= sigmaf[T+i][0];  
		eps_neg |= prob_neg;			     
	}  
	return sigmaf[T:T+H-1][];  
}  
  
Garch::FOR_APARCH(const ee, const hh, const p, const q, const alpha, const beta, const gamma, const delta, const level_forc, const Ki)	    
/*  
**  Purpose: forecasts from an APARCH(p,q) (H x 1)  
**  
**  Input  : ee = pre-forecast residual values (T x 1)  
**           hh = pre-forecast conditional variances (T x 1)  
**			 p = GARCH order   
**           q = ARCH order  
** 			 alpha = alpha coefficients (q x 1)  
** 			 beta = beta coefficients (p x 1)  
**			 gamma = asymmetry coefficient  
** 			 delta = exponent  
**           level_forc = b*X_i for i=1, ..., T+H (T+H x 1)  
**			 Ki = KIAPARCH output  
**  
**  Output : Sigmaf = Forecasted Conditional variance (H x 1)  
**  OK mais vrifier et Changer aussi KIAPARCH --> partout (meme dans .h)					   
**  Attention, cette procedure rend h^2_t --> vrifier que c'est bon dans prg.  
*/  
{  
	decl i,j;  
	decl T=rows(ee);  
	decl e = ee;  
	decl H = sizer(level_forc)-T;	  
	decl sigmaf = hh.^(delta/2)|zeros(H,1);   
	decl maxpq = limits(p|q)[1];  
	decl G = new matrix[q][1];  
	decl k=0;  
	for (i=0; i< H; i++)  
   	{  
		sigmaf[T+i][0] = level_forc[T+i];  
		if (i<q)  
		{  
			for(j=0;j<q;j++)  
			{  
				if (j>=k)  
					G[j][] = ( fabs(e[T+i-j-1][0]) - (gamma[j][] * e[T+i-j-1][0]) ) .^ delta;  
				else  
					G[j][] = (Ki[j][] * sigmaf[T+i-j-1][0]);  
				sigmaf[T+i][0] += (alpha[j][0] * G[j][]);  
			}	  
		}  
		else  
		{  
			for(j=0; j<q;j++)  
       			sigmaf[T+i][0] += (alpha[j][0] * (Ki[j][] * sigmaf[T+i-j-1][0]) );  
		}  
		for(j=0; j<p;j++)  
			sigmaf[T+i][0] += (beta[j][0] * sigmaf[T+i-j-1][0]);  
		++k;  
	}  
    return sigmaf[T:T+H-1][].^(2/delta);	     
}  
  
Garch::FOR_EGARCH(const e, const hh, const p, const q, const alpha, const beta, const theta1, const theta2, const level, const Cst)	    
/*  
**  Purpose: forecasts from a EGARCH(p,q) (H x 1)  
**  
**  Input  : e = pre-forecast residual values (T x 1)  
**           hh = pre-forecast conditional variances (T x 1)  
**			 p = GARCH order   
**           q = ARCH order  
**           alpha = ARCH coefficients (q x 1)  
**           beta = GARCH coefficients (p x 1)  
**           theta's = EGARCH theta's coefficients (1 x 1)  
**           level = b*X_i for i=T+1,...,T+H (H x 1)  
**			 Cst = E|z_t| (1x1)  
**  
**  Output : Sigmaf = Forecasted Conditional variance (H x 1)  
**  OK  
**  Mais vrifier la cst dans le prg.														     
**  Attention renvoi bien h^2_t  
**  Attention requiert level pour i= 1, ..., T,...,T+H  
**  Ajouter E_abseps(const dist, const par) (+ dans .h) et dans le prg  
**  Attention Il faut mettre des vecteurs vides quand on n'estime pas le par....  OK  
**  Cf par --> student  
*/  
{  
	decl i,j;  
	decl b,t1,t2;  
	decl T=rows(e);  
	decl H = sizer(level)-T;  
	decl sigmaf = log(hh)|zeros(H,1);  
	decl Z = new matrix[q][1];  
	decl G = new matrix[q][1];  
	decl maxpq = limits(p|q)[1];											   
	Z = reversec( e./ sqrt(hh) );	   										    
	G = theta1*Z + theta2*( fabs(Z) - Cst );  
	for (i=0;i<H;i++)  
	{  
		sigmaf[T+i][0] = level[T+i] + G[0][0];  
		  
		for(j=0;j<q;j++)								  
   			sigmaf[T+i][0] += (alpha[j][0] * G[j+1][0]);  
		G = zeros(1,1)|G;  
		  
   		for(j=0; j<p;j++)  
			sigmaf[T+i][0] += beta[j][0] * (sigmaf[T+i-j-1][0]-level[T+i-j-1]);  
	} 			  
	return exp(sigmaf)[T:T+H-1][];  
}  
  
Garch::FOR_FIEGARCH(const e, const hh, const p, const q, const d, const alpha, const beta, const theta1, const theta2, const level, const Cst, const laglamb)    
/*  
**  Purpose: Forecast FIEGARCH(p,d,q) (Baillie and Bollerslev, 1996)  
**  
**  Input  : e 		= residuals (m_cT x 1)  
**           hh = pre-forecast conditional variances (T x 1)  
**			 p 		= GARCH order   
**           q 		= ARCH order  
**           d = d parameter (FI) (1 x 1)  
**           alpha = ARCH coefficients (q x 1)  
**           beta = GARCH coefficients (p x 1)  
**           theta's = EGARCH theta's coefficients (1 x 1)  
**           level = b*X_i for i=1, ..., T,...,T+H (T+H x 1)  
**			 Cst = E|z_t| (1x1)  
**           laglamb = truncation order (1 x 1)  
**  Output : sigma_sq = Forecasted conditional variance (H x 1)	   
**  Attention requiert level pour i= 1, ..., T,...,T+H  
**  Changer le tutorial pour le FIEGARCH  
*/  
{  
	decl i,j;  
	decl b,t1,t2,Gd;  
	decl T=rows(e);  
	decl H = sizer(level)-T;  
	decl sigmaf = log(hh)|zeros(H,1);  
	decl Z = new matrix[q][1];  
	decl G = new matrix[q][1];  
	decl maxpq = limits(p|q)[1];  
	decl del;  
	decl k=range(1,laglamb)';  
	del=(k-1+d)./k;  
	del=(1|cumprod(del,1))';  	  
	Z = e./sqrt(hh);	     
	G = theta1*Z + theta2*( fabs(Z) - Cst );  
	for (i=0;i<H;i++)  
	{  
		sigmaf[T+i][0] = level[T+i];  
		if (q>0)  
			Gd = reversec( G+shape(G,q,1)*(reversec(alpha)) );  
		else  
			Gd = reversec( G );			  
		G |= zeros(1,1);  
		sigmaf[T+i][0] += del[][0:laglamb] * Gd[0:laglamb][];	  
   		for(j=0; j<p;j++)  
			sigmaf[T+i][0] += (beta[j][0] * (sigmaf[T+i-j-1][0]-level[T+i-j-1]));  
	}  
	return exp(sigmaf)[T:T+H-1][];  
}  
  
Garch::FOR_FIGARCH_BBM(const esqr, const hh, const p, const q, const d, const alpha, const beta, const HY, const level_forc, const laglamb)	  
/*  
**  Purpose: forecasts from a FIGARCH(p,q) with BBM's method (H x 1)  
**  
**  Input  : esqr = pre-forecast squared residual values (T x 1)  
**           hh = pre-forecast conditional variances (T x 1)  
** 			 d = FI parameter  
**			 p = GARCH order   
**           q = ARCH order  
**           HY = log(alpha) parameter of the HYGARCH, 0 otherwize  
**           para = d, followed by GARCH coefficients and ARCH coefficients (1 x p+q)  
**           level_forc = b*X_i for i=1, ..., T+H (T+H x 1)  
**           laglamb = truncation order (1 x 1)  
**  
**  Output : Sigmaf = Forecasted Conditional variance (H x 1)						    
**  OK. De plus, donne bien le garch avec phi_1=alpha_1+beta_1 et d=0  
**  Il faudrait peut_etre sortir le calcul de del de la proc  
**  Il faut aussi gnraliser au HYGARCH  
*/  
{   
	decl i,j,k,del,eps_l;  
	decl T=rows(esqr);  
	decl e2=esqr;  
	decl H = sizer(level_forc)-T;  
	decl sigmaf = hh|zeros(H,1);   
	decl eps = zeros(H,1);   
	decl maxpq = limits(p|q)[1];  
	k=range(1,laglamb)';  
	del=(k-1-d)./k;  
	del=reversec(cumprod(del,1))';             
	for (i=0; i<H; i++)  
    {  
       eps[i][0] = exp(HY)*(del*e2[T-laglamb+i:T-1+i][0]);		    
       sigmaf[T+i][0] = level_forc[T+i]-eps[i][0];  
	   if (i<p)  
	   {  
	   	  for(j=0; j<p;j++)  
          	  sigmaf[T+i][0] += beta[j][0] * (sigmaf[T+i-j-1][0] - e2[T+i-j-1][0]);    
	   }  
	   for(j=0;j<q;j++)  
	   {  
	      if (i<q)  
		  {  
		  	 eps_l=exp(HY)*(del*e2[T-laglamb+i-j-1:T-1+i-j-1][0]);			      
             sigmaf[T+i][0] += alpha[j][0] * (e2[T+i-j-1][0] + eps_l);  
		  }  
		  else  
		  	 sigmaf[T+i][0] += alpha[j][0] * (e2[T+i-j-1][0] + eps[i-j-1][0]);  
	   }	  		    
   	   e2 |= sigmaf[T+i][0];      
    }  
    return sigmaf[T:T+H-1][];                  
}  
  
Garch::FOR_FIGARCH_Chung(const esqr, const hh, const p, const q, const d, const alpha, const beta, const level)  
/*  
**  Purpose: forecasts from a FIGARCH(p,q) with Chung's method (H x 1)  
**  
**  Input  : esqr = pre-forecast squared residual values (T x 1)  
**           hh = pre-forecast conditional variances (T x 1)  
**			 p = GARCH order   
**           q = ARCH order  
**           para = d, followed by GARCH coefficients and ARCH coefficients (1 x p+q)  
**           level = b*X_i for i=1, ..., T,...,T+H (T+H x 1)  
**  
**  Output : Sigmaf = Forecasted Conditional variance (H x 1)					    
**  OK  
**  Attention level: i=1, ..., T,...,T+H Verifier que c'est bon.   
*/  
{   
	decl i,j,k,del,eps_l;  
	decl T=rows(esqr);  
	decl e2=esqr;  
	decl H = sizer(level)-T;  
	decl sigmaf = hh|zeros(H,1);   
	decl eps = zeros(H,1);   
	decl maxpq = limits(p|q)[1];  
	     
	k=range(1,T+H-1)';  
	del=(k-1-d)./k;  
	del=cumprod(del,1);  
  
	for (i=0; i<H; i++)  
    {  
       eps[i][0] = reverser(del[0:T+i-1][]')*(e2[0:T+i-1][0]-level[0:T+i-1][0]);  
       sigmaf[T+i][0] = level[T+i]-eps[i][0];  
  
	   for(j=0; j<p;j++)  
       		sigmaf[T+i][0] += beta[j][0] * (sigmaf[T+i-j-1][0]-e2[T+i-j-1][0]); //+level[T+i-j-1][0]   
  
	   for(j=0;j<q;j++)  
	   {  
	      if (i<q)  
		  {  
		  	 eps_l=reverser(del[0:T+i-1-j-1][]')*(e2[0:T+i-1-j-1][0]-level[0:T+i-1-j-1][0]);  
             sigmaf[T+i][0] += alpha[j][0] * (e2[T+i-j-1][0]-level[T+i-j-1][0]+eps_l);  
		  }  
		  else  
		  	 sigmaf[T+i][0] += alpha[j][0] * (e2[T+i-j-1][0]-level[T+i-j-1][0]+eps[i-j-1][0]);  
	   }	  		    
   	   e2 |= sigmaf[T+i][0];      
    }   
    return sigmaf[T:T+H-1][];                  
}  
  
Garch::FOR_FIAPARCH_BBM(const e, const hh, const p, const q, const d, const alpha, const beta, const gamma, const delta, const level_forc, const laglamb, const Ki)	   
/*  
**  Purpose: forecasts from a FIAPARCH(p,d,q) with BBM's method (H x 1)  
**  
**  Input  : e = pre-forecast residual values (T x 1)  
**           hh = pre-forecast conditional variances (T x 1)  
**			 p = GARCH order   
**           q = ARCH order  
**			 d = long-memory parameter  
** 			 alpha = alpha coefficients (q x 1)  
** 			 beta = beta coefficients (p x 1)  
**			 gamma = asymmetry coefficient  
** 			 delta = exponent  
**           level_forc = b*X_i for i=1, ..., T+H (T+H x 1)  
**           laglamb = truncation order (1 x 1)  
**			 Ki = KIAPARCH output  
**  
**  Output : Sigmaf = Forecasted Conditional variance (H x 1)						    
*/  
{   
	decl i,j,k,del,eps_l;  
	decl T=rows(e);  
	decl H = sizer(level_forc)-T;  
	decl sigmaf = hh.^(delta/2)|zeros(H,1);   
	decl eps = zeros(H,1);   
	decl maxpq = limits(p|q)[1];  
	     
	k=range(1,laglamb)';  
	del=(k-1-d)./k;  
	del=reversec(cumprod(del,1))';           
	decl G = ( fabs(e) - (gamma * e) ) .^ delta;  
	  
	for (i=0; i<H; i++)  
    {  
       eps[i][0] = (del*G[T-laglamb+i:T-1+i][0]);		    
       sigmaf[T+i][0] = level_forc[T+i]-eps[i][0];  
  
	   for(j=0; j<p;j++)  
       		sigmaf[T+i][0] += beta[j][0] * (sigmaf[T+i-j-1][0] - G[T+i-j-1][0]);    
  
	   for(j=0;j<q;j++)  
	   {  
	      if (i<q)  
		  {  
		  	 eps_l=(del*G[T-laglamb+i-j-1:T-1+i-j-1][0]);			      
             sigmaf[T+i][0] += alpha[j][0] * (G[T+i-j-1][0] + eps_l);  
		  }  
		  else  
		  	 sigmaf[T+i][0] += alpha[j][0] * (G[T+i-j-1][0] + eps[i-j-1][0]);  
	   }	  		    
   	   G |= Ki*sigmaf[T+i][0];  
    }   
    return sigmaf[T:T+H-1][].^(2/delta);                  
}  
  
Garch::FOR_FIAPARCH_Chung(const e, const hh, const p, const q, const d, const alpha, const beta, const gamma, const delta, const level_forc, const Ki)	   
/*  
**  Purpose: forecasts from a FIAPARCH(p,d,q) with Chung's method (H x 1)  
**  
**  Input  : e = pre-forecast residual values (T x 1)  
**           hh = pre-forecast conditional variances (T x 1)  
**			 p = GARCH order   
**           q = ARCH order  
**			 d = long-memory parameter  
** 			 alpha = alpha coefficients (q x 1)  
** 			 beta = beta coefficients (p x 1)  
**			 gamma = asymmetry coefficient  
** 			 delta = exponent  
**           level_forc = b*X_i for i=1, ..., T,...,T+H (T+H x 1)  
**           laglamb = truncation order (1 x 1)  
**			 Ki = KIAPARCH output  
**  
**  Output : Sigmaf = Forecasted Conditional variance (H x 1)						    
*/  
{   
	decl i,j,k,del,eps_l;  
	decl T=rows(e);  
	decl H = sizer(level_forc)-T;  
	decl sigmaf = hh.^(delta/2)|zeros(H,1);   
	decl eps = zeros(H,1);   
	decl maxpq = limits(p|q)[1];  
  
	k=range(1,T+H-1)';  
	del=(k-1-d)./k;  
	del=cumprod(del,1);  
  
	decl G = ( fabs(e) - (gamma * e) ) .^ delta;  
	  
	for (i=0; i<H; i++)  
    {  
       eps[i][0] = reverser(del[0:T+i-1][]')*(G[0:T+i-1][0]-level_forc[0:T+i-1][0]);  
	   sigmaf[T+i][0] = level_forc[T+i]-eps[i][0];  
  
	   for(j=0; j<p;j++)  
       		sigmaf[T+i][0] += beta[j][0] * (sigmaf[T+i-j-1][0]-G[T+i-j-1][0]);    
  
	   for(j=0;j<q;j++)  
	   {  
	      if (i<q)  
		  {  
		  	 eps_l=reverser(del[0:T+i-1-j-1][]')*(G[0:T+i-1-j-1][0]-level_forc[0:T+i-1-j-1][0]);  
             sigmaf[T+i][0] += alpha[j][0] * (G[T+i-j-1][0]-level_forc[T+i-j-1][0]+eps_l);  
		  }  
		  else  
		  	 sigmaf[T+i][0] += alpha[j][0] * (G[T+i-j-1][0]-level_forc[T+i-j-1][0]+eps[i-j-1][0]);  
	   }	  		    
   	   G |= Ki*sigmaf[T+i][0];  
    }  
    return sigmaf[T:T+H-1][].^(2/delta);                  
} 

Garch::FOR_GRAPHS(const plot, const pre, const type, const valcrit)			
{
	decl y2,i, mf, eb, npv;
	decl year1 = ObsYear(m_iT2est + 1), per1 = ObsPeriod(m_iT2est + 1), freq = GetFrequency();
	i = plot;
	
	y2 = m_vY[m_cT-pre-1:m_cT-1] | m_Yfor;   
	if (sizer(m_mForc) > 0)
	{
		mf = zeros(pre,2) | m_mForc[][0:1];  	
		DrawTMatrix(i, y2'[0][], "Observed Series", ObsYear(m_iT2est-pre+1), ObsPeriod(m_iT2est-pre+1), freq, 0, 14);
		DrawTMatrix(i, mf'[0][], "Forecasted Series", ObsYear(m_iT2est-pre+1), ObsPeriod(m_iT2est-pre+1), freq, 0, 2);
	    eb = sqrt(mf[][1])' * valcrit/2;
	
		if (type == 1) DrawZ(eb, "Z", ZMODE_BAND);
		else if (type == 2)	DrawZ(eb, "Z", ZMODE_BAR);
		else if (type == 3)	DrawZ(eb, "Z", ZMODE_FAN);
		DrawLine(i, m_cT+m_iT1est, -2, m_cT+m_iT1est, 2, 1);
		DrawLine(i++, m_cT-pre+1+m_iT1est, 0, m_cT+m_iT1est, 0, 1);

		DrawTMatrix(i++, m_mForc[][1]', "Var.Forecasts", year1, per1, freq, 0, 3);
	}
} 
 
/*------------------------/////////////////////----------------------------*/ 
/*-----------------------// DENSITY RELATED //-----------------------------*/ 
/*----------------------/////////////////////------------------------------*/ 
 
Garch::GaussLik(const vE, const vSigma2) 		
/* 
**  Purpose: Computes Log-Likelihood function w/ Gaussian distribution 
** 
**  Input  : vE 		= Residuals (m_cT x 1) 
**           vSigma2  	= Conditional variance (m_cT x 1) 
** 
**  Output : Log-Likelihood function (1 x 1) 
*/ 
{ 										
     decl e2; 							
	 e2 = vE.^2; 
	 return ( -0.5*( log(vSigma2) + (e2 ./ vSigma2) ) - 0.5*log(M_2PI) ); 
} 
 
Garch::StudentLik(const vE, const vSigma2, const v) 
/* 
**  Purpose: Computes Log-Likelihood function w/ Student-t distribution 
** 
**  Input  : vE 		= Residuals (m_cT x 1) 
**           vSigma2  	= Conditional variance (m_cT x 1) 
**			 v			= Degrees of freedom (1 x 1) 
** 
**  Output : Log-Likelihood function (1 x 1) 
*/ 
{ 
	decl s = ((v-2.0)/v) * vSigma2; 
	decl e2; 
	e2 = vE .* vE; 
	decl kernel = -0.5 * (v+1) * log(1.0 + ((1.0 / v) * (e2./s))); 
	return (kernel - 0.5*log(s)+ (loggamma((v+1)/2) - loggamma(v/2) - 0.5 * log(M_PI*v))); 
} 
 
Garch::GEDLik(const vE, const vSigma2, const v) 
/* 
**  Purpose: Computes Log-Likelihood function w/ GED distribution 
** 
**  Input  : vE 		= Residuals (m_cT x 1) 
**           vSigma2  	= Conditional variance (m_cT x 1) 
**			 v			= Degrees of freedom (1 x 1) 
** 
**  Output : Log-Likelihood function (1 x 1) 
*/ 
{ 
	decl Logl; 
	decl Lambda = sqrt(((2^(-2/v))*gammafact(1/v))/gammafact(3/v)); 
  
	return log(v) - 0.5*fabs(vE./(Lambda*sqrt(vSigma2))).^v 
	       - (log(Lambda) + (1+1/v)*log(2) + loggamma(1/v)) - .5*log(vSigma2); 
} 
 
Garch::SkStudentLik(const vE, const vSigma2, const s, const v)  
/*   
**  Purpose : Computes a vector of Log-likelihoods based on the Standardized asymetric Student-t distribution 
** 
**  Format  : LogL = SKStudentLik(vE,vSigma2,s,v); 
** 
**  Input   : vE = residuals 
**            vSigma2 = conditional variance 
**            s = log(skewness parameter)  
**            v = Degree of freedom  
** 
**  Output  : LogL = vector of Log-Likelihoods         
*/ 
{ 
	decl g,c,tamp,signe,m,b,vv,g2,g3;   
    g=exp(s); g2=g^2; g3=g^3; 
    c=gammafact((v+1)/2)/(gammafact(v/2)*sqrt(M_PI*(v-2))); 
    b=2/(g+(1/g)); 
	m=b*c*(v-2)*(g2-1/g2)/(v-1); 
	vv=sqrt(((b*(g3+1/g3)/2) - m^2)./vSigma2); 
    signe = (vE .>= -m./vv) - (vE .< -m./vv); 
	tamp = StudentLik((g.^(-signe)).*((vv.*vE)+m), 1,v); 
	return tamp+log(b)+log(vv); 
}

//En irtam
Garch::NM2Lik(const vE, const vSigma2_1, const vSigma2_2, const p, const mu)  
/*   
**  Purpose : Computes a vector of Log-likelihoods based on the Standardized asymetric Student-t distribution
** 
**  Format  : LogL = NM2Lik(vE,vSigma2_1,vSigma2_2,p,mu); 
** 
**  Input   : vE = residuals 
**            vSigma2_1 = conditional variance 1
**			  vSigma2_2 = conditional variance 2
**            p = probability parameter  
**            mu = mu 
** 
**  Output  : LogL = vector of Log-Likelihoods         
*/ 
{ 
	 decl m1_p=1-p;
	 decl mu2= -p*mu/m1_p;
	 decl e2_1, e2_2; 							
	 e2_1 = (vE-mu).^2;
	 e2_2 = (vE-mu2).^2;
	 decl g1 = exp(-e2_1./(2.*vSigma2_1)).*p./sqrt(vSigma2_1);
	 decl g2 = exp(-e2_2./(2.*vSigma2_2)).*m1_p./sqrt(vSigma2_2);
	 return (log(g1+g2)- 0.5*log(M_2PI)); 
}

//En irtam
Garch::NM3Lik(const vE, const vSigma2_1, const vSigma2_2, const vSigma2_3, const p1, const p2, const mu1, const mu2)  
/*   
**  Purpose : Computes a vector of Log-likelihoods based on the Standardized asymetric Student-t distribution
** 
**  Format  : LogL = NM3Lik(vE,vSigma2_1,vSigma2_2,vSigma2_3,p1,p2,mu1,mu2); 
** 
**  Input   : vE = residuals 
**            vSigma2_i = conditional variance i
**			  pi = probability parameteri  
**            mui = mui 
** 
**  Output  : LogL = vector of Log-Likelihoods         
*/ 
{ 
	 decl p3=1-p1-p2;
	 decl mu3= -(p1*mu1+p2*mu2)/p3;
	 decl e2_1, e2_2, e2_3; 							
	 e2_1 = (vE-mu1).^2;
	 e2_2 = (vE-mu2).^2;
	 e2_3 = (vE-mu3).^2;
	 decl g1 = exp(-e2_1./(2.*vSigma2_1)).*p1./sqrt(vSigma2_1);
	 decl g2 = exp(-e2_2./(2.*vSigma2_2)).*p2./sqrt(vSigma2_2);
	 decl g3 = exp(-e2_3./(2.*vSigma2_3)).*p3./sqrt(vSigma2_3);
	 decl s=log(g1+g2+g3)- 0.5*log(M_2PI);
	 //println(p1,"\t",p2,"\t",sumc(s)[0][0]);
	 return (s); 
}
 
//Nincs megvaltoztava
Garch::KiAparch(const dist, const q, const par, const delta, const gamma)			    
/* 
	dist = distribution (0 for normal, 1 Student, 2 GED and 3 SK-Student 
	q = MA order of the APARCH(p,q)	 
	par = asymmetry parameter and/or degree of freedom 
	delta = exponent of the APARCH 
	gamma = leverage effect parameters 
*/ 
{ 
	decl i, t1, nu; 
	decl vKi = new matrix [q][1];	    
	decl t2 = new matrix [q][1];		 
	decl gg1=1; decl gg2=1; 
	if (dist == 0) 
	{ 
		t1 = (1/sqrt(M_2PI))* 2^((delta-1)/2) * gammafact((delta+1)/2); 
	} 
	else if (dist == 1) 
	{ 
		nu=par; 
		t1 = (1/(2*sqrt((nu-2)*M_PI))) * gammafact((delta+1)/2) * gammafact((nu-delta)/2) * (nu - 2)^((1+delta)/2) * (1/gammafact(nu/2)); 
	}							  
	else if (dist == 2) 
	{ 
		nu=par; 
	    decl lambda = sqrt((2^(-2/nu)) * gammafact(1/nu) * (1/gammafact(3/nu))); 
	    t1 = 2^((delta-nu)/nu) * gammafact((delta+1)/nu) * (1/gammafact(1/nu)) * lambda^delta; 
	} 	 
	else if (dist == 3) 
	{ 
	   decl g = exp(par[0]); 
	   nu=par[1]; 
	   gg1=g^(-1-delta); 
	   gg2=g^(1+delta); 
	   t1 = gammafact((delta+1)/2) * gammafact((nu-delta)/2) * (nu - 2)^((1+delta)/2)/(((1/g) + g)*sqrt((nu-2)*M_PI)*gammafact(nu/2)); 
	}																				    

	if (m_cFilter == 4)
	{
		for (i=0; i<q; i++)  
		{ 
				t2[i][] = (((1 + gamma[i][]).^delta)*gg1 + ((1 - gamma[i][]).^delta)*gg2);  
				vKi[i][] = t1 .* t2[i][];
		}
	}
	else													
	{
		t2[0][] = (((1 + gamma).^delta)*gg1 + ((1 - gamma).^delta)*gg2);  
		vKi = t1 .* t2[0][];
	}

	return vKi; 
}	 
 
 
//Nem ertem mit csinal
Garch::E_abseps(const dist, const par)										   
/* 
**  In: 	dist = distrinution (0 for normal, 1 Student, 2 GED, 3 SK-Student, 4 NM 
**			par = asymmetry parameter and/or degree of freedom 
**  Out: 	Cst 
*/ 
{ 
	decl Cst,nu; 
	if (dist==0) 
	    Cst = sqrt(2/M_PI); 
	else if (dist==1) 
	{ 
		nu=par; 
		Cst = 2*sqrt(nu-2)*exp(loggamma((nu+1)/2)/((nu-1)*exp(loggamma(nu/2)))); 
	} 
	else if (dist==2) 
	{ 
		nu=par; 
	    decl Lambda = sqrt(((2^(-2/nu))*gammafact(1/nu))/gammafact(3/nu)); 
		Cst = Lambda*2^(1/nu)*exp(loggamma(2/nu)-loggamma(1/nu)); 
	} 
	else if (dist==3) 
	{ 
	    decl g = exp(par[0]); 
		nu=par[1]; 
	    decl b = 2/((1/g)+g); 
		decl t1 = 2*b*sqrt(nu-2)*(g^2)*gammafact((1+nu)/2); 
		decl t2 = sqrt(M_PI)*(nu - 1)*gammafact(nu/2); 
		Cst = t1 / t2; 
	}

	else if (dist==4) 
	{ 
	     Cst=0;
	}
	else if (dist==5) 
	{ 
	     Cst=0;
	}
	return Cst; 
} 
 
Garch::CD(const e, const var, const dist, const par)				
/* 
**  Purpose : Computes the cdf of e./sqrt(var)
**            dist = 0 (normal), 1 (Student), 2 (ged), 3 (skewed Student) or 4 (NM2)
**			  par = logxi | df (<> if dist = 0)
** 
*/ 
{ 
	decl cd;
	decl stres=e./sqrt(var);
    if (dist==0)	cd=probn(stres); 
    else if (dist==1)
	{
		decl nu=par[0];
		cd=probt(stres*sqrt(nu/(nu-2)),nu);	  
	}
	else if (dist==2)	  
	{
		decl nu=par[0];
		cd=CDFGED(stres,nu);	// A vrifier
	}
   	else if (dist==3) 
   	{ 
		decl logxi=par[0];
		decl nu=par[1];
	    decl g,g2,g3,c,bb,m,v; 
		g=exp(logxi); g2=g^2; g3=g^3; 
	    c=gammafact((nu+1)/2)/(gammafact(nu/2)*sqrt(M_PI*(nu-2))); 
	    bb=2/(g+(1/g)); 
		m=bb*c*(nu-2)*(g2-1/g2)/(nu-1); 
		v=sqrt(((bb*(g3+1/g3)/2) - m^2)./var); 
		cd=CDFTA((v.*e)+m,logxi,nu); 
   }

//En irtam
   else if (dist==4)
   {
   		cd = CDFNM2(e, m_vSigma2_1, m_vSigma2_2, m_p1, m_mu1);
   }
   else if (dist==5)
   {
   		cd = CDFNM3(e, m_vSigma2_1, m_vSigma2_2, m_vSigma2_3, m_p1, m_p2, m_mu1, m_mu2);
   }

	return cd;
} 
 
Garch::CDFTA(const ee,const logxi,const nu) 
/*   
**  Purpose : computes the cdf of Skewed Student errors 
** 
**  Format  : {cd} = CDFTA(ee,logxi,nu); 
** 
**  Input   : ee = series 
**            logxi = log(skewness parameter)  
**            nu = Degree of freedom  
** 
**  Output  : cd = cdf   
** 
*/	 
{  
	decl cdp,cdn,cd,cst,g,pos,x;	 
    pos = (ee .>= 0); 
	g = exp(logxi); 
    cst = 2/(g + 1/g); 
	x = ee*sqrt(nu/(nu-2)); /* V(ee)=1 --> V(x)=nu/(nu-2) */ 
	cdp  = cst.*g.*(probt(-x./g,nu));  
	cdn  = cst.*(1/g).*(probt(x.*g,nu));	 
	cd   = pos.*(1-cdp) + (1-pos).*cdn;  
	return cd; 
}

//En irtam
Garch::CDFNM2(const ee, const var1, const var2, const p, const mu) 
/*   
**  Purpose : computes the cdf of NM2 errors 
** 
**  Format  : {cd} = CDFTA(ee,var1,var2,p,mu); 
** 
**  Input   : ee = series 
**			  vari = variancei series
**			  p=p1
**            mu = mu1  
** 
**  Output  : cd = cdf   
** 
*/	 
{
	decl mu2=-p*mu/(1-p);
    decl stres1=(ee-mu)./sqrt(var1);
	decl stres2=(ee-mu2)./sqrt(var2);
	return (p*probn(stres1)+(1-p)*probn(stres2));
}

//En irtam
Garch::CDFNM3(const ee, const var1, const var2, const var3, const p1, const p2, const mu1, const mu2) 
/*   
**  Purpose : computes the cdf of NM2 errors 
** 
**  Format  : {cd} = CDFTA(ee,var1,var2,var3,p1,p2,mu1,mu2); 
** 
**  Input   : ee = series 
**			  vari = variancei series
**			  pi=pi
**            mui = mui  
** 
**  Output  : cd = cdf   
** 
*/	 
{
	decl mu3=-(p1*mu1+p2*mu2)/(1-p1-p2);
    decl stres1=(ee-mu1)./sqrt(var1);
	decl stres2=(ee-mu2)./sqrt(var2);
	decl stres3=(ee-mu3)./sqrt(var3);
	return (p1*probn(stres1)+p2*probn(stres2)+(1-p1-p2)*probn(stres3));
}
 
Garch::mom_trst(const mu, const k) 
{ 
	return ( 2*gammafact((1+mu)/2)*((mu-2)^(0.5*(1+k)))*gammafact((mu-k)/2)*gammafact((1+k)/2) / (sqrt(M_PI*(mu-2))*gammafact(mu/2)*2*gammafact((1+mu)/2)) ); 
} 
 
Garch::INVCDFTA(const p,const logxi,const nu) 
/*   
**  Purpose : computes the inverse of the cdf of Skewed Student errors 
** 
**  Format  : {x} = INVCDFTA(p,logxi,nu); 
** 
**  Input   : p = probability 
**            logxi = log(skewness parameter)  
**            nu = Degree of freedom  
** 
**  Output  : x = solution of the integral equation p = F(x|logxi,nu)   
** 
*/	 
{  
    decl cdfinv,cst,g,i,var_t,pos,cdfinv_pos,cdfinv_neg,p1,p2,z,M1;    
    g = exp(logxi); 
	cst = 2/(g + 1/g); 
    cdfinv=zeros(sizer(p),1); 
    pos=(p.<= 1-g^2/(1+g^2)); 
    p1=p*g/cst; 
    p2=(1-p)/(cst*g); 
    z=(p1.>=0).*(p1.<=1);     /* to avoid a problem such as p1 or p2 < 0 or > 1 */  
    p1=z.*p1 - (z-1.0).*0.5; 
    z=(p2.>=0).*(p2.<=1); 
    p2=z.*p2 - (z-1.0).*0.5; 
    cdfinv_pos = quant(p1,nu)*sqrt((nu-2)/nu)/g; 
    cdfinv_neg = -quant(p2,nu)*sqrt((nu-2)/nu)*g; 
    cdfinv=cdfinv_pos.*pos+cdfinv_neg.*(1-pos); 
	M1=mom_trst(nu,1);	 /* Computes the non-centered first moment of the standardized Student */  
	cdfinv = (cdfinv - M1 * ( g - (1/g) ))/sqrt(g^2+(1/g^2)-1-(M1 * ( g - (1/g) ))^2); /* Standardize the quantile */ 
    return cdfinv; 
}  
 
Garch::CDFGED(const ee,const nu)   
/*   
**  Purpose : computes the cdf of GED errors 
** 
**  Format  : {cd} = CDFGED(ee,nu); 
** 
**  Input   : ee = series 
**            nu = Tail parameter 
** 
**  Output  : cd = cdf   
** 
*/	 
{  
	decl f,x1,d; 
	decl Lambda = exp((-1/nu)*log(2) + 0.5*loggamma(1/nu) - 0.5*loggamma(3/nu)); 
 	d=2/nu; 
 	x1 = fabs(ee/Lambda); 
 	f = 1-0.5*(1-probgamma(0.5*x1.^(2/d),d/2,1));						  
	return ((ee.>0).*f + (ee.<0).*(1-f)); 
} 
 
Garch::INVCDFGED(const p,const nu) 
/*   
**  Purpose : computes the inverse of the cdf of a GED density 
** 
**  Format  : {x} = INVCDFGED(p,nu); 
** 
**  Input   : p = probability 
**            nu = Degree of freedom  
** 
**  Output  : x = solution of the integral equation p = F(x|nu)   
** 
*/	 
{ 
	decl p1,x1,x2; 
	decl d=2/nu; 
	decl Lambda = exp((-1/nu)*log(2) + 0.5*loggamma(1/nu) - 0.5*loggamma(3/nu)); 
    p1= (p.>=0.5).*p +(p.<0.5).*(1-p); 
    x1 = (2*quangamma((1-2*(1-p1)), d/2, 1)).^(d/2);	 
    x2 = x1.*((p.>=0.5)-(p.<0.5)); 
	return (x2.*Lambda); 
} 
 
/*----------------------------///////////--------------------------------*/ 
/*---------------------------// TESTS //---------------------------------*/ 
/*--------------------------///////////----------------------------------*/ 
 
Garch::Normality(const e) 
/* 
**  Purpose : Computes skewness, excess kurtosis, Jarque-Bera, associated adjusted t-statistics and Prob. 
** 
**  Input   : e = series to be tested 
** 
**  Output  : 1 if successful 
*/ 
{	 
    decl t,m3,t_m3,SkT,m4,t_m4,KuT,jbe,JB,x1,x2,x3,mx; 
 
	t=double(rows(e)); 
 
	m3 = meanc((e-(meanc(e))').^3)./(sqrt(varc(e)).^3); 
	t_m3 = fabs(m3)/sqrt((6*t*(t-1))/((t-2)*(t+1)*(t+3))); 
	SkT = double(t_m3); 
	 
	m4 = meanc((e-(meanc(e))').^4)./(sqrt(varc(e)).^4)-3; 
	t_m4 = fabs(m4)/sqrt((24*t*(t-1)*(t-1))/((t-2)*(t-3)*(t+3)*(t+5))); 
	KuT = double(t_m4); 
	 
    jbe = ((t/6)*(m3.^2) + (t/24)*(m4.^2)); 
	JB = double(jbe); 
 
	x1 = m3~SkT~(2*tailn(SkT)); 
	x2 = m4~KuT~(2*tailn(KuT)); 
	x3 = JB~JB~tailchi(JB,2); 
	mx = x1|x2|x3; 
    println("%r", {"Skewness", "Excess Kurtosis", "Jarque-Bera"}, 
	      "%c",{"Statistic","t-Test","P-Value"}, mx ); 
	println("---------------");	 
	return 1; 
} 
 
Garch::ICriterion(const LogL, const n, const q) 
/* 
** Object : computes the Akaike, Schwarz, Shibata and Hannan-Quinn Tests 
** 
** Input : 	LogL 	= Log-likehood value (1X1) 
**			n 		= number of observations 
**			q 		= number of parameters 
** 
** Output : 1 if successful 
*/ 
 
{ 
	decl aic,sch,shi,hq	; 
 
	aic = (-2*LogL)/n + 2 * q/n; 
	sch	= (-2*LogL)/n + q * log(n)/n; 
	shi = (-2*LogL)/n + log((n+2*q)/n); 
	hq = (-2*LogL)/n + (2*q*log(log(n)))/n; 
 
    println("Information Criterium (minimize)"); 
    println("Akaike   ", "%16.6f", double(aic), 
          "  Shibata  ", "%16.6f", double(shi)); 
    println("Schwarz         ", "%8.6f", double(sch), 
          "  Hannan-Quinn    ", "%8.6f", double(hq)); 
	println("---------------"); 
    return   1;  
} 
 
Garch::SBT(const res, const cvar) 
/*   
**  Purpose : Computes Sign Bias Test, Negative Size Bias Test, 
**				Positive Size Bias Test and Joint Test for the Three Effects (Engle and Ng, 1993) 
** 
**  Input   : res = residuals (m_cT x 1)  
**            cvar = conditional variance (m_cT x 1) 
** 
**  Output  : 1 if successful 
*/ 
 
{ 
	decl resn,Splus,Sminus,plus,minus,n,i,x,y,beta,e,se,t,prob,ec,tc,probc,betac,mx; 
 
	resn=res./sqrt(cvar); 
	n = rows(res); 
	Splus=zeros(n,1); 
	Sminus=zeros(n,1); 
	plus=zeros(n,1); 
	minus=zeros(n,1); 
	beta=zeros(4,1); 
 
	for (i=0;i<n;++i) 
	{ 
   		Splus[i] = (0 .< resn[i]); 
   		Sminus[i] = (0 .> resn[i]); 
	} 
 
	plus=Splus.*res; 
	minus=Sminus.*res; 
	x=ones(n-1,1)~Sminus[0:n-2]~minus[0:n-2]~plus[0:n-2]; 
	y=resn[1:n-1].^2; 
 
	print("Diagnostic test based on the news impact curve (EGARCH vs. GARCH)"); 
 
	olsc(y,x,&beta); 
	e=y-(x*beta);	 
	se=sqrt(diagonal((sumc(e.*e)/(n-4))*invert(x'*x))); 
	t = fabs(beta ./ se); 
	prob = 2 * tailn(t); 
 
	olsc(y,ones(n-1,1),&betac); 
	ec=y-(ones(n-1,1)*betac);	 
	tc = n * ( ( (ec' * ec ) - (e' * e) )/(e' * e) ); 
    probc = tailchi(tc,3); 
	mx = t[1][1]~prob[1][1]|t[2][2]~prob[2][2]|t[3][3]~prob[3][3]|tc[0][0]~probc[0][0]; 
	 
	println("%r", {"Sign Bias t-Test", "Negative Size Bias t-Test","Positive Size Bias t-Test","Joint Test for the Three Effects"}, 
	        "%c", {"Test","Prob"},"%9.5f", mx); 
	println("---------------"); 
    return 1; 
}
 
Garch::BoxPQ(const eh,const ncor,const adj) 
/*   
**  Purpose : Computes Box-Pierce Q-statistics on standardized residuals 
**		  and squared standardized residuals 
** 
**  Input   : eh 	= Series to be tested 
**            ncor 	= vector of lags  
**            adj  	= number of degrees of freedom to be substracted for eh 
** 
**  Output  : 1 if successful 
*/ 
{   
	if (ncor != <>) 
	{ 
		decl m,ant,cr,q,eh1,il,marg,nn; 	 
		nn=rows(eh); 
		m=meanc(eh); 

		if (adj >0) 		println("  --> P-values adjusted by ",adj," degree(s) of freedom "); 

		decl Iter=sizer(ncor); 
		if (Iter==0) Iter=1; 			 
		for (ant=0;ant<Iter; ++ant) 
		{ 
			cr=ones(ncor[ant],1); 
			q=0.0; 
			eh1=eh-m; 		 
			for (il=0; il < ncor[ant]; ++il)  
			{ 
		   		eh1 = 0.0|eh1[0:nn-2]; 
		   		cr[il][0] = meanc((eh-m).*eh1)/meanc((eh-m).*(eh-m)); 
		   		q = q + cr[il][0]*cr[il][0] / (nn-il-1); 
			} 		 
			q=q*(nn+2)*nn; 
			marg=tailchi(q,ncor[ant]-adj); 
			println("  Q(",ncor[ant],") = ",q,"   [",marg, " ]"); 
		} 	 
		println("H0 : No serial correlation ==> Accept H0 when prob. is High [Q < Chisq(lag)]");
	}						    
	return 1; 
} 
 
Garch::Nyblom(const eh, const grad)  
{ 
	decl parnames,hs,zs,mz,nn,sez,x,mcgr,nyblomj,nyblomt,table,i;
	parnames = GetParNames(); 
	nn=rows(eh); 
	hs = grad' * grad; 
	zs = eh~(eh.^2)~(eh.^3)~(eh.^4); 
	mz = meanc(zs)'; 
	zs[][0] -= mz[0]; 
	zs[][1] -= mz[1]; 
	zs[][2] -= mz[2]; 
	zs[][3] -= mz[3]; 
	sez = sqrt(meanc(zs.^2)/nn); 
	x = cumulate(grad); 
	mcgr = x' * x; 
	nyblomj = sumr(diagonal(mcgr/hs))/nn; 
	nyblomt = diagonal(mcgr)./(diagonal(hs)*nn); 
	table = parnames | nyblomt'; 
	println("Joint Statistic of the Nyblom test of stability: ",double(nyblomj)); 
	println("\nIndividual Nyblom Statistics: ");    
	if (m_cFilter == 10) 
	{ 
		for (i = 0; i < m_cPar-1; ++i)	println("%-17s", parnames[i], "%.5f", nyblomt[0][i]); 
	} 
	else 
	{ 
		for (i = 0; i < m_cPar; ++i)	println("%-17s", parnames[i], "%.5f", nyblomt[0][i]); 
	}  
	println("\nRem: Asymptotic 1% critical value for individual statistics = 0.75.\n", 
	 		  "     Asymptotic 5% critical value for individual statistics = 0.47."); 
	println("---------------"); 	 
  return 1; 
}  
 
Garch::APGT(const cd, const ng, const np) 
/*   
**  Purpose: Computes adjusted Pearson Chi-square Goodness-of-fit test (Vlaar, 93) 
** 
**  Input  : cd = values of the cumulative distribution function 
**           ng = classification in "ng" groups  
**           np = model with "np" parameters 
** 
*/ 
{ 
	if (ng != <>) 
	{ 
		decl x2,v,num1,num,enu,t,i,npp,k,stat,chi1,chi2,mx; 
		t=rows(cd); 
	    println("Adjusted Pearson Chi-square Goodness-of-fit test"); 
		k=sizer(ng); 
		stat = <>; chi1 = <>;	chi2 = <>; 		 
		for (i = 0; i < k; i++)   
		{ 
	    	v = range(1/ng[i], 1, 1/ng[i]); 
	    	num1 = countc(cd[][0], v); 
			num  = num1[0:sizer(num1)-2]; 
			npp = limits(np|ng[i]-2)[0]; 
			enu = t/ng[i]; 
	    	x2 = ((num-enu).^2)/enu; 
			stat |= sumc(x2); 
			chi1 |= tailchi(sumc(x2),ng[i]-1); 
			chi2 |= tailchi(sumc(x2),ng[i]-1-npp); 
		} 
		mx = ng ~ stat ~ chi1 ~ chi2; 
	    print("%c",{"Cells","Statistic","P-Value(lag-1)","P-Value(lag-k-1)"}, 
			  "%cf", {"%6.0f", "%12.4f", "%17.6f", "%20.6f"}, mx); 
		println("Rem.: k = # estimated parameters");  
		println("---------------"); 
	}		   
	return 1; 
} 
 
Garch::AUTO(const z, const ncor, const min, const max, const plot)  
/*   
**  Purpose : Computes and Plot the autocorrelations (with maximum lag=ncor)
**			  min and max = coordinates of the Y-axis (for the 4 graphs)
** 
*/ 
{ 
	decl t,sa,am,ap,z1,z2,z3,z4,q,s,i; 
	t=rows(z);	 
	sa=(1/sqrt(t)); 
	am=-sa*2; ap=sa*2; 
	z1=z-meanc(z); 
	z2=(z-meanc(z)).^2; 
	z3=(z-meanc(z)).^3; 
	z4=(z-meanc(z)).^4; 
	q=acf(z1~z2~z3~z4,ncor)[1:][]; 
	for (i=0;i < 4; ++i)  
	{	 
		s = sprint("ACF(Moment: ", i+1,")"); 
		DrawMatrix(plot+i,q[][i]',s,1,1); 
		DrawAdjust(ADJ_MINMAX, min, max); 
		DrawLine(plot+i, 0, ap, ncor,ap, 2); 
		DrawLine(plot+i, 0, am, ncor,am, 2); 
	}	 
} 
 
Garch::absha(const z,const u,const o)   
/* 
Computes frequencies in an interval defined by u and o 
*/ 
{ 
	decl cases,ah,i; 
	cases=sizer(z); 
	ah=0; 
	for (i=0;i < cases; ++i)  
	{ 
 		if ((z[i][0]>u) && (z[i][0] <= o)) 
   			ah++; 
	} 
return ah; 
} 
 
Garch::confidence_limits_uniform(const z_series,const number_of_bins,const conf_interval, const draw, const plot)   
 
/* Purpose: 
   ======== 
   Computes from the vector of assumed uniform 0-1 "z_series" 
   the confidence bounds of a confidence interval of size CONF_INTERVAL. 
 
   Input: 
   ====== 
   Z_SERIES: The series for which the histogram is to be computed. 
   NUMBER_OF_BINS: Desired number of bins. 
   CONF_INTERVAL: Size of the confidence interval 
   DRAW 1 to plot the histogram, 0 otherwise 
   PLOT : Plot area index. 
    
   Output: 
   ======= 
   BIN_BOUNDS:  Upper and lower bound for bins (a number_of_bins x 2) matrix 
   X_AXIS_BINS: Means of bins  (a number_of_bins x 1) vector 
   Y_AXIS_BINS: frequency of observations in bin  (a number_of_bins x 1) vector 
   Lower_bound: skalar: lower bound of confidence interval 
   Upper_bound: skalar: upper bound of confidence interval 
*/ 
{ 
	decl  bindwith, bin_o, bin_u, i, bin_bounds, n, j, f, m, p, q, s, kum, t, g, 
          Lower_bound, r, v, Upper_bound, n_u, n_o, result, bin_means, sup, 
          inf,b,freq, exfr, diff2, chi_square, degrees_freedom, p_value,low,up; 
// Bin upper and lower bounds   
 	bindwith=1/number_of_bins; 
 	bin_o=ones(number_of_bins,1); 
 	bin_u=ones(number_of_bins,1); 
	for (i=0;i < number_of_bins; ++i)  
	{ 
 		bin_o[i][0]=(i+1)*bindwith; 
		bin_u[i][0]=i*bindwith;	 
	} 
	bin_bounds = bin_u~bin_o; 
	bin_means  = bin_u+(bin_o-bin_u)/2; 
// Frequencies of z observations in histogram bins (use procedue absha) 
	n=zeros(number_of_bins,1); 
	for (i=0;i < number_of_bins; ++i)  
	{ 
		n[i][0]=absha(z_series, bin_bounds[i][0], bin_bounds[i][1]); 
	} 
// Compute confidence bounds      
// compute binomial probabilities  
    f=rows(z_series); 
    m=range(1,f,1)'; 
    p=zeros(f+1,1); 
    p[0]=(1-bindwith)^f; 
    p[f]=(bindwith)^f; 
	for (q=1;q < f; ++q)  
	{ 
    	p[q][0]=exp(sumc(log(m[0:sizer(m)-1])) 
		        -sumc(log(m[0:sizer(m)-q-1])) 
		        -sumc(log(m[0:q-1])) 
		        +q*log(bindwith)+(f-q)*log(1-bindwith)); 
	} 
// cumulate probabilities  
	kum=p; 
	for (s=0;s < f; ++s)  
	{ 
		kum[s+1][0]=kum[s][0]+p[s+1][0]; 
	} 
//  lower bound  
	g=0; 
	for (t=0;t < f+1; ++t)  
	{ 
       if (kum[t][0] <= (1-conf_interval)/2) 
          ++g; 
	} 
    Lower_bound=g-1; 
// upper bound   
    v=0; 
	for (t=0;t < f+1; ++t)  
	{ 
       if (kum[t][0] <= (1-(1-conf_interval)/2)) 
          ++v; 
	} 
    Upper_bound=v; 
// Compute Lower_bound and Upper_bound for normalized histogram 
	low=Lower_bound*number_of_bins/sizer(z_series); 
	up=Upper_bound*number_of_bins/sizer(z_series); 
	 
	if (draw != 0) 
	{ 
		if (oxversion() < 300) DrawDensity(plot, z_series', {"Probability Integral Transform"}, 0, 1, 0);			  
		else 				   DrawDensity(plot, z_series', {"Probability Integral Transform"}, 0, 1, 0, 0, 0, number_of_bins, 2);	  
		DrawLine(plot, 0, low, 1,low, 2); 
		DrawLine(plot, 0, up, 1,up, 2); 
	} 
	println("Probability Integral Transform"); 
	println("The Lower and Upper bounds are ", low, " and ", up);		 
return 1; 
} 
 
Garch::FEM(const forc, const obs)  
/*   
**  Purpose: computes Forecast Error Measures 
** 
**  Format : FEM(const forc, const obs);
**
**	input  : forc = mean forecast ~ variance forecast
**			 obs  = observed series and variance
** 
**  Output : MSE = Mean Squared Error 
**           MedSE = Median Squared Error 
**           ME = Mean Error 
**           MAE = Mean Absolute Error 
**           RMSE = Root Mean Squared Error 
**           HMSE = Heteroskedastic Mean Squared Error 
**           MAPE = Mean Absolute Percentage Error 
**           AMAPE = Adjusted Mean Absolute Percentage Error 
**           PCS = Percentage Correct Sign 
**           THEIL = Theil Inequality Coefficient 
**           LL = logarithmic loss function    
** 
**  Remarks : - See Brooks, C., 1997, Linear and Non Linear (Non-Forecastability of High-Frequency Exchange Rates, 
**               Journal of Forecasting, Vol. 16, p. 125-145. 
**            - The PCS test is not useful when forecasting volatilty because the volatility is always  
**               positive. 
** 
*/ 
{  
	decl i,MSE,MedSE,ME,MAE,MAPE,AMAPE,PCS,LL,THEIL,RMSE, maxc, maxc2,a,b; 
	decl res1, res2; 
	decl xp = new matrix[2][10];
	decl Tforc=rows(forc); 
	res1 = (obs[][0] - forc[][0])~(obs[][1] - forc[][1]);   
	res2 = (obs[][0] + forc[][0])~(obs[][1] + forc[][1]);  
	for (i=0;i<2;++i) 
	{ 
		MSE = (sumc(res1[][i].^2)/rows(res1[][i])); 
		MedSE = (quantilec(res1[][i].^2)); 
		ME = (sumc(res1[][i])/rows(res1[][i])); 
		MAE = (sumc(fabs(res1[][i]))/rows(res1[][i])); 
		RMSE = sqrt((sumc(res1[][i].^2)/rows(res1[][i]))); 
		if (i == 1) 
		{ 
			MAPE = (sumc(fabs(res1[][i]./obs[][i]))/rows(res1[][i])); 
			AMAPE = (sumc(fabs(res1[][i]./res2[][i]))/rows(res1[][i])); 
			LL = (sumc(log((forc[][i]./obs[][i])).^2)/rows(res1[][i])); 
			PCS = M_NAN; 
			THEIL = sqrt((sumc(res1[][i].^2))*(1/(1+Tforc)))/ (sqrt((sumc(obs[][i].^2))*(1/(1+Tforc))) + sqrt((sumc(forc[][i].^2))*(1/(1+Tforc)))); 
		}   
		else 
		{ 
			MAPE = M_NAN; 
			AMAPE = M_NAN; 
			LL = M_NAN; 
			PCS = sumc( ((obs[][i] .* forc[][i]) .> 0) )/rows(res1[][i]); 
			THEIL = sqrt((sumc(res1[][i].^2))*(1/(1+Tforc)))/ (sqrt((sumc(obs[][i].^2))*(1/(1+Tforc))) + sqrt((sumc(forc[][i].^2))*(1/(1+Tforc)))); 
		} 
		xp[i][] = MSE~MedSE~ME~MAE~RMSE~MAPE~AMAPE~PCS~THEIL~LL; 
	}
	print("Forecast Evaluation Measures"); 
	println("%r", {"Mean Squared Error(MSE)", "Median Squared Error(MedSE)", 
	               "Mean Error(ME)","Mean Absolute Error(MAE)", 
	               "Root Mean Squared Error(RMSE)", 
	               "Mean Absolute Percentage Error(MAPE)", "Adjusted Mean Absolute Percentage Error(AMAPE)", 
	               "Percentage Correct Sign(PCS)", "Theil Inequality Coefficient(TIC)", "Logarithmic Loss Function(LL)"},  
	               "%c", {"Mean","Variance"},"%12.4g", xp'); 
	println("---------------"); 
	return 1; 
}  
 
Garch::MZ(const HFor, const For, const nbFor)	  
{
	println("Mincer-Zarnowitz regression on the forecasted volatility :"); 
	decl Y, X, beta, e, R2, covmat, WhiteCov, names = {}; 
	decl hs, XX, RobustSE, TstatR, mparR; 
	decl i; 
	Y = HFor[][0]; 
	X = ones(rows(HFor),1) ~ For[]; 
	olsc(Y, X,&beta, &covmat, &XX);		 // covmat = 1/(X'X) et XX = X'X 
	e = Y - X * beta; 
	decl Omega=zeros(2,2); 
	decl Q=zeros(2,2); 
	for	(i = 0; i < rows(HFor); ++i) 
	{ 
		Q += (X[i][]'*X[i][])/nbFor; 
		Omega += ((X[i][]'*X[i][])*e[i]^2)/nbFor; 
	} 
	decl invQ=invert(Q); 
	WhiteCov = invQ * Omega * invQ /(nbFor-2);  
	RobustSE = sqrt(diagonal(WhiteCov));						    
	TstatR = beta'./ RobustSE; 
	mparR = beta ~ RobustSE' ~ TstatR'; 
	names |= sprint("Alpha");  
	names |= sprint("Beta"); 
	MLEMeth(mparR,names,0,2); 
	R2=1-(e'*e)/((HFor[][0]-meanc(HFor[][0]))'*(HFor[][0]-meanc(HFor[][0])));   
	println("R: ", R2[0]); 
	println("Note: S.E. are Heteroskedastic Consistent (White, 80)"); 
	println("---------------"); 
	return 1; 
} 

/*----------------------------////////////--------------------------------*/ 
/*---------------------------// OUTPUT //---------------------------------*/ 
/*--------------------------////////////----------------------------------*/ 
 
Garch::Estimate()	   // Launch from Oxpack 
{ 
	if (oxversion() < 320)
	{
        println("\n");
        println("Requires Ox 3.2 or newer!");
        println("Please update your version of Ox ", oxversion()/100,"\n");
        exit(0);
 	}
	startingvalues = "./startingvalues3.txt";
	if (m_iModelClass==0) 					
	{
		decl series, l, nbser,i,names;
		println("\nTESTS :");	 
		println("=======");	 

		series = GetGroup(T_VAR);
		GetGroupNames(T_VAR, &names);
		nbser = columns(series);
    	m_cY = 0; 	m_cXM = 0; 	m_cXV = 0; 	 m_cOV = 0;
		m_cGJR = 0; m_cEgarch = 0; m_cAparch = 0; m_cHY = 0; m_cNMGJR = 0; m_cNMAGARCH = 0;
		m_iT1est = m_iT1sel; 
		m_iT2est = m_iT2sel;
	
		if (m_vTests[0] != 0) 	 Info();

		for	(i = 0; i < nbser; ++i)
		{
			if (m_vTests[1]+m_vTests[2]+m_vTests[4]+m_vTests[5]!=0)
			{
				println("\nSeries #", i+1,"/",nbser, ": ", names[i]);
				print("---------");
				if (m_vTests[1] != 0) 	Normality(series[][i]); 
				if (m_vTests[2] != 0) 
				{ 
					for (l = 0; l < sizer(m_cLagArch); l++)   
					ArchTest(series[][i], 1, m_cLagArch'[l],  2, TRUE); 
					println("---------------"); 
				} 
				if (m_vTests[4] != 0) 
				{ 
					println("Q-Statistics on Raw data");
					BoxPQ(series[][i],m_cLagPort, 0); 
					println("---------------"); 
				}
				if (m_vTests[5] != 0)
				{
					println("Q-Statistics on Squared data");				
					BoxPQ(series[][i].^2, m_cLagPort,0);
				}
			}
		}
		return 1; 
	}
	else if (m_iModelClass==1)
	{
		decl time;  
		Dialogs();
		m_cTests = 0;
		m_cFix=0;  
		SetPar(m_vPar);		   
	    SetParCount(rows(m_vPar)); 
    	SetFreePar(m_vPar);	 
		time = timer(); 
		if (!InitData()) 
    	{ 
	    	print("Failed to load data\n"); 
        	return; 
	    }  
		GetPara();	 
		if (!CheckPara()) 
    	{ 
	    	println("Uncorrect parameters. Estimation stopped."); 
        	exit(0); 
    	} 
		m_cRobustLL=0;

		if (m_cBound == 0)	m_iResult = MaxBFGS(FigLL_max, &m_vPar, &m_dLL, 0, TRUE);
		else 				m_iResult = MaxSQPF(FigLL_max, &m_vPar, &m_dLL, 0, TRUE, cfunc_gt0, 0, m_mBound[][0],m_mBound[][1]);

		if(m_cNM2==1)
		{
			m_p2=1-m_p1;
			m_mu2=-(m_p1*m_mu1)/m_p2;
		}
		else if (m_cNM3==1)
		{
			if ( (m_p1<0) || (m_p1>1) ||(m_p2<0) || (m_p2>1) || (m_p1+m_p2>1))
			{
				println("\n",m_p1,"\t",m_p2,"\t Probabilities out of range!");
			}
			m_p3=1-m_p1-m_p2;
			m_mu3=-(m_p1*m_mu1+m_p2*m_mu2)/m_p3;
		}
		m_vStandErrors = m_vE./sqrt(m_vSigma2); 	 
		m_vSqStandErrors = (m_vE.*m_vE)./m_vSigma2;
		m_cd = CD(m_vE,m_vSigma2,m_cDist,m_cA|m_cV);
		m_stdres = quann(m_cd);
		Output(); 
		println("Elapsed Time : ", (timer()-time)/100," seconds (or ",(timer()-time)/6000," minutes)."); 
		return 1; 
	}
}	  			    
 
Garch::Initialization(const vStart)	   // Launch from GarchEstim.ox 
{ 
	m_cRobustLL=0; 
	m_vPar = vStart;
	startingvalues = "./startingvalues3.txt";
	
	if ((vStart!=<>)&&(m_cFix==1)&&(sizer(m_vFix)!=sizer(m_vPar)))
	{
		println("Warning: Wrong number of parameters in the second argument of FixParam(). Please correct it and restart !");
		exit(0);
	}

	if (vStart == <>) 
		InitStartValues(1,m_cBound); 
	else
		InitStartValues(0,m_cBound); 
	
	if (!InitData()) 
    { 
	    println("Failed to load data !"); 
        exit(0);  
    }  
	SplitPara(m_vPar); 
	GetPara();
	SetParCount(rows(m_vPar));	// Gives the number of Free and Fixed parameters
	SetPar(m_vPar); 			// Set the parameter values (Free and Fixed)
	if (m_cFix==1)				// If Fixed Parameters
	{
		decl par_fixed=selectifr(range(0,rows(m_vPar)-1)',m_vFix); // Select the row numbers of the fixed parameters
		decl vpar_fixed=selectifr(m_vPar,m_vFix);				   // Select the values of the fixed parameters
		FixPar(par_fixed,vpar_fixed);							   // Set the fixed parameters
	}

	m_vPar=GetFreePar();					   // Optimizes only on the Free parameters

	if (!CheckPara()) 
    { 
	    println("Uncorrect parameters. Estimation stopped."); 
        exit(0);  
    }	 
}

Garch::cfunc_gt0(const avF, const vP)
{
	avF[0] = matrix(1);
	return 1;
}

Garch::DoEstimation()
{
	decl time, Z; 
	time = timer();

	if (oxversion() < 320)
	{
        println("\n");
        println("Requires Ox 3.2 or newer!");
        println("Please update your version of Ox ", oxversion()/100,"\n");
        exit(0);
 	}
	MaxControl(-1, m_cIter); 
	m_vSigma2 = ones(m_cT,1);
	m_vPar_start=m_vPar;
	m_vPar_cont=m_vPar;
	
	if (m_cBound == 0)	m_iResult = MaxBFGS(FigLL_max, &m_vPar, &m_dLL, 0, TRUE);
	else 				m_iResult = MaxSQPF(FigLL_max, &m_vPar, &m_dLL, 0, TRUE, cfunc_gt0, 0, m_mBound[][0],m_mBound[][1]);

		if(m_cNM2==1)
		{
			if (isnan(m_p1)) { println("\nSorry. Optimisation unsuccessful. "); exit(0);}
			m_p2=1-m_p1;
			m_mu2=-(m_p1*m_mu1)/m_p2;
		}
		else if (m_cNM3==1)
		{
			if (isnan(m_p1)) { println("\nSorry. Optimisation unsuccessful. "); exit(0);}
			if (!( (m_p1>0) && (m_p1<1) &&(m_p2>0) && (m_p2<1) && (m_p1+m_p2<1)))
			{
				println("\n",m_p1,"\t",m_p2,"\t Probabilities out of range! Program stopped.");
				exit(1);
			}
			m_p3=1-m_p1-m_p2;
			m_mu3=-(m_p1*m_mu1+m_p2*m_mu2)/m_p3;
		}
	m_vStandErrors = m_vE./sqrt(m_vSigma2); 	 
	m_vSqStandErrors = (m_vE.*m_vE)./m_vSigma2; 	
    m_cd = CD(m_vE,m_vSigma2,m_cDist,m_cA|m_cV);
	m_stdres = quann(m_cd);			//Here is the mistake!!! Correction:
	
//En irtam
	decl i,j;
	if (isdotinf(sumc(m_stdres)))
	for ( i=0; i<rows(m_cd)[0]; i++)
	{
		j=0;
		while  ((isdotinf(m_stdres[i]))	&& (j<1000))
		{
			j++;
			m_stdres[i] = quann(m_cd[i]-0.0001*j);
		}
		if (j>0) println("Unsuccessful inversion of observation ",i," had to decrease by 0.0001 * ",j);
		
	}
	//eddig
	
	if (m_cFOR==1)
	//not changed yet
    { 
        decl a = 0, b = 0; 
		if (m_cXM != 0) 	a =	sizer(m_mXM) + m_cTforc; 
		if (m_cXV != 0)		b = sizer(m_mXV) + m_cTforc; 
		if ((m_cT + m_cTforc) > GetSize())  
		{ 
			println("Forecast tests are not possible. You do not have enough out-of-sample (actual) observations."); 
			println("You have selected ",m_cT," observations in your sample and a forecast horizon of ", m_cTforc,"."); 
			println("Since the whole database includes ", GetSize()," observations, the maximum sample size to run the tests is ",(GetSize()-m_cTforc),"."); 
			exit(0); 
		} 
				 
		FORECASTING();
		GetForErrors(m_cOV); // To create m_Yfor and m_Hfor
											
		if ((m_cXM != 0)&&(sizer(GetXBetaForc(m_cTforc))< m_cTforc))																										   
				println("Forecasts errors measures cannot be computed because there are not enough out-of-sample observations for the explanatory variables in the mean."); 
		else if ((m_cXV != 0)&&(sizer(GetZBetaForc(m_cTforc))< m_cTforc))																										   
				println("Forecasts errors measures cannot be computed because there are not enough out-of-sample observations for the explanatory variables in the variance."); 
		else 	FEM(m_mForc, m_Yfor~m_Hfor);  		
			   
		if (sizer(GetForcData(Y_VAR,m_cTforc)) < m_cTforc)
				println("Forecasts graphics are not displayed because there are not enough out-of-sample observations for the Y series."); 
		else if ((m_cXM != 0)&&(sizer(GetXBetaForc(m_cTforc))< m_cTforc))																										   
				println("Forecasts graphics are not displayed because there are not enough out-of-sample observations for the explanatory variable(s) in the mean."); 
		else if ((m_cXV != 0)&&(sizer(GetZBetaForc(m_cTforc))< m_cTforc))																										   
				println("Forecasts graphics are not displayed because there are not enough out-of-sample observations for the explanatory variable(s) in the variance."); 
		else if (m_cForGraphs)
		{
			FOR_GRAPHS(0,10,2,2);
			ShowDrawWindow();
		}
		if ((m_cSForGraphs)&&(m_cForGraphs))	SaveDrawWindow(m_sNameForGraphs); 
	}	 
	if (m_cGraphs) 
	{ 
		TestGraphicAnalysis(1,1,1,1,0); 
		ShowDrawWindow(); 
	} 
	if (m_cSGraphs)		    
	{ 
		TestGraphicAnalysis(1,1,1,1,0); 
		SaveDrawWindow(m_sNameGraphs); 
	}

	if (m_momtest)
	{
		 MOMTEST();
		 if (m_cDist==4)
		{
			Compute_momNM(2,1);
		}
		else if (m_cDist==5)
		{
			Compute_momNM(3,1);
		}
		else
		{
			Compute_momN();
		}
	}

	if (m_acf)
	{
		ACF();
	}

	if (m_hist)
	{
	}
//Ezt en kommentaltam	
	//println("Elapsed Time: ", (timer()-time)/100," seconds (or ",(timer()-time)/6000," minutes)."); 
}	  			    
 
Garch::TestGraphicAnalysis(const ser, const res, const sqres, const h, const plot) 
{	 
	decl i=plot, s;
	s = (m_iModelClass == MC_STATS ? GetGroup(T_VAR) : m_vY);	  
	
	if (ser == 1)  
	{ 															  
		Draw(i, s'); 
	  	DrawTitle(i, "Series (Y)"); 
		i = i+1; 
	} 	 
	if (res == 1)  
	{ 
		Draw(i, m_vE'); 
		DrawTitle(i, "Residuals (E)"); 
		i = i+1; 
	} 
	if (sqres == 1)  
	{ 
		Draw(i, ((m_vE).^2)' ); 
	  	DrawTitle(i, "Squared Residuals"); 
		i = i+1; 
	} 
	if (h == 1)  
	{ 
    	Draw(i, m_vSigma2'); 
		DrawTitle(i, "Conditionnal Variance (H)"); 
		i = i+1; 
	} 
} 
 
Garch::QuantileGraphs(const meth, const quantile, const iplot) 
{ 
	decl i, Q, s; 
	decl n=sizer(quantile); 
	decl myq = new matrix[m_cT][n];; 
	if (meth == 1)  
	{ 
		Q=zeros(n,1); 
		for	(i = 0; i < n; ++i) 
		Q[i] = quantilec(m_vStandErrors, quantile[i]); 
	} 
	else if (meth == 2)  
	{ 
		if (m_cDist == 0) Q = quann(quantile); 
		else if (m_cDist == 1) Q = quant(quantile, m_cV)*sqrt((m_cV-2)/m_cV); 
		else if (m_cDist == 3) 
		{ 
			Q=zeros(n,1); 
			for	(i = 0; i < n; ++i) 
				Q[i] = INVCDFTA(quantile[i], m_cA, m_cV); 
		} 
		else {println("Quantile not available for this distribution");	exit(0);} 
	} 
	myq = (m_vY-m_vE) * ones(1,n) + sqrt(m_vSigma2) * Q'; 
	if ((n==2) && (quantile[0]<quantile[1])) 
	{ 
		decl in=(m_vY.>myq[][0]).*(m_vY.<myq[][1]); 
		print; 
		println("Percentage of observations within the (",quantile[1]-quantile[0],") interval :", double(meanc(in))*100," %."); 
	} 
	DrawTMatrix(iplot, m_vY', "Conditional mean", 1, 1, 1, 0, 1); 
	for (i = 0; i < n; ++i) 
	{ 
		s =	sprint("Quantile ",double(quantile[i][])); 
		DrawTMatrix(iplot, myq'[i][], s, 1, 1, 1, 0, 2+i); 
	} 
} 
 
Garch::Output() 
{ 
/*En irtam
	decl dfunc, my_par;
	//my_par=<0.0012;0.000083;0.0575;0.9357;5.6263>;	//for gbp
	//my_par=<-0.0032;0.000406;0.0484;0.9236;4.7074>;	 //for jpy	 t-GARCH
	my_par=<0.000233;0.0001737;0.027;0.9358;0.000442;0.1172;0.9592;0.8764;-0.006>;	//for jpy NM2-GARCH
	m_vPar=my_par;
	FigLL(my_par,&dfunc,0,TRUE);
	m_dLL=dfunc;
	print("\nItt: ",dfunc);	  */
	
	println(""); 
	println("\n  ********************"); 
	println(" ** SPECIFICATIONS **");	 
	println("*******************");	 
    print("Mean Equation :"); 
    if  (m_cARFI == 0) 
    	println(" ARMA (", m_cAR, ", ", m_cMA, ") model."); 
    else	 
    	println(" ARFIMA (", m_cAR, ", d, ", m_cMA, ") model."); 
 
    if (!m_cXM) println("No regressor in the mean"); 
    else println (m_cXM," regressor(s) in the mean."); 
    
    print("Variance Equation :"); 
    if  (m_cFilter == 1) 
    	println(" GARCH (", m_cP, ", ", m_cQ, ") model."); 
    else if  (m_cFilter == 10) 
    	println(" IGARCH (", m_cP, ", ", m_cQ, ") model."); 
    else if (m_cFilter == 11)	 
    	println(" FIGARCH (", m_cP,", d, ", m_cQ,") model estimated with BBM's method (Truncation order : ", m_claglamb,")."); 
    else if (m_cFilter == 12)	 
    	println(" FIGARCH (", m_cP,", d, ", m_cQ,") model estimated with Chung's method."); 
    else if (m_cFilter == 2)	 
    	println(" EGARCH (", m_cP, ", ", m_cQ, ") model."); 
    else if (m_cFilter == 21)	 
    	println(" FIEGARCH (", m_cP, ", d, ", m_cQ, ") model (Truncation order : ", m_claglamb,")."); 
    else if (m_cFilter == 3)	 
    	println(" GJR (", m_cP, ", ", m_cQ, ") model."); 
    else if (m_cFilter == 4)	 
    	println(" APARCH (", m_cP, ", ", m_cQ, ") model."); 
    else if (m_cFilter == 41)	 
    	println(" FIAPARCH (", m_cP, ", d, ", m_cQ, ") model estimated with BBM's method (Truncation order : ", m_claglamb,").");  
    else if (m_cFilter == 42)	 
    	println(" FIAPARCH (", m_cP, ", d, ", m_cQ, ") model estimated with Chung's Method."); 
    else if (m_cFilter == 51)	 
    	println(" HYGARCH (", m_cP, ", d, ", m_cQ, ") model of Davidson (Truncation order : ", m_claglamb,").");
	else if (m_cFilter == 112)	 
    	println(" NMGJR (", m_cP, ", ", m_cQ, ") model.");
	else if (m_cFilter == 113)	 
    	println(" NMAGARCH (", m_cP, ", ", m_cQ, ") model."); 

	if (m_c_in_mean != 0)
		println("            in-mean");  
	
    if (!m_cXV)	 println("No regressor in the variance");  	 
    else println (m_cXV," regressor(s) in the variance."); 
    
    if  (m_cDist == 0) 
    	println("The distribution is a Gauss distribution."); 
    else	if 	(m_cDist == 1) 
    	println("The distribution is a Student distribution, with ",m_cV," degrees of freedom."); 
    else	if 	(m_cDist == 2) 
    	println("The distribution is a GED distribution, with a tail coefficient of ",m_cV,"."); 
    else	if 	(m_cDist == 3) 
    	println("The distribution is a Skewed Student distribution, with a tail coefficient of ",m_cV," and an asymmetry coefficient of ", m_cA,"."); 
 	else	if 	(m_cDist == 4)
			{
				println("The distribution is a Normal Mixture2 distribution, with p= ",m_p1,", mu1 of ", m_mu1, " and mu2 of ", m_mu2,".");
			}
	else	if 	(m_cDist == 5)
			{
				println("The distribution is a Normal Mixture3 distribution, with p1= ",m_p1,", p2= ",m_p2, ", mu1 of ", m_mu1, ", mu2 of ", m_mu2, " and mu3 of ", m_mu3,".");
			}
 
	println("\n", MaxConvergenceMsg(m_iResult), 
        " using numerical derivatives", 
        "\nLog-likelihood = ", double(m_dLL));

 	decl Pnames = GetFreeParNames();
	
//I modified here, I put the third part
	if (m_iResult == MAX_CONV || m_iResult == MAX_WEAK_CONV || m_iResult == 3) 
    { 
		decl Tstat,Pvalue,TstatR,PvalueR,mpar,mparR,abstval,tprob,tval,testp, gR, gR2,par;	 
		println("Please wait : Computing the Std Errors ..."); 
//I modified here, I put this as a comment
		//Covar();
		Tstat  = m_vPar'./m_vStdErrors; 
        mpar = m_vPar ~ m_vStdErrors' ~ Tstat'; 
		MLEMeth(mpar,Pnames,m_iMethod,m_cPar); 
	} 
	decl i, j, names = zeros(1,m_cPar); 
	decl sumc_ab=0;
//En tettem ezt kommentarba
//	println(""); 
//	println("%18s","No. Observations :", "%10.0f", m_cT,			   
//           "%19s"," No. Parameters  :", "%10.0f", double(m_cPar)); 
//    println("%18s","Mean (Y)         :", "%10.5f", double(meanc(m_vY)), 
//           "%6s","  Variance (Y)    :", "%10.5f", double(variance(m_vY))); 
    println("LogLikelihood:", "%10.4f", double(m_dLL));
	
//En irtam ezt
	decl aic, bic;
	decl LogL = double (m_dLL);
	aic = (-2*LogL)/m_cT + 2 * m_cPar/m_cT; 
	bic	= (-2*LogL)/m_cT + m_cPar * log(m_cT)/m_cT;
	println("AIC: ",aic);
	println("BIC: ",bic);
	
	if (m_cP>0) sumc_ab+=sumc(m_vbetav); 
	if (m_cQ>0) sumc_ab+=sumc(m_valphav);

//En tettem ezt kommentarba	
	//((m_cFilter == 1)&&(m_cP+m_cQ>0)) ? println("%19s"," Alpha[1]+Beta[1]:", "%10.5f", double(sumc_ab)) : println("");  	 

	if ((m_cYsmall!=0)&&(m_cVar==1))
	{
		println("\nWarning : To avoid numerical problems, the estimated parameter");
		println("Cst(V), and its std.Error have been multiplied by 10^",m_cYsmall,".");
	}
	if ((m_iResult < 3)&&(m_cP+m_cQ>0) && (m_cFilter<100))
	{
		Positivity(m_cFilter); 
		Stationarity(m_cFilter);
	}
	
//Ezt en tettem kommentarba	
//	println("\nEstimated Parameters Vector : ");
//	if (m_cFilter != 10) 
//	{ 
//		for (i=0; i < m_cPar-1; ++i) 
//		{ 
//			print("% 8.6f",m_vPar'[i],";"); 
//		} 
//		print("% 8.6f",m_vPar'[m_cPar-1]); 
//		println("\n"); 
//	} 
//	else 
//	{ 
//		for (i=0; i < m_cPar-2; ++i) 
//		{ 
//			print("% 8.6f",m_vPar'[i],";"); 
//		} 
//		print("% 8.6f",m_vPar'[m_cPar-2]); 
//		println("\n");	 
//	}
	
//Modified here, originally it was 3 instead of 2
	if (m_iResult > 3)		  					 
	{ 
		decl i; 
		println("Parameters Names"); 
		for (i = 0; i < sizer(m_vPar); ++i)	print("%-17s", Pnames[i],"; "); 
		println("\n The tests are not reported since there is no convergence."); 
	}
	if (m_cPrintTest == 1)Tests();

	println("Long term moments:");
	println("Volatility:\t",m_vol);
	if ((m_cDist==4)  || (m_cDist==5))
	{
		println("Vol1:\t" , m_vol1);
		println("Vol2:\t", m_vol2);
		if (m_cDist==5)	println("Vol3:\t" , m_vol3);
		else println("Vol3:");
	}
	else
	{
		println("Vol1:\t");
		println("Vol2:\t");
		println("Vol3:\t");
	}
	println("Skewness:\t",m_sk);
	println("Kurtosis:\t",m_kurt);
	

	if (m_momtest)
	{
		 for (i=1; i<5; i++)
		 	println(m_vmomtest[i-1][0]);
		 for (i=1; i<5; i++)
		 	for (j=1; j<5; j++)
		 		println(m_vmomtest[i-1][j]);
		 println(m_testtot[0][0]);
	}
} 
 
Garch::MLEMeth(const par, const parnames, const name, const nbpar)
{ 
	decl i, mx, tval, abstval, tprob, astval, tp;
	if (name == M_HESS) 									
		println("\n Maximum Likelihood Estimation (Std.Errors based on Second derivatives)"); 
	else if (name == M_CROSSPRODUCT) 							
		println("\n Maximum Likelihood Estimation (Std.Errors based on Numerical OPG matrix)"); 
	else 
		println("\nQuasi Maximum Likelihood Estimation"); 
	print("%29s", "Coefficient", "%11s", "Std.Error"); 
    println("%9s", "t-value", "%8s", "t-prob"); 
	for (i = 0; i < sizer(par); ++i)								 
   	{
       	print("%-17s", parnames[i], "%#12.6f", par[i][0]); 
   		print("%#11.5g", par[i][1]); 
    	tval = par[i][2]; 
		abstval = fabs(tval); 
    	tprob = 2 * tailt(abstval, m_cT-sizer(par));  
   		println(abstval <= 1e-4 ? "%9.2f" : abstval >= 1e3 ? "%#9.4g" 
	   		: "%#9.4g", tval, "%8.4f", tprob); 
	} 
	if (m_cFilter == 10)										  
		println("%-17s", "GARCH(Beta1)", "%#12.6f", m_vbetav[0]);  
	if (m_cFix==1)			
	{
		decl parnames_all=GetParNames();
		decl par_fixed=selectifr(range(0,rows(m_vFix)-1)',m_vFix); // Select the row numbers of the fixed parameters
		decl vpar_fixed=selectifr(GetPar(),m_vFix);				   // Select the values of the fixed parameters
		for (i = 0; i < sizer(par_fixed); ++i) 
        	println("%-17s", parnames_all[par_fixed[i]], "%#12.6f", vpar_fixed[i]);
	}
} 
 
Garch::Covar() 
{ 
    decl mhess,hs,Par, gR,COV;  
	Par = m_vPar;
	if (m_iMethod!=M_CROSSPRODUCT)
	{
		if (Num2Derivative(FigLL, Par, &mhess)) 
		{ 
			hs = invert(mhess); 
			COV = -hs;  
		}
	}
	if (m_iMethod!=M_HESS)
	{
		m_cRobustLL=1; 
		oxwarning(0);
		if (NumJacobianEx(FigLL2, Par, <>, TRUE, &m_vGrad))
		{
			if (m_iMethod==M_CROSSPRODUCT) 
				COV = invert(m_vGrad'*m_vGrad);	
			if (m_iMethod==M_QMLE) 
				COV = hs*(m_vGrad'*m_vGrad)*hs;
		}
		if (COV==0) println("\nWarning: Covariance matrix not positive definite\n", "Std.Errors cannot be computed");
		m_cRobustLL=0; 
	}
	m_mCovar=COV;
	m_vStdErrors = sqrt(diagonal(COV));	
	
	return <>; 
} 

Garch::Positivity(const filter)		
{ 
  decl posit = 0; 
  println("\nThe sample mean of squared residuals was used to start recursion."); 
  if (m_cXV > 0) 
  	println("Positivity & stationarity constraints could not be computed because there are explanatory variables in the conditional variance equation."); 
  else  
  { 
  	if ((filter == 1)&&(m_cP > 0)) 		// GARCH - Positivit
  	{ 
		decl i,j; 
		decl delta = zeros(1, m_cT); 
 
		for (i = 1; i < m_cQ+1; i++) 
		{ 
			delta[i] =  m_valphav[i-1]; 
			for (j = 1; j < m_cP+1; j++) if (i >= j) delta[i] += m_vbetav[j-1] * delta[i-j]; 
		} 
		for (i = m_cQ+1; i < m_cT; i++) 
		{ 
			delta[i] = m_vbetav[0] * delta[i-1]; 
			for (j = 2; j < m_cP+1; j++) if (i >= j) delta[i] += m_vbetav[j-1] * delta[i-j]; 	
		} 
		 
		if (limits((delta)')[0][0] >= 0)  	posit = 1; 
		else								posit = 0; 
 
	    print("The positivity constraint for the GARCH (", m_cP,",",m_cQ,") is "); 
		(posit == 1) ? println("observed.") : println("not observed.")	; 
		println("This constraint is alpha[L]/[1 - beta(L)] >= 0.");
	} 
  	else if (filter == 11) 	 // FIGARCH(1,d,1) ou (0,d,1) (BBM) - Positivit
  	{ 
		decl a, b, c, d;
		
		if ((m_cP == 1)&&(m_cQ == 0)) 
		{ 
			if ((m_calpha0 > 0)&&(0 <= m_vbetav[0])&&(m_vbetav[0] <= m_dD)&&(m_dD<= 1))	posit = 1; 
			else 																		posit = 0;

			println("The positivity constraint for the FIGARCH (", m_cP,",d,",m_cQ,") is "); 
			(posit == 1) ? println("observed.") : println("not observed."); 
			println("  => See Bollerslev and Mikkelsen (1996) for more details."); 			
		}		 
		if ((m_cP == 1)&&(m_cQ == 1)) 							
		{ 
	 		a = m_vbetav[0]-m_dD; 
			b = ((2-m_dD)/3); 
			c =	m_dD * (m_valphav[0] - ((1-m_dD)/2)); 
			d =	m_vbetav[0] * (m_valphav[0] - m_vbetav[0] + m_dD); 
 
			if ((m_calpha0 > 0)&&(a <= m_valphav[0]) && (m_valphav[0]<= b)&&(c <= d))  	posit = 1; 
			else																		posit = 0; 

			println("The positivity constraint for the FIGARCH (", m_cP,",d,",m_cQ,") is "); 
			(posit == 1) ? println("observed (",a,"<",m_valphav[0],"<",b," and ",c,"<",d," valid).") : println("not observed (",a,"<",m_valphav[0],"<",c,"<",d," not valid)."); 
			println("  => See Bollerslev and Mikkelsen (1996) for more details."); 
		}
	} 
	else if (filter == 12) 	   // FIGARCH(1,d,1) ou (0,d,1) (Chung) - Positivit
  	{ 
		if ((m_cP == 1)&&(m_cQ == 0)) 
		{ 
			if ((m_calpha0 > 0)&&(0 <= m_vbetav[0])&&(m_vbetav[0] <= m_dD)&&(m_dD<= 1))	posit = 1; 
			else 																		posit = 0; 
		}		 
		if ((m_cP == 1)&&(m_cQ == 1)) 
		{ 
			if ((m_calpha0 > 0)&&(0 <= m_valphav[0])&&(m_valphav[0] <= m_vbetav[0])&&(m_vbetav[0] <= m_dD)&&(m_dD<= 1))	posit = 1; 
			else 																										posit = 0;; 
		} 
 
		println("The positivity constraint for the FIGARCH (", m_cP,",d,",m_cQ,") is "); 
		(posit == 1) ? println("observed.") : println("not observed.")	; 
		println("  => See Chung (1999), Appendix A, for more details."); 
   	}  
  }; 

  return 1; 
} 

Garch::Stationarity(const filter)
{ 
  decl posit = 0; 

  if (m_cXV == 0) 
  { 
	if (filter == 1) 			
	{
		if (m_cNM2==0)
		{
			if ((m_calpha0 > 0)&&(sumc(m_vbetav)+sumc(m_valphav) < 1))			// GARCH - Existence 2e moment
			{
				decl i, val;
				posit = 1;

				if (m_cP > m_cQ)
				{
					for (i = 0; i < m_cQ; i++)		(m_valphav[i] + m_vbetav[i] >= 0) ? (posit = posit .* 1) : (posit = posit .* 0);
					for (i = m_cQ; i < m_cP; i++)	(m_vbetav[i] >= 0) ? (posit = posit * 1) : (posit = posit * 0);
				}
				else if (m_cP < m_cQ)
				{
					for (i = 0; i < m_cP; i++)		(m_valphav[i] + m_vbetav[i] >= 0) ? (posit = posit * 1) : (posit = posit * 0);
					for (i = m_cP; i < m_cQ; i++)	(m_valphav[i] >= 0) ? (posit = posit * 1) : (posit = posit * 0);
				}
				else  for (i = 0; i < m_cP; i++)	(m_valphav[i] + m_vbetav[i] >= 0) ? (posit = posit * 1) : (posit = posit * 0);
			}
			else posit = 0;
		
		    print("The unconditional variance for this GARCH (", m_cP,",",m_cQ,") "); 
			(posit == 1) ? println("exists and is positive.") : println("does not exist and/or is not positive.")	; 
			println("The conditions are alpha[0] > 0, alpha[L] + beta[L] < 1 and alpha[i] + beta[i] >= 0.");
			println("  => See Doornik & Ooms (2001) for more details.");

			if ((m_cP < 2)&&(m_cQ == 1))	// GARCH(1,1)ou(0,1) - Existence 4e moment
			{
				decl const2,Kurt,E,E2,E3,E4,s;
				s = exp(m_cA);
			
				if (m_cDist==0) 		Kurt = 3;
				else if (m_cDist==1) 	Kurt = 3 * (m_cV - 2)/(m_cV - 4);
				else if (m_cDist==2) 	Kurt = gammafact((5 * m_cV)/2) * gammafact(m_cV/2) / ((gammafact(3 * m_cV / 2))^2);
				else if (m_cDist==3)
				{
					E  = mom_trst(m_cV,1) * ( s - (1/s) );
					E2 = mom_trst(m_cV,2) * ( (s^3) + (1/s)^3 ) / ( s + (1/s) );
					E3 = mom_trst(m_cV,3) * ( (s^4) - (1/s)^4 ) / ( s + (1/s) );
					E4 = mom_trst(m_cV,4) * ( (s^5) + (1/s)^5 ) / ( s + (1/s) );
					Kurt = ( E4 - 4*E3*E + 6*E2*(E^2) - 3*(E^4) ) / ((E2 - E^2)^2);
				}
				
//Ezt en commentaltam			
//				(m_cP == 0) ? (const2 = m_valphav[0]^2 * Kurt) : (const2 = m_vbetav[0]^2 + 2 * m_vbetav[0] * m_valphav[0] + m_valphav[0]^2 * Kurt);

//				print("The condition for existence of the fourth moment of the GARCH is "); 	
//				(const2 < 1) ? println("observed.") : println("not observed.")	; 
//				println("The constraint equals ", double(const2)," and should be < 1.");
//			    println("  => See Ling & McAleer (2001) for details.");					
			}
		}
		else
		{
		//ide jon a 2. es 4. moment existence tesztelese
		}
		
	}
	else if (filter == 3) 		   // GJR - Existence 2e moment
	{ 
		decl k, constraint, asx; 

		if (m_cDist==3)	k=1/(1+exp(m_cA)^2);								 
		else 			k=0.5;

		(m_cP > 0) ? (constraint = sumc(m_vbetav) + sumc(m_valphav + (m_vleverage.*k))) : (constraint = sumc(m_valphav + (m_vleverage.*k))); 
		 
		print("The condition for existence of the second moment of the GJR is "); 		
		(constraint < 1) ? println("observed.") : println("not observed.")	; 
		println("This condition is alpha(1) + beta(1) + k gamma(1) < 1 (with k = ", double(k)," with this distribution.)");
		println("In this estimation, this sum equals ", double(constraint),".");

		if ((m_cP < 2)&&(m_cQ == 1))	// GJR(1,1)ou(0,1) - Existence 4e moment
		{
			decl const2,Kurt,E,E2,E3,E4,s;
			s = exp(m_cA);
			
			if (m_cDist==0) 		Kurt = 3;
			else if (m_cDist==1) 	Kurt = 3 * (m_cV - 2)/(m_cV - 4);
			else if (m_cDist==2) 	Kurt = gammafact((5 * m_cV)/2) * gammafact(m_cV/2) / ((gammafact(3 * m_cV / 2))^2);
			else if (m_cDist==3)
			{
				E  = mom_trst(m_cV,1) * ( s - (1/s) );
				E2 = mom_trst(m_cV,2) * ( (s^3) + (1/s)^3 ) / ( s + (1/s) );
				E3 = mom_trst(m_cV,3) * ( (s^4) - (1/s)^4 ) / ( s + (1/s) );
				E4 = mom_trst(m_cV,4) * ( (s^5) + (1/s)^5 ) / ( s + (1/s) );
				Kurt = ( E4 - 4*E3*E + 6*E2*(E^2) - 3*(E^4) ) / ((E2 - E^2)^2);
			}
			
			(m_cP == 0) ? (const2 = (m_valphav[0]^2 +  2 * m_valphav[0] * m_vleverage[0] * k + m_vleverage[0]^2 * k) * Kurt) :
			   			  (const2 = m_vbetav[0]^2 + 2 * m_vbetav[0] * m_valphav[0] +  2 * m_vbetav[0] * m_vleverage[0] * k
									 + (m_valphav[0]^2 +  2 * m_valphav[0] * m_vleverage[0] * k + m_vleverage[0]^2 * k) * Kurt);

			(const2 < 1) ? (posit = 1) : (posit = 0);
			(m_cDist == 3) ? ((m_cV >= 5) ? (posit = 1) : (posit = 0)) : (posit = posit);
			
			print("The condition for existence of the fourth moment of the GJR is "); 	
			(const2 < 1) ? println("observed.") : println("not observed.")	; 
			print("The constraint equals ", double(const2)," (should be < 1)");
			(m_cDist == 1) ? print(" while the degree of freedom is ", m_cV, " (should be >= 5)") : print(".");
			println("  => See Ling & McAleer (2001) for details.");					
		}
	}
	else if (filter == 4) 	 // APARCH - Existence
	{ 
		decl ki = KiAparch(m_cDist,m_cQ, m_cA|m_cV, m_ddelta, m_vgamma);  
		decl constraint, asx; 
		(m_cP > 0) ? (constraint = sumc(m_vbetav) + sumc(m_valphav.*ki)) : (constraint = sumc(m_valphav.*ki)); 
		 
		print("The condition for existence of E(sigma^delta) and E(|e^delta|) is "); 
		(constraint < 1) ? println("observed.") : println("not observed.")	; 
		println("The constraint equals ", double(constraint)," and should be < 1."); 
	} 
  };
  
  if(m_cNeg != 0)  println("WARNING ! There are ", int(m_cNeg), " estimated negative conditional variances.");   

  return 1; 
} 

Garch::Tests() 
{ 
	decl i; 
	println(""); 
	println("\n  ***********"); 
	println(" ** TESTS **");	 
	print("***********");	 
	Normality(m_vStandErrors); 
 	ICriterion(m_dLL, m_cT, sizer(m_vPar)); 
	if (m_cLagPort != <>) 
	{ 
		println("Q-Statistics on Standardized Residuals");				
		BoxPQ(m_vStandErrors,m_cLagPort, m_cAR+m_cMA);	 
		println("--------------"); 
		println("Q-Statistics on Squared Standardized Residuals");				
		BoxPQ(m_vSqStandErrors, m_cLagPort, m_cP+m_cQ);  	 
		println("--------------"); 
	} 
	if (m_cLagArch != <>) 
	{ 
		for (i = 0; i < sizer(m_cLagArch); i++)   
		{ 
			ArchTest(m_vStandErrors, 1, m_cLagArch[i],  m_cP+m_cQ, TRUE);  
		} 
		println("--------------"); 
	} 
	SBT(m_vE, m_vSigma2); 
 	if (m_cNyblom==1)
	{
		if (m_vGrad==0)
		{
			if (NumJacobianEx(FigLL2, m_vPar, <>, TRUE, &m_vGrad))
				Nyblom(m_vStandErrors,m_vGrad);
			else
				println("The Nyblom test can't be computed");
		}
		else
			Nyblom(m_vStandErrors,m_vGrad);		
	}
	if (m_cGOF==1)	 	APGT(m_cd,m_cCellGOF,m_cPar); 
} 

Garch::STORE(const res, const res2, const condv, const mfor, const vfor, const stdres, const d, const name, const file) 
{ 
	decl n1,n2,n3,n4,n5,n6,n7;													    
	n1 = "Res_"~name; 
	n2 = "SqRes_"~name; 
	n3 = "CondV_"~name; 
	n4 = "MeanFor_"~name; 
	n5 = "VarFor_"~name;   
	n6 = "NormErr_"~name;
	n7 = "Num1Der_"~name;
	 
	if ((res > 0) && (file == 0))	   		savemat(n1~".xls",m_vE);			  
	else if	((res > 0) && (file > 0))  		savemat(n1~".in7",m_vE); 
 
	if ((res2 > 0) && (file == 0))			savemat(n2~".xls",m_vE.^2); 
	else if	((res2 > 0) && (file > 0)) 		savemat(n2~".in7",m_vE.^2); 
 
	if ((condv > 0) && (file == 0))	   		savemat(n3~".xls",m_vSigma2); 
	else if	((condv > 0) && (file > 0))		savemat(n3~".in7",m_vSigma2); 
 
	if ((mfor > 0) && (m_cFOR > 0) && (file == 0))	savemat(n4~".xls",m_mForc[][0]); 
	else if	((condv > 0) && (file > 0))		        savemat(n4~".in7",m_mForc[][0]); 
 
	if ((vfor > 0) && (m_cFOR > 0) && (file == 0))	savemat(n5~".xls",m_mForc[][1]); 
	else if	((condv > 0) && (file > 0))		        savemat(n5~".in7",m_mForc[][1]);

//En irtam
	if ((stdres > 0) && (file == 0))		savemat(n6~".xls",m_stdres); 
	else if	((stdres > 0) && (file > 0))	savemat(n6~".in7",m_stdres);

	if ( (d>0)&& (m_num1der == 0)) Num1Der();

	if ((d > 0) && (file == 0))		savemat(n7~".xls",m_num1der); 
	else if	((d > 0) && (file > 0))	savemat(n7~".in7",m_num1der);	  
}

//En irtam
Garch::Num1Der()
{
	Covar();
	decl num1der, deriv, i;

	m_myt=0;
	//Num1Derivative (Figll, m_vPar, &num1der);
	//num1der=num1der';
	num1der = m_vGrad[0][];
	
	for (i=1; i<m_cT; i++)		 
	{
		m_myt=i;
		//Num1Derivative (Figll, m_vPar, &deriv);
		//deriv=deriv';
		deriv = m_vGrad[i][];
		
		num1der |= (deriv);
	}
	m_num1der=num1der;
	
}
 
Garch::SAVEPAR(const i, const file)		  	 
{ 
  if (i>0)		savemat(file~".xls" ,PAR()[][:i-1]); 
  return  1; 
}

Garch::VaR_test(const Y, const emp_quan_pos, const emp_quan_neg, const th_quan)
/*  
**  Purpose : Computes the Kupiec LR test
**
**  Input   : Y = observations (Tx1)
**			  emp_quan_pos = empirical quantiles for short positions (Tx1)
**			  emp_quan_neg = empirical quantiles for long positions (Tx1)
**			  th_quan = theoretical quantiles	(kx1)
**  Output  : Statistic ~ P value of the test, i.e. X(1)
**
** Remark: Expected shortfall1: average size of the loss when the quantile is exceeded
**         Expected shortfall2: average size of the (loss/predicted loss) when the quantile is exceeded
**
*/
{
	decl failure_pos=Y.>=emp_quan_pos;
	decl failure_neg=Y.<=emp_quan_neg;
	decl failure_rate_pos=meanc(failure_pos);
 	decl failure_rate_neg=meanc(failure_neg);
	decl x_pos=sumc(failure_pos)';
	decl x_neg=sumc(failure_neg)';
	decl n=rows(Y);
    decl p_pos=x_pos/n;
    decl p_neg=x_neg/n;		   
    decl lr_pos=2*( x_pos.*log(p_pos)+(n-x_pos).*log(1-p_pos) - (x_pos.*log(1-th_quan')+(n-x_pos).*log(th_quan')) );
    decl lr_neg=2*( x_neg.*log(p_neg)+(n-x_neg).*log(1-p_neg) - (x_neg.*log(1-th_quan')+(n-x_neg).*log(th_quan')) );
	decl prob_pos=1-probchi(lr_pos,1);
	decl prob_neg=1-probchi(lr_neg,1);	
	decl CI_pos=(p_pos-1.96*sqrt(p_pos.*(1-p_pos)/n))~(p_pos+1.96*sqrt(p_pos.*(1-p_pos)/n));
	decl CI_neg=(p_neg-1.96*sqrt(p_neg.*(1-p_neg)/n))~(p_neg+1.96*sqrt(p_neg.*(1-p_neg)/n));
	decl esf1_pos=sumc(failure_pos.*Y)./sumc(failure_pos);
	decl esf1_neg=sumc(failure_neg.*Y)./sumc(failure_neg);
	decl esf2_pos=sumc(failure_pos.*(Y./emp_quan_pos))./sumc(failure_pos);
	decl esf2_neg=sumc(failure_neg.*(Y./emp_quan_neg))./sumc(failure_neg);

	println("%50s","- Short positions -");
	println("%13s","Quantile","%15s","Failure rate","%13s","Kupiec LRT","%11s","P-value","%12s","ESF1","%13s","ESF2");
	println(th_quan'~(1-failure_rate_pos')~lr_pos~prob_pos~esf1_pos'~esf2_pos'); //95 CI ~(1-CI_pos[][1])~(1-CI_pos[][0])
	println("%50s","- Long positions -");
	println("%13s","Quantile","%15s","Failure rate","%13s","Kupiec LRT","%11s","P-value","%12s","ESF1","%13s","ESF2");
	println(1-th_quan'~failure_rate_neg'~lr_neg~prob_neg~esf1_neg'~esf2_neg'); //95 CI ~(1-CI_pos[][1])~(1-CI_pos[][0])

	return 0;
}
/*----------------------------/////////////------------------------------*/ 
/*---------------------------// OX PACK //-------------------------------*/ 
/*--------------------------/////////////--------------------------------*/ 

Garch::SendVarStatus()		 
{ 
	m_cMean = 1;			 
	m_cVar = 1; 
 	m_cAR = 0; 
	m_cMA = 0; 
	m_cARFI = 0; 
  	m_cP = 1; 
    m_cQ = 1; 
 	m_cD = 0; 
  	m_cDist = 0; 
   	m_cRobustLL = 0; 
	m_cFilter = 1; 
	m_cD = 0; 
	m_cBound = 0;
	m_c_in_mean = 0;
    m_vGrad = 0;

		
	if (m_iModelClass == MC_GARCH)
	return 
		{{ "&Y variable", 'Y', STATUS_ONEONLY + STATUS_ENDOGENOUS, Y_VAR}, 
         { "&Mean", 'M', STATUS_GROUP, X_VAR}, 
		 { "&Variance", 'V', STATUS_GROUP2, Z_VAR}, 
         { "&Obs.Var.", 'O', STATUS_GROUP + STATUS_GROUP2 + STATUS_ONEONLY, O_VAR}};
	else															
		return
        {{ "&Tested Series",'T',STATUS_ENDOGENOUS+STATUS_GROUP, T_VAR}
		};
} 
 
Garch::SendSpecials()		    
{ 
	    return <>;
} 

//Ezt sem ertem
Garch::SendDialog(const sDialog)	   
{ 
	if (sDialog == "modelclass0")
	{
		// set model class, and activate model formulation dialog
		m_iModelClass = MC_GARCH;
		"OxPackDialog"("OP_FORMULATE", 0, 0, 0);
		return 0;
	}
	else if (sDialog == "modelclass1")			 
	{
		// set model class, and activate model formulation dialog
		m_iModelClass = MC_STATS;
		"OxPackDialog"("OP_FORMULATE", 0, 0, 0);
		return 0;
	}
	else if (sDialog == "OP_OPTIONS") 
    { 
        decl deps1, deps2, iprint, iitmax, bcompact; 
		[iitmax, iprint, bcompact] = GetMaxControl();        
        [deps1, deps2] = GetMaxControlEps();         
		iprint = 10; 
		return 
        { 
            { "Maximization Settings" }, 
            { "Maximum number of iterations", CTL_INT,    iitmax,  "itmax" }, 
            { "Write results for every",      CTL_INT,    iprint,  "iprint" }, 
            { "Write in compact form",        CTL_CHECK,  bcompact,"compact"}, 
            { "Convergence" }, 
            { "Strong convergence tolerance", CTL_DOUBLE, deps1,   "eps1"}, 
            { "Weak convergence tolerance",   CTL_DOUBLE, deps2,   "eps2"}, 
			{ "Default" }, 
            { "Reset default",                CTL_CHECK,  0,       "default"} 
		}; 
    } 
	else if (sDialog == "OP_SETTINGS") 
	{ 
		decl m_cLagPort = <5;10;20;50>; 
		decl m_cLagArch = <2;5;10>;
		
		if (m_iModelClass == MC_GARCH)
		return 
		{ 
			{ "Parameters Estimation",CTL_GROUP,0},						  
			{ " Unbounded Parameters", CTL_RADIO, m_cBound, "UP"}, 
			{ " Bounded Parameters", CTL_RADIO}, 
			{ "AR(FI)MA Orders (m,d,l)",CTL_GROUP,0}, 							 
			{ " AR order (m) = ", CTL_INT, m_cAR, "AR" }, 
			{ " MA order (l) = ", CTL_INT, m_cMA, "MA" }, 
			{ " ARFIMA", CTL_CHECK, m_cARFI, "arfima" }, 
			{ "GARCH Orders",CTL_GROUP, 1}, 
			{ " Garch order (p) = ", CTL_INT, m_cP, "p" }, 
			{ " Arch  order (q) = ", CTL_INT, m_cQ, "q" }, 
			{ "Model", CTL_GROUP,0 }, 
			{ " GARCH",	CTL_RADIO, m_cFilter < 10 ? m_cFilter-1 : 0 , "spec"}, 
			{ " EGARCH", CTL_RADIO}, 
			{ " GJR", CTL_RADIO}, 
			{ " APARCH", CTL_RADIO}, 
			{ " IGARCH",CTL_RADIO}, 
			{ " FIGARCH", CTL_RADIO}, 
			{ " FIEGARCH", CTL_RADIO}, 
			{ " FIAPARCH", CTL_RADIO}, 
			{ " HYGARCH",CTL_RADIO},
			{ "ARCH-in-Mean",CTL_GROUP,0},
			{ " No ARCH-in-Mean", CTL_RADIO, m_c_in_mean, "in_mean"}, 
			{ " Add the conditional variance", CTL_RADIO}, 
			{ " Add the conditional std.",CTL_RADIO},
			{ "Distribution",CTL_GROUP,0}, 
			{ "Gauss",	CTL_RADIO, m_cDist, "distri"}, 
			{ "Student",CTL_RADIO}, 
			{ "GED",CTL_RADIO}, 
			{ "Skewed Student",CTL_RADIO}, 
			{ "Constants",CTL_GROUP,0}, 
			{ " Mean", CTL_CHECK, m_cMean, "cst-m"}, 
			{ " Variance", CTL_CHECK, m_cVar, "cst-v"}
		};
		else if (m_iModelClass == MC_STATS)					    
		return
		{	{ "Choose some tests:" },
			{ "Basic Stats", CTL_CHECK,  1, "basic"},
			{ "Normality Test", CTL_CHECK, 1, "normality" },
			{ "LM Arch Test", CTL_CHECK,  1, "lmarch"},		
			{ "   with lags : ", CTL_STRMAT, m_cLagArch, "LagArch"},
			{ "Box-Pierce with Standardized Series", CTL_CHECK, 1, "box" },
			{ "Box-Pierce with Squared Standardized Series", CTL_CHECK, 1, "box2" },
			{ "   with lags : ", CTL_STRMAT, m_cLagPort, "LagBP"} 
		};
	}
	// allow base class to process unhandled cases 
	return Modelbase::SendDialog(sDialog); 
} 
 
//Ezt sem ertem
Garch::SendMethods()			 
{ 
	decl asopt,aval,startmet; 
	startmet = 0;
	m_cFix=0; 
 
	if (m_iModelClass == MC_GARCH)
	{
		if ("OxPackDialog"("Starting Values", 
						{ 	{ "Starting Values" }, 
							{ " Choose the way the starting values are fixed :"}, 
							{ "  Default (given by this program)",CTL_RADIO, startmet, "startmethod" }, 
							{ "  Manually (Individual Form)",CTL_RADIO}, 
							{ "  Manually (Matrix Form)",CTL_RADIO} 
						},		 
						&asopt, &aval) 
	    	)				    
			{ 
				m_cStartMet = aval[0]; 
			} 
 
		return	{	{"Second Derivatives", M_HESS, FALSE, 0}, 
				{"Outer-Product of Gradients", M_CROSSPRODUCT, FALSE, 0}, 
				{"Quasi-Maximum Likelihood Estimation", M_QMLE, FALSE, 0}				 
				};
	}
	else if (m_iModelClass == MC_STATS)
   		return	{	{"Tests on raw series", M_TESTS, FALSE, 0} 
				};
} 
 
//Detto
Garch::ReceiveData()		 
{ 
	Modelbase::ReceiveData(); 
} 
 
//Detto
Garch::ReceiveModel()			 
{ 
	Select(Y_VAR, "OxPackGetData"("SelGroup", Y_VAR)); 
	Select(Z_VAR, "OxPackGetData"("SelGroup", Z_VAR)); 
	Select(O_VAR, "OxPackGetData"("SelGroup", O_VAR));
	Select(T_VAR, "OxPackGetData"("SelGroup", T_VAR));
	Modelbase::ReceiveModel(); 
} 
 
//Detto
Garch::SendMenu(const sMenu)	   
{ 
	if (sMenu == "ModelClass") 								
	{ 
		return 
			{{ "&1: Garch Models", "modelclass0", 1,
					m_iModelClass == MC_GARCH},
			 { "&2: Dataset Statistics", "modelclass1",
			 		m_iModelClass == MC_STATS}
			 };
			 
	} 
	else if (sMenu == "Test") 
	{ 
	    return 
			{{ "&Tests ...", m_iModelClass == MC_STATS ? "" : "OP_TEST_SUMMARY"}, 
			 { "&Graphic Analysis ...", "OP_TEST_GRAPHICS"}, 
			 0, 
			 { "&Forecast ...", m_iModelClass == MC_STATS ? "" : "OP_TEST_FORECAST"}, 
			 0, 
			 { "&Exclusion Restrictions...", m_iModelClass == MC_STATS ? "" : "OP_TEST_SUBSET"},				 
			 { "&Linear Restrictions...", m_iModelClass == MC_STATS ? "" : "OP_TEST_LINRES"},			 
			 0,																 
			 { "&Store ...", m_iModelClass == MC_STATS ? "" : "OP_TEST_STORE"} 
			}; 
	} 
} 
 
//Detto
Garch::ReceiveDialog(const sDialog, const asOptions, const aValues)   
{ 
	if (sDialog == "OP_OPTIONS")
    {
		// process user actions for options dialog
		Modelbase::ReceiveDialog(sDialog, asOptions, aValues);
	}
	else if (sDialog == "OP_SETTINGS") 
	{ 
	   if (m_iModelClass == MC_GARCH)
	   {
	   		decl fra, spe; 
	   		m_cBound = aValues[0]; 
	   		m_cAR = aValues[1]; 
	   		m_cMA = aValues[2]; 
		   	m_cARFI = aValues[3]; 
		   	m_cP = aValues[4]; 
	   		m_cQ = aValues[5]; 
 		   	spe = aValues[6]; 
 		   	m_c_in_mean = aValues[7]; 
	    															
   	   		if (spe == 0)	   	{m_cFilter = 1; m_cEgarch = 0; m_cGJR = 0; m_cAparch = 0; m_cD = 0; m_cHY = 0;}  
			else if (spe == 1) 	{m_cFilter = 2; m_cEgarch = 1; m_cGJR = 0; m_cAparch = 0; m_cD = 0; m_cHY = 0;}  
			else if	(spe == 2) 	{m_cFilter = 3; m_cEgarch = 0; m_cGJR = 1; m_cAparch = 0; m_cD = 0; m_cHY = 0;} 
			else if	(spe == 3) 	{m_cFilter = 4; m_cEgarch = 0; m_cGJR = 0; m_cAparch = 1; m_cD = 0; m_cHY = 0;} 
   			else if (spe == 4)	{m_cFilter = 10; m_cEgarch = 0; m_cGJR = 0; m_cAparch = 0; m_cD = 0; m_cHY = 0;} 
			else if (spe == 5) 	{m_cEgarch = 0; m_cGJR = 0; m_cAparch = 0; m_cD = 1; m_cHY = 0;}  
			else if	(spe == 6) 	{m_cFilter = 21; m_cEgarch = 1; m_cGJR = 0; m_cAparch = 0; m_cD = 1; m_cHY = 0;} 
			else if	(spe == 7) 	{m_cEgarch = 0; m_cGJR = 0; m_cAparch = 1; m_cD = 1; m_cHY = 0;}
	   		else if (spe == 8)	{m_cFilter = 51; m_cEgarch = 0; m_cGJR = 0; m_cAparch = 0; m_cD = 1; m_cHY = 1;} 

		   	if ((m_cFilter == 3)&&(m_cQ < 1)) 
			{ 
				println("In GJR, the ARCH order (q) must be greater than 0.\n", 
						"It is currently equal to ", m_cQ,". It has been automatically fixed at 1."); 
				m_cQ = 1; 
				Pause(2); 
			} 
			if ((m_cFilter == 4)&&(m_cQ < 1)) 
			{ 
				println("In APARCH, the ARCH order (q) must be greater than 0.\n", 
						"It is currently equal to ", m_cQ,". It has been automatically fixed at 1."); 
				m_cQ = 1; 
				Pause(2); 
			} 
 
	   		m_cDist = aValues[8]; 
	   		if (m_cDist == 0) 	   { m_cSk = 0; m_cKu = 0;} 
	   		else if (m_cDist == 1) { m_cSk = 0; m_cKu = 1;} 
			else if (m_cDist == 2) { m_cSk = 0; m_cKu = 1;} 
			else if (m_cDist == 3) { m_cSk = 1; m_cKu = 1;}; 
 
	   		m_cMean = aValues[9]; 
	   		m_cVar = aValues[10]; 
	   }
	   else if (m_iModelClass == MC_STATS)	
	   {
			decl i;
			
			m_cLagArch = aValues[3];
			m_cLagPort = aValues[6]; 
 			m_vTests = aValues;
     }							 	   
	   return 1;
	} 
	else if (sDialog == "OP_TEST_GRAPHICS") 
	{ 
	  	decl asdlg, asoptions, avalues, quan = <0.025;0.975>, plot; 
		if ("OxPackDialog"("Graphics", 
				{	{ "Series" }, 
					{ "Raw Series (Y)", CTL_CHECK, 0, "series" }, 
					{ "Residuals", CTL_CHECK,  m_iModelClass == MC_STATS ? -1 : 0, "residuals" }, 
					{ "Squared Residuals", CTL_CHECK, m_iModelClass == MC_STATS ? -1 : 0, "squres" }, 
					{ "Conditionnal Variance", CTL_CHECK, m_iModelClass == MC_STATS ? -1 : 0, "hetero" }, 
					{ "In-Sample Dynamic Interval Forecast",CTL_GROUP, m_iModelClass == MC_STATS ? -1 : 0}, 	 
					{ "None", CTL_RADIO, 0, "quantmeth"}, 
					{ "Empirical Quantiles", CTL_RADIO}, 
					{ "Theoretical Quantiles", CTL_RADIO}, 
					{ "   with the following quantiles :", CTL_STRMAT, quan, "quan"} 
				}, 
				&asoptions, &avalues) 
			) 
		{ 
			plot = 0;  
			if ((avalues[0] != 0)||(avalues[1] != 0)||(avalues[2] != 0)||(avalues[3] != 0)) 
				TestGraphicAnalysis(avalues[0],avalues[1],avalues[2],avalues[3],plot); 
			plot = avalues[0] + avalues[1] + avalues[2] + avalues[3]; 
			if (avalues[4] != 0)  
				QuantileGraphs(avalues[4],avalues[5],plot); 
			ShowDrawWindow(); 
		} 
	} 
	else if (sDialog == "OP_TEST_SUMMARY") 
	{	 
		decl i,l,asdlg, asoptions, avalues; 
		decl m_cLagPort = <5;10;20;50>; 
		decl m_cLagArch = <2;5;10>; 
		decl m_cCellGOF = <40;50;60>; 
		 
		if ("OxPackDialog"("Tests", 
				{ 	{ "Available Tests :" }, 
					{ " Information Criteria", CTL_CHECK, 1, "IC"}, 
					{ " Normality Test", CTL_CHECK, 1, "Norm"}, 
					{ " Box/Pierce with Standardized Residuals", CTL_CHECK, 1, "BPR"}, 
					{ " Box/Pierce with Squared Standardized Residuals", CTL_CHECK, 1, "BPR2"}, 
					{ "   with lags : ", CTL_STRMAT, m_cLagPort, "LagPort"}, 
					{ " Sign Bias Test", CTL_CHECK, 0, "SBT"}, 
					{ " Arch Test", CTL_CHECK, 0, "Arch"}, 
					{ "   with lags : ", CTL_STRMAT, m_cLagArch, "LagArch"}, 
					{ " Nyblom Stability Test", CTL_CHECK, 0, "Nybl"}, 
					{ " Adjusted Pearson Chi-square Goodness-of-fit", CTL_CHECK, 0, "APGF"}, 
					{ "   with Cells number : ", CTL_STRMAT, m_cCellGOF, "NumCells"}, 
					{ " Print Variance-Covariance Matrix", CTL_CHECK, 0, "VCMat"} 
				},	 
				&asoptions, &avalues) 
			) 
		{ 
			m_cLagPort = avalues[4]; 
			m_cLagArch = avalues[7]; 
			m_cCellGOF = avalues[10]; 
			println("\nTESTS :");	 
			println("------------");	 
 
			if (avalues[0] != 0) 
				{ 
					ICriterion(m_dLL, m_cT, sizer(m_vPar)); 
					println("---------------"); 
				} 
			if (avalues[1] != 0) 
				{ 
					Normality(m_vStandErrors); 
					println("---------------"); 
				} 
			if (avalues[2] != 0) 
				{ 
					println("Q-Statistics on Standardized Residuals");				
					BoxPQ(m_vStandErrors,m_cLagPort, m_cAR+m_cMA); 
					println("---------------"); 
				} 
 
	   		if (avalues[3] != 0)
				{
					println("Q-Statistics on Squared Standardized Residuals");				
					BoxPQ(m_vSqStandErrors, m_cLagPort, m_cP+m_cQ); 
					println("---------------"); 
				} 
			if (avalues[5] != 0)   	SBT(m_vE, m_vSigma2); 
			if (avalues[6] != 0) 
				{ 
					for (l = 0; l < sizer(m_cLagArch); l++)   
					ArchTest(m_vStandErrors, 1, m_cLagArch[l],  m_cP+m_cQ, TRUE); 
					println("---------------");	 
				} 
 		 	if (avalues[8] != 0)
			{
				if (m_vGrad==0)
				{
					if (NumJacobianEx(FigLL2, m_vPar, <>, TRUE, &m_vGrad))
						Nyblom(m_vStandErrors,m_vGrad);
					else
						println("The Nyblom test can't be computed");
				}
				else
					Nyblom(m_vStandErrors,m_vGrad);		
			}
			if (avalues[9] != 0)   	APGT(m_cd,m_cCellGOF,m_cPar); 
			if (avalues[11] != 0)
			{
				if (m_iMethod == M_HESS) 
					println("Variance-Covariance Matrix using Inverse of computed Hessian:");
				else if (m_iMethod == M_CROSSPRODUCT) 
					println("Variance-Covariance Matrix using Inverse of computed Numerical OPG matrix:");
				else
					println("Robust Variance-Covariance (QML):");
				println(m_mCovar);
			}
		}  	 
	}  
	else if (sDialog == "OP_TEST_FORECAST")					   
	{ 
		decl asoptions, avalues; 
		decl iplot = 0, etype = 1, prev = 15, crv = 2; 
		 
		if ("OxPackDialog"("Forecast", 
				{	{ "Forecasting" }, 
					{ "Number of forecasts", CTL_INT, 10, "cforc" },		   
					{ "Options",CTL_GROUP,0}, 									  
					{ "Print Forecasts Errors Measures", CTL_CHECK, 1, "fem" }, 
					{ "Print Forecasts", CTL_CHECK, 0, "prfor" }, 
					{ "Graph Forecasts", CTL_CHECK, 1, "graph" }, 
					{ "Number of pre-observations", CTL_INT, 10, "pre" }, 
					{ "Confidence Interval",CTL_GROUP,0}, 						  
					{ "None", CTL_RADIO, 1, "quantmeth"}, 
					{ "Error Bands", CTL_RADIO},
					{ "Error Bars", CTL_RADIO},
					{ "Error Fans", CTL_RADIO},
					{ "Critical Value", CTL_INT, 2, "cv" } 
				}, 
				&asoptions, &avalues) 
			) 
 
		{ 
			decl a = 0, b = 0; 
 
			if (m_cAR+m_cMA)	    
			{					    
	   			if (m_cAR)		m_vAR_MA = m_vAR;		 
	   			if (m_cMA) 
	   			{ 
	      			if (m_cAR)  m_vAR_MA |= m_vMA; 
		  			else		m_vAR_MA = m_vMA;		   
	   			} 
			}
			else  m_vAR_MA=<>;
 
			m_cTforc = avalues[0]; 
			m_cPrintFor = avalues[2];  
			if (m_cXM != 0) 	a =	sizer(m_mXM) + m_cTforc; 
			if (m_cXV != 0)		b = sizer(m_mXV) + m_cTforc; 
			 
			if ((a > GetSize()) || (b > GetSize()))  
			{ 
				println("Forecasting is not possible. You do not have enough out-of-sample actual explanatory variables observations."); 
				println("You have selected ",m_cT," observations in your sample."); 
				println("The maximum number of 1 step-ahead dynamic forecasting is ", GetSize()-m_cT," since the dataset includes ",GetSize() ," observations."); 
				exit(0);
			} 
				 
			FORECASTING(); 
 
			if ((m_cT + m_cTforc) > GetSize())  
			{ 
				println("Forecast tests are not possible. You do not have enough out-of-sample (actual) observations."); 
				println("You have selected ",m_cT," observations in your sample and a forecast horizon of ", m_cTforc,"."); 
				println("Since the whole database includes ", GetSize()," observations, the maximum sample size to run the tests is ",(GetSize()-m_cTforc),"."); 
			//	exit(0); 
			} 		
			GetForErrors(m_cOV); // To create m_Yfor and m_Hfor				 
			if (avalues[1] == 1)			
			{
				if ((m_cXM != 0)&&(sizer(GetXBetaForc(m_cTforc))< m_cTforc))																										   
						println("Forecasts errors measures cannot be computed because there are not enough out-of-sample observations for the explanatory variables in the mean."); 
				else if ((m_cXV != 0)&&(sizer(GetZBetaForc(m_cTforc))< m_cTforc))																										   
						println("Forecasts errors measures cannot be computed because there are not enough out-of-sample observations for the explanatory variables in the variance."); 
				else if ((m_cT + m_cTforc) < GetSize()+1) 	FEM(m_mForc, m_Yfor~m_Hfor);  	
			}
			
			prev = avalues[4]; 
			etype = avalues[5]; 
			crv = avalues[6];
			
			if (avalues[3] == 1) 
			{ 
				if (sizer(GetForcData(Y_VAR,m_cTforc))< m_cTforc)
						println("Forecasts graphics are not displayed because there are not enough out-of-sample observations for the Y series."); 
				else if ((m_cXM != 0)&&(sizer(GetXBetaForc(m_cTforc))< m_cTforc))																										   
						println("Forecasts graphics are not displayed because there are not enough out-of-sample observations for the explanatory variable(s) in the mean."); 
				else if ((m_cXV != 0)&&(sizer(GetZBetaForc(m_cTforc))< m_cTforc))																										   
						println("Forecasts graphics are not displayed because there are not enough out-of-sample observations for the explanatory variable(s) in the variance."); 
				else 	FOR_GRAPHS(0,prev,etype,crv);

				iplot = iplot + 3; 
			} 
			 
			if (iplot > 0) ShowDrawWindow(); 
		}   
	}				  
	else if (sDialog == "OP_TEST_STORE") 
	{ 
		decl asdlg, asoptions, avalues; 
		if ("OxPackDialog"("Store in Database", 
				{	{ "Store in database" }, 
					{ "Residuals", CTL_CHECK, 0, "residuals" }, 
					{ "Squared Residuals", CTL_CHECK, 0, "squres" }, 
					{ "Standardized Residuals", CTL_CHECK, 0, "stdres" }, 
					{ "Conditionnal Variance", CTL_CHECK, 0, "hetero" }, 
					{ "Mean Forecasts", CTL_CHECK, sizer(m_mForc) > 0 ? 0 : -1, "foremean" }, 
					{ "Variance Forecasts", CTL_CHECK, sizer(m_mForc) > 0 ? 0 : -1, "forevar" } 
				}, 
				&asoptions, &avalues) 
			) 
		{ 
			if (avalues[0] > 0) 
				"OxPackStore"(m_vE, m_iT1est, m_iT2est, "Res"); 
			if (avalues[1] > 0) 
				"OxPackStore"(m_vE.^2, m_iT1est, m_iT2est, "SqRes"); 
			if (avalues[2] > 0) 
				"OxPackStore"(m_vStandErrors, m_iT1est, m_iT2est, "StdRes"); 
			if (avalues[3] > 0) 
				"OxPackStore"(m_vSigma2, m_iT1est, m_iT2est, "CondV"); 
			if (avalues[4] > 0)	   
				"OxPackStore"(m_mForc[][0], m_iT2est+1, m_iT2est+m_cTforc, "ForY"); 
			if (avalues[5] > 0) 
-				"OxPackStore"(m_mForc[][1], m_iT2est+1, m_iT2est+m_cTforc, "ForVar"); 
		} 
	} 
	else 
	{	// allow base class to process unhandled cases 
		Modelbase::ReceiveDialog(sDialog, asOptions, aValues); 
	}
}

Garch::Dialogs() 
{ 
    decl asoptions2, avalues2, initvect; 
	decl i,cm,cv,ar,ma,arfi,arch,garch,d,regm,regv,gjr,agarch,theta1,theta2,psy,delta,g,v,a,Z,hy;
	decl cv_2, regv_2, arch_2, garch_2, d_2, gjr_2, theta1_2, theta2_2, psy_2, delta_2;
 	decl cv_3, regv_3, arch_3, garch_3, d_3, gjr_3, theta1_3, theta2_3, psy_3, delta_3;
 
	InitStartValues(1,m_cBound); 	// 304 Prbl: if	<> --> can't use the bounds ....
 
	if (m_cStartMet == 0)	  		GetPara(); 
	else if (m_cStartMet == 1) 
	{																			  
		cm = (m_cMean == 0) ? <> : m_clevel	; 
		regm = (m_cXM == 0) ? <> : m_vbetam; 
		arfi  = (m_cARFI == 0) ? <> : m_dARFI; 
		ar = (m_cAR == 0) ? <> : m_vAR; 
		ma = (m_cMA == 0) ? <> : m_vMA; 
		cv = (m_cVar == 0) ? <> : m_calpha0; 
		regv = (m_cXV == 0)	? <> : m_vpsyv; 
		//d = (m_cD == 0) ? <> : m_cD; 	   Szerintem e helyett inkabb van:
		d = (m_cD == 0) ? <> : m_dD; 
		arch = (m_cQ == 0) ? <> : m_valphav; 
		garch = (m_cP == 0) ? <> : m_vbetav;		 
		garch = (m_cD == 0) ? garch : garch./2;
		
//En irtam
		//innen
		if ( (m_cNM2 != 0)	|| (m_cNM3 != 0))
		{
			cv_2 = (m_cVar == 0) ? <> : m_calpha0_2; 
			regv_2 = (m_cXV == 0)	? <> : m_vpsyv_2; 
			arch_2 = (m_cQ == 0) ? <> : m_valphav_2; 
			garch_2 = (m_cP == 0) ? <> : m_vbetav_2;		 
			garch_2 = (m_cD == 0) ? garch_2 : garch_2./2;
			d_2 = (m_cD == 0) ? <> : m_dD_2; 
		}
		if (m_cNM3 != 0)
		{
			cv_3 = (m_cVar == 0) ? <> : m_calpha0_3; 
			regv_3 = (m_cXV == 0)	? <> : m_vpsyv_3; 
			arch_3 = (m_cQ == 0) ? <> : m_valphav_3; 
			garch_3 = (m_cP == 0) ? <> : m_vbetav_3;		 
			garch_3 = (m_cD == 0) ? garch_3 : garch_3./2;
			d_3 = (m_cD == 0) ? <> : m_dD_3; 
		}
		//eddig
 
		if (m_cFilter == 10) 
		{ 
			garch = <0.1>;
			for (i=1; i < m_cP; ++i)	  garch |= 0.1; 
 
			if (m_cP==1)		garch =  1 - sumc(arch); 
			else if (m_cP>1)	garch[0] =  1 - sumc(garch[1:][0]) - sumc(arch);

//En irtam			
			if ((m_cNM2 != 0)  || (m_cNM3 != 0))
			{
				garch_2 = <0.1>;
				for (i=1; i < m_cP; ++i)	  garch_2 |= 0.1; 
 
				if (m_cP==1)		garch_2 =  1 - sumc(arch_2); 
				else if (m_cP>1)	garch_2[0] =  1 - sumc(garch_2[1:][0]) - sumc(arch_2);
			}
			if (m_cNM3 != 0)
			{
				garch_3 = <0.1>;
				for (i=1; i < m_cP; ++i)	  garch_3 |= 0.1; 
 
				if (m_cP==1)		garch_3 =  1 - sumc(arch_3); 
				else if (m_cP>1)	garch_3[0] =  1 - sumc(garch_3[1:][0]) - sumc(arch_3);
			}
 		} 
				 		 
 		gjr = ((m_cGJR == 0) && (m_cNMGJR == 0) && (m_cNMAGARCH ==0)) ? <> : m_vleverage;
		theta1 = (m_cEgarch == 0) ? <> : m_vtheta1; 
		theta2 = (m_cEgarch == 0) ? <> : m_vtheta2;
	//	psy	= (m_cAparch == 0) ? <> : (m_cD == 0) ? m_vgamma : m_vgamma[0]; 	 
		psy	= (m_cAparch == 0) ? <> : m_vgamma;
		delta = (m_cAparch == 0) ? <> :	m_ddelta; 
 		v =  (m_cKu == 0) ? <> : m_cV; 
		a = (m_cSk == 0) ? <> :	m_cA; 
		hy = (m_cHY == 0) ? <> :  m_vHY;

//En irtam
		if ( (m_cNM2 != 0) || (m_cNM3 != 0))
		{
			gjr_2 = ((m_cNMGJR == 0) && (m_cNMAGARCH ==0)) ? <> : m_vleverage_2;
			theta1_2 = (m_cEgarch == 0) ? <> : m_vtheta1_2; 
			theta2_2 = (m_cEgarch == 0) ? <> : m_vtheta2_2; 
		//	psy_2	= (m_cAparch == 0) ? <> : (m_cD == 0) ? m_vgamma_2 : m_vgamma_2[0]; 	 
			psy_2	= (m_cAparch == 0) ? <> : m_vgamma_2;
			delta_2 = (m_cAparch == 0) ? <> :	m_ddelta_2; 
		}

		if (m_cNM3 != 0)
		{
			gjr_3 = ((m_cNMGJR == 0) && (m_cNMAGARCH ==0)) ? <> : m_vleverage_3;
			theta1_3 = (m_cEgarch == 0) ? <> : m_vtheta1_3; 
			theta2_3 = (m_cEgarch == 0) ? <> : m_vtheta2_3; 
		//	psy_2	= (m_cAparch == 0) ? <> : (m_cD == 0) ? m_vgamma_2 : m_vgamma_2[0]; 	 
			psy_3	= (m_cAparch == 0) ? <> : m_vgamma_3;
			delta_3 = (m_cAparch == 0) ? <> :	m_ddelta_3; 
		}
		 
	 //figyelem a beszurasra innen
	 if ((m_cNM2 == 0)	&&	 (m_cNM3 == 0))
	 {
		if ("OxPackDialog"("Initial Values", 
				{ 	{ "Initial Values" }, 
					{ " NOTE : If there are no value for a coefficient, the specification"}, 
					{ " of the model does not take this coefficient into account."}, 
 					{ "Mean Equation ", CTL_GROUP, 0 }, 								
					{ " Constant :", CTL_STRMAT, cm, "cstminit" }, 
					{ " Regressor(s) Coefficient(s)", CTL_STRMAT, regm, "beta-m" }, 
					{ " Fractional parameter (ARFIMA)", CTL_STRMAT, arfi, "d" }, 
					{ " AR Coefficient(s) :", CTL_STRMAT, ar, "vAR" }, 
					{ " MA Coefficient(s) :", CTL_STRMAT, ma, "vMA" }, 
					{ "Variance Equation :", CTL_GROUP, 0 }, 
					{ " Constant :", CTL_STRMAT, cv, "cstvinit" }, 
					{ " Regressor(s) Coefficient(s):",CTL_STRMAT, regv, "gamma" }, 
					{ " Figarch Coefficient (d)", CTL_STRMAT, d, "d" }, 
					{ " Garch Coefficient(s) (p):", CTL_STRMAT, garch, "beta" }, 
					{ " Arch Coefficient(s) (q):", CTL_STRMAT, arch, "alpha" }, 
					{ "Specification Parameters", CTL_GROUP, 0 }, 		
					{ " GJR or AGARCH Coefficient(s) :", CTL_STRMAT, gjr, "lev" }, 
					{ " Egarch Theta1      :",CTL_STRMAT, theta1, "theta1" }, 
					{ " Egarch Theta2      :",CTL_STRMAT, theta2, "theta2" }, 
					{ " Aparch Gamma('s)   :",CTL_STRMAT, psy, "psy" }, 
					{ " Aparch Delta       :",CTL_STRMAT, delta, "delta" }, 
					{ " Hygarch Coef.      :",CTL_STRMAT, hy, "hy" },			   
					{ "Distribution Parameters :", CTL_GROUP, 0 }, 
					{ " Degrees of freedom :", CTL_STRMAT, v, "df" }, 
					{ " Asymmetric parameter (Skewed Student):", CTL_STRMAT, a, "asym" }					 
				},	 
				&asoptions2, &avalues2) 
			)				    
		{ 
			if (avalues2[0] == <>)	m_clevel = 0.0; 
			else m_clevel = double(avalues2[0]); 
 
			m_vbetam = avalues2[1]; 
 
			if (avalues2[2] == <>)	m_dARFI = 0.0; 
			else m_dARFI = double(avalues2[2]); 
			 
			m_vAR = avalues2[3]; 
			m_vMA = avalues2[4]; 
 
			if (avalues2[5] == <>)	m_calpha0 = 0.0; 
			else m_calpha0 = double(avalues2[5]); 
 
			m_vpsyv = avalues2[6]; 
 
			if (avalues2[7] == <>)	m_dD = 0.0; 
			else m_dD = double(avalues2[7]); 
			 
			m_vbetav = avalues2[8]; 
			m_valphav = avalues2[9]; 
			m_vleverage = avalues2[10]; 
			m_vtheta1 = avalues2[11]; 
			m_vtheta2 = avalues2[12]; 
			m_vgamma = avalues2[13]; 

			if ((m_cAparch == 1)&&(m_cD == 1))  	m_vgamma = (avalues2[13])[0];
			else 								m_vgamma = avalues2[13]; 

			if (avalues2[14] == <>)	m_ddelta = 0.0; 
			else m_ddelta = double(avalues2[14]); 
			 
			m_vHY = avalues2[15];										    
			 
			if (avalues2[16] == <>) m_cV = 0.0; 
			else m_cV = double(avalues2[16]); 
 
 			if (avalues2[17] == <>) m_cA = 0.0; 
			else m_cA = double(avalues2[17]); 
 
		   for (i=0;i<18;++i) 
		   { 
		   	 if ((ismatrix(avalues2[i]) == 0)||(columns(avalues2[i]) > 1)) 
				print("Error in the element number ", i); 
		   } 
		}
	 }
	 //eddig
	 //En irtam innen
	 else  if (m_cNM2 != 0)
	 {
	 	if ("OxPackDialog"("Initial Values", 
				{ 	{ "Initial Values" }, 
					{ " NOTE : If there are no value for a coefficient, the specification"}, 
					{ " of the model does not take this coefficient into account."}, 
 					{ "Mean Equation ", CTL_GROUP, 0 }, 								
					{ " Constant :", CTL_STRMAT, cm, "cstminit" }, 						//0
					{ " Regressor(s) Coefficient(s)", CTL_STRMAT, regm, "beta-m" }, 	//1
					{ " Fractional parameter (ARFIMA)", CTL_STRMAT, arfi, "d" }, 		//2
					{ " AR Coefficient(s) :", CTL_STRMAT, ar, "vAR" }, 					//3
					{ " MA Coefficient(s) :", CTL_STRMAT, ma, "vMA" }, 					//4
					{ "Variance1 Equation :", CTL_GROUP, 0 }, 
					{ " Constant :", CTL_STRMAT, cv, "cstvinit" }, 						//5
					{ " Regressor(s) Coefficient(s):",CTL_STRMAT, regv, "gamma" }, 		//6
					{ " Figarch Coefficient (d)", CTL_STRMAT, d, "d" }, 				//7
					{ " Garch Coefficient(s) (p):", CTL_STRMAT, garch, "beta" }, 		//8
					{ " Arch Coefficient(s) (q):", CTL_STRMAT, arch, "alpha" }, 		//9
					{ "Specification Parameters", CTL_GROUP, 0 }, 		
					{ " GJR or AGARCH Coefficient(s) :", CTL_STRMAT, gjr, "lev" }, 		//10
					{ " Egarch Theta1      :",CTL_STRMAT, theta1, "theta1" }, 			//11
					{ " Egarch Theta2      :",CTL_STRMAT, theta2, "theta2" }, 			//12
					{ " Aparch Gamma('s)   :",CTL_STRMAT, psy, "psy" }, 				//13
					{ " Aparch Delta       :",CTL_STRMAT, delta, "delta" }, 			//14
					{ " Hygarch Coef.      :",CTL_STRMAT, hy, "hy" },			   		//15
					{ "Distribution Parameters :", CTL_GROUP, 0 }, 
					{ " Degrees of freedom :", CTL_STRMAT, v, "df" }, 					//16
					{ " Asymmetric parameter (Skewed Student):", CTL_STRMAT, a, "asym" },//17
					{ "Variance2 Equation :", CTL_GROUP, 0 }, 
					{ " Constant :", CTL_STRMAT, cv_2, "cstvinit_2" }, 					//18
					{ " Regressor(s) Coefficient(s):",CTL_STRMAT, regv_2, "gamma_2" }, 	//19
					{ " Figarch Coefficient (d)", CTL_STRMAT, d_2, "d_2" }, 			//20
					{ " Garch Coefficient(s) (p):", CTL_STRMAT, garch_2, "beta_2" }, 	//21
					{ " Arch Coefficient(s) (q):", CTL_STRMAT, arch_2, "alpha_2" }, 	//22
					{ "Specification Parameters", CTL_GROUP, 0 }, 		
					{ " GJR or AGARCH Coefficient(s) :", CTL_STRMAT, gjr_2, "lev_2" }, 	//23
					{ " Egarch Theta1      :",CTL_STRMAT, theta1_2, "theta1_2" }, 		//24
					{ " Egarch Theta2      :",CTL_STRMAT, theta2_2, "theta2_2" }, 		//25
					{ " Aparch Gamma('s)   :",CTL_STRMAT, psy_2, "psy_2" }, 			//26
					{ " Aparch Delta       :",CTL_STRMAT, delta_2, "delta_2" }			//27

				},	 
				&asoptions2, &avalues2) 
			)				    
		{ 
			if (avalues2[0] == <>)	m_clevel = 0.0; 
			else m_clevel = double(avalues2[0]); 
 
			m_vbetam = avalues2[1]; 
 
			if (avalues2[2] == <>)	m_dARFI = 0.0; 
			else m_dARFI = double(avalues2[2]); 
			 
			m_vAR = avalues2[3]; 
			m_vMA = avalues2[4]; 
 
			//innen
			if (avalues2[5] == <>)	m_calpha0 = 0.0; 
			else m_calpha0 = double(avalues2[5]); 
 
			m_vpsyv = avalues2[6]; 
 
			if (avalues2[7] == <>)	m_dD = 0.0; 
			else m_dD = double(avalues2[7]); 
			 
			m_vbetav = avalues2[8]; 
			m_valphav = avalues2[9]; 
			m_vleverage = avalues2[10]; 
			m_vtheta1 = avalues2[11]; 
			m_vtheta2 = avalues2[12]; 
			m_vgamma = avalues2[13]; 

			if ((m_cAparch == 1)&&(m_cD == 1))  	m_vgamma = (avalues2[13])[0];
			else 								m_vgamma = avalues2[13]; 

			if (avalues2[14] == <>)	m_ddelta = 0.0; 
			else m_ddelta = double(avalues2[14]);
			//eddig
			 
			m_vHY = avalues2[15];										    
			 
			if (avalues2[16] == <>) m_cV = 0.0; 
			else m_cV = double(avalues2[16]); 
 
 			if (avalues2[17] == <>) m_cA = 0.0; 
			else m_cA = double(avalues2[17]); 


			//innen	  +13
			if (avalues2[18] == <>)	m_calpha0_2 = 0.0; 
			else m_calpha0_2 = double(avalues2[18]); 
 
			m_vpsyv_2 = avalues2[19]; 
 
			if (avalues2[20] == <>)	m_dD_2 = 0.0; 
			else m_dD_2 = double(avalues2[20]); 
			 
			m_vbetav_2 = avalues2[21]; 
			m_valphav_2 = avalues2[22]; 
			m_vleverage_2 = avalues2[23]; 
			m_vtheta1_2 = avalues2[24]; 
			m_vtheta2_2 = avalues2[25]; 
			m_vgamma_2 = avalues2[26]; 

			if ((m_cAparch == 1)&&(m_cD == 1))  	m_vgamma_2 = (avalues2[26])[0];
			else 								m_vgamma_2 = avalues2[26]; 

			if (avalues2[27] == <>)	m_ddelta_2 = 0.0; 
			else m_ddelta_2 = double(avalues2[27]);
			//eddig

		   for (i=0;i<28;++i) 
		   { 
		   	 if ((ismatrix(avalues2[i]) == 0)||(columns(avalues2[i]) > 1)) 
				print("Error in the element number ", i); 
		   } 
		}
	 }
	 
	 else  if (m_cNM3 != 0)
	 {
	 	if ("OxPackDialog"("Initial Values", 
				{ 	{ "Initial Values" }, 
					{ " NOTE : If there are no value for a coefficient, the specification"}, 
					{ " of the model does not take this coefficient into account."}, 
 					{ "Mean Equation ", CTL_GROUP, 0 }, 								
					{ " Constant :", CTL_STRMAT, cm, "cstminit" }, 
					{ " Regressor(s) Coefficient(s)", CTL_STRMAT, regm, "beta-m" }, 
					{ " Fractional parameter (ARFIMA)", CTL_STRMAT, arfi, "d" }, 
					{ " AR Coefficient(s) :", CTL_STRMAT, ar, "vAR" }, 
					{ " MA Coefficient(s) :", CTL_STRMAT, ma, "vMA" }, 
					{ "Variance1 Equation :", CTL_GROUP, 0 }, 
					{ " Constant :", CTL_STRMAT, cv, "cstvinit" }, 
					{ " Regressor(s) Coefficient(s):",CTL_STRMAT, regv, "gamma" }, 
					{ " Figarch Coefficient (d)", CTL_STRMAT, d, "d" }, 
					{ " Garch Coefficient(s) (p):", CTL_STRMAT, garch, "beta" }, 
					{ " Arch Coefficient(s) (q):", CTL_STRMAT, arch, "alpha" }, 
					{ "Specification Parameters", CTL_GROUP, 0 }, 		
					{ " GJR or AGARCH Coefficient(s) :", CTL_STRMAT, gjr, "lev" }, 
					{ " Egarch Theta1      :",CTL_STRMAT, theta1, "theta1" }, 
					{ " Egarch Theta2      :",CTL_STRMAT, theta2, "theta2" }, 
					{ " Aparch Gamma('s)   :",CTL_STRMAT, psy, "psy" }, 
					{ " Aparch Delta       :",CTL_STRMAT, delta, "delta" }, 
					{ " Hygarch Coef.      :",CTL_STRMAT, hy, "hy" },			   
					{ "Distribution Parameters :", CTL_GROUP, 0 }, 
					{ " Degrees of freedom :", CTL_STRMAT, v, "df" }, 
					{ " Asymmetric parameter (Skewed Student):", CTL_STRMAT, a, "asym" },
					{ "Variance2 Equation :", CTL_GROUP, 0 }, 
					{ " Constant :", CTL_STRMAT, cv_2, "cstvinit" }, 
					{ " Regressor(s) Coefficient(s):",CTL_STRMAT, regv_2, "gamma" }, 
					{ " Figarch Coefficient (d)", CTL_STRMAT, d_2, "d" }, 
					{ " Garch Coefficient(s) (p):", CTL_STRMAT, garch_2, "beta" }, 
					{ " Arch Coefficient(s) (q):", CTL_STRMAT, arch_2, "alpha" }, 
					{ "Specification Parameters", CTL_GROUP, 0 }, 		
					{ " GJR or AGARCH Coefficient(s) :", CTL_STRMAT, gjr_2, "lev" }, 
					{ " Egarch Theta1      :",CTL_STRMAT, theta1_2, "theta1" }, 
					{ " Egarch Theta2      :",CTL_STRMAT, theta2_2, "theta2" }, 
					{ " Aparch Gamma('s)   :",CTL_STRMAT, psy_2, "psy" }, 
					{ " Aparch Delta       :",CTL_STRMAT, delta_2, "delta" },
					{ "Variance3 Equation :", CTL_GROUP, 0 }, 
					{ " Constant :", CTL_STRMAT, cv_3, "cstvinit" }, 				  //28
					{ " Regressor(s) Coefficient(s):",CTL_STRMAT, regv_3, "gamma" },  //29
					{ " Figarch Coefficient (d)", CTL_STRMAT, d_3, "d" }, 			  //30
					{ " Garch Coefficient(s) (p):", CTL_STRMAT, garch_3, "beta" }, 	  //31
					{ " Arch Coefficient(s) (q):", CTL_STRMAT, arch_3, "alpha" }, 	  //32
					{ "Specification Parameters", CTL_GROUP, 0 }, 		
					{ " GJR or AGARCH Coefficient(s) :", CTL_STRMAT, gjr_3, "lev" }, 			  //33
					{ " Egarch Theta1      :",CTL_STRMAT, theta1_3, "theta1" }, 	  //34
					{ " Egarch Theta2      :",CTL_STRMAT, theta2_3, "theta2" }, 	  //35
					{ " Aparch Gamma('s)   :",CTL_STRMAT, psy_3, "psy" }, 			  //36
					{ " Aparch Delta       :",CTL_STRMAT, delta_3, "delta" }		  //37

				},	 
				&asoptions2, &avalues2) 
			)				    
		{ 
			if (avalues2[0] == <>)	m_clevel = 0.0; 
			else m_clevel = double(avalues2[0]); 
 
			m_vbetam = avalues2[1]; 
 
			if (avalues2[2] == <>)	m_dARFI = 0.0; 
			else m_dARFI = double(avalues2[2]); 
			 
			m_vAR = avalues2[3]; 
			m_vMA = avalues2[4]; 
 
			//innen
			if (avalues2[5] == <>)	m_calpha0 = 0.0; 
			else m_calpha0 = double(avalues2[5]); 
 
			m_vpsyv = avalues2[6]; 
 
			if (avalues2[7] == <>)	m_dD = 0.0; 
			else m_dD = double(avalues2[7]); 
			 
			m_vbetav = avalues2[8]; 
			m_valphav = avalues2[9]; 
			m_vleverage = avalues2[10]; 
			m_vtheta1 = avalues2[11]; 
			m_vtheta2 = avalues2[12]; 
			m_vgamma = avalues2[13]; 

			if ((m_cAparch == 1)&&(m_cD == 1))  	m_vgamma = (avalues2[13])[0];
			else 								m_vgamma = avalues2[13]; 

			if (avalues2[14] == <>)	m_ddelta = 0.0; 
			else m_ddelta = double(avalues2[14]);
			//eddig
			 
			m_vHY = avalues2[15];										    
			 
			if (avalues2[16] == <>) m_cV = 0.0; 
			else m_cV = double(avalues2[16]); 
 
 			if (avalues2[17] == <>) m_cA = 0.0; 
			else m_cA = double(avalues2[17]); 


			//innen	  +13  +10
			if (avalues2[18] == <>)	m_calpha0_2 = 0.0; 
			else m_calpha0_2 = double(avalues2[18]); 
 
			m_vpsyv_2 = avalues2[19]; 
 
			if (avalues2[20] == <>)	m_dD_2 = 0.0; 
			else m_dD_2 = double(avalues2[20]); 
			 
			m_vbetav_2 = avalues2[21]; 
			m_valphav_2 = avalues2[22]; 
			m_vleverage_2 = avalues2[23]; 
			m_vtheta1_2 = avalues2[24]; 
			m_vtheta2_2 = avalues2[25]; 
			m_vgamma_2 = avalues2[26]; 

			if ((m_cAparch == 1)&&(m_cD == 1))  	m_vgamma_2 = (avalues2[26])[0];
			else 								m_vgamma_2 = avalues2[26]; 

			if (avalues2[27] == <>)	m_ddelta_2 = 0.0; 
			else m_ddelta_2 = double(avalues2[27]);
			
			//innen megint
			if (avalues2[28] == <>)	m_calpha0_3 = 0.0; 
			else m_calpha0_3 = double(avalues2[28]); 
 
			m_vpsyv_3 = avalues2[29]; 
 
			if (avalues2[30] == <>)	m_dD_3 = 0.0; 
			else m_dD_3 = double(avalues2[30]); 
			 
			m_vbetav_3 = avalues2[31]; 
			m_valphav_3 = avalues2[32]; 
			m_vleverage_3 = avalues2[33]; 
			m_vtheta1_3 = avalues2[34]; 
			m_vtheta2_3 = avalues2[35]; 
			m_vgamma_3 = avalues2[36]; 

			if ((m_cAparch == 1)&&(m_cD == 1))  	m_vgamma_3 = (avalues2[36])[0];
			else 								m_vgamma_3 = avalues2[36]; 

			if (avalues2[37] == <>)	m_ddelta_3 = 0.0; 
			else m_ddelta_3 = double(avalues2[37]);
			//eddig

		   for (i=0;i<38;++i) 
		   { 
		   	 if ((ismatrix(avalues2[i]) == 0)||(columns(avalues2[i]) > 1)) 
				print("Error in the element number ", i); 
		   } 
		}
	 }
	 //eddig
	} 
	else if (m_cStartMet == 2)    
	{ 
		GetPara();
		m_vPar = "OxPackMatrixEditor"(m_vPar, rows(m_vPar), columns(m_vPar), 0, 0, "Starting values");
		SplitPara(m_vPar);
	}

//		GetNbPar();		  
// 
//		InitStartValues(1,m_cBound); 	// 304 Prbl: if	<> --> can't use the bounds ....
// 
//		decl s = GetParNames(); 
//		decl names = " - "; 
// 
//		if (m_cFilter != 10)    for (i=0;i<m_cPar;++i) 	   names = names ~ "-" ~ s[i]; 
//		else 				   for (i=0;i<m_cPar-1;++i)    names = names ~ "-" ~ s[i]; 
//		 
//		{ if ("OxPackDialog"("Initial Values", 
//				{	{ "Initial Parameters Vector :" }, 
//					{ "Parameters: ", CTL_STRING, names, "parnames" }, 
//					{ " Initial values :", CTL_STRMAT, m_vPar, "initvect" } 
//				},	 
//				&asoptions2, &avalues2) 
//			 ) 
//			{ 
//				m_vPar = avalues2[1]; 
//				SplitPara(m_vPar); 
//				GetPara(); 
//			} 
//		} 
//	} 
 
	if (m_cD == 1)  
	{ 
		decl aso,ava,figmet,trunc,str1,str2,str3,n; 
		figmet = 0; 
		trunc = 1000; 
    	n = sizer(GetGroup(Y_VAR));	  
 
		if ((m_cAparch == 0)&&(m_cEgarch == 0)&&(m_cHY == 0)) 
		{ 
			str1 = " Choose the method to estimate your FIGARCH model :"; 
			str2 = " Chung"	; 
		} 
		else if (m_cEgarch == 1) 
		{ 
			str1 = " Choose the truncation order of your FIEGARCH model :"; 
			str2 = " Truncation order : t-1"; 
		} 
		else if (m_cAparch == 1) 
		{ 
			str1 = " Choose the truncation order of your FIAPARCH model :"; 
			str2 = " Truncation order : t-1"; 
		} 
		else if (m_cHY == 1) 
		{ 
			str1 = " Choose the truncation order of your HYGARCH model :"; 
		}

		if (m_cHY == 0)
		{
			if ("OxPackDialog"("Figarch", 
						{ 	{ "Estimation Method" },
							{ str1 }, 
							{ str2, CTL_RADIO, figmet, "figmeth" }, 
							{ " Baillie, Bollerslev, Mikkelsen (BBM) ",CTL_RADIO}, 
							{ " Truncation Order (can be modified):",CTL_INT,trunc,"laglamb"} 
						},		 
							&aso, &ava) 
				)
			{ 
				if (m_cEgarch == 1) 
				{ 
					if (ava[0] == 0) m_claglamb = n; 
					else if (ava[0] == 1) m_claglamb = ava[1]; 
				} 
				else if	(m_cAparch == 1) 
				{ 
					if (ava[0] == 0) {m_cFilter = 42; m_cFIMethod = 1; m_claglamb = n;} 
					else if (ava[0] == 1) {m_cFilter = 41;	m_cFIMethod = 0; m_claglamb = ava[1];} 
				}
				else  
				{ 
					if (ava[0] == 0) 
						{m_cFilter = 12; m_cFIMethod = 1;} 
					else if (ava[0] == 1) 
						{m_cFilter = 11; m_cFIMethod = 0;} 
																							 
					m_claglamb = ava[1]; 
				} 
			} 
		}
		else //HYGARCH
		{
			if ("OxPackDialog"("Figarch", 
						{ 	{ "Estimation Method" },
							{ str1 }, 
							{ " Baillie, Bollerslev, Mikkelsen (BBM) ",CTL_RADIO}, 
							{ " Truncation Order (can be modified):",CTL_INT,trunc,"laglamb"} 
						},		 
							&aso, &ava) 
				)
			{ 
				m_claglamb = ava[0]; 
			} 
		}
		
	} 
}

StartValues(const object)
{
	object.SetStartValue("m_clevel", 0.066);

	object.GetPara();  									// DO NOT REMOVE THIS LINE WHEN USING THIS FUNCTION
	object.Initialization(object.GetValue("m_vPar"));  	// DO NOT REMOVE THIS LINE WHEN USING THIS FUNCTION
}

//En irtam
Garch::Figll(const vP, const adFunc, const avScore, const amHessian) 
{ 
	decl likel,vP2;
	SetFreePar(vP);		// Update the free parameters

	SplitPara(GetPar());	// Update the global variables (parameters) with the free (optimized) and Fixed Parameters    
	Res_Var();
		 
	if (m_cDist == 0)	    	likel = Gausslik(m_vE, m_vSigma2); 
	else if (m_cDist == 1)		likel = Studentlik(m_vE, m_vSigma2, m_cV);		 
	else if (m_cDist == 2)		likel = GEDlik(m_vE, m_vSigma2, m_cV); 
	else if (m_cDist == 3)		likel = SkStudentlik(m_vE, m_vSigma2, m_cA, m_cV);
	else if (m_cDist == 4)		likel = NM2lik(m_vE,m_vSigma2_1,m_vSigma2_2,m_p1,m_mu1);
	else if (m_cDist == 5)		likel = NM3lik(m_vE,m_vSigma2_1,m_vSigma2_2,m_vSigma2_3,m_p1,m_p2,m_mu1,m_mu2);

	if (m_cRobustLL == 0)
								adFunc[0]=likel;	//sumc(likel);
	else						adFunc[0]=likel; 
 
	return 1;                           
}

//En irtam
Garch::Gausslik(const vE, const vSigma2) 
/* 
**  Purpose: Computes Log-Likelihood function w/ Gaussian distribution in a point
** 
**  Input  : vE 		= Residuals (m_cT x 1) 
**           vSigma2  	= Conditional variance (m_cT x 1) 
** 
**  Output : Log-Likelihood function (1 x 1) 
*/ 
{ 										
     decl e2; 							
	 e2 = vE[m_myt]^2; 
	 return ( -0.5*( log(vSigma2[m_myt]) + (e2 / vSigma2[m_myt]) ) - 0.5*log(M_2PI) ); 
} 

//En irtam
Garch::Studentlik(const vE, const vSigma2, const v) 
/* 
**  Purpose: Computes Log-Likelihood function w/ Student-t distribution  in a point
** 
**  Input  : vE 		= Residuals (m_cT x 1) 
**           vSigma2  	= Conditional variance (m_cT x 1) 
**			 v			= Degrees of freedom (1 x 1) 
** 
**  Output : Log-Likelihood function (1 x 1) 
*/ 
{ 
	decl s = ((v-2.0)/v) * vSigma2[m_myt]; 
	decl e2; 
	e2 = vE [m_myt]* vE[m_myt]; 
	decl kernel = -0.5 * (v+1) * log(1.0 + ((1.0 / v) * (e2/s))); 
	return (kernel - 0.5*log(s)+ (loggamma((v+1)/2) - loggamma(v/2) - 0.5 * log(M_PI*v))); 
} 

//En irtam
Garch::GEDlik(const vE, const vSigma2, const v) 
/* 
**  Purpose: Computes Log-Likelihood function w/ GED distribution 	in a point
** 
**  Input  : vE 		= Residuals (m_cT x 1) 
**           vSigma2  	= Conditional variance (m_cT x 1) 
**			 v			= Degrees of freedom (1 x 1) 
** 
**  Output : Log-Likelihood function (1 x 1) 
*/ 
{ 
	decl Logl; 
	decl Lambda = sqrt(((2^(-2/v))*gammafact(1/v))/gammafact(3/v)); 
  
	return log(v) - 0.5*fabs(vE[m_myt]/(Lambda*sqrt(vSigma2[m_myt])))^v 
	       - (log(Lambda) + (1+1/v)*log(2) + loggamma(1/v)) - 0.5*log(vSigma2[m_myt]); 
} 

//En irtam
Garch::SkStudentlik(const vE, const vSigma2, const s, const v)  
/*   
**  Purpose : Computes a vector of Log-likelihoods based on the Standardized asymetric Student-t distribution 	 in a point
** 
**  Format  : LogL = SKStudentLik(vE,vSigma2,s,v); 
** 
**  Input   : vE = residuals 
**            vSigma2 = conditional variance 
**            s = log(skewness parameter)  
**            v = Degree of freedom  
** 
**  Output  : LogL = vector of Log-Likelihoods         
*/ 
{ 
	decl g,c,tamp,signe,m,b,vv,g2,g3;   
    g=exp(s); g2=g^2; g3=g^3; 
    c=gammafact((v+1)/2)/(gammafact(v/2)*sqrt(M_PI*(v-2))); 
    b=2/(g+(1/g)); 
	m=b*c*(v-2)*(g2-1/g2)/(v-1);
	vv=sqrt(((b*(g3+1/g3)/2) - m^2)/vSigma2[m_myt]); 
    signe = (vE[m_myt]>= -m/vv) - (vE[m_myt]< -m/vv); 
	tamp = Studentlik((g^(-signe))*((vv*vE[m_myt])+m), 1,v);
	return tamp+log(b)+log(vv);
	
	//vv=sqrt(((b*(g3+1/g3)/2) - m^2)./vSigma2); 
    //signe = (vE .>= -m./vv) - (vE .< -m./vv); 
	//tamp = StudentLik((g.^(-signe)).*((vv.*vE)+m), 1,v); 
	//return tamp+log(b)+log(vv); 
}

//En irtam
Garch::NM2lik(const vE, const vSigma2_1, const vSigma2_2, const p, const mu)  
/*   
**  Purpose : Computes a vector of Log-likelihoods based on the Standardized asymetric Student-t distribution  in a point
** 
**  Format  : LogL = NM2Lik(vE,vSigma2_1,vSigma2_2,p,mu); 
** 
**  Input   : vE = residuals 
**            vSigma2_1 = conditional variance 1
**			  vSigma2_2 = conditional variance 2
**            p = probability parameter  
**            mu = mu 
** 
**  Output  : LogL = vector of Log-Likelihoods         
*/ 
{ 
	 decl m1_p=1-p;
	 decl mu2= -p*mu/m1_p;
	 decl e2_1, e2_2; 							
	 e2_1 = (vE[m_myt]-mu)^2;
	 e2_2 = (vE[m_myt]-mu2)^2;
	 decl g1 = exp(-e2_1/(2*vSigma2_1[m_myt]))*p/sqrt(vSigma2_1[m_myt]);
	 decl g2 = exp(-e2_2/(2*vSigma2_2[m_myt]))*m1_p/sqrt(vSigma2_2[m_myt]);
	 return (log(g1+g2)- 0.5*log(M_2PI)); 
}

//En irtam
Garch::NM3lik(const vE, const vSigma2_1, const vSigma2_2, const vSigma2_3, const p1, const p2, const mu1, const mu2)  
/*   
**  Purpose : Computes a vector of Log-likelihoods based on the Standardized asymetric Student-t distribution  in a point
** 
**  Format  : LogL = NM2Lik(vE,vSigma2_1,vSigma2_2,p,mu); 
** 
**  Input   : vE = residuals 
**            vSigma2_1 = conditional variance 1
**			  vSigma2_2 = conditional variance 2
**            p = probability parameter  
**            mu = mu 
** 
**  Output  : LogL = vector of Log-Likelihoods         
*/ 
{ 
	 decl p3=1-p1-p2;
	 decl mu3= -(p1*mu1+p2*mu2)/p3;
	 decl e2_1, e2_2, e2_3; 							
	 e2_1 = (vE[m_myt]-mu1)^2;
	 e2_2 = (vE[m_myt]-mu2)^2;
	 e2_2 = (vE[m_myt]-mu3)^2;
	 decl g1 = exp(-e2_1/(2*vSigma2_1[m_myt]))*p1/sqrt(vSigma2_1[m_myt]);
	 decl g2 = exp(-e2_2/(2*vSigma2_2[m_myt]))*p2/sqrt(vSigma2_2[m_myt]);
	 decl g3 = exp(-e2_3/(2*vSigma2_3[m_myt]))*p3/sqrt(vSigma2_3[m_myt]);
	 return (log(g1+g2+g3)- 0.5*log(M_2PI)); 
}



//En irtam
Garch::NMRESTR(const n) 
{ 
	if ((n < 0)||(n > 5)) 
	{ 
		println("The argument of the NM2RESTR(dist) function must be 0 (no restr.), 1 (m1=m2=a1-a2=b1-b2=0), 2 (m1=m2=a2=b2=0), 3 (m1=m2), 4(a1-a2=b1-b2=0) or 5 (a2=b2=0).\n", 
				"You have entered ", n,". Please correct it."); 
		exit(0); 
	} 
	 
	m_restr=n;
}

//En irtam
Garch::MYTESTS(const momtest, const acf, const hist)
{
	m_momtest=momtest;
	m_acf=acf;
	m_hist=hist;
}

//En irtam
Garch::MOMTEST()
{
	Num1Der();
	GetDtransf();
	decl i,j;
	m_vmomtest = zeros(4,5);
	for	(i=	0; i<4; i++)
		for (j= 0; j<5; j++)
			m_vmomtest[i][j]=  Momtest_1(i+1,j);
	m_testtot = Momtest_tot();
	
	return 1;
}

//En irtam
Garch::GetDtransf()
{
	m_D_transf=	m_num1der * invert(( m_num1der')*m_num1der)	* (m_num1der');
}

//En irtam
Garch::Momtest_1(const power, const lag)
{
	decl res;
	decl i;
	decl my_const=<0,1,0,3>;
	
	if (lag==0)	res = (m_stdres.^power) - my_const[power-1];
	else
	{	res = ((lag0(m_stdres,lag).^power)-my_const[power-1] );
		for (i=0; i<lag; i++)	res[i]=0;
		res = ((m_stdres.^power) - my_const[power-1]).*	res;
	}

	return ( (meanc(res)^2)
		*invert( (1/(m_cT*m_cT)) * ((res') * res - ((res') * m_D_transf * res)) ) );
}

//En irtam
Garch::Momtest_tot()
{
	decl res,res_cum=0;
	decl r=zeros(20,1);
	decl i,j,k,l;
	decl my_const=<0,1,0,3>;
	k=4;

	r[0][0]=meanc(m_stdres);
	res_cum=m_stdres;   //M matrix

	for (i=2; i<5; i++)
	{
		res = (m_stdres.^i) - my_const[i-1];
		r[i-1][0]=meanc(res);
		res_cum~=res;
	}
	for (i=1; i<5; i++)	 //power  = moment
	{
		for (j=1; j<5; j++)	   //lag  =AC of order lag
		{
			res = ((lag0(m_stdres,j).^i)-my_const[i-1] );
			for (l=0; l<j; l++)	res[l]=0;
			res = ((m_stdres.^i) - my_const[i-1]).*	res;
			r[k][0]=meanc(res);
			k++;
			res_cum~=res;
		}
	}

	return ( (r')
		*invert( (1/(m_cT*m_cT)) * ((res_cum') * res_cum - ((res_cum') * m_D_transf * res_cum)) ) * (r) );
}

//En irtam
Garch::Compute_momNM(const n, const num)
{
	decl nr = n;
	decl x=0, x_sub=0;
	decl pp=zeros(nr,1);
	pp[0]=m_p1;
	pp[1]=m_p2;
	decl m=zeros(nr,1);
	m[0]=m_mu1;
	m[1]=m_mu2;
	decl o=zeros(nr,1);
	o[0]=m_calpha0;
	o[1]=m_calpha0_2;
	decl a=zeros(nr,1);
	a[0]=m_valphav[0];
	a[1]=m_valphav_2[0];
	decl b=zeros(nr,1);
	b[0]=m_vbetav[0];
	b[1]=m_vbetav_2[0];
	decl lambda=zeros(nr,1);
	lambda[0]=m_vleverage[0];
	lambda[1]=m_vleverage_2[0];

/*	pp[0]=0.948834;
	pp[1]=1-pp[0];
	m[0]=0.004099;
	m[1]=-pp[0]*m[0]/pp[1];
	
	o[0]=0.0003745;
	o[1]=0.07104434;
	a[0]=0.06178465;
	a[1]=0.5223942;
	b[0]=0.90410389;
	b[1]=0.30926823;
*/	
	if (nr==3)
	{
		pp[2]=m_p3;
		m[2]=m_mu3;
		o[2]=m_calpha0_3;
		a[2]=m_valphav_3[0];
		b[2]=m_vbetav_3[0];
		lambda[2]=m_vleverage_3[0];
	}
	
	decl delta=a;
   	if (m_cNMGJR == 1)   delta +=lambda./2;
	
	decl y=zeros(nr,1);
	decl w=zeros(nr,1);
	decl sk=0;
	decl r=zeros(nr,nr);
	decl amatrix=zeros(nr,nr);
	decl c=zeros(nr,1);
	decl d=zeros(nr,1);
	decl e=zeros(nr,nr);
	decl q=0;
	decl bmatrix=zeros(nr,nr);
	decl f=zeros(nr,1);
	decl g=zeros(nr,1);
	decl gamma=zeros(nr,1);
	decl ss=0;
	decl z;
	decl my_matrix;
	decl my_q;
	decl exp_mu_sq;
	decl exp_eps_t_t1_sq;
	decl my_value;
	decl a_mod;
	decl final_value;
	decl my_eta_corr=zeros(2,2);
	decl my_ro=zeros(2,2);
	decl my_l=zeros(2,2);
	decl my_num=num;

	while(my_num>0)
	{
	m[1]=-m[0]*pp[0]/pp[1];
	delta=a;
	x_sub = 1- sumc(pp.*delta./(1.-b))[0][0];
	x=sumc(pp.*(m.*m+o./(1.-b)))[0][0]/x_sub;
	if (m_cNMAGARCH == 1) 	x += sumc(pp.*a.*(lambda.^2)./(1.-b))[0][0]/x_sub;
	
	m_vol=sqrt(x);

	y=	(o+delta.* x)./(1.-b);
	if (m_cNMAGARCH == 1)	y+=(a.*(lambda.^2))./(1.-b);
	
	m_vol1=sqrt(y[0]);
	m_vol2=sqrt(y[1]);
	if (nr==3) m_vol3=sqrt(y[2]);
	
	sk=sumc(pp.*(3.*y.*m+m.^3))[0][0];
	m_sk=sk/(x^(3/2));

	w=(o.^2) + 2.*o.*delta.*x + 2.*o.*b.*y;
	if (m_cNMAGARCH == 1)	w += 6*x*(a.^2).*(lambda.^2) + (a.^2).*((lambda.^4)-4*sk*lambda) + 2*o.*a.*(lambda.^2) + 2*a.*(lambda.^2).*b.*y;
	
	r= o*(o') + x.*(o*(delta')+delta*(o')) + ( (b.*y)*(o')+o*((b.*y)') );
	if (m_cNMAGARCH == 1)
	{
		r += x*( (a.*(lambda.^4))*(a')+4*(a.*lambda)*((a.*lambda)')+ a*((a.*(lambda.^4))') ) - 2*sk*( (a.*lambda)*(a')+a*((a.*lambda)'));
		r += ( (b.*y)*((a.*(lambda.^2))')+(a.*(lambda.^2))*((b.*y)') );
		r += o*((a.*(lambda.^2))') +  (a.*(lambda.^2))*(o') + (a.*(lambda.^2))*((a.*(lambda.^2))');
	}
	amatrix = -(delta.*((pp.*b)'))./(1.-b.*(b'));
	amatrix-=diagonalize(amatrix);
	my_matrix=((pp.*delta)*(b'))./(1.-b*(b'));
	my_matrix-=diagonalize(my_matrix);
	my_matrix=1.-sumc(my_matrix);
	my_matrix=diag(my_matrix);
	amatrix+=my_matrix;
	amatrix=1/amatrix;

	q=sumc(pp.*m.*m)[0][0];
	c=((pp.*(r'))./(1.-b.*(b')));
	c-=diagonalize(c);
	c=(sumc(c))';
	c=amatrix *(c+y.*q);
	
	d=((pp.*(delta*(delta')))./(1.-b.*(b')));
	d-=diagonalize(d);
	d=(sumc(d))';
	d=amatrix *d;

	e=amatrix.*(pp');

	f=w+2*delta.*b.*c;
	gamma=a.^2;
	if (m_cNMGJR == 1)  gamma += (a.*lambda) + (0.25)*(lambda.^2);		 //vagy esetleg 0.25 a 0.5 helyett???
	g=gamma + 2*delta.*b.*d;
	ss=sumc(pp.*(6.*(m.^2).*(y) + (m.^4)))[0][0];
	bmatrix=diag(1-(b.^2))-2*(delta.*b).*e;
	bmatrix=1/bmatrix;

	z=(3*(pp')*bmatrix*f + ss)/(1 - 3*(pp')*bmatrix*g);
	m_kurt=z[0][0]/(x^2)-3;
	
	decl my_v=bmatrix*(f+g.*z);
	m_m=c+d.*z+e*my_v;

	my_q=y/x;
	exp_mu_sq=z*(my_q.^2) - 2*my_q.*m_m + my_v;
	exp_eps_t_t1_sq=sumc(pp.*((m.^2+o)*x+a*z+b.*m_m));
	my_value=4*(my_q.^2).*exp_eps_t_t1_sq./exp_mu_sq;
	a_mod=a./my_q;
	final_value=(-((a_mod+b).^2).*my_value + a_mod - b.*(a_mod+b) - b.*(1+a_mod).*(a_mod+b))./((1+(a_mod+b).^4).*my_value+1+(1+a_mod).^2+(a_mod-b.*(a_mod+b)).^2+(b.*(a_mod+b)).^2);
	//println(final_value);
	
	//println("Uncond. moments are: ",x," ",m_sk," ",m_kurt);
	
	my_l=(r+z[0][0]*a.*(a')+a.*(b').*(m_m')+b.*m_m.*(a'))./(1.-b.*(b'));   
	my_l[0][0]=(o[0]^2+2*o[0]*a[0]*x+2*o[0]*b[0]*y[0]+z[0][0]*a[0]^2+2*a[0]*b[0]*m_m[0])/(1-b[0]^2);
	my_l[1][1]=(o[1]^2+2*o[1]*a[1]*x+2*o[1]*b[1]*y[1]+z[0][0]*a[1]^2+2*a[1]*b[1]*m_m[1])/(1-b[1]^2);
	my_ro=(a').*(z[0][0]*my_q-m_m) + (b').*(my_q.*(m_m')-my_l);
	my_eta_corr=sumr(pp'.*my_ro).*(my_q')-my_ro;
	
	//println("Eta_corr_it_jt+1 ",my_eta_corr./sqrt(exp_mu_sq.*(exp_mu_sq')));
	//println("Corr_epst_t-1_eta_it",my_q.*sk.*sumc(pp.*m.*a)./sqrt(exp_eps_t_t1_sq.*exp_mu_sq));

	
	{
		m_vPar_forec[0][6]=pp[0];
		m_vPar_forec[0][7]=m[0]/sqrt(2);
		m_vPar_forec[0][8]=m[1]/sqrt(2);
		m_vPar_forec[0][0]=o[0]*(1+a_mod[0]+b[0]);
		m_vPar_forec[0][3]=o[1]*(1+a_mod[1]+b[1]);

		decl x1=b[0]-0.2;
		decl x2=b[1]-0.2;
		decl i=0;
		
		while (fabs(x1/(x1^2+1)+final_value[0]) >0.0000001 )
		{
			i=i+1;
			if (i>1000)
			{
				println("Not found solution for optimization");
				exit(1);
			}
			x1=x1-(x1/(x1^2+1)+final_value[0])*((1+x1^2)^2)/(1-x1^2);
		}

		i=0;
		while (fabs(x2/(x2^2+1)+final_value[1]) >0.0000001 )
		{
			i=i+1;
			if (i>1000)
			{
				println("Not found solution for optimization");
				exit(1);
			}
			x2=x2-(x2/(x2^2+1)+final_value[1])*((1+x2^2)^2)/(1-x2^2);
		}

		m_vPar_forec[0][2]=x1;
		m_vPar_forec[0][5]=x2;
		m_vPar_forec[0][1]=my_q[0]*((a_mod[0]+b[0])^2-m_vPar_forec[0][2]);
		m_vPar_forec[0][4]=my_q[1]*((a_mod[1]+b[1])^2-m_vPar_forec[0][5]);

		//println(m_vol," ", m_sk, " ", m_kurt);
		my_num-=1;
		o[0]=m_vPar_forec[0][0];
		a[0]=m_vPar_forec[0][1];
		b[0]=m_vPar_forec[0][2];
		o[1]=m_vPar_forec[0][3];
		a[1]=m_vPar_forec[0][4];
		b[1]=m_vPar_forec[0][5];
		m[0]=m_vPar_forec[0][7];
	}
	}	
	return 1;
}

//En irtam
Garch::Compute_momN()
{
	m_vol = m_calpha0;
	decl mya=m_valphav[0];
	if (m_cNMGJR==1) mya += 0.5*m_vleverage[0];
	if (m_cNMAGARCH == 1) m_vol	+= m_valphav[0]*(m_vleverage[0]^2);
	m_vol = m_vol/(1-mya-m_vbetav[0]);
	
	m_sk=0;
	decl myconst=0;
	m_kurt=(m_calpha0^2+2*m_calpha0*m_vol*(mya+m_vbetav[0]));
		
	if (m_cDist == 0)		myconst=3;
	else if (m_cDist ==1)	myconst=(3*m_cV-6)/(m_cV-4);
	else if (m_cDist == 3)
	{
		decl asym=exp(m_cA);
		decl m1, m2, m3, m4;
		decl e1, e2, e3, e4;
		m1=gammafact(m_cV/2-1/2)*(sqrt(m_cV-2))/(sqrt(M_PI)*gammafact(m_cV/2));
		m2=gammafact(m_cV/2-1)*gammafact(3/2)*pow(m_cV-2,3/2)/(sqrt(M_PI)*gammafact(m_cV/2));
		m3=gammafact(m_cV/2-3/2)*gammafact(2)*pow(m_cV-2,2)/(sqrt(M_PI)*gammafact(m_cV/2));
		m4=gammafact(m_cV/2-2)*gammafact(5/2)*pow(m_cV-2,5/2)/(sqrt(M_PI)*gammafact(m_cV/2));  
		e1= m1 * (asym-1/asym);
		e2= m2 * (pow(asym,2)-1+1/pow(asym,2));
		e3= m3 * (asym-1/asym)*(pow(asym,2)+1/pow(asym,2));
		e4= m4 * (pow(asym,5)+1/pow(asym,5))/(asym+1/asym);
		decl var_eps= e2 - e1 * e1;
		m_sk=(e3-3*e1*e2+2*pow(e1,3))/pow(var_eps,3/2);
		myconst=((e4-4*e1*e3+6*e2*pow(e1,2)-3*pow(e1,4))/pow(var_eps,2));
	}
	
	if (m_cNMAGARCH==1) m_kurt +=  (m_vleverage[0]^2)*((m_vleverage[0]^2)*(mya^2)+2*m_calpha0*mya+2*mya*m_vol*(myconst*mya+m_vbetav[0]));
	if (m_cNMGJR == 1) m_kurt=m_kurt/(1-myconst*(m_valphav[0]^2+m_valphav[0]*m_vleverage[0]+0.5*m_vleverage[0]^2)-(m_vbetav[0]^2)-2*mya*m_vbetav[0]);
	else m_kurt=m_kurt/(1-3*(mya^2)-(m_vbetav[0]^2)-2*mya*m_vbetav[0]);
	m_kurt=myconst*m_kurt/(m_vol^2)-3;
	m_vol=sqrt(m_vol);
	return 1;
}

//En irtam
Garch::ACF()
{
	decl lag=250;
	decl rok=zeros(lag,1);
	decl ck=zeros(lag,1);
	decl x=m_vol^2;
	decl z= (m_kurt+3)*x*x;
	println("Fourth moment ",z);
	decl n1="ACF_02";
	if ((m_cNM2==0) && (m_cNM3==0))
	{
		decl c_one;
		if (m_cNMGJR==1)
		{
			c_one= m_calpha0*x	+ (m_valphav[0]+0.5*m_vleverage[0])*z + m_vbetav[0]*z/3;
			ck=cumsum(m_calpha0*x*ones(lag,1),m_valphav[0]+0.5*m_vleverage[0]+m_vbetav[0],c_one);
		}
		else if (m_cNMAGARCH==1)
		{
			c_one= (m_calpha0+m_valphav[0]*(m_vleverage[0]^2))*x + m_valphav[0]*z + m_vbetav[0]*z/3;
			ck=cumsum((m_calpha0+m_valphav[0]*(m_vleverage[0]^2))*x*ones(lag,1),m_valphav[0]+m_vbetav[0],c_one);
		}
		else
		{
			c_one= m_calpha0*x	+ m_valphav[0]*z + m_vbetav[0]*z/3;
			ck=cumsum(m_calpha0*x*ones(lag,1),m_valphav[0]+m_vbetav[0],c_one);
		}
		rok=(ck-x^2)./(z-x^2);
	}
	else 
	{
		decl nr;
		if (m_cNM2==1) nr=2;
			else if (m_cNM3==1) nr=3;
		decl b=zeros(nr,1);
		decl my_const=0;
		decl my_p=zeros(1,nr);
		my_p[0][0]=m_p1;
		my_p[0][1]=m_p2;
		decl my_o=zeros(nr,1);
		my_o[0][0]=m_calpha0;
		my_o[1][0]=m_calpha0_2;
		decl my_a=zeros(nr,1);
		my_a[0][0]=m_valphav[0];
		my_a[1][0]=m_valphav_2[0];
		decl my_b=zeros(nr,1);
		my_b[0][0]=m_vbetav[0];
		my_b[1][0]=m_vbetav_2[0];
		decl my_l=zeros(nr,1);
		my_l[0][0]=m_vleverage[0];
		my_l[1][0]=m_vleverage_2[0];
		
		if (nr==2) my_const =x*(m_p1*m_mu1*m_mu1+m_p2*m_mu2*m_mu2);	
		else
		{
			my_p[0][2]=m_p3;
			my_o[2][0]=m_calpha0_3;
			my_a[2][0]=m_valphav_3[0];
			my_b[2][0]=m_vbetav_3[0];
			my_l[2][0]=m_vleverage_3[0];
			my_const = x*(m_p1*m_mu1*m_mu1+m_p2*m_mu2*m_mu2+m_p3*m_mu3*m_mu3);
		}
		b=m_m;
		ck[0]=z;
		
		if (m_cNMGJR==1)			b=my_o.*x+(my_a+0.5*my_l).*ck[0]+my_b.*b;
		else if (m_cNMAGARCH==1)	b=(my_o+my_a.*my_l.*my_l).*x+my_a.*ck[0]+my_b.*b-2*m_sk*(m_vol^3)*my_a.*my_l;
		else						b=my_o.*x+my_a.*ck[0]+my_b.*b;
		
		ck[0]=my_const+my_p*b;
		decl i;
		for (i=1; i<lag; i++)
		{
			if (m_cNMGJR==1)			b=my_o.*x+(my_a+0.5*my_l).*ck[i-1]+my_b.*b;
			else if (m_cNMAGARCH==1)	b=(my_o+my_a.*my_l.*my_l).*x+my_a.*ck[i-1]+my_b.*b;
			else						b=my_o.*x+my_a.*ck[i-1]+my_b.*b;
			
			ck[i]=my_const+my_p*b;	
		}
		rok=(ck-x^2)./(z-x^2);
	}
	

	savemat(n1~".xls",rok);
	return 1;
	
}

//En irtam
Garch::My_simulation(const n)
{
	if (n<1) return 1;
	
	else
	{
	println("Simulating for the histogram...");
	if (m_hist==1)
	{
		decl n1="Sim_02";
		decl step_ahead=1000;
		decl i;
		decl my=ranu(1,n);
		decl volatilities=ones(1,n)*m_vol;
		decl my_eps=zeros(1,n);
		if (m_cDist==0)
		{
			 if (m_cNMGJR==1)
			 {
				my_eps=quann(my);
				decl my_sign=(my_eps.<0);
				my_eps=(my_eps.^2).*volatilities;
			 	volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vleverage[0].*my_sign.*my_eps+m_vbetav[0].*volatilities;
			 	for (i=0; i<step_ahead; i++)
			 	{
			 		if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=	quann(my);
					my_sign=(my_eps.<0);
					my_eps=(my_eps.^2).*volatilities;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vleverage[0].*my_sign.*my_eps+m_vbetav[0].*volatilities;
			 	}
			 }
			 else if (m_cNMAGARCH==1)
			 {
			 	my_eps=( (quann(my)).*(volatilities.^0.5)-m_vleverage[0]).^2;
			 	volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
			 	for (i=0; i<step_ahead; i++)
			 	{
			 		if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=((quann(my)).*(volatilities.^0.5)-m_vleverage[0]).^2;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
			 	}
			 }
			 else
			 {
			 	my_eps=(quann(my).^2).*volatilities;
			 	volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
			 	for (i=0; i<step_ahead; i++)
			 	{
			 		if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=(quann(my).^2).*volatilities;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
			 	}
			 }

			 my_eps=quann(my).*sqrt(volatilities);	
		}
		else if (m_cDist==1)
		{
			if (m_cNMGJR==1)
			{
				 my_eps=quant(my, m_cV);
				 decl my_sign=(my_eps.<0);
				 my_eps=(my_eps.^2).*((m_cV-2)/m_cV).*volatilities;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vleverage[0].*my_sign.*my_eps+m_vbetav[0].*volatilities;
				 for (i=0; i<step_ahead; i++)
				 {
					if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=quant(my, m_cV);
					my_sign=(my_eps.<0);
					my_eps=(my_eps.^2).*((m_cV-2)/m_cV).*volatilities;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vleverage[0].*my_sign.*my_eps+m_vbetav[0].*volatilities;
				}
			}
			else if (m_cNMAGARCH==1)
			{
				 my_eps=((quant(my, m_cV)).*((((m_cV-2)/m_cV).*volatilities).^0.5)-m_vleverage[0]).^2;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				 for (i=0; i<step_ahead; i++)
				 {
					if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=((quant(my, m_cV)).*((((m_cV-2)/m_cV).*volatilities).^0.5)-m_vleverage[0]).^2;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				}
			}
			else
			{
			 	my_eps=(quant(my, m_cV).^2).*((m_cV-2)/m_cV).*volatilities;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				 for (i=0; i<step_ahead; i++)
				 {
					if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=(quant(my, m_cV).^2).*((m_cV-2)/m_cV).*volatilities;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				}
			}

			my_eps=quant(my, m_cV).*sqrt((m_cV-2)/m_cV).*sqrt(volatilities);
		}
		else if (m_cDist==2)
		{
			println ("Histogram simulation not available for the GED distribution");
		}
		else if (m_cDist==3)
		{
			if (m_cNMGJR==1)
			{
				 my_eps=INVCDFTA(my, m_cA, m_cV);
				 decl my_sign =(my_eps.<0);
				 my_eps=(my_eps.^2).*volatilities;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vleverage[0].*my_sign.*my_eps+m_vbetav[0].*volatilities;
				 for (i=0; i<step_ahead; i++)
				 {
				 	if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=	INVCDFTA(my, m_cA, m_cV);
					my_sign=(my_eps.<0);
					my_eps=(my_eps.^2).*volatilities;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vleverage[0].*my_sign.*my_eps+m_vbetav[0].*volatilities;
				}
			}
			else if (m_cNMAGARCH==1)
			{
				 my_eps=((INVCDFTA(my, m_cA, m_cV)).*(volatilities.^0.5)-m_vleverage[0]).^2;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				 for (i=0; i<step_ahead; i++)
				 {
				 	if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=((INVCDFTA(my, m_cA, m_cV)).*(volatilities.^0.5)-m_vleverage[0]).^2;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				}
			}
			else
			{
				 my_eps=(INVCDFTA(my, m_cA, m_cV).^2).*volatilities;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				 for (i=0; i<step_ahead; i++)
				 {
				 	if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=(INVCDFTA(my, m_cA, m_cV).^2).*volatilities;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				}
			}
			my_eps=INVCDFTA(my, m_cA, m_cV).*sqrt(volatilities);	
		}
		else if (m_cDist==4)
		{
			decl volatilities_2=ones(1,n)*m_vol;
			if (m_cNMGJR==1)
			{
				 my_eps=INVCDFNM2(my,volatilities, volatilities_2,m_p1,m_mu1);
				 decl my_sign=(my_eps.<0);
				 my_eps=my_eps.^2;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vleverage[0].*my_sign.*my_eps+m_vbetav[0].*volatilities;
				 volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps+m_vleverage_2[0].*my_sign.*my_eps+m_vbetav_2[0].*volatilities_2;
				 for (i=0; i<step_ahead; i++)
				 {
				 	if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=INVCDFNM2(my,volatilities, volatilities_2,m_p1,m_mu1);
					my_sign=(my_eps.<0);
					my_eps=my_eps.^2;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vleverage[0].*my_sign.*my_eps+m_vbetav[0].*volatilities;
					volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps+m_vleverage_2[0].*my_sign.*my_eps+m_vbetav_2[0].*volatilities_2;
				}
			}
			else if (m_cNMAGARCH==1)
			{
				 my_eps=INVCDFNM2(my,volatilities, volatilities_2,m_p1,m_mu1);
				 decl my_eps_2=my_eps;
				 my_eps=(my_eps-m_vleverage[0]).^2;
				 my_eps_2=(my_eps_2-m_vleverage_2[0]).^2;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				 volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps_2+m_vbetav_2[0].*volatilities_2;
				 for (i=0; i<step_ahead; i++)
				 {
				 	if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=INVCDFNM2(my,volatilities, volatilities_2,m_p1,m_mu1);
					my_eps_2=my_eps;
					my_eps=(my_eps-m_vleverage[0]).^2;
				 	my_eps_2=(my_eps_2-m_vleverage_2[0]).^2;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
					volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps_2+m_vbetav_2[0].*volatilities_2;
				}
			}
			else
			{
				 my_eps=INVCDFNM2(my,volatilities, volatilities_2,m_p1,m_mu1).^2;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				 volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps+m_vbetav_2[0].*volatilities_2;
				 for (i=0; i<step_ahead; i++)
				 {
				 	if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=INVCDFNM2(my,volatilities, volatilities_2,m_p1,m_mu1).^2;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
					volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps+m_vbetav_2[0].*volatilities_2;
				}
			}
			my_eps=INVCDFNM2(my,volatilities, volatilities_2,m_p1,m_mu1);	
		}
		else if (m_cDist==5)
		{
			decl volatilities_2=ones(1,n)*m_vol;
			decl volatilities_3=ones(1,n)*m_vol;
			if (m_cNMGJR==1)
			{
				 my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2);
				 decl my_sign=(my_eps.<0);
				 my_eps=my_eps.^2;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vleverage[0].*my_sign.*my_eps+m_vbetav[0].*volatilities;
				 volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps+m_vleverage_2[0].*my_sign.*my_eps+m_vbetav_2[0].*volatilities_2;
				 volatilities_3=m_calpha0_3.*ones(1,n)+m_valphav_3[0].*my_eps+m_vleverage_3[0].*my_sign.*my_eps+m_vbetav_3[0].*volatilities_3;
				 for (i=0; i<step_ahead; i++)
				 {
					if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2);
					my_sign=(my_eps.<0);
				 	my_eps=my_eps.^2;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vleverage[0].*my_sign.*my_eps+m_vbetav[0].*volatilities;
					volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps+m_vleverage_2[0].*my_sign.*my_eps+m_vbetav_2[0].*volatilities_2;
					volatilities_3=m_calpha0_3.*ones(1,n)+m_valphav_3[0].*my_eps+m_vleverage_3[0].*my_sign.*my_eps+m_vbetav_3[0].*volatilities_3;
				}
			}
			else if (m_cNMAGARCH==1)
			{
				 my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2);
				 decl my_eps_2=my_eps;
				 decl my_eps_3=my_eps;
				 my_eps=(my_eps-m_vleverage[0]).^2;
				 my_eps_2=(my_eps_2-m_vleverage_2[0]).^2;
				 my_eps_3=(my_eps_3-m_vleverage_3[0]).^2;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				 volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps_2+m_vbetav_2[0].*volatilities_2;
				 volatilities_3=m_calpha0_3.*ones(1,n)+m_valphav_3[0].*my_eps_3+m_vbetav_3[0].*volatilities_3;
				 for (i=0; i<step_ahead; i++)
				 {
					if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2);
					my_eps_2=my_eps;
				 	my_eps_3=my_eps;
				 	my_eps=(my_eps-m_vleverage[0]).^2;
				 	my_eps_2=(my_eps_2-m_vleverage_2[0]).^2;
				 	my_eps_3=(my_eps_3-m_vleverage_3[0]).^2;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
					volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps_2+m_vbetav_2[0].*volatilities_2;
					volatilities_3=m_calpha0_3.*ones(1,n)+m_valphav_3[0].*my_eps_3+m_vbetav_3[0].*volatilities_3;
				}
			}
			else
			{
				 my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2).^2;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				 volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps+m_vbetav_2[0].*volatilities_2;
				 volatilities_3=m_calpha0_3.*ones(1,n)+m_valphav_3[0].*my_eps+m_vbetav_3[0].*volatilities_3;
				 for (i=0; i<step_ahead; i++)
				 {
					if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2).^2;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
					volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps+m_vbetav_2[0].*volatilities_2;
					volatilities_3=m_calpha0_3.*ones(1,n)+m_valphav_3[0].*my_eps+m_vbetav_3[0].*volatilities_3;
				}
			}
			my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2);	
		}

		savemat(n1~".xls",my_eps');
		println("\nSimulation finished.");
		return 1;
	}
	}
}

//En irtam
Garch::INVCDFNM2(const prob, const var1, const var2, const p, const mu)
{
	decl x_old=0;
	decl x_new;
	decl precision=0.0000000001;
	decl found = 0;
	decl g;
	decl der;
	decl p2=1-p;
	decl mu2= -p.*mu./p2;

	decl vol1=sqrt(var1);
	decl vol2=sqrt(var2);

	decl x_old1=x_old-mu;
	decl x_old2=x_old-mu2;
	decl i=0;
	
	while (found==0)
	{
		i++;
		g=p.*probn(x_old1./vol1)+p2.*probn(x_old2./vol2);
		der=p.*(1.0./(sqrt(M_2PI).*vol1)).*exp((-(x_old1.^2))./(2.0.*var1))+p2.*(1.0./(sqrt(M_2PI).*vol2)).*exp((-(x_old2.^2))./(2.0.*var2));
		x_new=x_old+(prob-g)./der;
		if ((maxc(maxc(fabs(x_new-x_old)')')<precision) || (i>100))
		{
			found=1;
			if (i>100) {println("\n","Attention! Inversion not succeeded since ",maxc(maxc(fabs(x_new-x_old)')') );	exit(1);}
			return x_new;
		}
		x_old=x_new;
		x_old1=x_old-mu;
		x_old2=x_old-mu2;
	}

	println("Unsuccessful inversion of NM2 distribution");
	return 0;	
}

//En irtam
Garch::INVCDFNM3(const prob, const var1, const var2, const var3, const p1, const p2, const mu1, const mu2)
{
	decl precision=0.000000001;
	decl found = 0;
	decl g;
	decl der;
	decl p3=1-p1-p2;
	decl mu3= -(p1.*mu1+p2.*mu2)./p3;
	decl x_old=0;
	decl x_new;
	
	decl vol1=sqrt(var1);
	decl vol2=sqrt(var2);
	decl vol3=sqrt(var3);

	decl x_old1=x_old-mu1;
	decl x_old2=x_old-mu2;
	decl x_old3=x_old-mu3;
	decl i=0;

	while (found==0)
	{
		i++;
		g=p1.*probn(x_old1./vol1)+p2.*probn(x_old2./vol2)+p3.*probn(x_old3./vol3);
		der=p1.*(1.0./(sqrt(M_2PI).*vol1)).*exp((-(x_old1.^2))./(2.0.*var1))+p2.*(1.0./(sqrt(M_2PI).*vol2)).*exp((-(x_old2.^2))./(2.0.*var2))+p3.*(1.0./(sqrt(M_2PI).*vol3)).*exp((-(x_old3.^2))./(2.0.*var3));
		x_new=x_old+(prob-g)./der;
		if (isdotnan(x_new)) println("\n Inversion lead to NaN matrix",maxc[0][0]," ",der[0][0]);
		if ((maxc(maxc(fabs(x_new-x_old)')')<precision) || (i>100))
		{
			found=1;
			if (i>100) println("\n","Attention! Inversion not succeeded since ",maxc(maxc(fabs(x_new-x_old)')'));
			return x_new;
		}
		x_old=x_new;
		x_old1=x_old-mu1;
		x_old2=x_old-mu2;
		x_old3=x_old-mu3;
	}

	println("Unsuccessful inversion of NM2 distribution");
	return 0;
}

Garch::My_inverse(const n)
{
	if (n==0) return 1;
	else
	{
		decl mm;
		
		if (m_cDist==1)	 mm=probt(m_vY.*sqrt(m_cV/(m_cV-2))./sqrt(m_mXM[][0]),m_cV);
		else if (m_cDist==3)
		{ 
			decl logxi=m_cA;
			decl nu=m_cV;
		    decl g,g2,g3,c,bb,m,v; 
			g=exp(logxi); g2=g^2; g3=g^3; 
		    c=gammafact((nu+1)/2)/(gammafact(nu/2)*sqrt(M_PI*(nu-2))); 
		    bb=2/(g+(1/g)); 
			m=bb*c*(nu-2)*(g2-1/g2)/(nu-1); 
			v=sqrt(((bb*(g3+1/g3)/2) - m^2)./m_mXM[][0]); 
			mm=CDFTA((v.*m_vY)+m,logxi,nu); 
		}
		else println("Unknown distribution for this inversion!");
		savemat("inverse2.xls",mm);
		exit(1);
	}
}

Garch::Forecast_in_line(const e, const c)
{
	//e =how much we have out of 20 to forecast
	//c =if |4 then forecast 20, otherwise if |2 then forecast 10, otherwise forecast 5
	
	decl s1=5, s2=10, s3=20, my_var=m_vSigma2[sizer(m_vSigma2)-1], my_obs=m_vY[sizer(m_vY)-1]^2;
	//println(sizer(m_vY), " ", sizer(m_vSigma2), " ", m_cT," ",m_cT+c*s1);
	decl my_max=0;
	if (fmod(c,2)) my_max= min(s1,e);
	else if (fmod(c,4)) my_max=min(s2,e);
	else my_max=min(s3,e);
	decl my_forc=zeros(my_max+1,1), my_ll=zeros(my_max+1,1), my_area=zeros(my_max+1,1);
	
	if (m_cDist==0)
	{
		Compute_momN();
		m_vforc[c][9]=m_dLL; m_vforc[c][10]=m_vol; m_vforc[c][11]=m_sk; m_vforc[c][12]=m_kurt;
		m_vforc[c][13]=m_calpha0; m_vforc[c][14]=m_valphav[0];
		if (m_cNMGJR==1)
		{
			decl my_sign=(my_data.<0);
			my_forc[0:my_max][0]= cumsum(m_calpha0+(m_valphav[0]+m_vleverage[0]*my_sign[m_cT+c*s1-2:]).*(my_data[m_cT+c*s1-2:].^2),m_vbetav[0],my_var);
			m_vforc[c][15]=m_vleverage[0]; m_vforc[c][16]=m_vbetav[0];	
		}
		else if (m_cNMAGARCH==1)
		{
			my_forc[0:my_max][0]= cumsum(m_calpha0+m_valphav[0]*((my_data[m_cT+c*s1-2:]-m_vleverage[0]).^2),m_vbetav[0],my_var);
			m_vforc[c][15]=m_vleverage[0]; m_vforc[c][16]=m_vbetav[0];	
		}
		else
		{
			my_forc[0:my_max][0]= cumsum(m_calpha0+m_valphav[0]*(my_data[m_cT+c*s1-2:].^2),m_vbetav[0],my_var);
			m_vforc[c][15]=m_vbetav[0];	  			
		}
		my_ll[1:][0]=GaussLik(my_data[m_cT+c*s1:m_cT+c*s1+my_max-1],my_forc[1:][0]);
		my_area[1:][0]=probn(my_data[m_cT+c*s1:m_cT+c*s1+my_max-1]./(my_forc[1:][0].^0.5));
	}
	else if (m_cDist==1)
	{
		Compute_momN();
		m_vforc[c][9]=m_dLL; m_vforc[c][10]=m_vol; m_vforc[c][11]=m_sk; m_vforc[c][12]=m_kurt;
		m_vforc[c][13]=m_calpha0; m_vforc[c][14]=m_valphav[0];
		if (m_cNMGJR==1)
		{
			decl my_sign=(my_data.<0);
			my_forc[0:my_max][0]= cumsum(m_calpha0+(m_valphav[0]+m_vleverage[0]*my_sign[m_cT+c*s1-2:]).*(my_data[m_cT+c*s1-2:].^2),m_vbetav[0],my_var);
			m_vforc[c][15]=m_vleverage[0]; m_vforc[c][16]=m_vbetav[0];	m_vforc[c][17]=m_cV; 
		}
		else if (m_cNMAGARCH==1)
		{
			my_forc[0:my_max][0]= cumsum(m_calpha0+m_valphav[0]*((my_data[m_cT+c*s1-2:]-m_vleverage[0]).^2),m_vbetav[0],my_var);
			m_vforc[c][15]=m_vleverage[0]; m_vforc[c][16]=m_vbetav[0]; m_vforc[c][17]=m_cV; 
		}
		else
		{
			my_forc[0:my_max][0]= cumsum(m_calpha0+m_valphav[0]*(my_data[m_cT+c*s1-2:].^2),m_vbetav[0],my_var);
			m_vforc[c][15]=m_vbetav[0];	 m_vforc[c][16]=m_cV; 	
		}
		my_ll[1:][0]=StudentLik(my_data[m_cT+c*s1:m_cT+c*s1+my_max-1],my_forc[1:][0],m_cV);
		my_area[1:][0]=probt(my_data[m_cT+c*s1:m_cT+c*s1+my_max-1].*sqrt(m_cV/(m_cV-2))./(my_forc[1:][0].^0.5),m_cV);
	}
	else if (m_cDist==3)
	{
		Compute_momN();
		m_vforc[c][9]=m_dLL; m_vforc[c][10]=m_vol; m_vforc[c][11]=m_sk; m_vforc[c][12]=m_kurt;
		m_vforc[c][13]=m_calpha0; m_vforc[c][14]=m_valphav[0];
		decl g,g2,g3,cc,bb,m,v; 
		if (m_cNMGJR==1)
		{
			decl my_sign=(my_data.<0);
			my_forc[0:my_max][0]= cumsum(m_calpha0+(m_valphav[0]+m_vleverage[0]*my_sign[m_cT+c*s1-2:]).*(my_data[m_cT+c*s1-2:].^2),m_vbetav[0],my_var);
			m_vforc[c][15]=m_vleverage[0]; m_vforc[c][16]=m_vbetav[0];	m_vforc[c][17]=m_cV;  m_vforc[c][18]=m_cA;
		}
		else if (m_cNMAGARCH==1)
		{
			my_forc[0:my_max][0]= cumsum(m_calpha0+m_valphav[0]*((my_data[m_cT+c*s1-2:]-m_vleverage[0]).^2),m_vbetav[0],my_var);
			m_vforc[c][15]=m_vleverage[0]; m_vforc[c][16]=m_vbetav[0];	m_vforc[c][17]=m_cV;  m_vforc[c][18]=m_cA;
		}
		else
		{
			my_forc[0:my_max][0]= cumsum(m_calpha0+m_valphav[0]*(my_data[m_cT+c*s1-2:].^2),m_vbetav[0],my_var);
			m_vforc[c][15]=m_vbetav[0];	 m_vforc[c][16]=m_cV;  m_vforc[c][17]=m_cA;	
		}
		my_ll[1:][0]=SkStudentLik(my_data[m_cT+c*s1:m_cT+c*s1+my_max-1],my_forc[1:][0],m_cA,m_cV);
		g=exp(m_cA); g2=g^2; g3=g^3; 
	    cc=gammafact((m_cV+1)/2)/(gammafact(m_cV/2)*sqrt(M_PI*(m_cV-2))); 
	    bb=2/(g+(1/g)); 
		m=bb*cc*(m_cV-2)*(g2-1/g2)/(m_cV-1); 
		v=(((bb*(g3+1/g3)/2) - m^2)./my_forc[1:][0]).^0.5; 
		my_area[1:][0]=CDFTA((v.*my_data[m_cT+c*s1:m_cT+c*s1+my_max-1])+m,m_cA,m_cV);
	}
	else if (m_cDist==4)
	{
		decl my_forc_1=zeros(my_max+1,1), my_forc_2=zeros(my_max+1,1), sigma_sq=0, my_var_2=m_vSigma2_2[sizer(m_vSigma2)-1];
		Compute_momNM(2,1);
		m_vforc[c][9]=m_dLL; m_vforc[c][10]=m_vol; m_vforc[c][11]=m_sk; m_vforc[c][12]=m_kurt;
		m_vforc[c][13]=m_p1; m_vforc[c][14]=m_mu1; m_vforc[c][15]=m_calpha0; m_vforc[c][16]=m_valphav[0];
		if (m_cNMGJR==1)
		{
			decl my_sign=(my_data.<0);
			sigma_sq = cumsum((m_calpha0~m_calpha0_2)+(((m_valphav[0]+m_vleverage[0]*my_sign[m_cT+c*s1-2:m_cT+c*s1-2+my_max]).*(my_data[m_cT+c*s1-2:m_cT+c*s1-2+my_max].^2)) ~ ((m_valphav_2[0]+m_vleverage_2[0]*my_sign[m_cT+c*s1-2:m_cT+c*s1-2+my_max]).*(my_data[m_cT+c*s1-2:m_cT+c*s1-2+my_max].^2)))
				,(m_vbetav[0])|(m_vbetav_2[0]),my_var~my_var_2);
		 	my_forc_1= sigma_sq [][0];
			my_forc_2= sigma_sq [][1];
			my_forc= 	m_p1* (my_forc_1 + m_mu1*m_mu1) + m_p2*(my_forc_2 + m_mu2*m_mu2);
		 	m_vforc[c][17]=m_vleverage[0]; m_vforc[c][18]=m_vbetav[0];	m_vforc[c][19]=m_p2; m_vforc[c][20]=m_mu2; m_vforc[c][21]=m_calpha0_2; m_vforc[c][22]=m_valphav_2[0]; m_vforc[c][23]=m_vleverage_2[0]; m_vforc[c][24]=m_vbetav_2[0];
		}
		else if (m_cNMAGARCH==1)
		{
			sigma_sq = cumsum((m_calpha0~m_calpha0_2)+((m_valphav[0]*((my_data[m_cT+c*s1-2:m_cT+c*s1-2+my_max]-m_vleverage[0]).^2)) ~ (m_valphav_2[0]*((my_data[m_cT+c*s1-2:m_cT+c*s1-2+my_max]-m_vleverage_2[0]).^2)))
				,(m_vbetav[0])|(m_vbetav_2[0]),my_var~my_var_2);
		 	my_forc_1= sigma_sq [][0];
			my_forc_2= sigma_sq [][1];
			my_forc= 	m_p1* (my_forc_1 + m_mu1*m_mu1) + m_p2*(my_forc_2 + m_mu2*m_mu2);
		 	m_vforc[c][17]=m_vleverage[0]; m_vforc[c][18]=m_vbetav[0];	m_vforc[c][19]=m_p2; m_vforc[c][20]=m_mu2; m_vforc[c][21]=m_calpha0_2; m_vforc[c][22]=m_valphav_2[0]; m_vforc[c][23]=m_vleverage_2[0]; m_vforc[c][24]=m_vbetav_2[0];
		}
		else
		{
			sigma_sq = cumsum((m_calpha0~m_calpha0_2)+((m_valphav[0]*(my_data[m_cT+c*s1-2:m_cT+c*s1-2+my_max].^2)) ~ (m_valphav_2[0]*(my_data[m_cT+c*s1-2:m_cT+c*s1-2+my_max].^2)))
				,(m_vbetav[0])|(m_vbetav_2[0]),my_var~my_var_2);
		 	my_forc_1= sigma_sq [][0];
			my_forc_2= sigma_sq [][1];
			my_forc= 	m_p1* (my_forc_1 + m_mu1*m_mu1) + m_p2*(my_forc_2 + m_mu2*m_mu2);
		 	m_vforc[c][17]=m_vbetav[0];	m_vforc[c][18]=m_p2; m_vforc[c][19]=m_mu2; m_vforc[c][20]=m_calpha0_2; m_vforc[c][21]=m_valphav_2[0]; m_vforc[c][22]=m_vbetav_2[0];
		}
		my_ll[1:][0]=NM2Lik(my_data[m_cT+c*s1:m_cT+c*s1+my_max-1],my_forc_1[1:][0],my_forc_2[1:][0],m_p1,m_mu1);
		my_area[1:][0]=CDFNM2(my_data[m_cT+c*s1:m_cT+c*s1+my_max-1],my_forc_2[1:][0],my_forc_2[1:][0],m_p1,m_mu1);
	}
	else if (m_cDist==5)
	{
		if (m_cNMGJR==1)
		{
		}
		else if (m_cNMAGARCH==1)
		{
		}
		else
		{
		}
	}
	
	m_vforc[c*s1:c*s1-1+min(s1,my_max)][0]=(my_forc[1:][0]).^0.5;
	m_vforc[c*s1:c*s1-1+min(s1,my_max)][3]=my_ll[1:][0];
	m_vforc[c*s1:c*s1-1+min(s1,my_max)][6]=my_area[1:][0];
	
	if (!(fmod(c,2))) 
	{
		m_vforc[c*s1:c*s1-1+min(s2,my_max)][1]=(my_forc[1:][0]).^0.5;
		m_vforc[c*s1:c*s1-1+min(s2,my_max)][4]=my_ll[1:][0];
		m_vforc[c*s1:c*s1-1+min(s2,my_max)][7]=my_area[1:][0];
	}
	if (!(fmod(c,4))) 
	{
		m_vforc[c*s1:c*s1-1+min(s3,my_max)][2]=(my_forc[1:][0]).^0.5;
		m_vforc[c*s1:c*s1-1+min(s3,my_max)][5]=my_ll[1:][0];
		m_vforc[c*s1:c*s1-1+min(s3,my_max)][8]=my_area[1:][0];
	}
	
	print((m_vPar)');
	return 1;
}

Garch::Print_all()
{
	savemat("Forc_2.xls",m_vforc);	
}

Garch::Rolling_estim()
{
	m_vSigma2 = ones(m_cT,1);
	decl my_par=1;
	decl my_signal=1, i=0, max=10;	//mennyire aprolekosan keresunk
	decl my_cont=0.65;				//mennyire maradunk a regi szamoknal a keresesnel - persistence
	decl my_par_old=m_vPar;
	if (fabs(m_p1-m_vPar_cont[sizer(m_vPar_cont)-2])<0.15) m_vPar_cont=my_cont*m_vPar_cont+(1-my_cont)* my_par_old;
	print(m_vPar_cont[sizer(m_vPar_cont)-2]," ");

	while (my_signal)
	{
		if (i) print(i," ");
		my_par=i/max; i++;
	
		if (i<max+1) m_vPar=m_vPar_cont*(1-my_par)+(my_par)*my_par_old;
		else if (i<2*max+1) m_vPar=m_vPar_start*(2-my_par)+(my_par-1)*my_par_old;
		else if (i<3*max+1) m_vPar=m_vPar_cont*(3-my_par)+(my_par-2)*m_vPar_start;
		else if (i<4*max+1) m_vPar=(0.99^(i-3*max))*m_vPar_cont;
		else  m_vPar=(0.99^(i-4*max))*my_par_old;
	
		if (m_cBound == 0)	m_iResult = MaxBFGS(FigLL_max, &m_vPar, &m_dLL, 0, TRUE);
		else 				m_iResult = MaxSQPF(FigLL_max, &m_vPar, &m_dLL, 0, TRUE, cfunc_gt0, 0, m_mBound[][0],m_mBound[][1]);
			if(m_cNM2==1)
			{
				m_p2=1-m_p1;
				m_mu2=-(m_p1*m_mu1)/m_p2;
			}
			else if (m_cNM3==1)
			{
				if (!( (m_p1>0) && (m_p1<1) &&(m_p2>0) && (m_p2<1) && (m_p1+m_p2<1)))
				{
					println("\n",m_p1,"\t",m_p2,"\t Probabilities out of range! Program stopped.");
					exit(1);
				}
				m_p3=1-m_p1-m_p2;
				m_mu3=-(m_p1*m_mu1+m_p2*m_mu2)/m_p3;
			}
			my_signal=((i<5*max+1) && (isnan(m_vPar) || (m_iResult==4) || (m_p1>1) || (m_p1<0)) );
	}
	if (isnan(m_vPar) || (m_iResult==4) || (m_p1>1) || (m_p1<0))
	{
		println("Try different starting values");
		m_vPar=my_par_old;
		return 0;
	}
	return 1;
}

Garch::RollingWindow(const e, const wl)
{
	if (e==1)
	{
		m_vforc=zeros(m_cT-wl,m_cPar+2*(m_cNM2+m_cNM3)+13);
		decl s1=5, s2=10, s3=20;
		decl j=wl;
		decl total_l=m_cT;
		m_cT=wl;
		decl my_count=-1;
		decl my_max=0;
		my_data=m_vY;
		decl my_result;
		
		while (j<total_l)
		{
			my_count++;
			print(my_count+1,"*");
//			if (my_count==81)  {
				m_vY=my_data[my_count*s1:j-1];
				my_result=Rolling_estim();
				my_max=min(s3,total_l-j);
				if (my_result) Forecast_in_line(my_max, my_count);
//			}
			j+=s1;
		}
		Print_all();
		m_vY=my_data;
		m_cT=total_l;
		println("\nRolling window estimation finished.");
		return 1;
	}
	return 0;
}

Garch::option_simulation(const n)
{
	if (n==0) return 0;
	else
	{
		println("Simulating the smile...");
		decl m_months=18;
		decl m_day_step=20;
		decl m_day_min=m_day_step;
		decl m_day_max=m_months*m_day_step;
		decl m_day=zeros(m_months,1);
		for (decl i=0; i<m_months; i++)	 m_day[i][0]=m_day_min+i*m_day_step;
		
		decl m_strikes=26;
		decl m_strike_min=80;
		decl m_strike_step=2;
		decl m_strike_max=m_strike_min+m_strike_step*(m_strikes-1);
		decl m_strike=zeros(1,m_strikes);
		for (decl j=0; j<m_strikes; j++)   m_strike[0][j]=m_strike_min+j*m_strike_step;
				
		decl m_smile=zeros(m_months,m_strikes);
		decl m_rate=0.098;							//risk-free interest rate
		decl m_average=zeros(1,m_strikes);
		decl m_price=zeros(n,1);
		m_price=m_price+100.00;
		
		decl my=ranu(n,1);
		decl volatilities=ones(n,1)*m_vol.^2;
		decl my_eps=zeros(n,1);
		decl my_month=0;
		decl i=0;

		if (m_cDist==0)
		{
			
			my_eps=(quann(my)).*(volatilities.^0.5);
			if (m_cNMGJR==1)
			 {
				decl my_sign=(my_eps.<0);
				volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vleverage[0].*my_sign.*my_eps.^2+m_vbetav[0].*volatilities;
			 	for (i=0; i<m_day_max; i++)
			 	{
			 		if (imod(i+1,m_day_step)==0)
					{
						m_average=meanc( (m_price-m_strike).<0 .? 0 .: (m_price-m_strike));
						m_smile[my_month][]=m_average*exp(-m_rate*i/240);
						my_month++;	print("*");
					}
					my=ranu(n,1);
					my_eps=(quann(my)).*(volatilities.^0.5);
					my_sign=(my_eps.<0);
					m_price=m_price.*exp((m_rate-0.5*volatilities)/240+my_eps/sqrt(240));
			 		volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vleverage[0].*my_sign.*my_eps.^2+m_vbetav[0].*volatilities;
			 	}
			 }
			 else if (m_cNMAGARCH==1)
			 {
			 	volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*(my_eps-m_vleverage[0]).^2+m_vbetav[0].*volatilities;
			 	for (i=0; i<m_day_max; i++)
			 	{
			 		if (imod(i+1,m_day_step)==0)
					{
						m_average=meanc( (m_price-m_strike).<0 .? 0 .: (m_price-m_strike));
						m_smile[my_month][]=m_average*exp(-m_rate*i/240);
						my_month++;	print("*");
					}
					my=ranu(n,1);
					my_eps=(quann(my)).*(volatilities.^0.5);
					m_price=m_price.*exp((m_rate-0.5*volatilities)/240+my_eps/sqrt(240));
			 		volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*(my_eps-m_vleverage[0]).^2+m_vbetav[0].*volatilities;
			 	}
			 }
			 else
			 {
			 	volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vbetav[0].*volatilities;
				for (i=0; i<m_day_max; i++)
			 	{
			 		if (fmod(i+1,m_day_step)==0) 
					{
						m_average=meanc( (m_price-m_strike).<0 .? 0 .: (m_price-m_strike));
						m_smile[my_month][]=m_average*exp(-m_rate*i/240);
						my_month++;	print("*");
					}
					my=ranu(n,1);
					my_eps=(quann(my)).*(volatilities.^0.5);
					m_price=m_price.*exp((m_rate-0.5*volatilities)/240+my_eps/sqrt(240));
					volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vbetav[0].*volatilities;
			 	}
			 }

			 //println(m_smile);
			 for(i=0; i<m_months; i++)
				for(decl j=0; j<m_strikes; j++)
					m_smile[i][j]=option_price_implied_volatility_call_black_scholes_newton(
					100, m_strike[0][j], m_rate, m_day[i][0]/240, m_smile[i][j]);
			 my_month++;
		}
		
		else if (m_cDist==1)
		{
			
			my_eps=(quant(my, m_cV)).*(((m_cV-2)/m_cV).*volatilities).^0.5;
			if (m_cNMGJR==1)
			 {
				decl my_sign=(my_eps.<0);
				volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vleverage[0].*my_sign.*my_eps.^2+m_vbetav[0].*volatilities;
			 	for (i=0; i<m_day_max; i++)
			 	{
			 		if (imod(i+1,m_day_step)==0)
					{
						m_average=meanc( (m_price-m_strike).<0 .? 0 .: (m_price-m_strike));
						m_smile[my_month][]=m_average*exp(-m_rate*i/240);
						my_month++;	print("*");
					}
					my=ranu(n,1);
					my_eps=(quant(my, m_cV)).*(((m_cV-2)/m_cV).*volatilities).^0.5;
					my_sign=(my_eps.<0);
					m_price=m_price.*exp((m_rate-0.5*volatilities)/240+my_eps/sqrt(240));
			 		volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vleverage[0].*my_sign.*my_eps.^2+m_vbetav[0].*volatilities;
			 	}
			 }
			 else if (m_cNMAGARCH==1)
			 {
			 	volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*(my_eps-m_vleverage[0]).^2+m_vbetav[0].*volatilities;
			 	for (i=0; i<m_day_max; i++)
			 	{
			 		if (imod(i+1,m_day_step)==0)
					{
						m_average=meanc( (m_price-m_strike).<0 .? 0 .: (m_price-m_strike));
						m_smile[my_month][]=m_average*exp(-m_rate*i/240);
						my_month++;	print("*");
					}
					my=ranu(n,1);
					my_eps=(quant(my, m_cV)).*(((m_cV-2)/m_cV).*volatilities).^0.5;
					m_price=m_price.*exp((m_rate-0.5*volatilities)/240+my_eps/sqrt(240));
			 		volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*(my_eps-m_vleverage[0]).^2+m_vbetav[0].*volatilities;
			 	}
			 }
			 else
			 {
			 	volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vbetav[0].*volatilities;
				for (i=0; i<m_day_max; i++)
			 	{
			 		if (imod(i+1,m_day_step)==0)
					{
						m_average=meanc( (m_price-m_strike).<0 .? 0 .: (m_price-m_strike));
						m_smile[my_month][]=m_average*exp(-m_rate*i/240);
						my_month++;	print("*");
					}
					my=ranu(n,1);
					my_eps=(quant(my, m_cV)).*(((m_cV-2)/m_cV).*volatilities).^0.5;
					m_price=m_price.*exp((m_rate-0.5*volatilities)/240+my_eps/sqrt(240));
					volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vbetav[0].*volatilities;
			 	}
			 }

			 //println(m_smile);
			 for(i=0; i<m_months; i++)
				for(decl j=0; j<m_strikes; j++)
					m_smile[i][j]=option_price_implied_volatility_call_black_scholes_newton(
					100, m_strike[0][j], m_rate, m_day[i][0]/240, m_smile[i][j]);
			 my_month++;
		}

		else if (m_cDist==2)
		{
			println("For NM1 GED distribution smile simulation not done yet");
		}

		else if (m_cDist==3)
		{
			
			my_eps=INVCDFTA(my, m_cA, m_cV).*(volatilities.^0.5);
			if (m_cNMGJR==1)
			 {
				decl my_sign=(my_eps.<0);
				volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vleverage[0].*my_sign.*my_eps.^2+m_vbetav[0].*volatilities;
			 	for (i=0; i<m_day_max; i++)
			 	{
			 		if (imod(i+1,m_day_step)==0)
					{
						m_average=meanc( (m_price-m_strike).<0 .? 0 .: (m_price-m_strike));
						m_smile[my_month][]=m_average*exp(-m_rate*i/240);
						my_month++;	print("*");
					}
					my=ranu(n,1);
					my_eps=INVCDFTA(my, m_cA, m_cV).*(volatilities.^0.5);
					my_sign=(my_eps.<0);
					m_price=m_price.*exp((m_rate-0.5*volatilities)/240+my_eps/sqrt(240));
			 		volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vleverage[0].*my_sign.*my_eps.^2+m_vbetav[0].*volatilities;
			 	}
			 }
			 else if (m_cNMAGARCH==1)
			 {
			 	volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*(my_eps-m_vleverage[0]).^2+m_vbetav[0].*volatilities;
			 	for (i=0; i<m_day_max; i++)
			 	{
			 		if (imod(i+1,m_day_step)==0)
					{
						m_average=meanc( (m_price-m_strike).<0 .? 0 .: (m_price-m_strike));
						m_smile[my_month][]=m_average*exp(-m_rate*i/240);
						my_month++;	print("*");
					}
					my=ranu(n,1);
					my_eps=INVCDFTA(my, m_cA, m_cV).*(volatilities.^0.5);
					m_price=m_price.*exp((m_rate-0.5*volatilities)/240+my_eps/sqrt(240));
			 		volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*(my_eps-m_vleverage[0]).^2+m_vbetav[0].*volatilities;
			 	}
			 }
			 else
			 {
			 	volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vbetav[0].*volatilities;
				for (i=0; i<m_day_max; i++)
			 	{
			 		if (imod(i+1,m_day_step)==0)
					{
						m_average=meanc( (m_price-m_strike).<0 .? 0 .: (m_price-m_strike));
						m_smile[my_month][]=m_average*exp(-m_rate*i/240);
						my_month++;	print("*");
					}
					my=ranu(n,1);
					my_eps=INVCDFTA(my, m_cA, m_cV).*(volatilities.^0.5);
					m_price=m_price.*exp((m_rate-0.5*volatilities)/240+my_eps/sqrt(240));
					volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vbetav[0].*volatilities;
			 	}
			 }

			 //println(m_smile);
			 for(i=0; i<m_months; i++)
				for(decl j=0; j<m_strikes; j++)
					m_smile[i][j]=option_price_implied_volatility_call_black_scholes_newton(
					100, m_strike[0][j], m_rate, m_day[i][0]/240, m_smile[i][j]);
			 my_month++;
		}
				
		else if (m_cDist==4)
		{
			volatilities=ones(n,1)*m_vol1.^2;
			decl volatilities_2=ones(n,1)*m_vol2.^2;
			if (m_cNMGJR==1)
			 {
				decl my_sign=(my_eps.<0);
				volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vleverage[0].*my_sign.*my_eps.^2+m_vbetav[0].*volatilities;
				volatilities_2=m_calpha0_2.*ones(n,1)+m_valphav_2[0].*my_eps.^2+m_vleverage_2[0].*my_sign.*my_eps.^2+m_vbetav_2[0].*volatilities_2;
				for (i=0; i<m_day_max; i++)
			 	{
			 		if (imod(i+1,m_day_step)==0)
					{
						m_average=meanc( (m_price-m_strike).<0 .? 0 .: (m_price-m_strike));
						m_smile[my_month][]=m_average*exp(-m_rate*i/240);
						my_month++;	print("*");
					}
					my=ranu(n,1);
					my_eps=INVCDFNM2(my,volatilities, volatilities_2,m_p1.*ones(n,1),m_mu1.*ones(n,1));
					my_sign=(my_eps.<0);
					//println("Next ",sumc(isdotnan(volatilities_2)));
					m_price=m_price.*exp((m_rate-0.5*volatilities)/240+my_eps/sqrt(240));
			 		volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*my_eps.^2+m_vleverage[0].*my_sign.*my_eps.^2+m_vbetav[0].*volatilities;
					volatilities_2=m_calpha0_2.*ones(n,1)+m_valphav_2[0].*my_eps.^2+m_vleverage_2[0].*my_sign.*my_eps.^2+m_vbetav_2[0].*volatilities_2;
				}
			 }
			 else if (m_cNMAGARCH==1)
			 {
			 	volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*(my_eps-m_vleverage[0]).^2+m_vbetav[0].*volatilities;
			 	volatilities_2=m_calpha0_2.*ones(n,1)+m_valphav_2[0].*(my_eps-m_vleverage_2[0]).^2+m_vbetav_2[0].*volatilities_2;
				for (i=0; i<m_day_max; i++)
			 	{
			 		if (imod(i+1,m_day_step)==0)
					{
						m_average=meanc( (m_price-m_strike).<0 .? 0 .: (m_price-m_strike));
						m_smile[my_month][]=m_average*exp(-m_rate*i/240);
						my_month++;	print("*");
					}
					my=ranu(n,1);
					my_eps=INVCDFNM2(my,volatilities, volatilities_2,m_p1.*ones(n,1),m_mu1.*ones(n,1));
					m_price=m_price.*exp((m_rate-0.5*volatilities)/240+my_eps/sqrt(240));
			 		volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*(my_eps-m_vleverage[0]).^2+m_vbetav[0].*volatilities;
			 		volatilities_2=m_calpha0_2.*ones(n,1)+m_valphav_2[0].*(my_eps-m_vleverage_2[0]).^2+m_vbetav_2[0].*volatilities_2;
				}
			 }
			 else
			 {
			 	volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*(my_eps).^2+m_vbetav[0].*volatilities;
			 	volatilities_2=m_calpha0_2.*ones(n,1)+m_valphav_2[0].*(my_eps).^2+m_vbetav_2[0].*volatilities_2;
				for (i=0; i<m_day_max; i++)
			 	{
			 		if (imod(i+1,m_day_step)==0)
					{
						m_average=meanc( (m_price-m_strike).<0 .? 0 .: (m_price-m_strike));
						m_smile[my_month][]=m_average*exp(-m_rate*i/240);
						my_month++;	print("*");
					}
					my=ranu(n,1);
					my_eps=INVCDFNM2(my,volatilities, volatilities_2,m_p1.*ones(n,1),m_mu1.*ones(n,1));
					m_price=m_price.*exp((m_rate-0.5*volatilities)/240+my_eps/sqrt(240));
					volatilities=m_calpha0.*ones(n,1)+m_valphav[0].*(my_eps).^2+m_vbetav[0].*volatilities;
			 		volatilities_2=m_calpha0_2.*ones(n,1)+m_valphav_2[0].*(my_eps).^2+m_vbetav_2[0].*volatilities_2;
				}
			 }

			 //println(m_smile);
			 for(i=0; i<m_months; i++)
				for(decl j=0; j<m_strikes; j++)
					m_smile[i][j]=option_price_implied_volatility_call_black_scholes_newton(
					100, m_strike[0][j], m_rate, m_day[i][0]/240, m_smile[i][j]);
			 my_month++;
		}

		else if (m_cDist==5)
		{

			println("For NM3 smile simulation not done yet");
/*			decl volatilities_2=ones(1,n)*m_vol;
			decl volatilities_3=ones(1,n)*m_vol;
			if (m_cNMGJR==1)
			{
				 my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2);
				 decl my_sign=(my_eps.<0);
				 my_eps=my_eps.^2;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vleverage[0].*my_sign.*my_eps+m_vbetav[0].*volatilities;
				 volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps+m_vleverage_2[0].*my_sign.*my_eps+m_vbetav_2[0].*volatilities_2;
				 volatilities_3=m_calpha0_3.*ones(1,n)+m_valphav_3[0].*my_eps+m_vleverage_3[0].*my_sign.*my_eps+m_vbetav_3[0].*volatilities_3;
				 for (i=0; i<step_ahead; i++)
				 {
					if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2);
					my_sign=(my_eps.<0);
				 	my_eps=my_eps.^2;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vleverage[0].*my_sign.*my_eps+m_vbetav[0].*volatilities;
					volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps+m_vleverage_2[0].*my_sign.*my_eps+m_vbetav_2[0].*volatilities_2;
					volatilities_3=m_calpha0_3.*ones(1,n)+m_valphav_3[0].*my_eps+m_vleverage_3[0].*my_sign.*my_eps+m_vbetav_3[0].*volatilities_3;
				}
			}
			else if (m_cNMAGARCH==1)
			{
				 my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2);
				 decl my_eps_2=my_eps;
				 decl my_eps_3=my_eps;
				 my_eps=(my_eps-m_vleverage[0]).^2;
				 my_eps_2=(my_eps_2-m_vleverage_2[0]).^2;
				 my_eps_3=(my_eps_3-m_vleverage_3[0]).^2;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				 volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps_2+m_vbetav_2[0].*volatilities_2;
				 volatilities_3=m_calpha0_3.*ones(1,n)+m_valphav_3[0].*my_eps_3+m_vbetav_3[0].*volatilities_3;
				 for (i=0; i<step_ahead; i++)
				 {
					if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2);
					my_eps_2=my_eps;
				 	my_eps_3=my_eps;
				 	my_eps=(my_eps-m_vleverage[0]).^2;
				 	my_eps_2=(my_eps_2-m_vleverage_2[0]).^2;
				 	my_eps_3=(my_eps_3-m_vleverage_3[0]).^2;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
					volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps_2+m_vbetav_2[0].*volatilities_2;
					volatilities_3=m_calpha0_3.*ones(1,n)+m_valphav_3[0].*my_eps_3+m_vbetav_3[0].*volatilities_3;
				}
			}
			else
			{
				 my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2).^2;
				 volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
				 volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps+m_vbetav_2[0].*volatilities_2;
				 volatilities_3=m_calpha0_3.*ones(1,n)+m_valphav_3[0].*my_eps+m_vbetav_3[0].*volatilities_3;
				 for (i=0; i<step_ahead; i++)
				 {
					if (imod(i,10)==0) print("*");
					my=ranu(1,n);
					my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2).^2;
					volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*my_eps+m_vbetav[0].*volatilities;
					volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*my_eps+m_vbetav_2[0].*volatilities_2;
					volatilities_3=m_calpha0_3.*ones(1,n)+m_valphav_3[0].*my_eps+m_vbetav_3[0].*volatilities_3;
				}
			}
			my_eps=INVCDFNM3(my,volatilities, volatilities_2,volatilities_3,m_p1,m_p2,m_mu1,m_mu2);	
*/		}
		
		savemat("Smiles.xls",m_smile);
		println("\nFinished simulating.");
	}
}

Garch::time_aggreg_sim(const n, const m, const k)
{
	//n = number of simulations, m = lenght of minimum time series, k = number of steps in time aggregation 
	if (n==0) return 0;
	else
	{
		println("Simulating...");
		//m_restr=6;					//to force p and mu specific values, see procedure FigLL_max
		Compute_momNM(2,1);
		decl my_l=(2^k)*m+7;
		decl my_data1=zeros(my_l,n);

		decl volatilities=ones(n,1)*m_vol.^2;
		decl volatilities_2=ones(n,1)*m_vol2.^2;
		decl my_eps=zeros(1,n);
		decl my=ranu(1,n);
		decl i=0;
		
		my_eps=INVCDFNM2(my,volatilities, volatilities_2,m_p1,m_mu1);
		
		volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*(my_eps).^2+m_vbetav[0].*volatilities;
		volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*(my_eps).^2+m_vbetav_2[0].*volatilities_2;
		
		for (i=0; i<my_l; i++)
		{
			my=ranu(1,n);
			if ( fmod(i,100) == 0) print("*");
			my_eps=INVCDFNM2(my,volatilities, volatilities_2,m_p1,m_mu1);
			my_data1[i][]=my_eps[0][];
			volatilities=m_calpha0.*ones(1,n)+m_valphav[0].*(my_eps).^2+m_vbetav[0].*volatilities;
			volatilities_2=m_calpha0_2.*ones(1,n)+m_valphav_2[0].*(my_eps).^2+m_vbetav_2[0].*volatilities_2;
		}
		//savemat("mysim.xls",my_data1);

		decl sq2=sqrt(2);
		decl my_data2= zeros(my_l-1,n);

		for (i=0; i<(2^(k-1))*m+3; i++)
		{
			my_data2[i][]=((my_data1[2*i][]+my_data1[2*i+1][]))/sq2 ;
			my_data2[i+(2^(k-1))*m+3][]=((my_data1[2*i+1][]+my_data1[2*i+2][]))/sq2;
		}
		//savemat("mysim2.xls",my_data2);

		decl my_data4= zeros(my_l-1,n);

		for (i=0; i<2*m+1; i++)
		{
			my_data4[i][]=((my_data2[2*i][]+my_data2[2*i+1][]))/sq2 ;
			my_data4[i+2*m+1][]=((my_data2[2*i+1][]+my_data2[2*i+2][]))/sq2;
			my_data4[i+4*m+2][]=((my_data2[4*m+3+2*i][]+my_data2[4*m+3+2*i+1][]))/sq2;
			my_data4[i+6*m+3][]=((my_data2[4*m+3+2*i+1][]+my_data2[4*m+3+2*i+2][]))/sq2;
		}
		//savemat("mysim4.xls",my_data4);

		decl my_data8= zeros(my_l-1,n);
		
		for (i=0; i<m; i++)
		{
			my_data8[i][]=((my_data4[2*i][]+my_data4[2*i+1][]))/sq2 ;
			my_data8[i+m][]=((my_data4[2*i+1][]+my_data4[2*i+2][]))/sq2;
			my_data8[i+m*2][]=((my_data4[2*m+2*i+1][]+my_data4[2*m+2*i+2][]))/sq2;
			my_data8[i+m*3][]=((my_data4[2*m+2*i+2][]+my_data4[2*m+2*i+3][]))/sq2;
			my_data8[i+m*4][]=((my_data4[3*m+2*i+2][]+my_data4[3*m+2*i+3][]))/sq2 ;
			my_data8[i+m*5][]=((my_data4[3*m+2*i+3][]+my_data4[3*m+2*i+4][]))/sq2;
			my_data8[i+m*6][]=((my_data4[4*m+2*i+3][]+my_data4[4*m+2*i+4][]))/sq2;
			my_data8[i+m*7][]=((my_data4[4*m+2*i+4][]+my_data4[4*m+2*i+5][]))/sq2;
		}
		//savemat("mysim8.xls",my_data8);
		
		decl param_st=zeros(21,14);
		param_st[0][0]=m_p1;
		param_st[0][1]=m_mu1;
		param_st[0][2]=m_mu2;
		param_st[0][3]=m_calpha0;
		param_st[0][4]=m_valphav[0];
		param_st[0][5]=m_vbetav[0];
		param_st[0][6]=m_calpha0_2;
		param_st[0][7]=m_valphav_2[0];
		param_st[0][8]=m_vbetav_2[0];
		param_st[0][9]=m_vol;
		param_st[0][10]=m_vol1;
		param_st[0][11]=m_vol2;
		param_st[0][12]=m_sk;
		param_st[0][13]=m_kurt;
				
		decl my_param=zeros(4*n,14);
		decl my_k=0;
		decl j=0;
		decl m_vPar_start=m_vPar;
		decl m_vPar_start2=m_vPar_forec[0:7];

		m_calpha0=m_vPar_start2[0];
		m_valphav[0]=m_vPar_start2[1];
		m_vbetav[0]=m_vPar_start2[2];
		m_calpha0_2=m_vPar_start2[3];		
		m_valphav_2[0]=m_vPar_start2[4];
		m_vbetav_2[0]=m_vPar_start2[5];
		m_p1=m_vPar_start2[6];
		m_mu1=m_vPar_start2[7];
		Compute_momNM(2,1);
		decl m_vPar_start4=m_vPar_forec[0:7];

		m_calpha0=m_vPar_start4[0];
		m_valphav[0]=m_vPar_start4[1];
		m_vbetav[0]=m_vPar_start4[2];
		m_calpha0_2=m_vPar_start4[3];
		m_valphav_2[0]=m_vPar_start4[4];
		m_vbetav_2[0]=m_vPar_start4[5];
		m_p1=m_vPar_start2[6];
		m_mu1=m_vPar_start4[7];
		Compute_momNM(2,1);
		decl m_vPar_start8=m_vPar_forec[0:7];

		println;
		println("\nFirst go: ");
		decl bound=0;
		
		for (i=0; i<n; i++)
		{
			print(" ",i);
			m_vY=my_data1[][i];
			m_vPar=m_vPar_start;
			m_iResult = MaxBFGS(FigLL_max, &m_vPar, &m_dLL, 0, TRUE);
			//m_iResult=MaxSQPF(FigLL_max, &m_vPar, &m_dLL, 0, TRUE, cfunc_gt0, 0, m_mBound[][0],m_mBound[][1]);
			bound= ( (m_p1<=0.5) || (m_p1>=1) || (m_mu1<-1) || (m_mu1>1) || (m_calpha0<-1) || (m_calpha0>1) || (m_valphav[0]<=0) || (m_valphav_2[0]<=0) || (m_valphav[0]>1) || (m_valphav_2[0]>1) || (m_vbetav[0]<=0) || (m_vbetav_2[0]<=0) || (m_vbetav[0]>1) || (m_vbetav_2[0]>1) ); 
	
			if ( (isnan(m_p1)) || (bound) )
			{
				print("*");
			}
			else
			{	//println(m_vPar');
				for (j=0; j<4; j++)
				{
					m_p2=1-m_p1;
					m_mu2=-(m_p1*m_mu1)/m_p2;
					Compute_momNM(2,1);
					my_param[j*n+my_k][0]=m_p1;
					my_param[j*n+my_k][1]=m_mu1;
					my_param[j*n+my_k][2]=m_mu2;
					my_param[j*n+my_k][3]=m_calpha0;
					my_param[j*n+my_k][4]=m_valphav[0];
					my_param[j*n+my_k][5]=m_vbetav[0];
					my_param[j*n+my_k][6]=m_calpha0_2;
					my_param[j*n+my_k][7]=m_valphav_2[0];
					my_param[j*n+my_k][8]=m_vbetav_2[0];
					my_param[j*n+my_k][9]=m_vol;
					my_param[j*n+my_k][10]=m_vol1;
					my_param[j*n+my_k][11]=m_vol2;
					my_param[j*n+my_k][12]=m_sk;
					my_param[j*n+my_k][13]=m_kurt;

					m_p1=m_vPar_forec[0][6];
					m_mu1=m_vPar_forec[0][7];
					m_mu2=m_vPar_forec[0][8];
					m_calpha0=m_vPar_forec[0][0];
					m_valphav[0]=m_vPar_forec[0][1];
					m_vbetav[0]=m_vPar_forec[0][2];
					m_calpha0_2=m_vPar_forec[0][3];
					m_valphav_2[0]=m_vPar_forec[0][4];
					m_vbetav_2[0]=m_vPar_forec[0][5];							   
				}
				
				my_k=my_k+1;
			}
		}
		
		param_st[1][]=meanc(my_param[0:my_k-1][]);
		param_st[2][]=sqrt(varc(my_param[0:my_k-1][]));
		param_st[3][]=meanc(my_param[n:n+my_k-1][]);
		param_st[4][]=sqrt(varc(my_param[n:n+my_k-1][]));
		param_st[5][]=meanc(my_param[2*n:2*n+my_k-1][]);
		param_st[6][]=sqrt(varc(my_param[2*n:2*n+my_k-1][]));
		param_st[7][]=meanc(my_param[3*n:3*n+my_k-1][]);
		param_st[8][]=sqrt(varc(my_param[3*n:3*n+my_k-1][]));
		
		println("\nSecond go: ");
		decl my_num=0;

		m_vPar_start[0]=m_vPar_start2[0];
		m_vPar_start[1]=m_vPar_start2[1];
		m_vPar_start[2]=m_vPar_start2[2];
		m_vPar_start[3]=m_vPar_start2[3];
		m_vPar_start[4]=m_vPar_start2[4];
		m_vPar_start[5]=m_vPar_start2[5];
		
		for (my_num=0; my_num<2; my_num++)
		{
		my_k=0;

		for (i=0; i<n; i++)
		{
			print(" ",i);
			if (my_num==0) m_vY=my_data2[0:(2^(k-1))*m+2][i];
			else m_vY=my_data2[(2^(k-1))*m+3:(2^k)*m+5][i];
			m_vPar=m_vPar_start2';
			m_iResult = MaxBFGS(FigLL_max, &m_vPar, &m_dLL, 0, TRUE);
			//m_iResult=MaxSQPF(FigLL_max, &m_vPar, &m_dLL, 0, TRUE, cfunc_gt0, 0, m_mBound[][0],m_mBound[][1]);
			bound= ( (m_p1<=0.5) || (m_p1>=1) || (m_mu1<-1) || (m_mu1>1) || (m_calpha0<-1) || (m_calpha0>1) || (m_valphav[0]<=0) || (m_valphav_2[0]<=0) || (m_valphav[0]>1) || (m_valphav_2[0]>1) || (m_vbetav[0]<=0) || (m_vbetav_2[0]<=0) || (m_vbetav[0]>1) || (m_vbetav_2[0]>1) ); 
	
			if ( (isnan(m_p1)) || (bound) )
			{
				print("* ");
			}
			else
			{	//println(m_vPar');
				for (j=0; j<3; j++)
				{
					m_p2=1-m_p1;
					m_mu2=-(m_p1*m_mu1)/m_p2;
					Compute_momNM(2,1);
					my_param[j*n+my_k][0]=m_p1;
					my_param[j*n+my_k][1]=m_mu1;
					my_param[j*n+my_k][2]=m_mu2;
					my_param[j*n+my_k][3]=m_calpha0;
					my_param[j*n+my_k][4]=m_valphav[0];
					my_param[j*n+my_k][5]=m_vbetav[0];
					my_param[j*n+my_k][6]=m_calpha0_2;
					my_param[j*n+my_k][7]=m_valphav_2[0];
					my_param[j*n+my_k][8]=m_vbetav_2[0];
					my_param[j*n+my_k][9]=m_vol;
					my_param[j*n+my_k][10]=m_vol1;
					my_param[j*n+my_k][11]=m_vol2;
					my_param[j*n+my_k][12]=m_sk;
					my_param[j*n+my_k][13]=m_kurt;

					m_p1=m_vPar_forec[0][6];
					m_mu1=m_vPar_forec[0][7];
					m_mu2=m_vPar_forec[0][8];
					m_calpha0=m_vPar_forec[0][0];
					m_valphav[0]=m_vPar_forec[0][1];
					m_vbetav[0]=m_vPar_forec[0][2];
					m_calpha0_2=m_vPar_forec[0][3];
					m_valphav_2[0]=m_vPar_forec[0][4];
					m_vbetav_2[0]=m_vPar_forec[0][5];
				}
				
				my_k=my_k+1;
			}
		}
		
		if(my_num==0)
		{
			param_st[9][]=meanc(my_param[0:my_k-1][]);
			param_st[10][]=sqrt(varc(my_param[0:my_k-1][]));
			param_st[11][]=meanc(my_param[n:n+my_k-1][]);
			param_st[12][]=sqrt(varc(my_param[n:n+my_k-1][]));
			param_st[13][]=meanc(my_param[2*n:2*n+my_k-1][]);
			param_st[14][]=sqrt(varc(my_param[2*n:2*n+my_k-1][]));
		}
		else
		{
			param_st[9][]=(param_st[9][]+meanc(my_param[0:my_k-1][]))/2;
			param_st[10][]=(param_st[10][]+sqrt(varc(my_param[0:my_k-1][])))/2;
			param_st[11][]=(param_st[11][]+meanc(my_param[n:n+my_k-1][]))/2;
			param_st[12][]=(param_st[12][]+sqrt(varc(my_param[n:n+my_k-1][])))/2;
			param_st[13][]=(param_st[13][]+meanc(my_param[2*n:2*n+my_k-1][]))/2;
			param_st[14][]=(param_st[14][]+sqrt(varc(my_param[2*n:2*n+my_k-1][])))/2;
		}

		}		

		println("\nThird go: ");
		
		m_vPar_start[0]=m_vPar_start4[0];
		m_vPar_start[1]=m_vPar_start4[1];
		m_vPar_start[2]=m_vPar_start4[2];
		m_vPar_start[3]=m_vPar_start4[3];
		m_vPar_start[4]=m_vPar_start4[4];
		m_vPar_start[5]=m_vPar_start4[5];
		
		for (my_num=0; my_num<4; my_num++)
		{
		my_k=0;

		for (i=0; i<n; i++)
		{
			print(" ",i);
			if (my_num==0) m_vY=my_data4[0:2*m][i];
			else if (my_num==1) m_vY=my_data4[2*m+1:4*m+1][i];
			else if (my_num==2) m_vY=my_data4[4*m+2:6*m+2][i];
			else m_vY=my_data4[6*m+3:8*m+3][i];
			m_vPar=m_vPar_start4';
			m_iResult = MaxBFGS(FigLL_max, &m_vPar, &m_dLL, 0, TRUE);
			//m_iResult=MaxSQPF(FigLL_max, &m_vPar, &m_dLL, 0, TRUE, cfunc_gt0, 0, m_mBound[][0],m_mBound[][1]);
			bound= ( (m_p1<=0.5) || (m_p1>=1) || (m_mu1<-1) || (m_mu1>1) || (m_calpha0<-1) || (m_calpha0>1) || (m_valphav[0]<=0) || (m_valphav_2[0]<=0) || (m_valphav[0]>2) || (m_valphav_2[0]>2) || (m_vbetav[0]<=0) || (m_vbetav_2[0]<=0) || (m_vbetav[0]>1) || (m_vbetav_2[0]>1) ); 
	
			if ( (isnan(m_p1)) || (bound) )
			{
				print("* ");
			}
			else
			{	//println(m_vPar');
				for (j=0; j<2; j++)
				{
					m_p2=1-m_p1;
					m_mu2=-(m_p1*m_mu1)/m_p2;
					Compute_momNM(2,1);
					my_param[j*n+my_k][0]=m_p1;
					my_param[j*n+my_k][1]=m_mu1;
					my_param[j*n+my_k][2]=m_mu2;
					my_param[j*n+my_k][3]=m_calpha0;
					my_param[j*n+my_k][4]=m_valphav[0];
					my_param[j*n+my_k][5]=m_vbetav[0];
					my_param[j*n+my_k][6]=m_calpha0_2;
					my_param[j*n+my_k][7]=m_valphav_2[0];
					my_param[j*n+my_k][8]=m_vbetav_2[0];
					my_param[j*n+my_k][9]=m_vol;
					my_param[j*n+my_k][10]=m_vol1;
					my_param[j*n+my_k][11]=m_vol2;
					my_param[j*n+my_k][12]=m_sk;
					my_param[j*n+my_k][13]=m_kurt;

					m_p1=m_vPar_forec[0][6];
					m_mu1=m_vPar_forec[0][7];
					m_mu2=m_vPar_forec[0][8];
					m_calpha0=m_vPar_forec[0][0];
					m_valphav[0]=m_vPar_forec[0][1];
					m_vbetav[0]=m_vPar_forec[0][2];
					m_calpha0_2=m_vPar_forec[0][3];
					m_valphav_2[0]=m_vPar_forec[0][4];
					m_vbetav_2[0]=m_vPar_forec[0][5];
				}
				
				my_k=my_k+1;
			}
		}
		
		if(my_num==0)
		{
			param_st[15][]=meanc(my_param[0:my_k-1][])/4;
			param_st[16][]=sqrt(varc(my_param[0:my_k-1][]))/4;			//Volatility computin is wrong!!!!!
			param_st[17][]=meanc(my_param[n:n+my_k-1][])/4;
			param_st[18][]=sqrt(varc(my_param[n:n+my_k-1][]))/4;
		}
		else
		{
			param_st[15][]=param_st[15][]+meanc(my_param[0:my_k-1][])/4;
			param_st[16][]=param_st[16][]+sqrt(varc(my_param[0:my_k-1][]))/4;
			param_st[17][]=param_st[17][]+meanc(my_param[n:n+my_k-1][])/4;
			param_st[18][]=param_st[18][]+sqrt(varc(my_param[n:n+my_k-1][]))/4;
		}

		}

		println("\nFourth go: ");
		
		m_vPar_start[0]=m_vPar_start8[0];
		m_vPar_start[1]=m_vPar_start8[1];
		m_vPar_start[2]=m_vPar_start8[2];
		m_vPar_start[3]=m_vPar_start8[3];
		m_vPar_start[4]=m_vPar_start8[4];
		m_vPar_start[5]=m_vPar_start8[5];
				
		for (my_num=0; my_num<8; my_num++)
		{
		my_k=0;

		for (i=0; i<n; i++)
		{
			print(" ",i);
			if (my_num==0) m_vY=my_data8[0:m-1][i];
			else if (my_num==1) m_vY=my_data8[m:2*m-1][i];
			else if (my_num==2) m_vY=my_data8[2*m:3*m-1][i];
			else if (my_num==3) m_vY=my_data8[3*m:4*m-1][i];
			else if (my_num==4) m_vY=my_data8[4*m:5*m-1][i];
			else if (my_num==5) m_vY=my_data8[5*m:6*m-1][i];
			else if (my_num==6) m_vY=my_data8[6*m:7*m-1][i];
			else if (my_num==7) m_vY=my_data8[7*m:8*m-1][i];
			
			m_vPar=m_vPar_start;
			m_iResult = MaxBFGS(FigLL_max, &m_vPar, &m_dLL, 0, TRUE);
			//m_iResult=MaxSQPF(FigLL_max, &m_vPar, &m_dLL, 0, TRUE, cfunc_gt0, 0, m_mBound[][0],m_mBound[][1]);
			bound= ( (m_p1<=0.5) || (m_p1>=1) || (m_mu1<-1) || (m_mu1>1) || (m_calpha0<-1) || (m_calpha0>1) || (m_valphav[0]<=0) || (m_valphav_2[0]<=0) || (m_valphav[0]>2) || (m_valphav_2[0]>2) || (m_vbetav[0]<=0) || (m_vbetav_2[0]<=0) || (m_vbetav[0]>1) || (m_vbetav_2[0]>1) ); 
	
			if ( (isnan(m_p1)) || (bound) )
			{
				print("* ");
			}
			else
			{	    //println(m_vPar');
					m_p2=1-m_p1;
					m_mu2=-(m_p1*m_mu1)/m_p2;
					Compute_momNM(2,1);
					my_param[j*n+my_k][0]=m_p1;
					my_param[j*n+my_k][1]=m_mu1;
					my_param[j*n+my_k][2]=m_mu2;
					my_param[j*n+my_k][3]=m_calpha0;
					my_param[j*n+my_k][4]=m_valphav[0];
					my_param[j*n+my_k][5]=m_vbetav[0];
					my_param[j*n+my_k][6]=m_calpha0_2;
					my_param[j*n+my_k][7]=m_valphav_2[0];
					my_param[j*n+my_k][8]=m_vbetav_2[0];
					my_param[j*n+my_k][9]=m_vol;
					my_param[j*n+my_k][10]=m_vol1;
					my_param[j*n+my_k][11]=m_vol2;
					my_param[j*n+my_k][12]=m_sk;
					my_param[j*n+my_k][13]=m_kurt;
					
					my_k=my_k+1;
			}
		}
		
		if(my_num==0)
		{
			param_st[19][]=meanc(my_param[0:my_k-1][])/8;
			param_st[20][]=sqrt(varc(my_param[0:my_k-1][]))/8;			//Volatility computin is wrong!!!!!
		}
		else
		{
			param_st[19][]=param_st[19][]+meanc(my_param[0:my_k-1][])/8;
			param_st[20][]=param_st[20][]+sqrt(varc(my_param[0:my_k-1][]))/8;
		}

		}
		
 		
		//println(my_param);
		println(param_st);
		exit(1);
	}
}

main()
{
	decl garchobj;
	garchobj = new Garch();

/*	decl c=0;
	println("Implied vols with different strikes - BS formula:");
	c=garchobj.option_price_call_black_scholes(100,95,0.03,0.09,1/12);
	println(95," ",c," ",garchobj.option_price_implied_volatility_call_black_scholes_newton(100, 95, 0.03, 1/12, c));
	c=garchobj.option_price_call_black_scholes(100,100,0.03,0.09,1/12);
	println(100," ",c," ",garchobj.option_price_implied_volatility_call_black_scholes_newton(100, 100, 0.03, 1/12, c));
	c=garchobj.option_price_call_black_scholes(100,105,0.03,0.09,1/12);
	println(105," ",c," ",garchobj.option_price_implied_volatility_call_black_scholes_newton(100, 105, 0.03, 1/12, c));

	println("Implied vols with different strikes - simulated:");
	c=garchobj.option_price_call_european_simulated(100, 95,0.03,0.09,1/12,1000000);
	println(95," ",c," ",garchobj.option_price_implied_volatility_call_black_scholes_newton(100, 95, 0.03, 1/12, c));
	c=garchobj.option_price_call_european_simulated(100, 100,0.03,0.09,1/12,1000000);
	println(100," ",c," ",garchobj.option_price_implied_volatility_call_black_scholes_newton(100, 100, 0.03, 1/12, c));
	c=garchobj.option_price_call_european_simulated(100, 105,0.03,0.09,1/12,1000000);
	println(105," ",c," ",garchobj.option_price_implied_volatility_call_black_scholes_newton(100, 105, 0.03, 1/12, c));
	exit(1);					     			 
*/	
//*** DATA ***//
	garchobj.Load("/data/sp_ox.xls");
	garchobj.Info();          
                                 
    garchobj.Select(Y_VAR, {"data",0,0} );		 //name of column where data is
	
	//garchobj.Select(X_VAR, {"var",0,0});		// use this one for the inversion of t-distrib!!!!!!!!!

//	garchobj.Select(X_VAR, {"NAME",0,0});		// REGRESSOR IN THE MEAN
//	garchobj.Select(Z_VAR, {"NAME",0,0});		// REGRESSOR IN THE VARIANCE
//  garchobj.Select(O_VAR, {"RV",0,0} );		// REALIZED VOLATILITY
							 
	garchobj.SetSelSample(-1, 1, 10000, 1);
	
//*** SPECIFICATIONS ***//
	garchobj.CSTS(0,1); 			// cst in Mean (1 or 0), cst in Variance (1 or 0)	
	garchobj.DISTRI(3);				// 0 for Gauss, 1 for Student, 2 for GED, 3 for Skewed-Student, 4 for NM2, 5 for NM3
	garchobj.ARMA_ORDERS(0,0); 		// AR order (p), MA order (q).
	garchobj.ARFIMA(0);				// 1 if Arfima wanted, 0 otherwise
	garchobj.GARCH_ORDERS(1,1);		// p order, q order
	garchobj.MODEL(12);				//	1:GARCH		2:EGARCH	3:GJR	4:APARCH	5:IGARCH
									//  6:FIGARCH(BBM)	7:FIGARCH(Chung)	8:FIEGARCH(BM only)
									//  9:FIAPARCH(BBM)	10: FIAPARCH(Chung)	11: HYGARCH(BBM)   12:NM-GJR	13:NM-AGARCH
	garchobj.ARCH_in_mean(0);		// ARCH-in-mean: 1 to add the variance in the cond. mean, 2 to add the cond. std., 0 othewize 						
	garchobj.TRUNC(100);			// Truncation order (only F.I. models with BBM method)
	garchobj.NMRESTR(0);			// Restriction for the NM2-GARCH model:
									// NM2: 0:no restr	1:MU1=MU2=A1-A2=B1-B2=0	 2:MU1=MU2=A2=B2=0	3:MU1=MU2
									//					4:A1-A2=B1-B2=0			 5:A2=B2=0
									// NM3: 0:no restr	1:MU1=MU2=MU3=A1-A2=B1-B2=A1-A3=B1-B3=0		2:MU1=MU2=MU3=A3=B3=0	3:MU1=MU2=MU3
									//					4:A1-A2=B1-B2=A1-A3=B1-B3=0					5:A3=B3=0 

//*** TESTS & FORECASTS ***//	
	garchobj.BOXPIERCE(<10;15;20>);	// Lags for the Box-Pierce Q-statistics, <> otherwise
	garchobj.ARCHLAGS(<2;5;10>);	// Lags for Engle's LM ARCH test, <> otherwise
	garchobj.NYBLOM(1);				// 1 to compute the Nyblom stability test, 0 otherwise  
	garchobj.PEARSON(<40;50;60>);	// Cells (<40;50;60>) for the adjusted Pearson Chi-square Goodness-of-fit test, <> otherwise //G@RCH1.12
	garchobj.FORECAST(0,10,1);     	// Arg.1 : 1 to launch the forecasting procedure, 0 otherwize 
									// Arg.2 : Number of forecasts
									// Arg.3 : 1 to Print the forecasts, 0 otherwise
	garchobj.MYTESTS(1,0,0);		// Arg.1 : Moment tests
									// Arg.2 : ACF
									// Arg.3 : Histogram simulation
	
//*** OUTPUT ***//	
	garchobj.MLE(1);				// 0 : both, 1 : MLE, 2 : QMLE
	garchobj.COVAR(0);			    // if 1, prints variance-covariance matrix of the parameters.
	garchobj.ITER(0);				// Interval of iterations between printed intermediary results (if no intermediary results wanted, enter '0')
	garchobj.TESTS(0,0);			// Arg. 1 : 1 to run tests PRIOR to estimation, 0 otherwise
									// Arg. 2 : 1 to run tests AFTER estimation, 0 otherwise
	garchobj.GRAPHS(1,0,"");		// Arg.1 : if 1, displays graphics of the estimations (only when using GiveWin).
									// Arg.2 : if 1, saves these graphics in a EPS file (OK with all Ox versions)
									// Arg.3 : Name of the saved file.
	garchobj.FOREGRAPHS(0,0,"");  	// Same as GRAPHS(p,s,n) but for the graphics of the forecasts. 

//*** PARAMETERS ***//	
	garchobj.BOUNDS(0);				// 1 if bounded parameters wanted, 0 otherwise
	garchobj.FixParam(0,<1;0;0;0>);   // Arg.1 : 1 to fix some parameters to their starting values, 0 otherwize
									// Arg.2 : 1 to fix (see garchobj.DoEstimation(<>)) and 0 to estimate the corresponding parameter

//*** ESTIMATION ***//										
	garchobj.Initialization(<>) ;

	StartValues(garchobj);

	garchobj.time_aggreg_sim(0,1000,3);	//how many simulations, how long the shortest time series, 2 on what power aggregation

	//garchobj.Compute_momNM(2,1);
	//exit(1);
	
	garchobj.PrintStartValues(0) ;	  // 1: Prints the S.V. in a table form ; 2: Individually ;  3: in a Ox code to use in StartValues

	garchobj.My_inverse(0);			  //1=to inverse the t and Asym t distributions for VaR calculations
	garchobj.DoEstimation() ;
// m_vPar = m_clevel | m_vbetam |  m_dARFI | m_vAR | m_vMA | m_calpha0 | m_vgammav | m_dD | m_valphav |	m_vbetav |
//			m_vleverage | m_vtheta1 | m_vtheta2 | m_vpsy | m_ddelta | m_cA | m_cV | m_vHY | m_v_in_mean


	garchobj.Output() ;
			
	garchobj.STORE(0,0,0,0,0,1,0,"02",0);  //  Arg.1,2,3,4,5,6,7 : if 1 -> stored. (Res-SqRes-CondV-MeanFor-VarFor-StdRes-FirstDer)
									   //  Arg.8 : Suffix. The name of the saved series will be "Res_ARG6" (or "MeanFor_ARG6", ...).	
									   //  Arg.9 : if 0, saves as an Excel spreadsheet (.xls). If 1, saves	as a GiveWin dataset (.in7)
	garchobj.My_simulation(0);		   // 0: no Simulation n: size of Simulation for the histogram //51000
	garchobj.option_simulation(50000);   // 0: no simulation n: size of simulation for the smile //50000

	garchobj.RollingWindow(0,2275);	//1 if you want rolling window; window lenght		 //2275
//Rolling window for NM3 not done!!!

	delete garchobj;
}

//cumulative density of errors memorized in m_cd