#include <oxstd.h> 
#include <oxfloat.h>
#import <maximize>
#import <modelbase>
#import <packages/Garch30/MBase2>
#include <oxdraw.h>

const decl FNR_ACCURACY=1.0e-5;
const decl FNR_MAXIT   =   1000;

enum
{
	Y_VAR, X_VAR, Z_VAR, O_VAR, T_VAR  	
};
enum // estimation types
{
    M_HESS, M_CROSSPRODUCT, M_QMLE, M_TESTS 
};
enum // model classes					   
{
	MC_STATS, MC_GARCH
};

class Garch : MBase2			
{
	decl m_iModelClass ;	// Model class
	decl m_vY	;	   		// Dependent variable [cT][1]
	
	decl m_mXM ; 	   		// Regressor in the Mean matrix [cT][m_cX]
	decl m_mXV ; 	   		// Regressor in the Variance matrix [cT][m_cX]
	decl m_vOV ;			// Observed Variance [cT][1]
	decl m_vE ;      		// Residuals [cT][1]
	decl m_vE2 ;     		// Squared residuals [cT][1]
	decl m_vSigma2 ; 		// Conditional variance	[cT][1]
	decl m_cNeg ;			// Number of observation with a negative variance
	decl m_cYsmall ; 		// Used to avoid the "too small m_calpha0" problem during convergence. // NEW
	decl m_dLL ;     		// Log-likelihood [1][1]
	  
	decl m_cT;       		// number of observations 
	decl m_cEst ;
	decl m_cY;       		// number of dependent variables (always 1 here) 
	decl m_cXM;      		// number of regressors in the mean equation (if any)
	decl m_cXV;      		// number of regressors in the variance (if any)
	decl m_cOV ;			// 1 if Observed Variance available, O otherwise 
	decl m_cMean ; 		// 1 if there is a constant in the mean, 0 otherwise 
	decl m_cVar ;			// 1 if there is a constant in the variance, 0 otherwise 
	 
	decl m_cDist ;   		// Distribution (0:Normal, 1: Student-t, 2: GED, 3: Skewed Student-t, 4: NM2, 5: NM3)
	decl m_cV	;      		// Kurtosis Coefficient (Student & GED deg.of freedom) 
	decl m_cA ;			// Skewness Coefficient
	decl m_cSk ;			// 1 if Skewness related parameter to be estimated, 0 otherwise  
	decl m_cKu ;			// 1 if Kurtosis related parameter to be estimated, 0 otherwise 
	
	decl m_cAR;       	// Auto-Regressive order p for ARMA(p,q) specification in the mean 
	decl m_cMA; 			// Moving Average order q for ARMA(p,q) specification in the mean
	decl m_cARFI;			// 1 if ARFIMA(p,d,q), 0 if ARMA(p,q)
	
	decl m_clevel ;  		// Constant in the mean  
	decl m_vbetam ;		// Coefficients of the regressors in the mean equation [m_cXM][1]
	decl m_vAR;			// AR Coefficients [m_cAR][1] 
	decl m_vMA;			// MA Coefficients [m_cMA][1]
	decl m_vAR_MA;        // AR|MA Coefficients [m_cAR+m_cMA][1] 
	decl m_dARFI;			// Value of the FI term in ARIMA(p,d,q) (need m_cARFI = 1).
	  
	decl m_cP ;	   		// Order p for Garch effects in GARCH(p,q) specification in the cond.variance
	decl m_cQ ;	   		// Order q for Arch effects in GARCH(p,q) specification in the cond.variance
	decl m_cD ;	   		// 1 if Fractional Integration wanted, 0 otherwise  
	decl m_cFIMethod ;	// 0 if BBM wanted, 1 if Chung wanted,
	decl m_claglamb ;		// Truncation Order
	decl m_cIGARCH ; 		// 1 if IGARCH(p,q), 0 otherwise 
	decl m_cGJR;			// 1 if GJR(p,q), 0 otherwise
	decl m_cHY;           // 1 if HYGARCH, 0 otherwise 
	decl m_cEgarch;		// 1 if EGARCH(p,q), 0 otherwise 
	decl m_cAparch;		// 1 if APARCH(p,q), 0 otherwise 
	decl m_cFilter;		// 1 : GARCH, 	10 : IGARCH, 	11 : FIGARCH(BBM), 		12: FIGARCH(Chung),
						// 2 : EGARCH, 					21 : FIEGARCH (BBM),  
						// 3 : GJR,
						// 4 : APARCH, 					41 : FIAPARCH (BBM), 	42 : FIAPARCH (Chung).
				 		// 			   					51 : HYGARCH (BBM). 	
						// 112 : NMGJR		113: NMAGARCH
	decl m_c_in_mean;     // 1 to add the var in the mean equation, 2 for the std, 0 otherwize					
	
	decl m_calpha0;		// Constant in the variance
	decl m_vpsyv ;  		// Coefficients of the regressors in the variance equation [m_cXV][2]
	decl m_dD ;	   		// Value (double) of the FI term in FIGARCH(p,d,q) (need m_cD = 1).
	decl m_vbetav ;		// Parameters of the lags of the cond.variance (cond.variance equation) [m_cQ][2]
	decl m_valphav ;		// Parameters of the lags of the residuals (cond.variance equation) [m_cP][2]
	decl m_vleverage; 	// Leverage coefficient(s) (GJR)
	decl m_vtheta1;   	// (FI)EGARCH coefficient
	decl m_vtheta2;   	// (FI)EGARCH coefficient
	decl m_vgamma;		// Gamma coefficient - (FI)APARCH
	decl m_ddelta;		// Delta coefficient - (FI)APARCH
	decl m_vHY;			// HYGARCH coefficient alpha
	decl m_v_in_mean;     // ARCH-in-mean parameter
	  
	decl m_cPar ; 		// Number of parameters tobe estimated ( = m_cMean + m_cXM + m_cARFI + m_cAR + m_cMA + m_cVar + m_cXV + m_cD + m_cP + m_cQ + m_cGJR*m_cQ + 2*m_cEgarch + m_cAparch*(m_cQ+1) + m_cSk + m_cKu)
	decl m_vPar ;	   		// Parameters vector [m_cPar][1]
						// m_vPar = m_clevel | m_vbetam |  m_dARFI | m_vAR | m_vMA | m_calpha0 | m_vgammav | m_dD |  m_vbetav | m_valphav | m_vleverage | m_vtheta1 | m_vtheta2 | m_vpsy | m_ddelta | m_cA | m_cV  
	
	decl m_mBound ;		// Bounds matrice [m_cPar][2]
	decl m_cBound ;		// 1 if bounded parameters used, 0 otherwise
	  
	decl m_cMLE ;			// 1 : MLE, 2 : QMLE, 0 : Both						
	decl m_cRobustLL;		// if 0 -> return the sum of likelihood in FigLL, if 1 -> return the likelihood vector
	decl m_vGrad;			// Gradients 
	decl m_vStdErrors;	// Standard Errors	  [m_cPar][1]
	decl m_vStandErrors;  // Standardized Errors	  [cT][1]
	decl m_vSqStandErrors; // Squared Standardized Errors	  [cT][1]
	decl m_cCovar;        // 1 to print Variance Covariance Matrix, 0 otherwise		   	
	decl m_cd;            // cdf of the standardized residuals 
//	decl m_cdf;           // cdf of the standardized residuals  	
	
	decl m_cTests ; 		// 1 to run tests on raw series (TESTSONLY function in OxEdit)  // NEW 310
	decl m_vTests ; 		// Vector of 0's & 1's forthe Descriptive Statistics in OxPack  // NEW 310
	decl m_cLagPort ;  	// Lag orders for the Box Pierce tests
	decl m_cLagArch ;  	// Lag orders for Engle's LM ARCH test
	decl m_cNyblom ;		// 1 if compute the Nyblom stability Test
	decl m_cGOF;          // 1 to compute the adjusted Pearson Chi-square Goodness-of-fit test, 0 otherwise  
	decl m_cCellGOF ;     // Number of cells for the adjusted Pearson Chi-square Goodness-of-fit test
	decl m_cFOR;			// 1 to launch the forecasting procedure
	decl m_cMethFOR;		// Number for step(s) ahead static forecast(s) 
	decl m_cTforc;		// Number of Forecasts
	decl m_mForc;			// Forecasts Matrix : Mean forecasts ~ Variance forecasts [m_cTforc][2]
	decl m_forYerror;     // Forecast error of Y 	[m_cTforc][1]
	decl m_Yfor;          // Observed Y corresponding to the forecasting period  [m_cTforc][1]
	//  decl m_forHerror;     // Forecast error of the conditional variance   [m_cTforc][1]
	decl m_Hfor;			// Observed Variance corresponding to the forecasting period  [m_cTforc][1]
	decl m_cPrintFor ;	// 1 to Print Forecasts, 0 otherwise
	  
	decl m_cIter ;		    // Number of iterations between printed intermediary results (if equal 0 => no intermediary results).
	decl m_cGraphs ;		// 1: Estimation Graphics, 0 : No Graphs   
	decl m_cForGraphs ;	    // 1: Forecasts Graphics, 0 : No Graphs
	decl m_cSGraphs ;		// 1: Saves Estimation Graphics, 0 : No Graphs   				  
	decl m_cSForGraphs ;	// 1: Saves Forecasts Graphics, 0 : No Graphs					  
	decl m_sNameGraphs ;	// 1: Saved Estimation Graphics file name, 0 : No Graphs      
	decl m_sNameForGraphs ;	// 1: Saved Forecasts Graphics file name, 0 : No Graphs       
	decl m_cStartMet ; 	    // in OxPack, define the way the starting values are entered
	decl m_cPrintTest ;     // 0: no printing ;  1: prints the tests output   
	
	decl m_cFix;          // 1 to fix some parameter values, 0 otherwize
	decl m_vFix;			// vector of 1's and 0's : 1 to estimate and 0 to fix (to the starting value)
	  						// the corresponding parameter (if m_cFix=1)
	decl startingvalues;    // string that locates the file startingvalues.txt

//En irtam
	decl m_myt;	//for computing the D matrix for moment tests
	Figll(const vP, const adFunc, const avScore, const amHessian);
	Gausslik(const vE, const vSigma2) ;
	Studentlik(const vE, const vSigma2, const v) ;
	GEDlik(const vE, const vSigma2, const a) ;
	SkStudentlik(const vE, const vSigma2, const s, const v) ;

	decl m_vSigma2_1 ; 		// Conditional variance1	[cT][1]
	decl m_vSigma2_2 ; 		// Conditional variance2	[cT][1]
	decl m_vSigma2_3 ; 		// Conditional variance3	[cT][1]

	decl m_calpha0_2;		// Constant in the variance
	decl m_vpsyv_2 ;  		// Coefficients of the regressors in the variance equation [m_cXV][2]
	decl m_dD_2 ;	   		// Value (double) of the FI term in FIGARCH(p,d,q) (need m_cD = 1).
	decl m_vbetav_2 ;		// Parameters of the lags of the cond.variance (cond.variance equation) [m_cQ][2]
	decl m_valphav_2 ;		// Parameters of the lags of the residuals (cond.variance equation) [m_cP][2]
	decl m_vleverage_2; 	// Leverage coefficient(s) (GJR)
	decl m_vtheta1_2;   	// (FI)EGARCH coefficient
	decl m_vtheta2_2;   	// (FI)EGARCH coefficient
	decl m_vgamma_2;		// Gamma coefficient - (FI)APARCH
	decl m_ddelta_2;		// Delta coefficient - (FI)APARCH

	decl m_calpha0_3;		// Constant in the variance
	decl m_vpsyv_3 ;  		// Coefficients of the regressors in the variance equation [m_cXV][2]
	decl m_dD_3 ;	   		// Value (double) of the FI term in FIGARCH(p,d,q) (need m_cD = 1).
	decl m_vbetav_3 ;		// Parameters of the lags of the cond.variance (cond.variance equation) [m_cQ][2]
	decl m_valphav_3 ;		// Parameters of the lags of the residuals (cond.variance equation) [m_cP][2]
	decl m_vleverage_3; 	// Leverage coefficient(s) (GJR)
	decl m_vtheta1_3;   	// (FI)EGARCH coefficient
	decl m_vtheta2_3;   	// (FI)EGARCH coefficient
	decl m_vgamma_3;		// Gamma coefficient - (FI)APARCH
	decl m_ddelta_3;		// Delta coefficient - (FI)APARCH
	
	decl m_p1;				// probability parameter1
	decl m_p2;				// probability parameter2
	decl m_p3;				// probability parameter3
	decl m_mu1;				// mu1 parameter
	decl m_mu2;				// mu2 parameter
	decl m_mu3;				// mu2 parameter
	decl m_cNM2 ;			// 1 if NM2 related parameters to be estimated, 0 otherwise 
	decl m_cNM3 ;			// 1 if NM3 related parameters to be estimated, 0 otherwise
	decl m_restr;			// NM2: 0:no restr	1:MU1=MU2=A1-A2=B1-B2=0	 2:MU1=MU2=A2=B2=0	3:MU1=MU2
							//					4:A1-A2=B1-B2=0			 5:A2=B2=0 
							// NM3: 0:no restr	1:MU1=MU2=MU3=A1-A2=B1-B2=A1-A3=B1-B3=0		2:MU1=MU2=MU3=A3=B3=0	3:MU1=MU2=MU3
							//					4:A1-A2=B1-B2=A1-A3=B1-B3=0					5:A3=B3=0 
	decl m_num1der;			// D table for moment test
	decl m_D_transf;		// D table for moment test transformed
	decl m_momtest;			// 1 if moment tests are done
	decl m_vmomtest;		// vector containing moment test results
	decl m_testtot;			// result of cumulative test
	decl m_acf;				// 1 if ACF is computed
	decl m_hist;			// 1 if Histogram is simulated
	decl m_stdres;			// Standardized residuals
	decl m_vol, m_vol1, m_vol2, m_vol3, m_sk, m_kurt;	//long-term moments
	decl m_m;				// for ACF computation

	decl m_cNMGJR;			// 1 if NMGJR(1,1), 0 otherwise
	decl m_cNMAGARCH;		// 1 if NMAGARCH(1,1), 0 otherwise
	decl m_vforc;			// forecasted series
	decl my_data;			// copied Y series, for forecast checking
	decl m_vPar_start;		// starting values saved;
	decl m_vPar_cont;		// saving the last values, continuing with this
	decl m_vPar_forec;		// time aggregation - forecasted parameters1
	
	GetZB1(const x, const n);
	GetZB2(const x, const n);
	GetZB3(const x, const n);
	NM2Lik(const vE, const vSigma2_1, const vSigma2_2, const p, const mu) ;
	NM2lik(const vE, const vSigma2_1, const vSigma2_2, const p, const mu) ;
	NM2Garch_Filter(const e, const level1, const level2, const p, const q, const par1, const par2) ;
	CDFNM2(const ee, const var1, const var2, const p, const mu);
	NM3Lik(const vE, const vSigma2_1, const vSigma2_2, const vSigma2_3, const p1, const p2, const mu1, const m2) ;
	NM3lik(const vE, const vSigma2_1, const vSigma2_2, const vSigma2_3, const p1, const p2, const mu1, const m2) ;
	NM3Garch_Filter(const e, const level1, const level2, const level3, const p, const q, const par1, const par2, const par3) ;
	CDFNM3(const ee, const var1, const var2, const var, const p1, const p2, const mu1, const mu2);
	INVCDFNM2(const prob, const var1, const var2, const p, const mu);
	INVCDFNM3(const prob, const var1, const var2, const var3, const p1, const p2, const mu1, const mu2);
	NMRESTR(const n);	
	FigLL_max(const vP, const adFunc, const avScore, const amHessian);
	Num1Der();
	MYTESTS(const momtest, const acf, const hist);
	MOMTEST();
	GetDtransf();
	Momtest_1(const power, const lag);
	Momtest_tot();
	Compute_momNM(const n, const num);
	Compute_momN();
	ACF();
	My_simulation(const n);
	option_simulation(const n);
	time_aggreg_sim(const n, const m, const k);
	My_inverse(const n);
	
	AGARCH_Filter(const e, const level, const p, const q, const par) ;
	NM2GJR_Filter(const e, const level1, const level2, const p, const q, const par1, const par2) ;
	NM2AGARCH_Filter(const e, const level1, const level2, const p, const q, const par1, const par2) ;
	NM3GJR_Filter(const e, const level1, const level2, const level3, const p, const q, const par1, const par2, const par3) ;
	NM3AGARCH_Filter(const e, const level1, const level2, const level3, const p, const q, const par1, const par2, const par3) ;
	
	RollingWindow(const e, const wl);
	Rolling_estim();
	Forecast_in_line(const e, const c);
	Print_all();

	option_price_call_black_scholes(decl S, decl X, decl r, decl sigma, decl time);
	option_price_implied_volatility_call_black_scholes_newton(decl S, decl X, decl r, decl time, decl option_price);
	option_price_implied_volatility_call_black_scholes_bisections(decl S, decl X, decl r, decl time, decl option_price);
	option_price_call_european_simulated(decl S, decl X, decl r, decl sigma, decl time, decl no_sims);

// Basic functions
	Garch();
	Init_Globals();
	Pause(const sec);
// Input
	Csts(const cstM, const cstV) ;
	CSTS(const cstM, const cstV) ;
	Distri(const dist);
	DISTRI(const dist);
	GetDistri();
	Armaorders(const cAR, const cMA); 
	ARMA_ORDERS(const cAR, const cMA);
	Arfima(const cARFI);					
	ARFIMA(const cARFI);					
	Garchorders(const cP, const cQ) ;
	GARCH_ORDERS(const cP, const cQ) ;
	ARCH_in_mean(const type);
	MODEL(const mod);								  
	TRUNC(const t);								 
	BOUNDS(const method) ;
	MLE(const method);
	BOXPIERCE(const lags);
	ARCHLAGS(const lags);
	NYBLOM(const i);
	PEARSON(const lags);
	FORECAST(const i, const nbforc, const iprint);
	ITER(const i);
	TESTS(const p, const a);		  	 	
	COVAR(const p);					  	 
	GRAPHS(const d, const s, const file);				 
	FOREGRAPHS(const d, const s, const file);			 
	STORE(const res, const res2, const condv, const mfor, const vfor, const stdres, const d, const name, const file) ;
	PAR(); 									 
	SAVEPAR(const i, const file); 		  
	InitStartValues(const init_par, const init_bounds);
	FixBounds(const m) ;
	InitData();
	FixParam(const cfix, const fix);
	FixedParam(const fix);
	SetStartValue(const name, const stval);
    PrintStartValues(const p);
    MatrixToString(const name_matrix, const val, const format);	
    CheckValue(const name, const stval);
// Data Handling
	GetYNames();
	GetXNames();
	GetZNames();
	GetINames();
	GetParNames();
	GetValue(const name) ;
	GetXBetaForc(const cTforc); 
	GetZBetaForc(const cTforc);
	GetForcData(const iGroup, const cTforc);   
	GetRes(const y, const x);
	GetXB(const x, const n); 
	GetZB(const x, const n);
	GetSeries();
	GetForErrors(const varobs);
	virtual GetcT();
	GetNbPar();
	GetPara() ;
	SplitPara(vP) ;
	CheckPara();
	MLEMeth(const par, const parnames, const name, const nbpar);   // GARCH 313
	FigLL(const vP, const adFunc, const avScore, const amHessian);
	FigLL2(const avF, const vP);
	Res_Var();
// Filters
	shape(const z,const m,const r);
	Garch_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_garch, const in_mean_type, const in_mean);
	GJR_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_gjr, const in_mean_type, const in_mean);
	APARCH_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_APARCH, const in_mean_type, const in_mean);
	EGARCH_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_EGARCH, const Cst, const in_mean_type, const in_mean);
	FIGARCH_BBM_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_figarch, const laglamb, const in_mean_type, const in_mean);
	FIAPARCH_BBM_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_fiaparch, const laglamb, const in_mean_type, const in_mean);
	FIGARCH_Chung_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_figarch, const in_mean_type, const in_mean);
	FIAPARCH_Chung_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_fiaparch, const in_mean_type, const in_mean);
	FIEGARCH_in_mean(const y, const Xb_mean, const ARMA_orders, const ARMA_coef, const ARFIMA, const d_arfima, const Xb_var, const p, const q, const par_FIEGARCH, const laglamb, const Cst, const in_mean_type, const in_mean);
	Garch_Filter(const e, const level, const p, const q, const par) ;
	GJR_Filter(const e, const level, const p, const q, const par) ;
	AParch(const e, const level, const p, const q, const par);
	Figarch_BBM(const y, const level, const p, const q, const laglamb, const par) ;
	Figarch_Chung(const e, const sm, const p, const q, const par);
	Figarch_Chung2(const e, const sm, const p, const q);
	EGarch(const e, const level, const p, const q, const par, const Cst);
	FIEGarch(const e, const level, const p, const q, const par, const laglamb, const Cst) ;
// Forecasting procedures  		 
	FORECASTING(); 
	FOR_ARMA(const y_l, const p, const q, const arma, const level_forc, const e);
	FOR_ARFIMA(const y_l, const p, const q, const d, const arma, const level_forc, const e);
	FOR_GARCH(const esqr, const hh, const p, const q, const alpha, const beta, const level_forc);
	FOR_GJR(const e, const hh, const p, const q, const alpha, const beta, const leverage, const level_forc, const prob_neg); 
	FOR_APARCH(const ee, const hh, const p, const q, const alpha, const beta, const gamma, const delta, const level_forc, const Ki);
	FOR_EGARCH(const e, const hh, const p, const q, const alpha, const beta, const theta1, const theta2, const level, const Cst);
	FOR_FIEGARCH(const e, const hh, const p, const q, const d, const alpha, const beta, const theta1, const theta2, const level, const Cst, const laglamb);
	FOR_FIGARCH_BBM(const esqr, const hh, const p, const q, const d, const alpha, const beta, const HY, const level_forc, const laglamb); 
	FOR_FIGARCH_Chung(const esqr, const hh, const p, const q, const d, const alpha, const beta, const level);
	FOR_FIAPARCH_BBM(const e, const hh, const p, const q, const d, const alpha, const beta, const gamma, const delta, const level_forc, const laglamb, const Ki);	
	FOR_FIAPARCH_Chung(const e, const hh, const p, const q, const d, const alpha, const beta, const gamma, const delta, const level_forc, const Ki);	
	FOR_GRAPHS(const plot, const pre, const type, const valcrit);			
// Density Related Functions
	GaussLik(const vE, const vSigma2) ;
	StudentLik(const vE, const vSigma2, const v) ;
	GEDLik(const vE, const vSigma2, const a) ;
	SkStudentLik(const vE, const vSigma2, const s, const v) ;
	KiAparch(const dist, const q, const par, const delta, const gamma);
	E_abseps(const dist, const par);
	CD(const e, const var, const dist, const par);
	CDFGED(const ee,const nu);  
	INVCDFGED(const p,const nu); 
	CDFTA(const ee,const logxi,const nu);
	mom_trst(const mu, const k);
	INVCDFTA(const p,const logxi,const nu);
// Tests
	Tests();
	Normality(const e);
	ICriterion(const LogL, const n, const q);
	SBT(const res, const cvar);
	BoxPQ(const eh,const ncor,const adj);
	Nyblom(const eh, const grad);
	APGT(const cd, const ng, const np);
	AUTO(const z, const ncor, const min, const max, const plot); 
	absha(const z,const u,const o);  
	confidence_limits_uniform (const z_series,const number_of_bins,const conf_interval, const draw, const plot);  
	FEM(const forc, const obs);									
	MZ(const HFor, const MatFor, const nbFor);							  
// Output
    Initialization(const vStart) ;
    Estimate();
	virtual cfunc_gt0(const avF, const vP); //NEW
    DoEstimation();
	Output();
	virtual Covar();
	Stationarity(const filter) ;  										
	Positivity(const filter) ;											
	TestGraphicAnalysis(const ser, const res, const sqres, const h, const plot);
	QuantileGraphs(const meth, const quantile, const iplot);
	VaR_test(const Y, const emp_quan_pos, const emp_quan_neg, const th_quan);
// OxPack
	Dialogs();
	SendVarStatus();
	SendSpecials();
	ReceiveData();
	ReceiveModel();
	SendDialog(const sDialog);
	SendMethods();
	SendMenu(const sMenu);
	ReceiveDialog(const sDialog, const asOptions, const aValues);
}; 