% select maximum common sample of reduced form residuals and external
% instrument for identification
% if 'wildbootind' is provided, perform wild bootstrap
function [rsh_sel_ind, inst_sel] = selextinstsample(X,dates,rsh,extinst,wildbootind)

inst_dates = extinst.dates;
inst_data = extinst.data;

p = size(X,1)-size(rsh,1);
rsh_dates = dates(1+p:end);

rsh_sel_ind = ismember(rsh_dates,inst_dates);
if nargin==4    
    inst_sel = inst_data(ismember(inst_dates,rsh_dates),:);
else
    wildbootind_sel = wildbootind(ismember(rsh_dates,inst_dates),:);    
    inst_sel = inst_data(ismember(inst_dates,rsh_dates),:).*wildbootind_sel; 
end
end