% Replication Files for
% "The Response of Asset Prices to Monetary Policy Shocks: Stronger Than Thought" 
% by Lucia Alessi and Mark Kerssenfischer
% Journal of Applied Econometrics, forthcoming
% 
% Mark Kerssenfischer, February 2019

clear

%% specify options
opts.h = 24;                % length of impulse-response functions
opts.xlabel = 6:6:24;       % x-axis labels
opts.nboot = 2000;          % bootstrap repitions

% benchmark specification
opts.dfm.phat = 6;          % lag length for DFM (and VAR)
opts.dfm.rhat = 8;          % number of static factors in DFM
opts.dfm.qhat = 8;          % number of dynamic factors in DFM

% alternative DFM specifications (robustness checks)
opts.rob_p = [3 4 9];		% lag length
opts.rob_r = [7 9:10];		% number of static factors
opts.rob_q = [5 6 7];		% number of dynamic factors

%% run estimation and produce figures
RUN_MAIN_EA
RUN_MAIN_US
