%% plot corporate yields
figure;
plotinds = [1:2:2*length(opts.fig1vars); 2:2:2*length(opts.fig1vars)]; clearvars ax
for i=1:length(opts.fig1vars)
    ax(1) = subplot(length(opts.fig1vars),2,plotinds(1,i));
    plotarea(squeeze(IRF_var(opts.fig1vars(i),:,:)),opts.xlabel); grid on;    
    ylabel(X.labels(opts.fig1vars(i)),'Units','normalized','position',[-.2 0.5 0],'interpreter','none');
    ax(2) = subplot(length(opts.fig1vars),2,plotinds(2,i));
    plotarea(squeeze(IRF_dfm(opts.fig1vars(i),:,:)),opts.xlabel); grid on;    
    linkaxes(ax)
    if i==1
        title(ax(1),'VAR','Units','normalized','position',[0.5 1.1 0]);
        title(ax(2),'DFM','Units','normalized','position',[0.5 1.1 0]);
    end
end

%% plot FX rates
figure;
plotinds = [1:2:2*length(opts.fig2vars); 2:2:2*length(opts.fig2vars)]; clearvars ax
for i=1:length(opts.fig2vars)
    ax(1) = subplot(length(opts.fig2vars),2,plotinds(1,i));
    plotarea(squeeze(IRF_var(opts.fig2vars(i),:,:)),opts.xlabel); grid on;    
    ylabel(X.labels(opts.fig2vars(i)),'Units','normalized','position',[-.2 0.5 0],'interpreter','none');
    ax(2) = subplot(length(opts.fig2vars),2,plotinds(2,i));
    plotarea(squeeze(IRF_dfm(opts.fig2vars(i),:,:)),opts.xlabel); grid on;    
    linkaxes(ax)
    if i==1
        title(ax(1),'VAR','Units','normalized','position',[0.5 1.1 0]);
        title(ax(2),'DFM','Units','normalized','position',[0.5 1.1 0]);
    end
end

%% plot stocks and house prices
figure;
plotinds = [1:2:2*length(opts.fig3vars); 2:2:2*length(opts.fig3vars)]; clearvars ax
for i=1:length(opts.fig3vars)
    ax(1) = subplot(length(opts.fig3vars),2,plotinds(1,i));
    plotarea(squeeze(IRF_var(opts.fig3vars(i),:,:)),opts.xlabel); grid on;    
    ylabel(X.labels(opts.fig3vars(i)),'Units','normalized','position',[-.2 0.5 0],'interpreter','none');
    ax(2) = subplot(length(opts.fig3vars),2,plotinds(2,i));
    plotarea(squeeze(IRF_dfm(opts.fig3vars(i),:,:)),opts.xlabel); grid on;    
    linkaxes(ax)
    if i==1
        title(ax(1),'VAR','Units','normalized','position',[0.5 1.1 0]);
        title(ax(2),'DFM','Units','normalized','position',[0.5 1.1 0]);
    end
end

%% plot core variables
yields_inds = getind(X.names(opts.var.varlist),X.names(opts.fig1vars));
fx_inds = getind(X.names(opts.var.varlist),X.names(opts.fig2vars));
oth_inds = getind(X.names(opts.var.varlist),X.names(opts.fig3vars));
figure;
plotinds = [1:2:2*length(opts.var.corevars); 2:2:2*length(opts.var.corevars)]; clearvars ax
for i=1:length(opts.var.corevars)
    ax(1) = subplot(length(opts.var.corevars),2,plotinds(1,i));
    plot(squeeze(IRF_var_core(i,:,yields_inds)),'k'); axis tight; grid on; hold on;
    plot(squeeze(IRF_var_core(i,:,fx_inds)),'b--');
    plot(squeeze(IRF_var_core(i,:,oth_inds)),'r-.');    
    plot(zeros(opts.h+1,1),'k','linewidth',0.5) 
    xticks(opts.xlabel+1)
    xticklabels(cellstr(num2str(opts.xlabel')))
    ylabel(X.labels(opts.var.corevars(i)),'Units','normalized','position',[-.2 0.5 0],'interpreter','none');
    ax(2) = subplot(length(opts.var.corevars),2,plotinds(2,i));
    plotarea(squeeze(IRF_dfm(opts.var.corevars(i),:,:)),opts.xlabel); grid on;    
    linkaxes(ax)
    if i==1
        title(ax(1),'VAR','Units','normalized','position',[0.5 1.1 0]);
        title(ax(2),'DFM','Units','normalized','position',[0.5 1.1 0]);
    end
end