%% Estimate 4-variable VARs for each asset price under study

N = size(X.data,2);
%% pre-allocate IRFs and shocks
IRF_var = NaN(N,opts.h+1,5);
IRF_var_core = NaN(length(opts.var.corevars),opts.h+1,length(opts.var.varlist));
u_var = NaN(size(X.data,1)-opts.dfm.phat,length(opts.var.corevars)+1,length(opts.var.varlist));
BB_var = NaN(N,length(opts.var.corevars)+1,opts.h+1,length(opts.var.varlist));


for i=1:length(opts.var.varlist)
varselind = [opts.var.corevars opts.var.varlist(i)];

%% reduced-form estimation
[BB_var(varselind,:,:,i), u_var(:,:,i)] = VARest(X.data(:,varselind), opts);
[BB_var_b, u_var_b, rr_var_b] = VARest_boot(X.data(:,varselind), opts);

%% external instrument identification
[u_var_sel, inst_var_sel] = selextinstsample(X.data,X.dates,u_var(:,:,i),hfinst);
IRFpoint = IdentExtInstr(BB_var(:,:,:,i), X.tcode, X.names, opts, u_var(u_var_sel,:,i), inst_var_sel);
IRF_var(opts.var.varlist(i),:,3) = IRFpoint(opts.var.varlist(i),:);
IRF_var_core(:,:,i) = IRFpoint(opts.var.corevars,:);

% Bootstrap
IRFvar_b = NaN(N,opts.h+1,opts.nboot);
for ii=1:opts.nboot
    [u_var_sel_b, inst_var_sel_b] = selextinstsample(X.data,X.dates,u_var_b(:,:,ii),hfinst,rr_var_b(:,ii));                    
    IRFvar_b(varselind,:,ii) = IdentExtInstr(BB_var_b(:,:,:,ii), X.tcode(varselind), X.names(varselind), opts, u_var_b(u_var_sel_b,:,ii), inst_var_sel_b);      
end
IRF_var(opts.var.varlist(i),:,1) = prctile(IRFvar_b(opts.var.varlist(i),:,:),5,3);
IRF_var(opts.var.varlist(i),:,2) = prctile(IRFvar_b(opts.var.varlist(i),:,:),10,3);
IRF_var(opts.var.varlist(i),:,4) = prctile(IRFvar_b(opts.var.varlist(i),:,:),90,3);
IRF_var(opts.var.varlist(i),:,5) = prctile(IRFvar_b(opts.var.varlist(i),:,:),95,3);

end
