function [B_b, rsh, rr]  = DFMest_BLL_Boot(Y, opts)

q = opts.dfm.qhat;
r = opts.dfm.rhat;
p = opts.dfm.phat;
h = opts.h;
[T, N] = size(Y);
                                                             
y=Y(2:end,:)-Y(1:end-1,:);                                                   % 1st Differences                                         
sy = std(y);                                                                 % Standardize
yy = (y-repmat(mean(y),size(y,1),1))./repmat(sy,size(y,1),1);
regX = [ones(size(Y,1),1) (1:size(Y,1))'];                                   % Detrend Data
beta = regX\Y;
X = Y-regX*beta;
Z=X./repmat(sy,size(X,1),1);                                                 % BLL - Standardization 

opt.disp = 0;
[W, ~] = eigs(cov(yy), r,'LM',opt);
lambda= W;
F=Z*lambda;                                                                  % static factors
                           
chi = F*W';                                                                  % common components (detrended)
Chi = (chi.*repmat(sy,size(chi,1),1))+regX*beta;                             % common components (incl. trend)
Idio = Y-Chi;

%%
RHS = NaN(T-p,r*p);
for i = 1:p
    RHS(:,1+(i-1)*r:i*r) = F(p+1-i:end-i,:);
end

LHS = F(p+1:end,:);
bet = [RHS ones(length(RHS),1)]\LHS; 
u = LHS-[RHS ones(length(RHS),1)]*bet;


%% perform wild bootstrap as in Gertler and Karadi (2015): Monetary Policy Surprises, Credit Costs, and Economic Activity
% see https://www.aeaweb.org/aej/mac/data/0701/2013-0329_data.zip

% Kilian bias correction
SIGMA = zeros(p*q);    
SIGMA(1:q,1:q) = u'*u/(T-p-p*q-1);	
coeffcompanion = [bet(1:p*r,:)'; eye((p-1)*r), zeros((p-1)*r,r)];

biascorr=kiliancorr(coeffcompanion,SIGMA,T,q,p);

betbiasc = [biascorr(1:q,:)'; bet(end,:)]; 
%%

rr = NaN(T-p,opts.nboot);
B_b = NaN(N,q,h+1,opts.nboot);
rsh = NaN(T-p,q,opts.nboot);

for j=1:opts.nboot
             
    rr(:,j) = 1-2*(rand(T-p,1)>0.5);    % store wild bootstrap draw
    resb = (u.*(rr(:,j)*ones(1,r)));      
         
    F_boot = zeros(p+size(LHS,1),size(LHS,2));
    F_boot(1:p,:)=F(1:p,:);
    for jj=p+1:p+size(LHS,1)
        lvars = (F_boot(jj-1:-1:jj-p,:))';
        F_boot(jj,:) = lvars(:)'*betbiasc(1:p*size(LHS,2),:)+betbiasc(p*size(LHS,2)+1:end,:)+resb(jj-p,:); 
    end
    Chi_boot = (F_boot*(lambda)')*diag(sy);      % common component  
       
    X_boot = Chi_boot + Idio;

[B_b(:,:,:,j), rsh(:,:,j)] = DFMest_BLL(X_boot,opts);
end