function Draw_Adj(Mat, lag, labels)

[ny, nx] = size(Mat);

if nargin == 2 && lag == 0;    
    y_labels = cell(1,nx);       
    ct=0;
    for i=1:nx;
        ct = ct + 1;
        y_labels{1,ct} = ['X',num2str(i),',t'];
    end
    x_labels = y_labels;
    
elseif nargin == 2 && lag ~= 0;   
    nl = nx/lag;
    y_labels = cell(1,nx); 
    x_labels = cell(1,ny);
    ct=0;
    for p = 1:lag
        for i = 1:nl;
            ct = ct + 1;
            y_labels{1,ct} = ['X',num2str(i),',t-',num2str(p)];
        end
    end
    ct=0;
    for i = 1:ny;
        ct = ct + 1;
        x_labels{1,ct} = ['X',num2str(i),',t'];
    end
elseif nargin == 3 && lag == 0;
    y_labels = cell(1,nx);
    ct = 0;
    for i = 1:length(labels);
        ct = ct + 1;
        y_labels{1,ct} = [labels{i,1},',t'];
    end
    x_labels = y_labels;
else
    y_labels = cell(1,length(labels)*lag);
    ct = 0;
    for p = 1:lag;
        for i = 1:length(labels);
            ct = ct + 1;
            y_labels{1,ct} = [labels{i,1},',t-',num2str(p)];
        end
    end
    x_labels = cell(1,length(labels));
    ct = 0;
    for i = 1:length(labels);
        ct = ct + 1;
        x_labels{1,ct} = [labels{i,1},',t'];
    end
end

if nx < 20
    figure
    set(gca,'Position',[0.1, .2, 0.7, 0.5]);
    heatmap(Mat, y_labels, x_labels, '%0.2f', 'TickAngle', 60, ...
        'ShowAllTicks', true, 'TickFontSize', 12, 'FontSize', 7,...
        'Colormap', 'money', 'ColorLevels', 3, 'GridLines', ':');
else
    figure
    set(gca,'Position',[0.1, .2, 0.7, 0.5]);
    heatmap(Mat, y_labels, x_labels, '%0.2f', 'TickAngle', 60, ...
        'ShowAllTicks', true, 'TickFontSize', 12, 'FontSize', 6,...
        'Colormap', 'money', 'ColorLevels', 3, 'GridLines', ':');
end