% This code implements the Macroeconomic Application in Section 5 in
% Ahelegbey D. F., Billio, M., Casarin, R. (2014). 
% "Bayesian Graphical Models for Structural Vector Autoregressive 
% Processes",  Journal of Applied Econometrics, forthcoming
%========================================================================

close all; clc; clear;

% Add path of functions, data and figures
addpath('functions');    addpath('data');    addpath('figures');

%-----------------------------LOAD DATA-----------------------------------
% Load quarterly macro data (1959Q1 - 2008Q4)
DATA = importdata('Macro_Data_1.txt');      % Used in Section 5
% DATA = importdata('Macro_Data_2.txt');    % For Robustness Check

%-------------------------LOAD VARIABLES----------------------------------
% Load List of variables
filename = 'Macro_Variables_1.txt';         % Used in Section 5
% filename = 'Macro_Variables_2.txt';       % For Robustness Check

fileID = fopen(filename,'r');
Vars = textscan(fileID, '%s%s%f%s', 'Delimiter', '\t', 'HeaderLines' ,1);
fclose(fileID);
ShortID = Vars{1};       % Short ID of variables
Tcode = Vars{:, 3};         % Transformation code
clear filename fileID ans

% Transformation of data to stationarity
Data = transform(DATA.data, Tcode);

%----------------------------PRELIMINARIES--------------------------------
ny = 7;        % number of response variables 
               % ny = 8, for Macro_Data_2 (Robustness Check)
               
nsimu  = 2e4;       % number of Simulation
sdz = 1;            % 1. Standardize dataset  0. Demean dataset
min_lag = 1;        % minimum lag order
max_lag = 4;        % maximum lag order

% Estimate lag based on BIC
lag = Estimate_BIC(Data, min_lag, max_lag, ny);

%-------------------SAMPLING MIN & MAR STRUCTURE -------------------------
MAR = SAMPLE_BGMAR_DAG(Data, nsimu, sdz, lag, ny);
MIN = SAMPLE_BGMIN_DAG(Data, nsimu, sdz, ny);

%-------------------DRAW MIN & MAR STRUCTURE -----------------------------
Draw_Adj(MAR.DAG, lag, ShortID)
Draw_Adj(MIN.DAG, 0, ShortID(1:ny))

%-------------------SAVE RESULTS ----------------------------------------
a = clock;
fname = sprintf('MACRO_%d_%d_%d_%d_%d_%d', ny, lag, a(2),a(3),a(4),a(5));
save(['results/' fname '.mat']);  