% This code implements the Financial Application in Section 6 in
% Ahelegbey D. F., Billio, M., Casarin, R. (2014). 
% "Bayesian Graphical Models for Structural Vector Autoregressive 
% Processes",  Journal of Applied Econometrics, forthcoming
%========================================================================

close all; clc; clear;

% Add path of functions, data and figures
addpath('functions');    addpath('data');    addpath('figures');

%-----------------------------LOAD DATA-----------------------------------
% Load monthly data of Supersectors, Euro-Stoxx600 (1/31/2001 - 8/30/2013)
DATA = importdata('Stoxx600_Data.txt');      

%-------------------------LOAD VARIABLES----------------------------------
% Load List of variables
filename = 'Stoxx_Variables.txt';         
fileID = fopen(filename,'r');
Vars = textscan(fileID, '%s%s%s', 'Delimiter', '\t');
fclose(fileID);
ShortID = Vars{1};       % Short ID of variables
clear filename fileID ans

Data = DATA.data;          
%----------------------------PRELIMINARIES--------------------------------
nsimu  = 4e4;       % number of Simulation
sdz = 1;            % 1. Standardize dataset  0. Demean dataset
lag = 1;            % lag order

%-------------------SAMPLING MAR STRUCTURE -------------------------------
MAR = SAMPLE_BGMAR_DAG(Data, nsimu, sdz, lag);

%-------------------DRAW MIN & MAR STRUCTURE -----------------------------
Draw_Adj(MAR.DAG, lag, ShortID);

%-------------------SAVE RESULTS ----------------------------------------
a = clock;
fname = sprintf('Finance_%d_%d_%d_%d', a(2),a(3),a(4),a(5));
save(['results/' fname '.mat']);  