% This code implements the Simulation Experiment in 
% Ahelegbey D. F., Billio, M., Casarin, R. (2014). 
% "Bayesian Graphical Models for Structural Vector Autoregressive 
% Processes",  Journal of Applied Econometrics, forthcoming
%========================================================================

close all; clc; clear;

% Add path of functions, data and figures
addpath('functions');    addpath('data');    addpath('figures');

%-----------------------------LOAD DATA-----------------------------------
% Generate Simulated data
N = 5;              % number of variables (multiple of 5 e.g 5, 10, 15)
T = 100;            % number of observations
lag = 1;            % lag order
[Data, B_p, B_0] = SIMVAR(N, T, lag);

%----------------------------PRELIMINARIES--------------------------------
nsimu  = 2e4;       % number of Simulation
sdz = 0;            % 1. Standardize dataset  0. Demean dataset

%-------------------SAMPLING MIN & MAR STRUCTURE -------------------------
MAR = SAMPLE_BGMAR_DAG(Data, nsimu, sdz, lag);
MIN = SAMPLE_BGMIN_DAG(Data, nsimu, sdz);

%-------------------DRAW MIN & MAR STRUCTURE -----------------------------
Draw_Adj(MAR.DAG, lag)
Draw_Adj(MIN.DAG, 0)

%-------------------SAVE RESULTS ----------------------------------------
a = clock;
fname = sprintf('Sim_%d_%d_%d_%d_%d_%d', N, lag, a(2),a(3),a(4),a(5));
save(['results/' fname '.mat']);  