clear all
randn('state',0)

% DGP
info.inference=0;info.trunc='both';S=250;B=250;
NN=1000000;
for nn=1:3
    N=500*nn;
    name=['mc_t3dgp7','N=' num2str(N)];
    rt=[1;0.15;0.2;0.25];
    w=randn(NN,1);e=randn(NN,1)*0.1;rs=0.3;re=randn(NN,1)*0.1+0.5;
    y=rs.*w+re+e;
    y(y<0)=0;
    y(y>1)=1;   

    beta_true=[0.3;0.5];sigsq_true=[0;0.02];
    str_beta=[];str_sigsq=[];
    for i=1:length(beta_true)
        str_beta=[str_beta;' & '];
    end
    for i=1:length(sigsq_true)
        str_sigsq=[str_sigsq;' & '];
    end

    D0=zeros(NN,1);
    D1=zeros(NN,1);
    xb=[w ones(NN,1)]*beta_true;sig=sqrt(sigsq_true(1)*w.^2+sigsq_true(2));


    xbl=(0-xb)./sig; 
    cdfl=normcdf(xbl);pdfl=normpdf(xbl);
    dLL1(:,1)=pdfl./cdfl./(-sig).*w;
    dLL1(:,2)=pdfl./cdfl./(-sig);
    dLL1(:,3)=pdfl./cdfl.*(-1/2*xbl./sig.^2).*w.^2;
    dLL1(:,4)=pdfl./cdfl.*(-1/2*xbl./sig.^2);
    D0(y==0)=1;

    xbr=-(1-xb)./sig;
    cdfr=normcdf(xbr);pdfr=normpdf(xbr);
    dLL2(:,1)=pdfr./cdfr./(sig).*w;
    dLL2(:,2)=pdfr./cdfr./(sig);
    dLL2(:,3)=pdfr./cdfr.*(-1/2*xbr./sig.^2).*w.^2;
    dLL2(:,4)=pdfr./cdfr.*(-1/2*xbr./sig.^2);
    D1(y==1)=1;

    dLL3(:,1)=(y-xb)./(sig.^2).*w;  
    dLL3(:,2)=(y-xb)./(sig.^2)*1;  
    dLL3(:,3)=(y-xb).^2./(2*sig.^4).*w.^2-.5*w.^2./sig.^2;  
    dLL3(:,4)=(y-xb).^2./(2*sig.^4)-.5./sig.^2;  

    dLL=D0*ones(1,4).*dLL1+D1*ones(1,4).*dLL2+(1-D0-D1)*ones(1,4).*dLL3;
    dLL=-dLL;

    for i=1:4
        for j=1:4
            H(i,j)=mean(dLL(:,i).*dLL(:,j));
        end
    end

    invH=inv(H);
    G=mvnrnd(zeros(1,size(H,1)),H,NN);
    invFG=G*invH;

    lambda_beta=invFG(:,3).*(invFG(:,3)>0);
    Fdelta=[H(1:2,1:2) H(1:2,4);H(4,1:2) H(4,4)];
    Fdeltabeta=H([1,2,4],3);
    Gdelta=G(:,[1,2,4]);

    lambda_delta=Gdelta*inv(Fdelta)-lambda_beta*(inv(Fdelta)*Fdeltabeta)';
    betastd=std(lambda_delta(:,1:2))/sqrt(N);
    sigsqstd(1)=std(lambda_beta)/sqrt(N);
    sigsqstd(2)=std(lambda_delta(:,3))/sqrt(N);


    q5beta=quantile(lambda_delta(:,1:2),0.05)/sqrt(N);
    q5sigsq(1)=quantile(lambda_beta,0.05)/sqrt(N);
    q5sigsq(2)=quantile(lambda_delta(:,3),0.05)/sqrt(N);
    q95beta=quantile(lambda_delta(:,1:2),0.95)/sqrt(N);
    q95sigsq(1)=quantile(lambda_beta,0.95)/sqrt(N);
    q95sigsq(2)=quantile(lambda_delta(:,3),0.95)/sqrt(N);
    
    xbl=[];cdfl=[];xbr=[];cdfr=[];pdfl=[];pdfr=[];xb=[];dLL=[];dLL1=[];dLL2=[];dLL3=[];D0=[];D1=[];
    H=[];invH=[];G=[];invFG=[];lambda_beta=[];Fdelta=[];Fdeltabeta=[];Gdelta=[];lambda_delta=[];

    w=randn(N,1);cons=ones(N,1);
    x=[];z=[w cons];s_bar=cons;
    d=size(x,2);q=size(z,2);p=size(s_bar,2);
    info.b=ones(d+p*q,1)*0.2;
    infobs=info;
    for s=1:S 
        [nn s]
        w=[];c=[];y=[];
        w=randn(N,1);e=randn(N,1)*0.1;rs=0.3;re=randn(N,1)*0.1+0.5;cons=ones(N,1);
        y=rs.*w+re+e;
        y(y<0)=0;
        y(y>1)=1;
        % MLE estimates, rs
        x=[];z=[w cons];s_bar=cons;
        r=gentobit(y,x,info,z,s_bar);
        beta_rs_s(:,s)=r.beta;sigsq_rs_s(:,s)=r.sigsq;
        % bootstrap standard errors
        data=[y w];
        for m=1:length(rt)
            eval(['rt' num2str(m) '=rt(m);'])
            BN=round(eval(['rt' num2str(m)])*N);
            for b=1:B
                rd_idx=round(0.5+N*rand(BN,1));id_bs=[];
                data_bs=data(rd_idx,:);
                y_bs=data_bs(:,1);cons=ones(length(y_bs),1);
                w_bs=data_bs(:,2:size(data,2));
                % rs
                x_bs=[];z_bs=[w_bs cons];s_bar_bs=cons;
                r=gentobit(y_bs,x_bs,infobs,z_bs,s_bar_bs);
                beta_rs_bs(:,b)=r.beta;
                sigsq_rs_bs(:,b)=r.sigsq;
            end          
            eval(['beta_rs_bs' num2str(m) '=beta_rs_bs;'])
            eval(['sigsq_rs_bs' num2str(m) '=sigsq_rs_bs;'])
            eval(['betastd_rs_bs' num2str(m) '(:,s)=sqrt(rt' num2str(m) ')*std(beta_rs_bs' num2str(m) ',0,2);'])
            eval(['sigsqstd_rs_bs' num2str(m) '(:,s)=sqrt(rt' num2str(m) ')*std(sigsq_rs_bs' num2str(m) ',0,2);'])
            eval(['betaq5_rs_bs' num2str(m) '(:,s)=sqrt(rt' num2str(m) ')*transpose(quantile(transpose(beta_rs_bs' num2str(m) '-beta_rs_s(:,s)*ones(1,B)),0.05));'])
            eval(['sigsqq5_rs_bs' num2str(m) '(:,s)=sqrt(rt' num2str(m) ')*transpose(quantile(transpose(sigsq_rs_bs' num2str(m) '-sigsq_rs_s(:,s)*ones(1,B)),0.05));'])
            eval(['betaq95_rs_bs' num2str(m) '(:,s)=sqrt(rt' num2str(m) ')*transpose(quantile(transpose(beta_rs_bs' num2str(m) '-beta_rs_s(:,s)*ones(1,B)),0.95));'])
            eval(['sigsqq95_rs_bs' num2str(m) '(:,s)=sqrt(rt' num2str(m) ')*transpose(quantile(transpose(sigsq_rs_bs' num2str(m) '-sigsq_rs_s(:,s)*ones(1,B)),0.95));'])
         y_bs=[];w_bs=[];x_bs=[];z_bs=[];s_bar_bs=[];beta_rs_bs=[];sigsq_rs_bs=[];
        end       
        save(name)       
        if round(s/50)==s/50
            [nn s]
            disp('b: true values --  estimated values ') 
            disp([beta_true mean(beta_rs_s,2) median(beta_rs_s,2)])
            disp('sigsq: true values --  estimated values ') 
            disp([sigsq_true mean(sigsq_rs_s,2) median(sigsq_rs_s,2)])
            % mean of all simulation results          
            disp('b 5% 95% estiamtes: true -- sandwich -- bs -- rbs,r=0.15 -- rbs,r=0.2 -- rbs,r=0.25')
            disp([str_beta num2str(q5beta','%0.4f') str_beta num2str(q95beta','%0.4f') str_beta num2str(-1.645*mean(betastd_rs_s,2),'%0.4f') str_beta num2str(1.645*mean(betastd_rs_s,2),'%0.4f') str_beta num2str(mean(betaq5_rs_bs1,2),'%0.4f') str_beta num2str(mean(betaq95_rs_bs1,2),'%0.4f') str_beta num2str(mean(betaq5_rs_bs2,2),'%0.4f') str_beta num2str(mean(betaq95_rs_bs2,2),'%0.4f') str_beta num2str(mean(betaq5_rs_bs3,2),'%0.4f') str_beta num2str(mean(betaq95_rs_bs3,2),'%0.4f') str_beta num2str(mean(betaq5_rs_bs4,2),'%0.4f') str_beta num2str(mean(betaq95_rs_bs4,2),'%0.4f')]) 
            disp('sigsq 5% 95% estiamtes: true -- sandwich -- bs -- rbs,r=0.15 -- rbs,r=0.2 -- rbs,r=0.25')
            disp([str_sigsq num2str(q5sigsq','%0.4f') str_sigsq num2str(q95sigsq','%0.4f') str_sigsq num2str(-1.645*mean(sigsqstd_rs_s,2),'%0.4f') str_sigsq num2str(1.645*mean(sigsqstd_rs_s,2),'%0.4f') str_sigsq num2str(mean(sigsqq5_rs_bs1,2),'%0.4f') str_sigsq num2str(mean(sigsqq95_rs_bs1,2),'%0.4f') str_sigsq num2str(mean(sigsqq5_rs_bs2,2),'%0.4f') str_sigsq num2str(mean(sigsqq95_rs_bs2,2),'%0.4f') str_sigsq num2str(mean(sigsqq5_rs_bs3,2),'%0.4f') str_sigsq num2str(mean(sigsqq95_rs_bs3,2),'%0.4f') str_sigsq num2str(mean(sigsqq5_rs_bs4,2),'%0.4f') str_sigsq num2str(mean(sigsqq95_rs_bs4,2),'%0.4f')]) 
            % median of all simulation results
            disp('b 5% 95% estiamtes: true -- sandwich -- bs -- rbs,r=0.15 -- rbs,r=0.2 -- rbs,r=0.25')
            disp([str_beta num2str(q5beta','%0.4f') str_beta num2str(q95beta','%0.4f') str_beta num2str(-1.645*median(betastd_rs_s,2),'%0.4f') str_beta num2str(1.645*median(betastd_rs_s,2),'%0.4f') str_beta num2str(median(betaq5_rs_bs1,2),'%0.4f') str_beta num2str(median(betaq95_rs_bs1,2),'%0.4f') str_beta num2str(median(betaq5_rs_bs2,2),'%0.4f') str_beta num2str(median(betaq95_rs_bs2,2),'%0.4f') str_beta num2str(median(betaq5_rs_bs3,2),'%0.4f') str_beta num2str(median(betaq95_rs_bs3,2),'%0.4f') str_beta num2str(median(betaq5_rs_bs4,2),'%0.4f') str_beta num2str(median(betaq95_rs_bs4,2),'%0.4f')]) 
            disp('sigsq 5% 95% estiamtes: true -- sandwich -- bs -- rbs,r=0.15 -- rbs,r=0.2 -- rbs,r=0.25')
            disp([str_sigsq num2str(q5sigsq','%0.4f') str_sigsq num2str(q95sigsq','%0.4f') str_sigsq num2str(-1.645*median(sigsqstd_rs_s,2),'%0.4f') str_sigsq num2str(1.645*median(sigsqstd_rs_s,2),'%0.4f') str_sigsq num2str(median(sigsqq5_rs_bs1,2),'%0.4f') str_sigsq num2str(median(sigsqq95_rs_bs1,2),'%0.4f') str_sigsq num2str(median(sigsqq5_rs_bs2,2),'%0.4f') str_sigsq num2str(median(sigsqq95_rs_bs2,2),'%0.4f') str_sigsq num2str(median(sigsqq5_rs_bs3,2),'%0.4f') str_sigsq num2str(median(sigsqq95_rs_bs3,2),'%0.4f') str_sigsq num2str(median(sigsqq5_rs_bs4,2),'%0.4f') str_sigsq num2str(median(sigsqq95_rs_bs4,2),'%0.4f')]) 
        end
    end
    beta_rs_s=[];betastd_rs_s=[];sigsq_rs_s=[];sigsqstd_rs_s=[];
end

            
            
