clear all
randn('state',0)

% DGP
S=1000;info.inference=0;info.trunc='both';
wstd=0.5;rho=0.6;T=4;
mu=zeros(1,T);
sigma=[wstd^2     wstd^2*rho wstd^2*rho wstd^2*rho ;
       wstd^2*rho wstd^2     wstd^2*rho wstd^2*rho ;
       wstd^2*rho wstd^2*rho wstd^2     wstd^2*rho ;
       wstd^2*rho wstd^2*rho wstd^2*rho wstd^2     ];

NN=10000;
NNT=NN*T;
wobs=mvnrnd(mu,sigma,NN).^2;e=randn(NNT,1)*0.1;cons=ones(NNT,1);
cobs=randn(NN,1)*0.1;
for t=1:T
    c((cumsum(ones(NN,1))-1)*T+t,:)=cobs;
end
for t=1:T
    w((cumsum(ones(NN,1))-1)*T+t,1)=wobs(:,t);
    wbar((cumsum(ones(NN,1))-1)*T+t,1)=mean(wobs(:,1:T),2);
end
crs=0.25;cre=0.75*sum(wbar,2)+c+0.25;
y=crs.*w+cre+e;
y(y<0)=0;
y(y>1)=1;    
beta_true=[0.25;0.25;0.75];sigsq_true=0.02;

% calculate true APE
x=w;z=cons;s_bar=[cons wbar];
tflag=3;vflag=[0;1];    
sbar_ind=s_bar(1,:);ind=1;vec=T*ones(NN,1);info.panelvec=vec;
for i=1:length(vec)-1
    ind=ind+vec(i);
    sbar_ind=[sbar_ind;s_bar(ind,:)];
end
r=gentobit_avgpe('ll_gentobit_3',x,[beta_true;sigsq_true],tflag,vflag,z,sbar_ind);   
ape_true=mean(r.pe);
disp(ape_true')

for nn=1:2
N=1000*nn;NT=N*T;
vec=T*ones(N,1);info.panelvec=vec;
name=['mc_t1dgp1',',N=' num2str(N)];

c=[];w=[];wbar=[];dwobs=[];dw=[];
for s=1:S
    wobs=mvnrnd(mu,sigma,N).^2;e=randn(NT,1)*0.1;cons=ones(NT,1);
    cobs=randn(N,1)*0.1;
    for t=1:T
        c((cumsum(ones(N,1))-1)*T+t,:)=cobs;
    end
    for t=1:T
        w((cumsum(ones(N,1))-1)*T+t,1)=wobs(:,t);
        wbar((cumsum(ones(N,1))-1)*T+t,1)=mean(wobs(:,1:T),2);
    end
    for t=1:T-1
        dwobs(:,t)=wobs(:,t+1)-wobs(:,t);
        dw((cumsum(ones(N,1))-1)*(T-1)+t,1)=dwobs(:,t);
    end
    crs=0.25;cre=0.75*sum(wbar,2)+c+0.25;
    y=crs.*w+cre+e;
    y(y<0)=0;
    y(y>1)=1;    

    % OLS estimates
    x=[w cons];
    beta_ols_s(:,s)=x\y;
    ape_ols_s(:,s)=beta_ols_s(:,s);acpe_ols_s(:,s)=beta_ols_s(:,s);
    
    % FE estimates
    dx=[dw ones(N*(T-1),1)];
    for t=1:T-1
        dy((cumsum(ones(N,1))-1)*(T-1)+t,1)=y((cumsum(ones(N,1))-1)*T+t+1)-y((cumsum(ones(N,1))-1)*T+t);
    end
    beta_fe_s(:,s)=dx\dy;
    ape_fe_s(:,s)=beta_fe_s(:,s);acpe_fe_s(:,s)=beta_fe_s(:,s);
    
    % IS estimates
    beta=zeros(2,1);
    for i=1:N
    mi=[];xi=[];
    xi=x((i-1)*T+1:i*T,:);
    yi=y((i-1)*T+1:i*T,:);
    beta=beta+inv(xi'*xi)*xi'*yi/N;
    end
    beta_is_s(:,s)=beta;
    ape_is_s(:,s)=beta_is_s(:,s);
    
    % MLE estimates, pooled
    x=w;z=cons;s_bar=cons;
    d_p=size(x,2);q_p=size(z,2);p_p=size(s_bar,2);
    info.b=ones(d_p+p_p*q_p,1)*0.2;
    r=gentobit(y,x,info,z,s_bar);
    beta_p_s(:,s)=r.beta;sigsq_p_s(:,s)=r.sigsq;
    sbar_ind0=ones(NT,1);
    r=gentobit_avgpe('ll_gentobit_3',x,[beta_p_s(:,s);sigsq_p_s(:,s)],tflag,vflag,z,sbar_ind0);   
    ape_p_s(:,s)=mean(r.pe);
    
    % MLE estimates, cre
    x=w;z=cons;s_bar=[cons wbar];
    d_cre=size(x,2);q_cre=size(z,2);p_cre=size(s_bar,2);
    info.b=ones(d_cre+p_cre*q_cre,1)*0.2;
    r=gentobit(y,x,info,z,s_bar);
    beta_cre_s(:,s)=r.beta;sigsq_cre_s(:,s)=r.sigsq;
    sbar_ind=s_bar(1,:);ind=1;
    for i=1:length(vec)-1
        ind=ind+vec(i);
        sbar_ind=[sbar_ind;s_bar(ind,:)];
    end
    r=gentobit_avgpe('ll_gentobit_3',x,[beta_cre_s(:,s);sigsq_cre_s(:,s)],tflag,vflag,z,sbar_ind);   
    ape_cre_s(:,s)=mean(r.pe);

    % MLE estimates, rs
    x=[];z=[w cons];s_bar=cons;
    d_rs=size(x,2);q_rs=size(z,2);p_rs=size(s_bar,2);
    info.b=ones(d_rs+p_rs*q_rs,1)*0.2;
    r=gentobit(y,x,info,z,s_bar);
    beta_rs_s(:,s)=r.beta;sigsq_rs_s(:,s)=r.sigsq;
    r=gentobit_avgpe('ll_gentobit_3',x,[beta_rs_s(:,s);sigsq_rs_s(:,s)],tflag,vflag,z,sbar_ind0);   
    ape_rs_s(:,s)=mean(r.pe);
        % MLE estimates, crs
    x=[];z=[w cons];s_bar=[cons wbar];
    d_crs=size(x,2);q_crs=size(z,2);p_crs=size(s_bar,2);
    info.b=ones(d_crs+p_crs*q_crs,1)*0.2;
    r=gentobit(y,x,info,z,s_bar);
    beta_crs_s(:,s)=r.beta;sigsq_crs_s(:,s)=r.sigsq;
    r=gentobit_avgpe('ll_gentobit_3',x,[beta_crs_s(:,s);sigsq_crs_s(:,s)],tflag,vflag,z,sbar_ind);   
    ape_crs_s(:,s)=mean(r.pe);
    save(name) 
    if s/100==round(s/100)
        s
        disp('b: ols -- fe -- is -- p -- cre -- rs -- crs')
        for k=1:p_crs
            disp([' &  ' num2str(mean(beta_ols_s(k,:),2),'%0.4f') '  &  ' num2str(mean(beta_fe_s(k,:),2),'%0.4f') ' &  ' num2str(mean(beta_is_s(k,:),2),'%0.4f') '  &  ' num2str(mean(beta_p_s(k,:),2),'%0.4f') '  &  '  num2str(mean(beta_cre_s(k,:),2),'%0.4f') '  &  ' num2str(mean(beta_rs_s(k,:),2),'%0.4f') '  &  ' num2str(mean(beta_crs_s(p_crs*(k-1)+1,:),2),'%0.4f')])
            disp([' & (' num2str(std(beta_ols_s(k,:),0,2),'%0.4f') ') & (' num2str(std(beta_fe_s(k,:),0,2),'%0.4f') ') & (' num2str(std(beta_is_s(k,:),0,2),'%0.4f') ') & (' num2str(std(beta_p_s(k,:),0,2),'%0.4f') ') & (' num2str(std(beta_cre_s(k,:),0,2),'%0.4f') ') & (' num2str(std(beta_rs_s(k,:),0,2),'%0.4f') ') & (' num2str(std(beta_crs_s(p_crs*(k-1)+1,:),0,2),'%0.4f') ')'])
        end
        disp('------------------------------------------------------------')
        for k=1:d_cre
            disp([' &         '  ' &         ' ' &         ' ' &         ' ' &  ' num2str(mean(beta_cre_s(p_crs+k,:),2),'%0.4f') '  &         ' ' &  '  num2str(mean(beta_crs_s(p_crs*j+k+1,:),2),'%0.4f')])
            disp([' &         '  ' &         ' ' &         ' ' &         ' ' & (' num2str(std(beta_cre_s(p_crs+k,:),0,2),'%0.4f') ') &         ' ' & ('  num2str(std(beta_crs_s(p_crs*j+k+1,:),0,2),'%0.4f') ')'])
        end
        for j=1:d_cre
            disp('------------------------------------------------------------')
            for k=1:d_cre
                disp([' &         ' ' &         ' ' &         ' ' &         '  ' &         ' ' &         ' ' &  ' num2str(mean(beta_crs_s(p_crs*j+k,:),2),'%0.4f')])
                disp([' &         ' ' &         ' ' &         ' ' &         '  ' &         ' ' &         ' ' & (' num2str(std(beta_crs_s(p_crs*j+k,:),0,2),'%0.4f') ')'])
            end
        end
        disp('sigsq: ols -- fe -- is -- p -- cre -- rs -- crs')
        for k=1:d_cre
            disp([' &         ' ' &         ' ' &         ' ' &         ' ' &         ' ' &  ' num2str(mean(sigsq_rs_s(k,:),2),'%0.4f') '  &  ' num2str(mean(sigsq_crs_s(k,:),2),'%0.4f')])
            disp([' &         ' ' &         ' ' &         ' ' &         ' ' &         ' ' & (' num2str(std(sigsq_rs_s(k,:),0,2),'%0.4f') ') & (' num2str(std(sigsq_crs_s(k,:),0,2),'%0.4f') ')'])
        end
        disp([' &         ' ' &         ' ' &         ' ' &  ' num2str(mean(sigsq_p_s,2),'%0.4f') '  &  '  num2str(mean(sigsq_cre_s,2),'%0.4f') '  &  ' num2str(mean(sigsq_rs_s(p_crs,:),2),'%0.4f') '  &  ' num2str(mean(sigsq_crs_s(p_crs,:),2),'%0.4f')])
        disp([' &         ' ' &         ' ' &         ' ' & (' num2str(std(sigsq_p_s,0,2),'%0.4f') ') & (' num2str(std(sigsq_cre_s,0,2),'%0.4f') ') & (' num2str(std(sigsq_rs_s(p_crs,:),0,2),'%0.4f') ') & (' num2str(std(sigsq_crs_s(p_crs,:),0,2),'%0.4f') ')'])
        
        % report ape
        disp('ape: true -- ols -- fe -- is -- p -- cre -- rs -- crs')
        for k=1:d_cre
        disp([' &  ' num2str(ape_true(k),'%0.4f') '  &  ' num2str(mean(ape_ols_s(k,:),2),'%0.4f') '  &  ' num2str(mean(ape_fe_s(k,:),2),'%0.4f') '  &  ' num2str(mean(ape_is_s(k,:),2),'%0.4f') '  &  ' num2str(mean(ape_p_s(k,:),2),'%0.4f') '  &  ' num2str(mean(ape_cre_s(k,:),2),'%0.4f') '  &  ' num2str(mean(ape_rs_s(k,:),2),'%0.4f') '  &  ' num2str(mean(ape_crs_s(k,:),2),'%0.4f')])
        disp([' &  ' '        & (' num2str(std(ape_ols_s(k,:),0,2),'%0.4f') ') & (' num2str(std(ape_fe_s(k,:),0,2),'%0.4f') ') & (' num2str(std(ape_is_s(k,:),0,2),'%0.4f') ') & (' num2str(std(ape_p_s(k,:),0,2),'%0.4f') ') & (' num2str(std(ape_cre_s(k,:),0,2),'%0.4f') ') & (' num2str(std(ape_rs_s(k,:),0,2),'%0.4f') ') & (' num2str(std(ape_crs_s(k,:),0,2),'%0.4f') ')' ])
        end
    end
end
beta_ols_s=[];sig_ols_s=[];ape_ols_s=[];
beta_fe_s=[];sig_fe_s=[];ape_fe_s=[];
beta_is_s=[];sig_is_s=[];ape_is_s=[];
beta_p_s=[];sig_p_s=[];ape_p_s=[];
beta_rs_s=[];sig_rs_s=[];ape_rs_s=[];
beta_crs_s=[];sig_crs_s=[];ape_crs_s=[];
end

save(name)