function s = gentobit_avgpe(f1,x,varargin)
% ape code for monte carlo. x could be continuous or dummy. 

eps = 1e-10;
n1 = size(x,2);
z=varargin{4};s_bar=varargin{5};varargin(5)=[];
[obs q]=size(z);
h = eps.^(1/3)*max(min(abs([x z]),[],1),1e-2)';
n2=n1+q;
ee = sparse(1:n2,1:n2,h,n2,n2);
pe = zeros(obs,n2);
varargin2=varargin;
N=size(s_bar,1);
for j=1:N
    % Compute expected response values for continuous x, z varibles        
    xz=kron(z,s_bar(j,:));
    xx=[x xz];
    fx1 = feval(f1,xx,varargin{:});
    for i=1:n1
        if length(unique(x(:,i)))~=2
            % Compute forward step for continuous x variables
            xplus=x+ones(obs,1)*ee(i,1:n1);
            xxplus=[xplus xz];
            pe(:,i) = pe(:,i)+(feval(f1,xxplus,varargin{:})-fx1)/h(i)/N;
            xplus=[];xxplus=[];
        else     
            % Compute expected response values for continuous x
            % varibles
            xx_d=xx;xx_d(:,i)=zeros(obs,1);
            fx1_d = feval(f1,xx_d,varargin{:});
            % Compute forward step for dummy x variables
            xxplus=xx;xxplus(:,i)=ones(obs,1);
            pe(:,i) = pe(:,i)+(feval(f1,xxplus,varargin{:})-fx1_d)/N;
            xx_d=[];fx1_d=[];fx2_d=[];xxplus=[];
        end
    end
    for i=n1+1:n2
        if length(unique(z(:,i-n1)))~=2
            % Compute forward step for continuous z variables
            zplus=z+ones(obs,1)*ee(i,n1+1:n2);
            varargin2{4}=zplus;
            xzplus=kron(zplus,s_bar(j,:));
            xxplus=[x xzplus];
            pe(:,i) = pe(:,i)+(feval(f1,xxplus,varargin2{:})-fx1)/h(i)/N;
            zplus=[];xzplus=[];xxplus=[];
        else     
            % Compute expected response values for dummy z
            % varibles
            z_d=z;z_d(:,i-n1)=zeros(obs,1);
            varargin2{4}=z_d;
            xz_d=kron(z_d,s_bar(j,:));
            xx_d=[x xz_d];
            fx1_d = feval(f1,xx_d,varargin2{:});
            % Compute forward step for dummy z variables
            zplus=z;zplus(:,i-n1)=ones(obs,1);
            varargin2{4}=zplus;
            xzplus=kron(zplus,s_bar(j,:));
            xxplus=[x xzplus];
            pe(:,i) = pe(:,i)+(feval(f1,xxplus,varargin2{:})-fx1_d)/N;
            z_d=[];xz_d=[];xx_d=[];zplus=[];xzplus=[];xxplus=[];fx1_d=[];fx2_d=[];
        end
    end
end
s.pe=pe;pe=[];
