function Ey=ll_gentobit_3(x,r,num,a,z)

error(nargchk(4,5,nargin));
error(nargoutchk(0,1,nargout));

obs=size(x,1);
if nargin==4
    z=ones(obs,1);
end

m=length(r);
q=size(z,2);
if q>0
    beta=r(1:m-q);
    sigsq=zeros(obs,1);
    for j=1:q
        sigsq=sigsq+z(:,j).^2*r(m-q+j);
    end
else
    beta=r(1:m-1);
    sigsq=r(m);
end
sig=sqrt(sigsq);

xb=x*beta;
if num==1
    aterm=a; 
    xbl=(aterm-xb)./sig; 
    Ey=xb.*(1-normcdf(xbl))+sig.*normpdf(xbl)+aterm*normcdf(xbl);
elseif num==2
    bterm=a;
    xbr=(bterm-xb)./sig;
    Ey=xb.*normcdf(xbr)-sig.*normpdf(xbr)+bterm*(1-normcdf(xbr));
elseif num==3
    aterm=a(1); bterm=a(2);
    xbl=(aterm-xb)./sig; 
    xbr=(bterm-xb)./sig;
    Ey=xb.*(normcdf(xbr)-normcdf(xbl))+sig.*(normpdf(xbl)-normpdf(xbr))+aterm*normcdf(xbl)+bterm*(1-normcdf(xbr));
else  error('wrong # for tobit type'); 
end
