function L=ll_gentobit(r,y,x,num,a,z)

error(nargchk(5,6,nargin));
error(nargoutchk(0,1,nargout));
if num==1,
    index1=1; index2=0; aterm=a; 
elseif num==2,
    index1=0; index2=1; bterm=a;
elseif num==3,
    index1=1; index2=1; aterm=a(1); bterm=a(2);
else  error('wrong # for tobit type'); 
end

obs=length(y);
if nargin==5
    z=ones(obs,1);
end

h= .00000001;           
m=length(r);
q=size(z,2);
if q>0
    beta=r(1:m-q);
    sigsq=zeros(obs,1);
    for j=1:q
        sigsq=sigsq+z(:,j).^2*max(r(m-q+j),h);
    end
else
    beta=r(1:m-1);
    sigsq=max(r(m),h);
end
sig=sqrt(sigsq);
xb=x*beta;
D0=zeros(obs,1);
D1=zeros(obs,1);
if index1==1
    xbl=(aterm-xb)./sig; 
    cdfl=normcdf(xbl);
    LL1=log(h+cdfl);
    D0(y==aterm)=1;
else LL1=0;
end

if index2==1,
    xbr=-(bterm-xb)./sig;
    cdfr =normcdf(xbr);
    LL2=log(h+cdfr);
    D1(y==bterm)=1;
else LL2=0;
end
LL3=-(y-xb).^2./(2*sigsq)-.5*log(2*pi*sigsq);  
LL=D0.*LL1+D1.*LL2+(1-D0-D1).*LL3;
L=-mean(LL);