function s = ape_app_rs(f1,x,varargin)
eps = 1e-10;
n1 = size(x,2);
z=varargin{4};
[obs q]=size(z);
h = eps.^(1/3)*max(min(abs([x z]),[],1),1e-2)';
n2=n1+q;
ee = sparse(1:n2,1:n2,h,n2,n2);
varargin2=varargin;
% Compute expected response values for continuous x, z varibles        
xx=z;
fx1 = feval(f1,xx,varargin{:});
for i=1:3
        % Compute forward step for continuous z variables
        zplus=z+ones(obs,1)*ee(i,n1+1:n2);
        varargin2{4}=zplus;
        xxplus=zplus;
        pe(:,i) = (feval(f1,xxplus,varargin2{:})-fx1)/h(i);
        zplus=[];xzplus=[];xxplus=[];
end   
for i=7:n2-7
        % Compute forward step for continuous z variables
        zplus=z+ones(obs,1)*ee(i,n1+1:n2);
        varargin2{4}=zplus;
        xxplus=zplus;
        pe(:,i) = (feval(f1,xxplus,varargin2{:})-fx1)/h(i);
        zplus=[];xzplus=[];xxplus=[];
end   
% Compute expected response values for education dummies
z_d=z;
z_d(:,4:6)=zeros(obs,3);
varargin2{4}=z_d;
xx_d=z_d;
fx1_d = feval(f1,xx_d,varargin2{:});
for i=4:6
    % Compute forward step for education dummies
    zplus=z_d;zplus(:,i)=ones(obs,1);
    varargin2{4}=zplus;
    xxplus=zplus;
    pe(:,i) =(feval(f1,xxplus,varargin2{:})-fx1_d);
    zplus=[];xzplus=[];xxplus=[];
end
% Compute expected response values for age dummies
z_d=z;
z_d(:,n2-6:n2-1)=zeros(obs,6);
varargin2{4}=z_d;
xx_d=z_d;
fx1_d = feval(f1,xx_d,varargin2{:});
for i=n2-6:n2-1
    % Compute forward step for age dummies
    zplus=z_d;zplus(:,i)=ones(obs,1);
    varargin2{4}=zplus;
    xxplus=zplus;
    pe(:,i) = (feval(f1,xxplus,varargin2{:})-fx1_d);
end
s.pe=pe;