function s = ape_app_p(f1,x,varargin)

eps = 1e-10;
n1 = size(x,2);
z=varargin{4};
[obs q]=size(z);
h = eps.^(1/3)*max(min(abs([x z]),[],1),1e-2)';
n2=n1+q;
ee = sparse(1:n2,1:n2,h,n2,n2);
% Compute expected response values for continuous x, z varibles        
xx=[x z];
fx1 = feval(f1,xx,varargin{:});
for i=1:3
    % Compute forward step for continuous x variables
    xplus=x+ones(obs,1)*ee(i,1:n1);
    xxplus=[xplus z];
    pe(:,i) = (feval(f1,xxplus,varargin{:})-fx1)/h(i);
    xplus=[];xxplus=[];
end   
for i=7:n1-6
    % Compute forward step for continuous x variables
    xplus=x+ones(obs,1)*ee(i,1:n1);
    xxplus=[xplus z];
    pe(:,i) = (feval(f1,xxplus,varargin{:})-fx1)/h(i);
    xplus=[];xxplus=[];
end
% Compute expected response values for education dummies
xx_d=xx;
xx_d(:,4:6)=zeros(obs,3);
fx1_d = feval(f1,xx_d,varargin{:});
for i=4:6
    % Compute forward step for dummy x variables
    xxplus=xx_d;xxplus(:,i)=ones(obs,1);
    pe(:,i) = (feval(f1,xxplus,varargin{:})-fx1_d);
    xxplus=[];
end        
% Compute expected response values for age dummies
xx_d=xx;xx_d(:,n1-5:n1)=zeros(obs,6);
fx1_d = feval(f1,xx_d,varargin{:});
for i=n1-5:n1
    % Compute forward step for dummy x variables
    xxplus=xx_d;xxplus(:,i)=ones(obs,1);
    pe(:,i) = (feval(f1,xxplus,varargin{:})-fx1_d);
end
s.pe=pe;