clear all;
load data;
name='app_mle';

% name variables
id=data(:,1);
age=data(:,2);  
lfamfa=data(:,3);
lfamtw=data(:,4);
lfamnoncapinc=data(:,5);
sharesafe=data(:,6);
edu_voc=data(:,7);
edu_voccol=data(:,8);
edu_univ=data(:,9);
lfamfa_bar=data(:,10);
lfamtw_bar=data(:,11);
lfamnoncapinc_bar=data(:,12);
t=data(:,13);
aexreturn=data(:,14);
interest=data(:,15);
var2mean=data(:,16);
data=[];

NT=length(sharesafe);
age1=zeros(NT,1);
age1(age>45&age<=50)=1;
age2=zeros(NT,1);
age2(age>50&age<=55)=1;
age3=zeros(NT,1);
age3(age>55&age<=60)=1;
age4=zeros(NT,1);
age4(age>60&age<=65)=1;
age5=zeros(NT,1);
age5(age>65&age<=70)=1;
age6=zeros(NT,1);
age6(age>70)=1;
age=[];

j=[];
for i=2:NT
    if id(i)~=id(i-1)
        j=[j;i];
     end
end
N=length(j)+1;
vec(1,1)=j(1,1)-1;
for i=2:N-1
    vec(i,1)=j(i,1)-j(i-1,1);
end
vec(N,1)=NT-j(N-1,1)+1;

cons=ones(NT,1);
y=sharesafe; sharesafe=[];
premium=aexreturn-interest;
aexreturn=[];interest=[];
info.trunc='both';info.inference=0;
B=500;
rt=0.15;  % rt=[0.15;0.2;0.25;1];

%% MLE estimates, pooled
x=[lfamfa lfamtw lfamnoncapinc edu_voc edu_univ edu_voccol premium var2mean t age1 age2 age3 age4 age5 age6];
z=cons;
s_bar=cons;
d_p=size(x,2);q_p=size(z,2);p_p=size(s_bar,2);
info.b=ones(d_p+p_p*q_p,1)*0.005;info.sig=ones(q_p,1)*0.01;
r=gentobit(y,x,info,z,s_bar);
beta_p=r.beta;sig_p=r.sigsq;tflag=r.tflag;vflag=r.vflag;
%APE estimates, p
r=ape_app_p('ll_gentobit_3',x,[beta_p;sig_p],tflag,vflag,z);
ape_p=mean(r.pe)';

%% MLE estimates, rs
x=[];
z=[lfamfa lfamtw lfamnoncapinc edu_voc edu_univ edu_voccol premium var2mean t age1 age2 age3 age4 age5 age6 cons];
s_bar=cons;
d_rs=size(x,2);q_rs=size(z,2);p_rs=size(s_bar,2);
info.b=ones(d_rs+p_rs*q_rs,1)*0.005;info.sig=ones(q_rs,1)*0.01;
r=gentobit(y,x,info,z,s_bar);
beta_rs=r.beta;sig_rs=r.sigsq;
% APE estimates, rs
r=ape_app_rs('ll_gentobit_3',x,[beta_rs;sig_rs],tflag,vflag,z);
ape_rs=mean(r.pe)';

%% MLE estimates, cre
x=[lfamfa lfamtw lfamnoncapinc edu_voc edu_univ edu_voccol premium var2mean t age1 age2 age3 age4 age5 age6 cons];
z=cons;
s_bar=[lfamfa_bar lfamtw_bar lfamnoncapinc_bar];
d_cre=size(x,2);q_cre=size(z,2);p_cre=size(s_bar,2);
info.b=ones(d_cre+p_cre*q_cre,1)*0.005;info.sig=ones(q_cre,1)*0.01;
r=gentobit(y,x,info,z,s_bar);
beta_cre=r.beta;sig_cre=r.sigsq;
% APE estimates, cre
sbar_ind=[];sbar_ind=s_bar(1,:);ind=1;
for i=1:length(vec)-1
    ind=ind+vec(i);
    sbar_ind=[sbar_ind;s_bar(ind,:)];
end
r=ape_app_cre('ll_gentobit_3',x,[beta_cre;sig_cre],tflag,vflag,z,mean(sbar_ind));
ape_cre=mean(r.pe)';

%% MLE estimates, crs
x=[lfamfa lfamtw lfamnoncapinc premium var2mean t];
z=[cons age1 age2 age3 age4 age5 age6];
s_bar=[cons edu_voc edu_univ edu_voccol lfamfa_bar lfamtw_bar lfamnoncapinc_bar];
d_crs=size(x,2);q_crs=size(z,2);p_crs=size(s_bar,2);
info.b=ones(d_crs+p_crs*q_crs,1)*0.005;info.sig=ones(q_crs,1)*0.01;
r=gentobit(y,x,info,z,s_bar);
beta_crs=r.beta;sig_crs=r.sigsq;
% APE estimates, crs
r=ape_app_crs('ll_gentobit_3',x,[beta_crs;sig_crs],tflag,vflag,z,s_bar(:,1:4),mean(sbar_ind));
ape_crs=mean(r.pe)';
[ape_p ape_rs ape_cre ape_crs] 


%% bootstrap standard errors
bsdata=[id y cons lfamfa lfamtw lfamnoncapinc edu_voc edu_univ edu_voccol premium var2mean t age1 age2 age3 age4 age5 age6 lfamfa_bar lfamtw_bar lfamnoncapinc_bar]; 
bsdata_sub=mat2cell(bsdata,vec,size(bsdata,2));
bsdata=[];
clear x z s_bar sbar_ind id y cons lfamfa lfamtw lfamnoncapinc edu_voc edu_univ edu_voccol premium var2mean t age1 age2 age3 age4 age5 age6 lfamfa_bar lfamtw_bar lfamnoncapinc_bar; 
rand('state',0)

for b=1:B
    for m=1:length(rt)
        eval(['rt' num2str(m) '=rt(m);'])
        N_bs=[];
        eval(['N_bs=round(rt'  num2str(m) '*N);'])
        ind_p=1;ind_cre=1;ind_rs=1;ind_crs=1;    
        while ind_p>0 ||ind_cre>0||ind_rs>0||ind_crs>0
        rd_idx=round(0.5+N*rand(N_bs,1));
        data_bs=[];vec_bs=[];
        for i=1:N_bs
            data_bs=[data_bs;bsdata_sub{rd_idx(i)}];
            vec_bs=[vec_bs;size(bsdata_sub{rd_idx(i)},1)];
        end
        y_bs=data_bs(:,2);NT_bs=length(y_bs);
        % check for multicolinearity of the bs dataset
        x_bs=data_bs(:,4:3+d_p);
        corr_p=corr(x_bs);
        x_bs=data_bs(:,4:3+d_cre-1);     
        s_bar_bs=data_bs(:,3+d_cre:3+d_cre+p_cre-1);
        corr_cre=corr([x_bs s_bar_bs(:,2:end)]);
        z_bs=[data_bs(:,4:3+(q_rs-1)) data_bs(:,3)];    
        corr_rs=corr(z_bs(:,1:end-1));        
        x_bs=data_bs(:,4:3+d_crs+3);
        z_bs=[data_bs(:,3) data_bs(:,4+d_crs+3:3+d_crs+3+(q_crs-1))];
        s_bar_bs=[data_bs(:,3) data_bs(:,3+d_cre:3+d_cre+(p_cre-1))];
        s_bar_bs(:,2+3:end+3)=s_bar_bs(:,2:end);
        s_bar_bs(:,2:1+3)=x_bs(:,4:3+3);
        x_bs(:,4:3+3)=[];
        temp=kron(z_bs,ones(1,size(s_bar_bs,2))).*kron(ones(1,size(z_bs,2)),s_bar_bs);temp(:,1)=[];
        corr_crs=corr([x_bs temp]);  
        ind_p=sum(sum(isnan(corr_p)));ind_cre=sum(sum(isnan(corr_cre)));ind_rs=sum(sum(isnan(corr_rs)));ind_crs=sum(sum(isnan(corr_crs)));
        if ind_p>0 ||ind_cre>0||ind_rs>0||ind_crs>0
            disp('multicolinearity in RHS variables in one of the 4 specifications, draw another bs sample.')
        end
        end
        % p
        x_bs=data_bs(:,4:3+d_p);
        z_bs=data_bs(:,3);
        s_bar_bs=data_bs(:,3);
        info.b=beta_p;info.sig=sig_p;
        r=gentobit(y_bs,x_bs,info,z_bs,s_bar_bs);
        eval(['beta_p_bs' num2str(m) '(:,b)=r.beta;'])
        eval(['sig_p_bs' num2str(m) '(:,b)=r.sigsq;'])      
        % APE estimates, p
        r=ape_app_p('ll_gentobit_3',x_bs,[r.beta;r.sigsq],tflag,vflag,z_bs);
        eval(['ape_p_bs' num2str(m) '(b,:)=mean(r.pe);'])
        % cre
        x_bs=[data_bs(:,4:3+d_cre-1) data_bs(:,3)];     
        z_bs=data_bs(:,3);
        s_bar_bs=data_bs(:,3+d_cre:3+d_cre+p_cre-1);    
        info.b=beta_cre;info.sig=sig_cre;
        r=gentobit(y_bs,x_bs,info,z_bs,s_bar_bs);
        eval(['beta_cre_bs' num2str(m) '(:,b)=r.beta;'])
        eval(['sig_cre_bs' num2str(m) '(:,b)=r.sigsq;'])
        % APE estimates, cre
        sbar_ind_bs=[];sbar_ind_bs=s_bar_bs(1,:);ind=1;
        for i=1:length(vec_bs)-1
            ind=ind+vec_bs(i);
            sbar_ind_bs=[sbar_ind_bs;s_bar_bs(ind,:)];
        end
        r=ape_app_cre('ll_gentobit_3',x_bs,[r.beta;r.sigsq],tflag,vflag,z_bs,mean(sbar_ind_bs));
        eval(['ape_cre_bs' num2str(m) '(b,:)=mean(r.pe);'])
        % rs
        x_bs=[];
        z_bs=[data_bs(:,4:3+(q_rs-1)) data_bs(:,3)];
        s_bar_bs=data_bs(:,3);
        info.b=beta_rs;info.sig=sig_rs;
        r=gentobit(y_bs,x_bs,info,z_bs,s_bar_bs);
        eval(['beta_rs_bs' num2str(m) '(:,b)=r.beta;'])
        eval(['sig_rs_bs' num2str(m) '(:,b)=r.sigsq;'])
        % APE estimates, rs
        r=ape_app_rs('ll_gentobit_3',x_bs,[r.beta;r.sigsq],tflag,vflag,z_bs);
        eval(['ape_rs_bs' num2str(m) '(b,:)=mean(r.pe);'])
        % crs
        x_bs=data_bs(:,4:3+d_crs+3);
        z_bs=[data_bs(:,3) data_bs(:,4+d_crs+3:3+d_crs+3+(q_crs-1))];
        s_bar_bs=[data_bs(:,3) data_bs(:,3+d_cre:3+d_cre+(p_cre-1))];
        s_bar_bs(:,2+3:end+3)=s_bar_bs(:,2:end);
        s_bar_bs(:,2:1+3)=x_bs(:,4:3+3);
        x_bs(:,4:3+3)=[];
        info.b=beta_crs;info.sig=sig_crs;
        r=gentobit(y_bs,x_bs,info,z_bs,s_bar_bs);
        eval(['beta_crs_bs' num2str(m) '(:,b)=r.beta;'])
        eval(['sig_crs_bs' num2str(m) '(:,b)=r.sigsq;'])
        % APE estimates, crs
        sbar_ind2_bs=[];sbar_ind2_bs=s_bar_bs(1,:);ind=1;
        for i=1:length(vec_bs)-1
            ind=ind+vec_bs(i);
            sbar_ind2_bs=[sbar_ind2_bs;s_bar_bs(ind,:)];
        end
        r=ape_app_crs('ll_gentobit_3',x_bs,[r.beta;r.sigsq],tflag,vflag,z_bs,s_bar_bs(:,1:4),mean(sbar_ind_bs));
        eval(['ape_crs_bs' num2str(m) '(b,:)=mean(r.pe);'])
        clear y_bs x_bs z_bs s_bar_bs sbar_ind_bs
    end   

if b/100==round(b/100)
    b
    save(name)
for m=1:length(rt)
    eval(['betastd_p_bs' num2str(m) '=sqrt(rt' num2str(m) ')*std(beta_p_bs' num2str(m) ',0,2);'])
    eval(['sigstd_p_bs' num2str(m) '=sqrt(rt' num2str(m) ')*std(sig_p_bs' num2str(m) ',0,2);'])
    eval(['apestd_p_bs' num2str(m) '=sqrt(rt' num2str(m) ')*std(ape_p_bs' num2str(m) ',0,1);'])
    eval(['betastd_cre_bs' num2str(m) '=sqrt(rt' num2str(m) ')*std(beta_cre_bs' num2str(m) ',0,2);'])
    eval(['sigstd_cre_bs' num2str(m) '=sqrt(rt' num2str(m) ')*std(sig_cre_bs' num2str(m) ',0,2);'])
    eval(['apestd_cre_bs' num2str(m) '=sqrt(rt' num2str(m) ')*std(ape_cre_bs' num2str(m) ',0,1);'])
    eval(['betastd_rs_bs' num2str(m) '=sqrt(rt' num2str(m) ')*std(beta_rs_bs' num2str(m) ',0,2);'])
    eval(['sigstd_rs_bs' num2str(m) '=sqrt(rt' num2str(m) ')*std(sig_rs_bs' num2str(m) ',0,2);'])
    eval(['apestd_rs_bs' num2str(m) '=sqrt(rt' num2str(m) ')*std(ape_rs_bs' num2str(m) ',0,1);'])
    eval(['betastd_crs_bs' num2str(m) '=sqrt(rt' num2str(m) ')*std(beta_crs_bs' num2str(m) ',0,2);'])
    eval(['sigstd_crs_bs' num2str(m) '=sqrt(rt' num2str(m) ')*std(sig_crs_bs' num2str(m) ',0,2);'])
    eval(['apestd_crs_bs' num2str(m) '=sqrt(rt' num2str(m) ')*std(ape_crs_bs' num2str(m) ',0,1);'])
end

disp('b: p -- rs -- cre -- crs')
       for k=1:3
            disp(['  &  '  num2str(beta_p(k,:),'%0.4f') '  &  '  num2str(beta_rs(k,:),'%0.4f') '  &  ' num2str(beta_cre(k,:),'%0.4f') '  &  ' num2str(beta_crs(k,:),'%0.4f') ] )
            for m=1:length(rt)
                disp(['  & (' num2str(eval(['betastd_p_bs' num2str(m) '(k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_rs_bs' num2str(m) '(k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_cre_bs' num2str(m) '(k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_crs_bs' num2str(m) '(k,:)']),'%0.4f') ')'])
            end
        end
        for k=4:6
            disp(['  &  '  num2str(beta_p(k,:),'%0.4f') '  &  '  num2str(beta_rs(k,:),'%0.4f') '  &  ' num2str(beta_cre(k,:),'%0.4f') '  &  ' num2str(beta_crs(end-6+(k-3),:),'%0.4f')  ] )
             for m=1:length(rt)
                disp(['  & (' num2str(eval(['betastd_p_bs' num2str(m) '(k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_rs_bs' num2str(m) '(k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_cre_bs' num2str(m) '(k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_crs_bs' num2str(m) '(end-6+(k-3),:)']),'%0.4f') ')'])

             end
        end
        for k=7:9
            disp(['  &  '  num2str(beta_p(k,:),'%0.4f') '  &  '  num2str(beta_rs(k,:),'%0.4f') '  &  ' num2str(beta_cre(k,:),'%0.4f') '  &  '  num2str(beta_crs(k-3,:),'%0.4f') ] )
            for m=1:length(rt)
                disp(['  & (' num2str(eval(['betastd_p_bs' num2str(m) '(k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_rs_bs' num2str(m) '(k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_cre_bs' num2str(m) '(k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_crs_bs' num2str(m) '(k-3,:)']),'%0.4f') ')'])
            end
        end
        for k=10:16
            disp(['  &  '  num2str(beta_p(k,:),'%0.4f') '  &  '  num2str(beta_rs(k,:),'%0.4f') '  &  ' num2str(beta_cre(k,:),'%0.4f') '  &  '   ] )
            for m=1:length(rt)
                disp(['  & (' num2str(eval(['betastd_p_bs' num2str(m) '(k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_rs_bs' num2str(m) '(k,:)']),'%0.4f') ') & ' num2str(eval(['betastd_cre_bs' num2str(m) '(k,:)']),'%0.4f') ') & '])
            end
        end
        
           disp('------------------------------------------------------------')
            for k=1:p_crs
                disp([' &  ' num2str(beta_crs(d_crs+k,:),'%0.4f') ' &  ' num2str(beta_crs(d_crs+p_crs+k,:),'%0.4f') ' &  ' num2str(beta_crs(d_crs+2*p_crs+k,:),'%0.4f') ' &  ' num2str(beta_crs(d_crs+3*p_crs+k,:),'%0.4f') ' &  ' num2str(beta_crs(d_crs+4*p_crs+k,:),'%0.4f') ' &  ' num2str(beta_crs(d_crs+5*p_crs+k,:),'%0.4f') ' &  '  num2str(beta_crs(d_crs+6*p_crs+k,:),'%0.4f') ])
                for m=1:length(rt)
                    disp([' & (' num2str(eval(['betastd_crs_bs' num2str(m) '(d_crs+k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_crs_bs' num2str(m) '(d_crs+p_crs+k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_crs_bs' num2str(m) '(d_crs+2*p_crs+k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_crs_bs' num2str(m) '(d_crs+3*p_crs+k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_crs_bs' num2str(m) '(d_crs+4*p_crs+k,:)']),'%0.4f') ') & (' num2str(eval(['betastd_crs_bs' num2str(m) '(d_crs+5*p_crs+k,:)']),'%0.4f') ')  & (' num2str(eval(['betastd_crs_bs' num2str(m) '(d_crs+6*p_crs+k,:)']),'%0.4f') ')'])
                end
            end
       
        disp('sig: p -- cre -- rs -- crs')
        for k=1:9
            disp([' &         ' ' &  ' num2str(sig_rs(k,:),'%0.6f') ' &         '  '  &  ' ])
            for m=1:length(rt)
                disp([' &         ' ' & (' num2str(eval(['sigstd_rs_bs' num2str(m) '(k,:)']),'%0.4f') ') &         ' ' & '])
            end
        end
        disp('------------------------------------------------------------')
        for k=10:15
            disp([' &         ' ' &  ' num2str(sig_rs(k,:),'%0.6f') ' &         '  '  &  ' num2str(sig_crs(k-9,:),'%0.6f')])
            for m=1:length(rt)
                disp([' &         '  ' & (' num2str(eval(['sigstd_rs_bs' num2str(m) '(k,:)']),'%0.4f') ') &         ' ' & (' num2str(eval(['sigstd_crs_bs' num2str(m) '(k-9,:)']),'%0.4f') ')'])
            end
        end
        disp([' &  ' num2str(sig_p,'%0.6f') ' &  ' num2str(sig_rs(end,:),'%0.6f')  ' &  ' num2str(sig_cre,'%0.6f') '  &  ' num2str(sig_crs(end,:),'%0.6f')])
        for m=1:length(rt)
            disp([' & (' num2str(eval(['sigstd_p_bs' num2str(m)]),'%0.4f') ') & (' num2str(eval(['sigstd_rs_bs' num2str(m) '(q_rs,:)']),'%0.4f') ') & (' num2str(eval(['sigstd_cre_bs' num2str(m) ]),'%0.4f') ') & (' num2str(eval(['sigstd_crs_bs' num2str(m) '(q_crs,:)']),'%0.4f') ')'])
        end       
        disp('ape: p -- rs -- cre -- crs')
        for k=1:q_rs-1
            disp([' &  ' num2str(ape_p(k,:),'%0.4f') ' &  ' num2str(ape_rs(k,:),'%0.4f')  ' &  ' num2str(ape_cre(k,:),'%0.4f') ' &  ' num2str(ape_crs(k,:),'%0.4f')])
            for m=1:length(rt)
                disp([' & (' num2str(eval(['apestd_p_bs' num2str(m) '(k)']),'%0.4f') ') & (' num2str(eval(['apestd_rs_bs' num2str(m) '(k)']),'%0.4f') ') & (' num2str(eval(['apestd_cre_bs' num2str(m) '(k)']),'%0.4f') ') & (' num2str(eval(['apestd_crs_bs' num2str(m) '(k)']),'%0.4f') ')'])
            end
        end

% Decide the significance level of coefficient, ape estimates based on
% bootstrap quantiles
    % b
    % pooled
    beta_p_05=beta_p+sqrt(rt1)*quantile(beta_p_bs1-beta_p*ones(1,b),0.005,2);
    beta_p_25=beta_p+sqrt(rt1)*quantile(beta_p_bs1-beta_p*ones(1,b),0.025,2);
    beta_p_5=beta_p+sqrt(rt1)*quantile(beta_p_bs1-beta_p*ones(1,b),0.05,2);
    beta_p_995=beta_p+sqrt(rt1)*quantile(beta_p_bs1-beta_p*ones(1,b),0.995,2);
    beta_p_975=beta_p+sqrt(rt1)*quantile(beta_p_bs1-beta_p*ones(1,b),0.975,2);
    beta_p_95=beta_p+sqrt(rt1)*quantile(beta_p_bs1-beta_p*ones(1,b),0.95,2);
    starbeta_p=zeros(length(beta_p),1);
    starbeta_p(beta_p_5.*beta_p_95>0)=1;
    starbeta_p(beta_p_25.*beta_p_975>0)=2;    
    starbeta_p(beta_p_05.*beta_p_995>0)=3;
    % rs
    beta_rs_05=beta_rs+sqrt(rt1)*quantile(beta_rs_bs1-beta_rs*ones(1,b),0.005,2);
    beta_rs_25=beta_rs+sqrt(rt1)*quantile(beta_rs_bs1-beta_rs*ones(1,b),0.025,2);
    beta_rs_5=beta_rs+sqrt(rt1)*quantile(beta_rs_bs1-beta_rs*ones(1,b),0.05,2);
    beta_rs_995=beta_rs+sqrt(rt1)*quantile(beta_rs_bs1-beta_rs*ones(1,b),0.995,2);
    beta_rs_975=beta_rs+sqrt(rt1)*quantile(beta_rs_bs1-beta_rs*ones(1,b),0.975,2);
    beta_rs_95=beta_rs+sqrt(rt1)*quantile(beta_rs_bs1-beta_rs*ones(1,b),0.95,2);
    starbeta_rs=zeros(length(beta_rs),1);
    starbeta_rs(beta_rs_5.*beta_rs_95>0)=1;
    starbeta_rs(beta_rs_25.*beta_rs_975>0)=2;    
    starbeta_rs(beta_rs_05.*beta_rs_995>0)=3;
    % cre
    beta_cre_05=beta_cre+sqrt(rt1)*quantile(beta_cre_bs1-beta_cre*ones(1,b),0.005,2);
    beta_cre_25=beta_cre+sqrt(rt1)*quantile(beta_cre_bs1-beta_cre*ones(1,b),0.025,2);
    beta_cre_5=beta_cre+sqrt(rt1)*quantile(beta_cre_bs1-beta_cre*ones(1,b),0.05,2);
    beta_cre_995=beta_cre+sqrt(rt1)*quantile(beta_cre_bs1-beta_cre*ones(1,b),0.995,2);
    beta_cre_975=beta_cre+sqrt(rt1)*quantile(beta_cre_bs1-beta_cre*ones(1,b),0.975,2);
    beta_cre_95=beta_cre+sqrt(rt1)*quantile(beta_cre_bs1-beta_cre*ones(1,b),0.95,2);
    starbeta_cre=zeros(length(beta_cre),1);
    starbeta_cre(beta_cre_5.*beta_cre_95>0)=1;
    starbeta_cre(beta_cre_25.*beta_cre_975>0)=2;    
    starbeta_cre(beta_cre_05.*beta_cre_995>0)=3;
    % crs
    beta_crs_05=beta_crs+sqrt(rt1)*quantile(beta_crs_bs1-beta_crs*ones(1,b),0.005,2);
    beta_crs_25=beta_crs+sqrt(rt1)*quantile(beta_crs_bs1-beta_crs*ones(1,b),0.025,2);
    beta_crs_5=beta_crs+sqrt(rt1)*quantile(beta_crs_bs1-beta_crs*ones(1,b),0.05,2);
    beta_crs_995=beta_crs+sqrt(rt1)*quantile(beta_crs_bs1-beta_crs*ones(1,b),0.995,2);
    beta_crs_975=beta_crs+sqrt(rt1)*quantile(beta_crs_bs1-beta_crs*ones(1,b),0.975,2);
    beta_crs_95=beta_crs+sqrt(rt1)*quantile(beta_crs_bs1-beta_crs*ones(1,b),0.95,2);
    starbeta_crs=zeros(length(beta_crs),1);
    starbeta_crs(beta_crs_5.*beta_crs_95>0)=1;
    starbeta_crs(beta_crs_25.*beta_crs_975>0)=2;    
    starbeta_crs(beta_crs_05.*beta_crs_995>0)=3;
    
    % sig
    % pooled
    sig_p_05=sig_p+sqrt(rt1)*quantile(sig_p_bs1-sig_p*ones(1,b),0.005,2);
    sig_p_25=sig_p+sqrt(rt1)*quantile(sig_p_bs1-sig_p*ones(1,b),0.025,2);
    sig_p_5=sig_p+sqrt(rt1)*quantile(sig_p_bs1-sig_p*ones(1,b),0.05,2);
    sig_p_995=sig_p+sqrt(rt1)*quantile(sig_p_bs1-sig_p*ones(1,b),0.995,2);
    sig_p_975=sig_p+sqrt(rt1)*quantile(sig_p_bs1-sig_p*ones(1,b),0.975,2);
    sig_p_95=sig_p+sqrt(rt1)*quantile(sig_p_bs1-sig_p*ones(1,b),0.95,2);
    starsig_p=zeros(length(sig_p),1);
    starsig_p(sig_p_5.*sig_p_95>0)=1;
    starsig_p(sig_p_25.*sig_p_975>0)=2;    
    starsig_p(sig_p_05.*sig_p_995>0)=3;
    % rs
    sig_rs_05=sig_rs+sqrt(rt1)*quantile(sig_rs_bs1-sig_rs*ones(1,b),0.005,2);
    sig_rs_25=sig_rs+sqrt(rt1)*quantile(sig_rs_bs1-sig_rs*ones(1,b),0.025,2);
    sig_rs_5=sig_rs+sqrt(rt1)*quantile(sig_rs_bs1-sig_rs*ones(1,b),0.05,2);
    sig_rs_995=sig_rs+sqrt(rt1)*quantile(sig_rs_bs1-sig_rs*ones(1,b),0.995,2);
    sig_rs_975=sig_rs+sqrt(rt1)*quantile(sig_rs_bs1-sig_rs*ones(1,b),0.975,2);
    sig_rs_95=sig_rs+sqrt(rt1)*quantile(sig_rs_bs1-sig_rs*ones(1,b),0.95,2);
    starsig_rs=zeros(length(sig_rs),1);
    starsig_rs(sig_rs_5.*sig_rs_95>0)=1;
    starsig_rs(sig_rs_25.*sig_rs_975>0)=2;    
    starsig_rs(sig_rs_05.*sig_rs_995>0)=3;
    % cre
    sig_cre_05=sig_cre+sqrt(rt1)*quantile(sig_cre_bs1-sig_cre*ones(1,b),0.005,2);
    sig_cre_25=sig_cre+sqrt(rt1)*quantile(sig_cre_bs1-sig_cre*ones(1,b),0.025,2);
    sig_cre_5=sig_cre+sqrt(rt1)*quantile(sig_cre_bs1-sig_cre*ones(1,b),0.05,2);
    sig_cre_995=sig_cre+sqrt(rt1)*quantile(sig_cre_bs1-sig_cre*ones(1,b),0.995,2);
    sig_cre_975=sig_cre+sqrt(rt1)*quantile(sig_cre_bs1-sig_cre*ones(1,b),0.975,2);
    sig_cre_95=sig_cre+sqrt(rt1)*quantile(sig_cre_bs1-sig_cre*ones(1,b),0.95,2);
    starsig_cre=zeros(length(sig_cre),1);
    starsig_cre(sig_cre_5.*sig_cre_95>0)=1;
    starsig_cre(sig_cre_25.*sig_cre_975>0)=2;    
    starsig_cre(sig_cre_05.*sig_cre_995>0)=3;
    % crs
    sig_crs_05=sig_crs+sqrt(rt1)*quantile(sig_crs_bs1-sig_crs*ones(1,b),0.005,2);
    sig_crs_25=sig_crs+sqrt(rt1)*quantile(sig_crs_bs1-sig_crs*ones(1,b),0.025,2);
    sig_crs_5=sig_crs+sqrt(rt1)*quantile(sig_crs_bs1-sig_crs*ones(1,b),0.05,2);
    sig_crs_995=sig_crs+sqrt(rt1)*quantile(sig_crs_bs1-sig_crs*ones(1,b),0.995,2);
    sig_crs_975=sig_crs+sqrt(rt1)*quantile(sig_crs_bs1-sig_crs*ones(1,b),0.975,2);
    sig_crs_95=sig_crs+sqrt(rt1)*quantile(sig_crs_bs1-sig_crs*ones(1,b),0.95,2);
    starsig_crs=zeros(length(sig_crs),1);
    starsig_crs(sig_crs_5.*sig_crs_95>0)=1;
    starsig_crs(sig_crs_25.*sig_crs_975>0)=2;    
    starsig_crs(sig_crs_05.*sig_crs_995>0)=3;
    
    % ape
    % pooled
    ape_p_05=ape_p+sqrt(rt1)*quantile(ape_p_bs1-ones(b,1)*ape_p',0.005,1)';
    ape_p_25=ape_p+sqrt(rt1)*quantile(ape_p_bs1-ones(b,1)*ape_p',0.025,1)';
    ape_p_5=ape_p+sqrt(rt1)*quantile(ape_p_bs1-ones(b,1)*ape_p',0.05,1)';
    ape_p_995=ape_p+sqrt(rt1)*quantile(ape_p_bs1-ones(b,1)*ape_p',0.995,1)';
    ape_p_975=ape_p+sqrt(rt1)*quantile(ape_p_bs1-ones(b,1)*ape_p',0.975,1)';
    ape_p_95=ape_p+sqrt(rt1)*quantile(ape_p_bs1-ones(b,1)*ape_p',0.95,1)';
    starape_p=zeros(length(ape_p),1);
    starape_p(ape_p_5.*ape_p_95>0)=1;
    starape_p(ape_p_25.*ape_p_975>0)=2;    
    starape_p(ape_p_05.*ape_p_995>0)=3;
    % rs
    ape_rs_05=ape_rs+sqrt(rt1)*quantile(ape_rs_bs1-ones(b,1)*ape_rs',0.005,1)';
    ape_rs_25=ape_rs+sqrt(rt1)*quantile(ape_rs_bs1-ones(b,1)*ape_rs',0.025,1)';
    ape_rs_5=ape_rs+sqrt(rt1)*quantile(ape_rs_bs1-ones(b,1)*ape_rs',0.05,1)';
    ape_rs_995=ape_rs+sqrt(rt1)*quantile(ape_rs_bs1-ones(b,1)*ape_rs',0.995,1)';
    ape_rs_975=ape_rs+sqrt(rt1)*quantile(ape_rs_bs1-ones(b,1)*ape_rs',0.975,1)';
    ape_rs_95=ape_rs+sqrt(rt1)*quantile(ape_rs_bs1-ones(b,1)*ape_rs',0.95,1)';
    starape_rs=zeros(length(ape_rs),1);
    starape_rs(ape_rs_5.*ape_rs_95>0)=1;
    starape_rs(ape_rs_25.*ape_rs_975>0)=2;    
    starape_rs(ape_rs_05.*ape_rs_995>0)=3;
    % cre
    ape_cre_05=ape_cre+sqrt(rt1)*quantile(ape_cre_bs1-ones(b,1)*ape_cre',0.005,1)';
    ape_cre_25=ape_cre+sqrt(rt1)*quantile(ape_cre_bs1-ones(b,1)*ape_cre',0.025,1)';
    ape_cre_5=ape_cre+sqrt(rt1)*quantile(ape_cre_bs1-ones(b,1)*ape_cre',0.05,1)';
    ape_cre_995=ape_cre+sqrt(rt1)*quantile(ape_cre_bs1-ones(b,1)*ape_cre',0.995,1)';
    ape_cre_975=ape_cre+sqrt(rt1)*quantile(ape_cre_bs1-ones(b,1)*ape_cre',0.975,1)';
    ape_cre_95=ape_cre+sqrt(rt1)*quantile(ape_cre_bs1-ones(b,1)*ape_cre',0.95,1)';
    starape_cre=zeros(length(ape_cre),1);
    starape_cre(ape_cre_5.*ape_cre_95>0)=1;
    starape_cre(ape_cre_25.*ape_cre_975>0)=2;    
    starape_cre(ape_cre_05.*ape_cre_995>0)=3;
    % crs
    ape_crs_05=ape_crs+sqrt(rt1)*quantile(ape_crs_bs1-ones(b,1)*ape_crs',0.005,1)';
    ape_crs_25=ape_crs+sqrt(rt1)*quantile(ape_crs_bs1-ones(b,1)*ape_crs',0.025,1)';
    ape_crs_5=ape_crs+sqrt(rt1)*quantile(ape_crs_bs1-ones(b,1)*ape_crs',0.05,1)';
    ape_crs_995=ape_crs+sqrt(rt1)*quantile(ape_crs_bs1-ones(b,1)*ape_crs',0.995,1)';
    ape_crs_975=ape_crs+sqrt(rt1)*quantile(ape_crs_bs1-ones(b,1)*ape_crs',0.975,1)';
    ape_crs_95=ape_crs+sqrt(rt1)*quantile(ape_crs_bs1-ones(b,1)*ape_crs',0.95,1)';
    starape_crs=zeros(length(ape_crs),1);
    starape_crs(ape_crs_5.*ape_crs_95>0)=1;
    starape_crs(ape_crs_25.*ape_crs_975>0)=2;    
    starape_crs(ape_crs_05.*ape_crs_995>0)=3;
    for j=1:length(ape_p)    
    ['  &  ' num2str(starape_p(j),'%0.4f') '  &  ' num2str(starape_rs(j),'%0.4f') '  &  ' num2str(starape_cre(j),'%0.4f') '  &  ' num2str(starape_crs(j),'%0.4f')]
    end 
    
    %'Hausman Test
    Dp=ape_crs-  ape_p;
    Dcre=ape_crs-ape_cre;
    Drs=ape_crs- ape_rs;
    stdDp=sqrt(rt1)*std(ape_crs_bs1-ape_p_bs1)';
    stdDcre=sqrt(rt1)*std(ape_crs_bs1-ape_cre_bs1)';
    stdDrs=sqrt(rt1)*std(ape_crs_bs1- ape_rs_bs1)';
    
    Dpq05=Dp+sqrt(rt1)*quantile(ape_crs_bs1-ape_p_bs1-ones(b,1)*Dp',0.005,1)';
    Dpq25=Dp+sqrt(rt1)*quantile(ape_crs_bs1-ape_p_bs1-ones(b,1)*Dp',0.025,1)';
    Dpq5=Dp+sqrt(rt1)*quantile(ape_crs_bs1-ape_p_bs1-ones(b,1)*Dp',0.05,1)';
    Dpq995=Dp+sqrt(rt1)*quantile(ape_crs_bs1-ape_p_bs1-ones(b,1)*Dp',0.995,1)';
    Dpq975=Dp+sqrt(rt1)*quantile(ape_crs_bs1-ape_p_bs1-ones(b,1)*Dp',0.975,1)';
    Dpq95=Dp+sqrt(rt1)*quantile(ape_crs_bs1-ape_p_bs1-ones(b,1)*Dp',0.95,1)';
    starp=zeros(length(Dp),1);
    starp(Dpq5.*Dpq95>0)=1;
    starp(Dpq25.*Dpq975>0)=2;    
    starp(Dpq05.*Dpq995>0)=3;

    Drsq05=Drs+sqrt(rt1)*quantile(ape_crs_bs1-ape_rs_bs1-ones(b,1)*Drs',0.005,1)';
    Drsq25=Drs+sqrt(rt1)*quantile(ape_crs_bs1-ape_rs_bs1-ones(b,1)*Drs',0.025,1)';
    Drsq5=Drs+sqrt(rt1)*quantile(ape_crs_bs1-ape_rs_bs1-ones(b,1)*Drs',0.05,1)';
    Drsq995=Drs+sqrt(rt1)*quantile(ape_crs_bs1-ape_rs_bs1-ones(b,1)*Drs',0.995,1)';
    Drsq975=Drs+sqrt(rt1)*quantile(ape_crs_bs1-ape_rs_bs1-ones(b,1)*Drs',0.975,1)';
    Drsq95=Drs+sqrt(rt1)*quantile(ape_crs_bs1-ape_rs_bs1-ones(b,1)*Drs',0.95,1)';
    starrs=zeros(length(Drs),1);
    starrs(Drsq5.*Drsq95>0)=1;
    starrs(Drsq25.*Drsq975>0)=2;    
    starrs(Drsq05.*Drsq995>0)=3;
    
    Dcreq05=Dcre+sqrt(rt1)*quantile(ape_crs_bs1-ape_cre_bs1-ones(b,1)*Dcre',0.005,1)';
    Dcreq25=Dcre+sqrt(rt1)*quantile(ape_crs_bs1-ape_cre_bs1-ones(b,1)*Dcre',0.025,1)';
    Dcreq5=Dcre+sqrt(rt1)*quantile(ape_crs_bs1-ape_cre_bs1-ones(b,1)*Dcre',0.05,1)';
    Dcreq995=Dcre+sqrt(rt1)*quantile(ape_crs_bs1-ape_cre_bs1-ones(b,1)*Dcre',0.995,1)';
    Dcreq975=Dcre+sqrt(rt1)*quantile(ape_crs_bs1-ape_cre_bs1-ones(b,1)*Dcre',0.975,1)';
    Dcreq95=Dcre+sqrt(rt1)*quantile(ape_crs_bs1-ape_cre_bs1-ones(b,1)*Dcre',0.95,1)';
    starcre=zeros(length(Dcre),1);
    starcre(Dcreq5.*Dcreq95>0)=1;
    starcre(Dcreq25.*Dcreq975>0)=2;    
    starcre(Dcreq05.*Dcreq995>0)=3;
for j=1:length(ape_p)    
    ['  &  ' num2str(Dp(j),'%0.4f') '  &  ' num2str(Drs(j),'%0.4f') '  &  ' num2str(Dcre(j),'%0.4f')]
    ['  & (' num2str(stdDp(j),'%0.4f') ') & (' num2str(stdDrs(j),'%0.4f') ') & (' num2str(stdDcre(j),'%0.4f') ')']
    ['  &  ' num2str(starp(j),'%0.4f') '  &  ' num2str(starrs(j),'%0.4f') '  &  ' num2str(starcre(j),'%0.4f')]
end 
end
end